/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import javax.swing.plaf.metal.MetalIconFactory;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalRootPaneUI
extends BasicRootPaneUI {
    private static MetalRootPaneUI instance;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public static ComponentUI createUI(JComponent jComponent) {
        if (instance == null) {
            instance = new MetalRootPaneUI();
        }
        return instance;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        JRootPane jRootPane = (JRootPane)jComponent;
        if (jRootPane.getWindowDecorationStyle() != 0) {
            this.installWindowDecorations(jRootPane);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        JRootPane jRootPane = (JRootPane)jComponent;
        if (jRootPane.getWindowDecorationStyle() != 0) {
            this.uninstallWindowDecorations(jRootPane);
        }
        super.uninstallUI(jComponent);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("windowDecorationStyle")) {
            JRootPane jRootPane = (JRootPane)propertyChangeEvent.getSource();
            if (jRootPane.getWindowDecorationStyle() != 0) {
                this.installWindowDecorations(jRootPane);
            } else {
                this.uninstallWindowDecorations(jRootPane);
            }
        }
    }

    private void installWindowDecorations(JRootPane jRootPane) {
        jRootPane.setBorder(new MetalFrameBorder());
        MetalTitlePane metalTitlePane = new MetalTitlePane(jRootPane);
        jRootPane.setLayout(new MetalRootLayout(metalTitlePane));
        if (!$assertionsDisabled && jRootPane.getLayeredPane().getComponentCount() <= 0) {
            throw new AssertionError((Object)"We should have a contentPane already");
        }
        jRootPane.getLayeredPane().add(metalTitlePane, JLayeredPane.FRAME_CONTENT_LAYER, 1);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void uninstallWindowDecorations(JRootPane jRootPane) {
        jRootPane.setBorder(null);
        JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
        for (int i = jLayeredPane.getComponentCount() - 1; i >= 0; --i) {
            if (!(jLayeredPane.getComponent(i) instanceof MetalTitlePane)) continue;
            jLayeredPane.remove(i);
            break;
        }
    }

    static {
        $assertionsDisabled = MetalRootPaneUI.class$("javax.swing.plaf.metal.MetalRootPaneUI").desiredAssertionStatus() ^ true;
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private Rectangle glassPaneBounds;
        private Rectangle layeredPaneBounds;
        private Rectangle contentPaneBounds;
        private Rectangle menuBarBounds;
        private Rectangle titlePaneBounds;
        private Dimension prefSize;
        private MetalTitlePane titlePane;

        MetalRootLayout(MetalTitlePane metalTitlePane) {
            this.titlePane = metalTitlePane;
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public Dimension maximumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        public void invalidateLayout(Container container) {
            MetalRootLayout metalRootLayout = this;
            synchronized (metalRootLayout) {
                try {
                    this.glassPaneBounds = null;
                    this.layeredPaneBounds = null;
                    this.contentPaneBounds = null;
                    this.menuBarBounds = null;
                    this.titlePaneBounds = null;
                    this.prefSize = null;
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            JRootPane jRootPane = (JRootPane)container;
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            Container container2 = jRootPane.getContentPane();
            JMenuBar jMenuBar = jRootPane.getJMenuBar();
            MetalRootLayout metalRootLayout = this;
            synchronized (metalRootLayout) {
                try {
                    Dimension dimension;
                    Cloneable cloneable;
                    if (this.prefSize == null) {
                        cloneable = container.getInsets();
                        this.prefSize = new Dimension(cloneable.left + cloneable.right, cloneable.top + cloneable.bottom);
                        dimension = ((Component)container2).getPreferredSize();
                        this.prefSize.width += dimension.width;
                        this.prefSize.height += dimension.height + this.titlePane.getPreferredSize().height;
                        if (jMenuBar != null) {
                            Dimension dimension2 = ((Component)jMenuBar).getPreferredSize();
                            if (dimension2.width > dimension.width) {
                                this.prefSize.width += dimension2.width - dimension.width;
                            }
                            this.prefSize.height += dimension2.height;
                        }
                    }
                    cloneable = new Dimension(this.prefSize);
                    dimension = null;
                    return cloneable;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    throw throwable;
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public void layoutContainer(Container container) {
            JRootPane jRootPane = (JRootPane)container;
            JLayeredPane jLayeredPane = jRootPane.getLayeredPane();
            Container container2 = jRootPane.getContentPane();
            JMenuBar jMenuBar = jRootPane.getJMenuBar();
            Component component = jRootPane.getGlassPane();
            if (this.glassPaneBounds == null || this.layeredPaneBounds == null || this.contentPaneBounds == null || this.menuBarBounds == null) {
                Insets insets = jRootPane.getInsets();
                int n = container.getBounds().width - insets.left - insets.right;
                int n2 = container.getBounds().height - insets.top - insets.bottom;
                if (this.titlePaneBounds == null) {
                    this.titlePaneBounds = new Rectangle();
                }
                this.titlePaneBounds.width = n;
                this.titlePaneBounds.height = this.titlePane.getPreferredSize().height;
                if (this.menuBarBounds == null) {
                    this.menuBarBounds = new Rectangle();
                }
                this.menuBarBounds.setBounds(0, this.titlePaneBounds.y + this.titlePaneBounds.height, n, 0);
                if (jMenuBar != null) {
                    Dimension dimension = ((Component)jMenuBar).getPreferredSize();
                    this.menuBarBounds.height = dimension.height > n2 ? n2 : dimension.height;
                }
                if (this.contentPaneBounds == null) {
                    this.contentPaneBounds = new Rectangle();
                }
                this.contentPaneBounds.setBounds(0, this.menuBarBounds.y + this.menuBarBounds.height, n, n2 - this.menuBarBounds.y - this.menuBarBounds.height);
                this.glassPaneBounds = new Rectangle(insets.left, insets.top, n, n2);
                this.layeredPaneBounds = new Rectangle(insets.left, insets.top, n, n2);
            }
            component.setBounds(this.glassPaneBounds);
            jLayeredPane.setBounds(this.layeredPaneBounds);
            if (jMenuBar != null) {
                jMenuBar.setBounds(this.menuBarBounds);
            }
            container2.setBounds(this.contentPaneBounds);
            this.titlePane.setBounds(this.titlePaneBounds);
        }
    }

    private static class MetalTitlePane
    extends JComponent {
        JRootPane rootPane;
        JButton closeButton;
        JButton iconButton;
        JButton maxButton;
        Icon minIcon;
        Icon maxIcon;
        private Icon iconIcon;
        Icon closeIcon;
        private Color notSelectedTitleColor;
        private Color selectedTitleColor;
        JLabel title;
        private Action closeAction;
        private Action iconifyAction;
        private Action maximizeAction;
        private JMenuBar menuBar;
        protected JMenu windowMenu;

        MetalTitlePane(JRootPane jRootPane) {
            this.rootPane = jRootPane;
            this.setLayout(this.createLayout());
            this.title = new JLabel();
            this.title.setHorizontalAlignment(2);
            this.title.setHorizontalTextPosition(2);
            this.title.setOpaque(false);
            this.installTitlePane();
        }

        protected LayoutManager createLayout() {
            return new MetalTitlePaneLayout(this);
        }

        protected void installTitlePane() {
            this.installDefaults();
            this.installListeners();
            this.createActions();
            this.assembleSystemMenu();
            this.createButtons();
            this.setButtonIcons();
            this.addSubComponents();
            this.enableActions();
        }

        private void enableActions() {
        }

        private void addSubComponents() {
            this.add(this.menuBar);
            this.add(this.closeButton);
            this.add(this.iconButton);
            this.add(this.maxButton);
        }

        private void installListeners() {
            MouseHandler mouseHandler = new MouseHandler(this);
            this.addMouseListener(mouseHandler);
            this.addMouseMotionListener(mouseHandler);
        }

        private void createActions() {
            this.closeAction = new CloseAction(this);
            this.iconifyAction = new IconifyAction(this);
            this.maximizeAction = new MaximizeAction(this);
        }

        private void assembleSystemMenu() {
            this.menuBar = this.createSystemMenuBar();
            this.windowMenu = this.createSystemMenu();
            this.menuBar.add(this.windowMenu);
            this.addSystemMenuItems(this.windowMenu);
            this.enableActions();
        }

        protected JMenuBar createSystemMenuBar() {
            if (this.menuBar == null) {
                this.menuBar = new JMenuBar();
            }
            this.menuBar.removeAll();
            return this.menuBar;
        }

        protected JMenu createSystemMenu() {
            if (this.windowMenu == null) {
                this.windowMenu = new JMenu();
            }
            this.windowMenu.removeAll();
            return this.windowMenu;
        }

        private void addSystemMenuItems(JMenu jMenu) {
        }

        protected void createButtons() {
            this.closeButton = new PaneButton(this, this.closeAction);
            this.closeButton.setText(null);
            this.iconButton = new PaneButton(this, this.iconifyAction);
            this.iconButton.setText(null);
            this.maxButton = new PaneButton(this, this.maximizeAction);
            this.maxButton.setText(null);
            this.closeButton.setBorderPainted(false);
            this.closeButton.setContentAreaFilled(false);
            this.iconButton.setBorderPainted(false);
            this.iconButton.setContentAreaFilled(false);
            this.maxButton.setBorderPainted(false);
            this.maxButton.setContentAreaFilled(false);
        }

        protected void setButtonIcons() {
            if (this.closeIcon != null && this.closeButton != null) {
                this.closeButton.setIcon(this.closeIcon);
            }
            if (this.iconIcon != null && this.iconButton != null) {
                this.iconButton.setIcon(this.iconIcon);
            }
            if (this.maxIcon != null && this.maxButton != null) {
                this.maxButton.setIcon(this.maxIcon);
            }
        }

        public void paintComponent(Graphics graphics) {
            int n;
            Window window = SwingUtilities.getWindowAncestor(this.rootPane);
            Color color = graphics.getColor();
            this.paintTitleBackground(graphics);
            this.paintChildren(graphics);
            Dimension dimension = this.getSize();
            if (window.isActive()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(0, 0, 0, 0);
            graphics.drawLine(dimension.width - 1, 0, dimension.width - 1, 0);
            graphics.drawLine(0, dimension.height - 1, dimension.width - 1, dimension.height - 1);
            if (UIManager.get("InternalFrame.activeTitleGradient") != null && window.isActive()) {
                MetalUtils.paintGradient(graphics, 0, 0, this.getWidth(), this.getHeight(), 1, "InternalFrame.activeTitleGradient");
            }
            Rectangle rectangle = this.title.getBounds();
            int n2 = n = rectangle.x + rectangle.width + 5;
            if (this.iconButton.isVisible()) {
                n2 = Math.max(this.iconButton.getX(), n2);
            } else if (this.maxButton.isVisible()) {
                n2 = Math.max(this.maxButton.getX(), n2);
            } else if (this.closeButton.isVisible()) {
                n2 = Math.max(this.closeButton.getX(), n2);
            }
            if ((n2 -= 7) > n) {
                MetalUtils.fillMetalPattern(this, graphics, n, 3, n2 - n, this.getHeight() - 6, Color.white, Color.gray);
            }
            graphics.setColor(color);
        }

        protected void paintTitleBackground(Graphics graphics) {
            Window window = SwingUtilities.getWindowAncestor(this.rootPane);
            if (!this.isOpaque()) {
                return;
            }
            Color color = graphics.getColor();
            Dimension dimension = this.getSize();
            Color color2 = this.getBackground();
            color2 = window.isActive() ? this.selectedTitleColor : this.notSelectedTitleColor;
            graphics.setColor(color2);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(color);
        }

        private void installDefaults() {
            this.title.setFont(UIManager.getFont("InternalFrame.titleFont"));
            this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
            this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
            this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
            this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
            this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.minIcon = MetalIconFactory.getInternalFrameAltMaximizeIcon(16);
            Frame frame = (Frame)SwingUtilities.getWindowAncestor(this.rootPane);
            this.title = new JLabel(frame.getTitle(), MetalIconFactory.getInternalFrameDefaultMenuIcon(), 2);
        }

        private class MetalTitlePaneLayout
        implements LayoutManager {
            private /* synthetic */ MetalTitlePane this$1;

            public MetalTitlePaneLayout(MetalTitlePane metalTitlePane) {
                this.this$1 = metalTitlePane;
            }

            public void addLayoutComponent(String string, Component component) {
            }

            public void layoutContainer(Container container) {
                int n;
                Dimension dimension = container.getSize();
                Insets insets = container.getInsets();
                int n2 = dimension.width - insets.left - insets.right;
                int n3 = dimension.height - insets.top - insets.bottom;
                int n4 = n2 - insets.right - 1;
                int n5 = insets.top + 2;
                int n6 = n3 - 4;
                if (this.this$1.closeButton.isVisible()) {
                    n = this.this$1.closeIcon.getIconWidth();
                    this.this$1.closeButton.setBounds(n4 -= n + 2, n5, n, n6);
                    n4 -= 6;
                }
                if (this.this$1.maxButton.isVisible()) {
                    n = this.this$1.maxIcon.getIconWidth();
                    this.this$1.maxButton.setBounds(n4 -= n + 4, n5, n, n6);
                }
                if (this.this$1.iconButton.isVisible()) {
                    n = this.this$1.minIcon.getIconWidth();
                    this.this$1.iconButton.setBounds(n4 -= n + 4, n5, n, n6);
                    n4 -= 2;
                }
                Dimension dimension2 = this.this$1.title.getPreferredSize();
                this.this$1.title.setBounds(insets.left + 5, insets.top, Math.min(dimension2.width, n4 - insets.left - 10), n3);
            }

            public Dimension minimumLayoutSize(Container container) {
                return this.preferredLayoutSize(container);
            }

            public Dimension preferredLayoutSize(Container container) {
                return new Dimension(22, 22);
            }

            public void removeLayoutComponent(Component component) {
            }
        }

        private class PaneButton
        extends JButton {
            private /* synthetic */ MetalTitlePane this$1;

            public PaneButton(MetalTitlePane metalTitlePane, Action action) {
                this.this$1 = metalTitlePane;
                super(action);
                this.setMargin(new Insets(0, 0, 0, 0));
            }

            public boolean isFocusable() {
                return false;
            }
        }

        private class MaximizeAction
        extends AbstractAction {
            private /* synthetic */ MetalTitlePane this$1;

            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.getWindowAncestor(this.this$1.rootPane);
                if (window instanceof Frame) {
                    Frame frame = (Frame)window;
                    int n = frame.getExtendedState();
                    frame.setExtendedState(6);
                }
            }

            MaximizeAction(MetalTitlePane metalTitlePane) {
                this.this$1 = metalTitlePane;
            }
        }

        private class IconifyAction
        extends AbstractAction {
            private /* synthetic */ MetalTitlePane this$1;

            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.getWindowAncestor(this.this$1.rootPane);
                if (window instanceof Frame) {
                    Frame frame = (Frame)window;
                    int n = frame.getExtendedState();
                    frame.setExtendedState(1);
                }
            }

            IconifyAction(MetalTitlePane metalTitlePane) {
                this.this$1 = metalTitlePane;
            }
        }

        private class CloseAction
        extends AbstractAction {
            private /* synthetic */ MetalTitlePane this$1;

            public CloseAction(MetalTitlePane metalTitlePane) {
                this.this$1 = metalTitlePane;
                super("Close");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Window window = SwingUtilities.getWindowAncestor(this.this$1.rootPane);
                if (window instanceof JFrame) {
                    JFrame jFrame = (JFrame)window;
                    switch (jFrame.getDefaultCloseOperation()) {
                        case 3: {
                            jFrame.setVisible(false);
                            jFrame.dispose();
                            System.exit(0);
                            break;
                        }
                        case 2: {
                            jFrame.setVisible(false);
                            jFrame.dispose();
                            break;
                        }
                        case 1: {
                            jFrame.setVisible(false);
                            break;
                        }
                    }
                } else if (window instanceof JDialog) {
                    JDialog jDialog = (JDialog)window;
                    switch (jDialog.getDefaultCloseOperation()) {
                        case 2: {
                            jDialog.setVisible(false);
                            jDialog.dispose();
                            break;
                        }
                        case 1: {
                            jDialog.setVisible(false);
                            break;
                        }
                    }
                }
            }
        }

        private class MouseHandler
        extends MouseInputAdapter {
            private /* synthetic */ MetalTitlePane this$1;
            Point lastDragLocation;

            public void mousePressed(MouseEvent mouseEvent) {
                this.lastDragLocation = mouseEvent.getPoint();
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = point.x - this.lastDragLocation.x;
                int n2 = point.y - this.lastDragLocation.y;
                Window window = SwingUtilities.getWindowAncestor(this.this$1.rootPane);
                Point point2 = window.getLocation();
                window.setLocation(point2.x + n, point2.y + n2);
            }

            MouseHandler(MetalTitlePane metalTitlePane) {
                this.this$1 = metalTitlePane;
            }
        }
    }

    private static class MetalFrameBorder
    extends AbstractBorder {
        public Insets getBorderInsets(Component component, Insets insets) {
            if (insets == null) {
                insets = new Insets(5, 5, 5, 5);
            } else {
                insets.top = 5;
                insets.left = 5;
                insets.bottom = 5;
                insets.right = 5;
            }
            return insets;
        }

        public Insets getBorderInsets(Component component) {
            return this.getBorderInsets(component, null);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JRootPane jRootPane = (JRootPane)component;
            Window window = SwingUtilities.getWindowAncestor(jRootPane);
            if (window.isActive()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.fillRect(n, n2, n3, 5);
            graphics.fillRect(n, n2, 5, n4);
            graphics.fillRect(n + n3 - 5, n2, 5, n4);
            graphics.fillRect(n, n2 + n4 - 5, n3, 5);
            graphics.setColor(MetalLookAndFeel.getControl());
            graphics.fillRect(n, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2, 1, 1);
            graphics.fillRect(n + n3 - 1, n2 + n4 - 1, 1, 1);
            graphics.fillRect(n, n2 + n4 - 1, 1, 1);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 14, n2 + 2, n + n3 - 15, n2 + 2);
            graphics.drawLine(n + 14, n2 + n4 - 3, n + n3 - 15, n2 + n4 - 3);
            graphics.drawLine(n + 2, n2 + 14, n + 2, n2 + n4 - 15);
            graphics.drawLine(n + n3 - 3, n2 + 14, n + n3 - 3, n2 + n4 - 15);
            if (window.isActive()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
            }
            graphics.drawLine(n + 15, n2 + 3, n + n3 - 14, n2 + 3);
            graphics.drawLine(n + 15, n2 + n4 - 2, n + n3 - 14, n2 + n4 - 2);
            graphics.drawLine(n + 3, n2 + 15, n + 3, n2 + n4 - 14);
            graphics.drawLine(n + n3 - 2, n2 + 15, n + n3 - 2, n2 + n4 - 14);
        }

        MetalFrameBorder() {
        }
    }
}

