/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    protected Icon icon = this.getDefaultIcon();

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRadioButtonUI();
    }

    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
    }

    protected String getPropertyPrefix() {
        return "RadioButton.";
    }

    public Icon getDefaultIcon() {
        return UIManager.getIcon(this.getPropertyPrefix() + "icon");
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        Font font = jComponent.getFont();
        graphics.setFont(font);
        ButtonModel buttonModel = abstractButton.getModel();
        boolean bl = abstractButton.isEnabled();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        SwingUtilities.calculateInnerArea(abstractButton, rectangle3);
        String string = SwingUtilities.layoutCompoundLabel(jComponent, graphics.getFontMetrics(font), abstractButton.getText(), icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle2, rectangle, abstractButton.getIconTextGap() + this.defaultTextShiftOffset);
        icon.paintIcon(jComponent, graphics, rectangle2.x, rectangle2.y);
        if (string != null) {
            this.paintText(graphics, abstractButton, rectangle, string);
        }
        if (abstractButton.hasFocus() && abstractButton.isFocusPainted() && buttonModel.isEnabled()) {
            this.paintFocus(graphics, rectangle, jComponent.getSize());
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Rectangle rectangle = new Rectangle();
        Rectangle rectangle2 = new Rectangle();
        Insets insets = abstractButton.getInsets();
        Icon icon = abstractButton.getIcon();
        if (icon == null) {
            icon = this.getDefaultIcon();
        }
        Rectangle rectangle3 = new Rectangle();
        SwingUtilities.layoutCompoundLabel(abstractButton, abstractButton.getFontMetrics(abstractButton.getFont()), abstractButton.getText(), icon, abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), rectangle3, rectangle, rectangle2, this.defaultTextIconGap + this.defaultTextShiftOffset);
        Rectangle rectangle4 = rectangle2.union(rectangle);
        return new Dimension(insets.left + rectangle4.width + insets.right + abstractButton.getHorizontalAlignment(), insets.top + rectangle4.height + insets.bottom);
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        Color color = UIManager.getColor(this.getPropertyPrefix() + ".focus");
        Color color2 = graphics.getColor();
        graphics.setColor(color);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(color2);
    }
}

