/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class BasicHTML {
    public static final String propertyKey = "html";
    public static final String documentBaseKey = "html.base";

    public static View createHTMLView(JComponent jComponent, String string) {
        HTMLDocument hTMLDocument = new HTMLDocument();
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        StringReader stringReader = new StringReader(string);
        try {
            hTMLEditorKit.read(stringReader, (Document)hTMLDocument, 0);
        }
        catch (IOException iOException) {
            AssertionError assertionError = new AssertionError((Object)"unexpected IOException");
            ((Throwable)((Object)assertionError)).initCause(iOException);
            throw assertionError;
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"unexpected BadLocationException");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        ViewFactory viewFactory = hTMLEditorKit.getViewFactory();
        Element element = hTMLDocument.getDefaultRootElement();
        View view = viewFactory.create(element);
        HTMLRootView hTMLRootView = new HTMLRootView(jComponent, view, hTMLEditorKit, hTMLDocument);
        return hTMLRootView;
    }

    public static boolean isHTMLString(String string) {
        return string != null && string.contains("<") && string.contains(">");
    }

    public static void updateRenderer(JComponent jComponent, String string) {
        if (BasicHTML.isHTMLString(string)) {
            jComponent.putClientProperty(propertyKey, BasicHTML.createHTMLView(jComponent, string));
        } else {
            jComponent.putClientProperty(propertyKey, null);
        }
    }

    private static class HTMLRootView
    extends View {
        private View view;
        private JComponent component;
        private EditorKit editorKit;
        private Document document;

        public HTMLRootView(JComponent jComponent, View view, EditorKit editorKit, Document document) {
            super(null);
            this.component = jComponent;
            this.editorKit = editorKit;
            this.document = document;
            this.setView(view);
        }

        public ViewFactory getViewFactory() {
            return this.editorKit.getViewFactory();
        }

        public void preferenceChanged(View view, boolean bl, boolean bl2) {
            this.component.revalidate();
        }

        public void setView(View view) {
            if (this.view != null) {
                this.view.setParent(null);
            }
            if (view != null) {
                view.setParent(this);
            }
            this.view = view;
        }

        public View getView(int n) {
            return this.view;
        }

        public int getViewCount() {
            int n = 0;
            if (this.view != null) {
                n = 1;
            }
            return n;
        }

        public Container getContainer() {
            return this.component;
        }

        public float getPreferredSpan(int n) {
            if (this.view != null) {
                return this.view.getPreferredSpan(n);
            }
            return 2.1474836E9f;
        }

        public void paint(Graphics graphics, Shape shape) {
            if (this.view != null) {
                Rectangle rectangle = shape.getBounds();
                this.view.setSize(rectangle.width, rectangle.height);
                this.view.paint(graphics, shape);
            }
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            return this.view.modelToView(n, shape, bias);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            return this.view.viewToModel(f, f2, shape, biasArray);
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.insertUpdate(documentEvent, shape, viewFactory);
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.removeUpdate(documentEvent, shape, viewFactory);
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            this.view.changedUpdate(documentEvent, shape, viewFactory);
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            return this.view.getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
        }

        public int getStartOffset() {
            return 0;
        }

        public int getEndOffset() {
            return this.getDocument().getLength();
        }

        public Document getDocument() {
            return this.document;
        }
    }
}

