/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.SplitPaneUI;

public class JSplitPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = -5634142046175988380L;
    public static final String BOTTOM = "bottom";
    public static final String CONTINUOUS_LAYOUT_PROPERTY = "continuousLayout";
    public static final String DIVIDER = "divider";
    public static final String DIVIDER_LOCATION_PROPERTY = "dividerLocation";
    public static final String DIVIDER_SIZE_PROPERTY = "dividerSize";
    public static final int HORIZONTAL_SPLIT = 1;
    public static final String LAST_DIVIDER_LOCATION_PROPERTY = "lastDividerLocation";
    public static final String LEFT = "left";
    public static final String ONE_TOUCH_EXPANDABLE_PROPERTY = "oneTouchExpandable";
    public static final String ORIENTATION_PROPERTY = "orientation";
    public static final String RESIZE_WEIGHT_PROPERTY = "resizeWeight";
    public static final String RIGHT = "right";
    public static final String TOP = "top";
    public static final int VERTICAL_SPLIT = 0;
    protected boolean continuousLayout;
    protected boolean oneTouchExpandable;
    protected int dividerSize;
    protected int lastDividerLocation;
    protected int orientation;
    protected Component leftComponent;
    protected Component rightComponent;
    private transient double resizeWeight;
    private boolean clientDividerSizeSet;
    private boolean clientOneTouchExpandableSet;

    private /* synthetic */ void finit$() {
        this.oneTouchExpandable = false;
        this.dividerSize = 10;
        this.clientDividerSizeSet = false;
        this.clientOneTouchExpandableSet = false;
    }

    public JSplitPane(int n, boolean bl, Component component, Component component2) {
        this.finit$();
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("orientation is invalid.");
        }
        this.orientation = n;
        this.continuousLayout = bl;
        this.setLeftComponent(component);
        this.setRightComponent(component2);
        this.updateUI();
    }

    public JSplitPane(int n, Component component, Component component2) {
        this(n, false, component, component2);
    }

    public JSplitPane(int n, boolean bl) {
        this(n, bl, null, null);
    }

    public JSplitPane(int n) {
        this(n, false, null, null);
    }

    public JSplitPane() {
        this(1, false, new JButton("left button"), new JButton("right button"));
    }

    protected void addImpl(Component component, Object object, int n) {
        boolean bl = false;
        boolean bl2 = true;
        int n2 = 2;
        if (object == null) {
            if (this.leftComponent == null) {
                object = LEFT;
            } else if (this.rightComponent == null) {
                object = RIGHT;
            }
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.equals(BOTTOM) || string.equals(RIGHT)) {
                if (this.rightComponent != null) {
                    this.remove(this.rightComponent);
                }
                this.rightComponent = component;
            } else if (string.equals(LEFT) || string.equals(TOP)) {
                if (this.leftComponent != null) {
                    this.remove(this.leftComponent);
                }
                this.leftComponent = component;
            } else if (string.equals(DIVIDER)) {
                object = null;
            } else {
                throw new IllegalArgumentException("Constraints is not a known identifier.");
            }
            if (this.getDividerLocation() != -1) {
                this.resetToPreferredSizes();
            }
            super.addImpl(component, object, n);
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJSplitPane(this);
        }
        return this.accessibleContext;
    }

    public Component getBottomComponent() {
        return this.rightComponent;
    }

    public int getDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getDividerLocation(this);
        }
        return -1;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public int getLastDividerLocation() {
        return this.lastDividerLocation;
    }

    public Component getLeftComponent() {
        return this.leftComponent;
    }

    public int getMaximumDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getMaximumDividerLocation(this);
        }
        return -1;
    }

    public int getMinimumDividerLocation() {
        if (this.ui != null) {
            return ((SplitPaneUI)this.ui).getMinimumDividerLocation(this);
        }
        return -1;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public double getResizeWeight() {
        return this.resizeWeight;
    }

    public Component getRightComponent() {
        return this.rightComponent;
    }

    public Component getTopComponent() {
        return this.leftComponent;
    }

    public SplitPaneUI getUI() {
        return (SplitPaneUI)this.ui;
    }

    public boolean isContinuousLayout() {
        return this.continuousLayout;
    }

    public boolean isOneTouchExpandable() {
        return this.oneTouchExpandable;
    }

    public boolean isValidateRoot() {
        return true;
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.ui != null) {
            ((SplitPaneUI)this.ui).finishedPaintingChildren(this, graphics);
        }
    }

    protected String paramString() {
        String string = "";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(",continuousLayout=").append(this.isContinuousLayout());
        stringBuffer.append(",dividerSize=").append(this.getDividerSize());
        stringBuffer.append(",lastDividerLocation=").append(this.getLastDividerLocation());
        stringBuffer.append(",oneTouchExpandable=").append(this.isOneTouchExpandable());
        stringBuffer.append(",orientation=");
        if (this.orientation == 1) {
            stringBuffer.append("HORIZONTAL_SPLIT");
        } else {
            stringBuffer.append("VERTICAL_SPLIT");
        }
        return string + stringBuffer.toString();
    }

    public void remove(Component component) {
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(component);
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component == this.leftComponent) {
            this.leftComponent = null;
        } else if (component == this.rightComponent) {
            this.rightComponent = null;
        }
        super.remove(n);
    }

    public void removeAll() {
        this.leftComponent = null;
        this.rightComponent = null;
        super.removeAll();
    }

    public void resetToPreferredSizes() {
        if (this.ui != null) {
            ((SplitPaneUI)this.ui).resetToPreferredSizes(this);
        }
    }

    public void setBottomComponent(Component component) {
        if (component != null) {
            this.add(component, BOTTOM);
        } else {
            this.add((Component)new JButton("right button"), BOTTOM);
        }
    }

    public void setContinuousLayout(boolean bl) {
        if (bl != this.continuousLayout) {
            boolean bl2 = this.continuousLayout;
            this.continuousLayout = bl;
            this.firePropertyChange(CONTINUOUS_LAYOUT_PROPERTY, bl2, this.continuousLayout);
        }
    }

    public void setDividerLocation(double d) {
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("proportion has to be between 0 and 1.");
        }
        int n = (this.orientation == 1 ? this.getWidth() : this.getHeight()) - this.getDividerSize();
        this.setDividerLocation((int)(d * (double)n));
    }

    public void setDividerLocation(int n) {
        if (this.ui != null && n != this.getDividerLocation()) {
            int n2 = this.getDividerLocation();
            if (n < 0) {
                ((SplitPaneUI)this.ui).resetToPreferredSizes(this);
            } else {
                ((SplitPaneUI)this.ui).setDividerLocation(this, n);
            }
            this.firePropertyChange(DIVIDER_LOCATION_PROPERTY, n2, this.getDividerLocation());
        }
    }

    public void setDividerSize(int n) {
        this.clientDividerSizeSet = true;
        if (n != this.dividerSize) {
            int n2 = this.dividerSize;
            this.dividerSize = n;
            this.firePropertyChange(DIVIDER_SIZE_PROPERTY, n2, this.dividerSize);
        }
    }

    public void setLastDividerLocation(int n) {
        if (n != this.lastDividerLocation) {
            int n2 = this.lastDividerLocation;
            this.lastDividerLocation = n;
            this.firePropertyChange(LAST_DIVIDER_LOCATION_PROPERTY, n2, this.lastDividerLocation);
        }
    }

    public void setLeftComponent(Component component) {
        if (component != null) {
            this.add(component, LEFT);
        } else {
            this.remove(this.leftComponent);
        }
    }

    public void setOneTouchExpandable(boolean bl) {
        this.clientOneTouchExpandableSet = true;
        if (bl != this.oneTouchExpandable) {
            boolean bl2 = this.oneTouchExpandable;
            this.oneTouchExpandable = bl;
            this.firePropertyChange(ONE_TOUCH_EXPANDABLE_PROPERTY, bl2, this.oneTouchExpandable);
        }
    }

    public void setOrientation(int n) {
        if (n != 1 && n != 0) {
            throw new IllegalArgumentException("orientation must be one of VERTICAL_SPLIT, HORIZONTAL_SPLIT");
        }
        if (n != this.orientation) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange(ORIENTATION_PROPERTY, n2, this.orientation);
        }
    }

    public void setResizeWeight(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Value outside permitted range.");
        }
        if (this.resizeWeight != d) {
            double d2 = this.resizeWeight;
            this.resizeWeight = d;
            this.firePropertyChange(RESIZE_WEIGHT_PROPERTY, d2, d);
        }
    }

    public void setRightComponent(Component component) {
        if (component != null) {
            this.add(component, RIGHT);
        } else {
            this.remove(this.rightComponent);
        }
    }

    public void setTopComponent(Component component) {
        if (component != null) {
            this.add(component, TOP);
        } else {
            this.add((Component)new JButton("left button"), TOP);
        }
    }

    public void setUI(SplitPaneUI splitPaneUI) {
        super.setUI(splitPaneUI);
    }

    public void updateUI() {
        this.setUI((SplitPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "SplitPaneUI";
    }

    void setUIProperty(String string, Object object) {
        if (string.equals(DIVIDER_SIZE_PROPERTY)) {
            if (!this.clientDividerSizeSet) {
                this.setDividerSize((Integer)object);
                this.clientDividerSizeSet = false;
            }
        } else if (string.equals(ONE_TOUCH_EXPANDABLE_PROPERTY)) {
            if (!this.clientOneTouchExpandableSet) {
                this.setOneTouchExpandable((Boolean)object);
                this.clientOneTouchExpandableSet = false;
            }
        } else {
            super.setUIProperty(string, object);
        }
    }

    protected class AccessibleJSplitPane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JSplitPane this$0;
        private static final long serialVersionUID = -1788116871416305366L;

        protected AccessibleJSplitPane(JSplitPane jSplitPane) {
            this.this$0 = jSplitPane;
            super(jSplitPane);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (this.this$0.getOrientation() == 1) {
                accessibleStateSet.add(AccessibleState.HORIZONTAL);
            } else if (this.this$0.getOrientation() == 0) {
                accessibleStateSet.add(AccessibleState.VERTICAL);
            }
            return accessibleStateSet;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(this.this$0.getDividerLocation());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            if (number == null) {
                return false;
            }
            Number number2 = this.getCurrentAccessibleValue();
            this.this$0.setDividerLocation(number.intValue());
            this.firePropertyChange("AccessibleValue", number2, new Integer(number.intValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(this.this$0.getMinimumDividerLocation());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(this.this$0.getMaximumDividerLocation());
        }
    }
}

