/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class TrustManagerFactory {
    private static final String TRUST_MANAGER_FACTORY = "TrustManagerFactory";
    private static final String DEFAULT_ALGORITHM = "JessieX509";
    private final TrustManagerFactorySpi tmfSpi;
    private final Provider provider;
    private final String algorithm;

    protected TrustManagerFactory(TrustManagerFactorySpi trustManagerFactorySpi, Provider provider, String string) {
        this.tmfSpi = trustManagerFactorySpi;
        this.provider = provider;
        this.algorithm = string;
    }

    public static final TrustManagerFactory getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return TrustManagerFactory.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static final TrustManagerFactory getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return TrustManagerFactory.getInstance(string, provider);
    }

    public static final TrustManagerFactory getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException();
        }
        try {
            return new TrustManagerFactory((TrustManagerFactorySpi)Engine.getInstance(TRUST_MANAGER_FACTORY, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        catch (ClassCastException classCastException) {
            throw new NoSuchAlgorithmException(string);
        }
    }

    public static final String getDefaultAlgorithm() {
        String string = null;
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(null){
                private /* synthetic */ TrustManagerFactory this$0;
                {
                    this.this$0 = trustManagerFactory;
                }

                public Object run() {
                    return Security.getProperty("ssl.TrustManagerFactory.algorithm");
                }
            });
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            string = DEFAULT_ALGORITHM;
        }
        return string;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final TrustManager[] getTrustManagers() {
        return this.tmfSpi.engineGetTrustManagers();
    }

    public final void init(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        this.tmfSpi.engineInit(managerFactoryParameters);
    }

    public final void init(KeyStore keyStore) throws KeyStoreException {
        this.tmfSpi.engineInit(keyStore);
    }
}

