/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;

public class RC2ParameterSpec
implements AlgorithmParameterSpec {
    private static final int RC2_IV_LENGTH = 8;
    private int effectiveKeyBits;
    private byte[] iv;

    public RC2ParameterSpec(int n) {
        this.effectiveKeyBits = n;
    }

    public RC2ParameterSpec(int n, byte[] byArray) {
        this(n, byArray, 0);
    }

    public RC2ParameterSpec(int n, byte[] byArray, int n2) {
        if (byArray.length - n2 < 8) {
            throw new IllegalArgumentException("IV too short");
        }
        this.effectiveKeyBits = n;
        this.iv = new byte[8];
        System.arraycopy(byArray, n2, this.iv, 0, 8);
    }

    public int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    public byte[] getIV() {
        return this.iv;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        byte[] byArray = ((RC2ParameterSpec)object).getIV();
        if (this.iv != byArray) {
            if (this.iv == null || byArray == null) {
                return false;
            }
            if (this.iv.length != byArray.length) {
                return false;
            }
            for (int i = 0; i < this.iv.length; ++i) {
                if (this.iv[i] == byArray[i]) continue;
                return false;
            }
        }
        return this.effectiveKeyBits == ((RC2ParameterSpec)object).getEffectiveKeyBits();
    }

    public int hashCode() {
        int n = this.effectiveKeyBits;
        if (this.iv != null) {
            for (int i = 0; i < 8; ++i) {
                n += this.iv[i];
            }
        }
        return n;
    }
}

