/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class StreamHandler
extends Handler {
    private OutputStream out;
    private Writer writer;
    private int streamState;
    private static final int STATE_FRESH = 0;
    private static final int STATE_PUBLISHED = 1;
    private static final int STATE_CLOSED = 2;

    private /* synthetic */ void finit$() {
        this.streamState = 0;
    }

    public StreamHandler() {
        this(null, null);
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        this(outputStream, "java.util.logging.StreamHandler", Level.INFO, formatter, StreamHandler.class$("java.util.logging.SimpleFormatter"));
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    StreamHandler(OutputStream outputStream, String string, Level level, Formatter formatter, Class clazz) {
        this.finit$();
        this.level = LogManager.getLevelProperty(string + ".level", level);
        this.filter = (Filter)LogManager.getInstanceProperty(string + ".filter", StreamHandler.class$("java.util.logging.Filter"), null);
        this.formatter = formatter != null ? formatter : (Formatter)LogManager.getInstanceProperty(string + ".formatter", StreamHandler.class$("java.util.logging.Formatter"), clazz);
        try {
            String string2 = LogManager.getLogManager().getProperty(string + ".encoding");
            if (string2 != null && string2.length() > 0) {
                new String(new byte[0], string2);
            }
            this.encoding = string2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outputStream != null) {
            try {
                this.changeWriter(outputStream, this.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.getMessage());
            }
        }
    }

    private void checkOpen() {
        if (this.streamState == 2) {
            throw new IllegalStateException(this.toString() + " has been closed");
        }
    }

    private void checkFresh() {
        this.checkOpen();
        if (this.streamState != 0) {
            throw new IllegalStateException("some log records have been published to " + this);
        }
    }

    private void changeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string);
        if (this.streamState != 0 || this.writer != null) {
            this.close();
        }
        this.writer = outputStreamWriter;
        this.out = outputStream;
        this.encoding = string;
        this.streamState = 0;
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        this.checkFresh();
        if (this.out != null) {
            this.writer = string == null ? new OutputStreamWriter(this.out) : new OutputStreamWriter(this.out, string);
        }
    }

    protected void setOutputStream(OutputStream outputStream) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        outputStream.getClass();
        try {
            this.changeWriter(outputStream, this.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.streamState == 0) {
            try {
                this.writer.write(this.formatter.getHead(this));
            }
            catch (IOException iOException) {
                this.reportError(null, iOException, 1);
                return;
            }
            catch (Exception exception) {
                this.reportError(null, exception, 0);
                return;
            }
            this.streamState = 1;
        }
        try {
            string = this.formatter.format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            this.writer.write(string);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
        }
    }

    public boolean isLoggable(LogRecord logRecord) {
        return this.writer != null && super.isLoggable(logRecord);
    }

    public void flush() {
        try {
            this.checkOpen();
            if (this.writer != null) {
                this.writer.flush();
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
    }

    public void close() throws SecurityException {
        LogManager.getLogManager().checkAccess();
        try {
            this.checkOpen();
            this.flush();
            if (this.writer != null) {
                if (this.formatter != null) {
                    if (this.streamState == 0) {
                        this.writer.write(this.formatter.getHead(this));
                    }
                    if (this.streamState != 2) {
                        this.writer.write(this.formatter.getTail(this));
                    }
                }
                this.streamState = 2;
                this.writer.close();
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
    }
}

