/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Timestamp
extends Date {
    static final long serialVersionUID = 2745179027874758501L;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DecimalFormat decimalFormat = new DecimalFormat("000000000");
    private static StringBuffer sbuf = new StringBuffer(29);
    private int nanos;

    public static Timestamp valueOf(String string) {
        int n = 0;
        int n2 = string.indexOf(46);
        if (n2 != -1) {
            if (string.lastIndexOf(46) != n2) {
                throw new IllegalArgumentException(string);
            }
            int n3 = string.length() - n2 - 1;
            if (n3 < 1 || n3 > 9) {
                throw new IllegalArgumentException(string);
            }
            n = Integer.parseInt(string.substring(n2 + 1));
            for (int i = n3; i < 9; ++i) {
                n *= 10;
            }
            string = string.substring(0, n2);
        }
        try {
            SimpleDateFormat simpleDateFormat = dateFormat;
            synchronized (simpleDateFormat) {
                Timestamp timestamp;
                Date date;
                try {
                    date = (Date)dateFormat.parseObject(string);
                }
                finally {
                    timestamp = null;
                }
                if (date == null) {
                    throw new IllegalArgumentException(string);
                }
                timestamp = new Timestamp(date.getTime() + (long)(n / 1000000));
                timestamp.nanos = n;
                Timestamp timestamp2 = timestamp;
                return timestamp2;
            }
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException(string);
        }
    }

    public Timestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6);
        this.nanos = n7;
    }

    public Timestamp(long l) {
        super(l - l % (long)1000);
        this.nanos = (int)(l % (long)1000) * 1000000;
    }

    public long getTime() {
        return super.getTime() + (long)(this.nanos / 1000000);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            try {
                int n;
                sbuf.setLength(0);
                dateFormat.format(this, sbuf, null);
                sbuf.append('.');
                decimalFormat.format(this.nanos, sbuf, (FieldPosition)null);
                for (n = sbuf.length() - 1; n > 20 && sbuf.charAt(n) == '0'; --n) {
                }
                String string = sbuf.substring(0, n + 1);
                Object var4_4 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public int getNanos() {
        return this.nanos;
    }

    public void setNanos(int n) {
        this.nanos = n;
    }

    public boolean before(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        return l2 < (l = timestamp.getTime()) || l2 == l && this.getNanos() < timestamp.getNanos();
    }

    public boolean after(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        return l2 > (l = timestamp.getTime()) || l2 == l && this.getNanos() > timestamp.getNanos();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Timestamp)) {
            return false;
        }
        return this.equals((Timestamp)object);
    }

    public boolean equals(Timestamp timestamp) {
        if (timestamp == null) {
            return false;
        }
        if (timestamp.getTime() != this.getTime()) {
            return false;
        }
        return timestamp.getNanos() == this.getNanos();
    }

    public int compareTo(Timestamp timestamp) {
        int n = super.compareTo(timestamp);
        if (n != 0) {
            return n;
        }
        return this.nanos - timestamp.nanos;
    }

    public int compareTo(Object object) {
        return this.compareTo((Timestamp)object);
    }
}

