/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketPermission;
import java.util.Enumeration;

public class MulticastSocket
extends DatagramSocket {
    public MulticastSocket() throws IOException {
        this(new InetSocketAddress(0));
    }

    public MulticastSocket(int n) throws IOException {
        this(new InetSocketAddress(n));
    }

    public MulticastSocket(SocketAddress socketAddress) throws IOException {
        super((SocketAddress)null);
        this.setReuseAddress(true);
        if (socketAddress != null) {
            this.bind(socketAddress);
        }
    }

    public InetAddress getInterface() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        return (InetAddress)this.getImpl().getOption(16);
    }

    public byte getTTL() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        return this.getImpl().getTTL();
    }

    public int getTimeToLive() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        return this.getImpl().getTimeToLive();
    }

    public void setInterface(InetAddress inetAddress) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(16, inetAddress);
    }

    public void setNetworkInterface(NetworkInterface networkInterface) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Enumeration enumeration = networkInterface.getInetAddresses();
        if (!enumeration.hasMoreElements()) {
            throw new SocketException("no network devices found");
        }
        InetAddress inetAddress = (InetAddress)enumeration.nextElement();
        this.getImpl().setOption(16, inetAddress);
    }

    public NetworkInterface getNetworkInterface() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        InetAddress inetAddress = (InetAddress)this.getImpl().getOption(16);
        NetworkInterface networkInterface = NetworkInterface.getByInetAddress(inetAddress);
        return networkInterface;
    }

    public void setLoopbackMode(boolean bl) throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setOption(18, bl);
    }

    public boolean getLoopbackMode() throws SocketException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        Object object = this.getImpl().getOption(18);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        throw new SocketException("unexpected type");
    }

    public void setTTL(byte by) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        this.getImpl().setTTL(by);
    }

    public void setTimeToLive(int n) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (n <= 0 || n > 255) {
            throw new IllegalArgumentException("Invalid ttl: " + n);
        }
        this.getImpl().setTimeToLive(n);
    }

    public void joinGroup(InetAddress inetAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!inetAddress.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.getImpl().join(inetAddress);
    }

    public void leaveGroup(InetAddress inetAddress) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!inetAddress.isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetAddress);
        }
        this.getImpl().leave(inetAddress);
    }

    public void joinGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("SocketAddress type not supported");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (!inetSocketAddress.getAddress().isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetSocketAddress.getAddress());
        }
        this.getImpl().joinGroup(socketAddress, networkInterface);
    }

    public void leaveGroup(SocketAddress socketAddress, NetworkInterface networkInterface) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (!inetSocketAddress.getAddress().isMulticastAddress()) {
            throw new IOException("Not a Multicast address");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMulticast(inetSocketAddress.getAddress());
        }
        this.getImpl().leaveGroup(socketAddress, networkInterface);
    }

    public synchronized void send(DatagramPacket datagramPacket, byte by) throws IOException {
        if (this.isClosed()) {
            throw new SocketException("socket is closed");
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            InetAddress inetAddress = datagramPacket.getAddress();
            if (inetAddress.isMulticastAddress()) {
                securityManager.checkPermission(new SocketPermission(inetAddress.getHostName() + datagramPacket.getPort(), "accept,connect"));
            } else {
                securityManager.checkConnect(inetAddress.getHostAddress(), datagramPacket.getPort());
            }
        }
        int n = this.getImpl().getTimeToLive();
        this.getImpl().setTimeToLive(by & 0xFF);
        this.getImpl().send(datagramPacket);
        this.getImpl().setTimeToLive(n);
    }
}

