/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;

public final class DatagramPacket {
    private byte[] buffer;
    private int offset;
    int length;
    int maxlen;
    private InetAddress address;
    private int port;

    public DatagramPacket(byte[] byArray, int n, int n2) {
        this.setData(byArray, n, n2);
        this.address = null;
        this.port = -1;
    }

    public DatagramPacket(byte[] byArray, int n) {
        this(byArray, 0, n);
    }

    public DatagramPacket(byte[] byArray, int n, int n2, InetAddress inetAddress, int n3) {
        this.setData(byArray, n, n2);
        this.setAddress(inetAddress);
        this.setPort(n3);
    }

    public DatagramPacket(byte[] byArray, int n, InetAddress inetAddress, int n2) {
        this(byArray, 0, n, inetAddress, n2);
    }

    public DatagramPacket(byte[] byArray, int n, int n2, SocketAddress socketAddress) throws SocketException {
        if (!(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        this.setData(byArray, n, n2);
        this.setAddress(inetSocketAddress.getAddress());
        this.setPort(inetSocketAddress.getPort());
    }

    public DatagramPacket(byte[] byArray, int n, SocketAddress socketAddress) throws SocketException {
        this(byArray, 0, n, socketAddress);
    }

    public synchronized InetAddress getAddress() {
        return this.address;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized byte[] getData() {
        return this.buffer;
    }

    public synchronized int getOffset() {
        return this.offset;
    }

    public synchronized int getLength() {
        return this.length;
    }

    public synchronized void setAddress(InetAddress inetAddress) {
        this.address = inetAddress;
    }

    public synchronized void setPort(int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        this.port = n;
    }

    public void setSocketAddress(SocketAddress socketAddress) throws IllegalArgumentException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("address may not be null");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        this.address = inetSocketAddress.getAddress();
        this.port = inetSocketAddress.getPort();
    }

    public SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.address, this.port);
    }

    public void setData(byte[] byArray) {
        this.setData(byArray, 0, byArray.length);
    }

    public synchronized void setData(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException("Null buffer");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid offset: " + n);
        }
        this.buffer = byArray;
        this.offset = n;
        this.setLength(n2);
    }

    public synchronized void setLength(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid length: " + n);
        }
        if (this.offset + n > this.buffer.length) {
            throw new IllegalArgumentException("Potential buffer overflow - offset: " + this.offset + " length: " + n);
        }
        this.length = n;
        this.maxlen = n;
    }
}

