/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 32;
    private static final int initial_buffer_size;

    public ByteArrayOutputStream() {
        this(initial_buffer_size);
    }

    public ByteArrayOutputStream(int n) {
        this.buf = new byte[n];
        this.count = 0;
    }

    public synchronized void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public synchronized byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        return byArray;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buf, 0, this.count, string);
    }

    public String toString(int n) {
        return new String(this.buf, n, 0, this.count);
    }

    private void resize(int n) {
        if (this.count + n > this.buf.length) {
            int n2 = this.buf.length * 2;
            if (this.count + n > n2) {
                n2 = this.count + n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }

    public synchronized void write(int n) {
        this.resize(1);
        this.buf[this.count++] = (byte)n;
    }

    public synchronized void write(byte[] byArray, int n, int n2) {
        if (n2 >= 0) {
            this.resize(n2);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public synchronized void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buf, 0, this.count);
    }

    static {
        int n = Integer.getInteger("gnu.java.io.ByteArrayOutputStream.initialBufferSize", 32);
        if (n <= 0) {
            n = 32;
        }
        initial_buffer_size = n;
    }
}

