/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class ColorConvertOp
implements BufferedImageOp,
RasterOp {
    private ColorSpace srccs;
    private ColorSpace dstcs;
    private RenderingHints hints;
    private ICC_Profile[] profiles;
    private ColorSpace[] spaces;
    private boolean rasterValid;

    public ColorConvertOp(ColorSpace colorSpace, RenderingHints renderingHints) {
        if (colorSpace == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{colorSpace};
        this.hints = renderingHints;
        this.rasterValid = false;
    }

    public ColorConvertOp(ColorSpace colorSpace, ColorSpace colorSpace2, RenderingHints renderingHints) {
        if (colorSpace == null || colorSpace2 == null) {
            throw new NullPointerException();
        }
        this.spaces = new ColorSpace[]{colorSpace, colorSpace2};
        this.hints = renderingHints;
    }

    public ColorConvertOp(ICC_Profile[] iCC_ProfileArray, RenderingHints renderingHints) {
        if (iCC_ProfileArray == null) {
            throw new NullPointerException();
        }
        this.hints = renderingHints;
        this.profiles = iCC_ProfileArray;
        this.spaces = new ColorSpace[iCC_ProfileArray.length];
        for (int i = 0; i < iCC_ProfileArray.length; ++i) {
            this.spaces[i] = new ICC_ColorSpace(iCC_ProfileArray[i]);
        }
    }

    public ColorConvertOp(RenderingHints renderingHints) {
        this.hints = renderingHints;
        this.srccs = null;
        this.dstcs = null;
        this.rasterValid = false;
    }

    public final BufferedImage filter(BufferedImage transparency, BufferedImage bufferedImage) {
        Transparency transparency2;
        if (bufferedImage == null && this.spaces.length == 0) {
            throw new IllegalArgumentException();
        }
        if (transparency.isAlphaPremultiplied()) {
            transparency2 = this.createCompatibleDestImage((BufferedImage)transparency, transparency.getColorModel());
            this.copyimage((BufferedImage)transparency, (BufferedImage)transparency2);
            ((BufferedImage)transparency2).coerceData(false);
            transparency = transparency2;
        }
        transparency2 = transparency.getColorModel();
        for (int i = 0; i < this.spaces.length; ++i) {
            BufferedImage bufferedImage2 = this.createCompatibleDestImage((BufferedImage)transparency, (ColorModel)transparency2);
            this.copyimage((BufferedImage)transparency, bufferedImage2);
            transparency = bufferedImage2;
        }
        if (bufferedImage == null) {
            return transparency;
        }
        this.copyimage((BufferedImage)transparency, bufferedImage);
        return bufferedImage;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        return new BufferedImage(colorModel, bufferedImage.getRaster().createCompatibleWritableRaster(), bufferedImage.isPremultiplied, null);
    }

    public final ICC_Profile[] getICC_Profiles() {
        return this.profiles;
    }

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        if (!this.rasterValid) {
            throw new IllegalArgumentException();
        }
        for (int i = 1; i < this.spaces.length - 1; ++i) {
            WritableRaster writableRaster2 = this.createCompatibleDestRaster(raster);
            this.copyraster(raster, this.spaces[i - 1], writableRaster2, this.spaces[i]);
            raster = writableRaster2;
        }
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        }
        this.copyraster(raster, this.spaces[this.spaces.length - 2], writableRaster, this.spaces[this.spaces.length - 1]);
        return writableRaster;
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            return (Point2D)point2D.clone();
        }
        point2D2.setLocation(point2D);
        return point2D2;
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return bufferedImage.getRaster().getBounds();
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    private void copyimage(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        if (this.hints != null) {
            graphics2D.setRenderingHints(this.hints);
        }
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.dispose();
    }

    private void copyraster(Raster raster, ColorSpace colorSpace, WritableRaster writableRaster, ColorSpace colorSpace2) {
        float[] fArray = new float[raster.getNumBands()];
        if (this.hints.get(RenderingHints.KEY_COLOR_RENDERING) == "Highest quality color rendering mode") {
            for (int i = raster.getMinY(); i < raster.getHeight() + raster.getMinY(); ++i) {
                for (int j = raster.getMinX(); j < raster.getWidth() + raster.getMinX(); ++j) {
                    writableRaster.setPixel(j, i, colorSpace2.fromCIEXYZ(colorSpace.toCIEXYZ(raster.getPixel(j, i, fArray))));
                }
            }
        } else {
            for (int i = raster.getMinY(); i < raster.getHeight() + raster.getMinY(); ++i) {
                for (int j = raster.getMinX(); j < raster.getWidth() + raster.getMinX(); ++j) {
                    writableRaster.setPixel(j, i, colorSpace2.fromRGB(colorSpace.toRGB(raster.getPixel(j, i, fArray))));
                }
            }
        }
    }
}

