/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

public abstract class Point2D
implements Cloneable {
    protected Point2D() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract void setLocation(double var1, double var3);

    public void setLocation(Point2D point2D) {
        this.setLocation(point2D.getX(), point2D.getY());
    }

    public static double distanceSq(double d, double d2, double d3, double d4) {
        double d5 = d3 -= d;
        double d6 = d4 -= d2;
        return d5 * d5 + d6 * d6;
    }

    public static double distance(double d, double d2, double d3, double d4) {
        return Math.sqrt(Point2D.distanceSq(d, d2, d3, d4));
    }

    public double distanceSq(double d, double d2) {
        return Point2D.distanceSq(this.getX(), this.getY(), d, d2);
    }

    public double distanceSq(Point2D point2D) {
        return Point2D.distanceSq(this.getX(), this.getY(), point2D.getX(), point2D.getY());
    }

    public double distance(double d, double d2) {
        return Point2D.distance(this.getX(), this.getY(), d, d2);
    }

    public double distance(Point2D point2D) {
        return Point2D.distance(this.getX(), this.getY(), point2D.getX(), point2D.getY());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getY());
        l = l * (long)31 ^ java.lang.Double.doubleToLongBits(this.getX());
        return (int)(l >> 32) ^ (int)l;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point2D)) {
            return false;
        }
        Point2D point2D = (Point2D)object;
        return this.getX() == point2D.getX() && this.getY() == point2D.getY();
    }

    public static class Float
    extends Point2D {
        public float x;
        public float y;

        public Float() {
        }

        public Float(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = (float)d;
            this.y = (float)d2;
        }

        public void setLocation(float f, float f2) {
            this.x = f;
            this.y = f2;
        }

        public String toString() {
            return "Point2D.Float[" + this.x + ", " + this.y + ']';
        }
    }

    public static class Double
    extends Point2D {
        public double x;
        public double y;

        public Double() {
        }

        public Double(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void setLocation(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public String toString() {
            return "Point2D.Double[" + this.x + ", " + this.y + ']';
        }
    }
}

