/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.GraphicsDevice;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;

public abstract class GraphicsConfiguration {
    private ImageCapabilities imageCapabilities;
    private BufferCapabilities bufferCapabilities;

    protected GraphicsConfiguration() {
    }

    public abstract GraphicsDevice getDevice();

    public abstract BufferedImage createCompatibleImage(int var1, int var2);

    public abstract VolatileImage createCompatibleVolatileImage(int var1, int var2);

    public VolatileImage createCompatibleVolatileImage(int n, int n2, ImageCapabilities imageCapabilities) throws AWTException {
        throw new AWTException("not implemented");
    }

    public abstract VolatileImage createCompatibleVolatileImage(int var1, int var2, int var3);

    public abstract BufferedImage createCompatibleImage(int var1, int var2, int var3);

    public abstract ColorModel getColorModel();

    public abstract ColorModel getColorModel(int var1);

    public abstract AffineTransform getDefaultTransform();

    public abstract AffineTransform getNormalizingTransform();

    public abstract Rectangle getBounds();

    public BufferCapabilities getBufferCapabilities() {
        if (this.imageCapabilities == null) {
            this.getImageCapabilities();
        }
        if (this.bufferCapabilities == null) {
            this.bufferCapabilities = new BufferCapabilities(this.imageCapabilities, this.imageCapabilities, null);
        }
        return this.bufferCapabilities;
    }

    public ImageCapabilities getImageCapabilities() {
        if (this.imageCapabilities == null) {
            this.imageCapabilities = new ImageCapabilities(false);
        }
        return this.imageCapabilities;
    }
}

