/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.ColorPaintContext;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.io.Serializable;

public class Color
implements Paint,
Serializable {
    private static final long serialVersionUID = 118526816881161077L;
    public static final Color white;
    public static final Color WHITE;
    public static final Color lightGray;
    public static final Color LIGHT_GRAY;
    public static final Color gray;
    public static final Color GRAY;
    public static final Color darkGray;
    public static final Color DARK_GRAY;
    public static final Color black;
    public static final Color BLACK;
    public static final Color red;
    public static final Color RED;
    public static final Color pink;
    public static final Color PINK;
    public static final Color orange;
    public static final Color ORANGE;
    public static final Color yellow;
    public static final Color YELLOW;
    public static final Color green;
    public static final Color GREEN;
    public static final Color magenta;
    public static final Color MAGENTA;
    public static final Color cyan;
    public static final Color CYAN;
    public static final Color blue;
    public static final Color BLUE;
    private static final int RED_MASK = 0xFF0000;
    private static final int GREEN_MASK = 65280;
    private static final int BLUE_MASK = 255;
    static final int ALPHA_MASK = -16777216;
    private static final float BRIGHT_SCALE = 0.7f;
    final int value;
    private float[] frgbvalue;
    private float[] fvalue;
    private final float falpha;
    private final ColorSpace cs;
    transient ColorPaintContext context;

    public Color(int n, int n2, int n3) {
        this(n, n2, n3, 255);
    }

    public Color(int n, int n2, int n3, int n4) {
        if ((n & 0xFF) != n || (n2 & 0xFF) != n2 || (n3 & 0xFF) != n3 || (n4 & 0xFF) != n4) {
            throw new IllegalArgumentException("Bad RGB values red=0x" + Integer.toHexString(n) + " green=0x" + Integer.toHexString(n2) + " blue=0x" + Integer.toHexString(n3) + " alpha=0x" + Integer.toHexString(n4));
        }
        this.value = n4 << 24 | n << 16 | n2 << 8 | n3;
        this.falpha = 1.0f;
        this.cs = null;
    }

    public Color(int n) {
        this(n, false);
    }

    public Color(int n, boolean bl) {
        if (bl) {
            this.falpha = (float)((n & 0xFF000000) >> 24) / 255.0f;
        } else {
            n |= 0xFF000000;
            this.falpha = 1.0f;
        }
        this.value = n;
        this.cs = null;
    }

    public Color(float f, float f2, float f3) {
        this(f, f2, f3, 1.0f);
    }

    public Color(float f, float f2, float f3, float f4) {
        this.value = Color.convert(f, f2, f3, f4);
        this.frgbvalue = new float[]{f, f2, f3};
        this.falpha = f4;
        this.cs = null;
    }

    public Color(ColorSpace colorSpace, float[] fArray, float f) {
        this.frgbvalue = colorSpace.toRGB(fArray);
        this.fvalue = fArray;
        this.falpha = f;
        this.cs = colorSpace;
        this.value = Color.convert(this.frgbvalue[0], this.frgbvalue[1], this.frgbvalue[2], f);
    }

    public int getRed() {
        return (this.getRGB() & 0xFF0000) >> 16;
    }

    public int getGreen() {
        return (this.getRGB() & 0xFF00) >> 8;
    }

    public int getBlue() {
        return this.getRGB() & 0xFF;
    }

    public int getAlpha() {
        return (this.getRGB() & 0xFF000000) >>> 24;
    }

    public int getRGB() {
        return this.value;
    }

    public Color brighter() {
        int n = this.getRGB();
        int n2 = (n & 0xFF0000) >> 16;
        int n3 = (n & 0xFF00) >> 8;
        int n4 = n & 0xFF;
        n2 = n2 < 3 ? 3 : (int)Math.min(255.0f, (float)n2 / 0.7f);
        n3 = n3 < 3 ? 3 : (int)Math.min(255.0f, (float)n3 / 0.7f);
        n4 = n4 < 3 ? 3 : (int)Math.min(255.0f, (float)n4 / 0.7f);
        return new Color(n2, n3, n4, 255);
    }

    public Color darker() {
        int n = this.getRGB();
        return new Color((int)((float)((n & 0xFF0000) >> 16) * 0.7f), (int)((float)((n & 0xFF00) >> 8) * 0.7f), (int)((float)(n & 0xFF) * 0.7f), 255);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Color && ((Color)object).value == this.value;
    }

    public String toString() {
        return this.getClass().getName() + "[r=" + ((this.value & 0xFF0000) >> 16) + ",g=" + ((this.value & 0xFF00) >> 8) + ",b=" + (this.value & 0xFF) + ']';
    }

    public static Color decode(String string) {
        return new Color(Integer.decode(string), false);
    }

    public static Color getColor(String string) {
        return Color.getColor(string, null);
    }

    public static Color getColor(String string, Color color) {
        Integer n = Integer.getInteger(string, null);
        if (n == null) {
            return color;
        }
        return new Color(n, false);
    }

    public static Color getColor(String string, int n) {
        Color color = Color.getColor(string, null);
        if (color == null) {
            return new Color(n, false);
        }
        return color;
    }

    public static int HSBtoRGB(float f, float f2, float f3) {
        if (f2 == 0.0f) {
            return Color.convert(f3, f3, f3, 0.0f);
        }
        if (f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f) {
            throw new IllegalArgumentException();
        }
        f -= (float)Math.floor(f);
        int n = (int)(6.0f * f);
        float f4 = 6.0f * f - (float)n;
        float f5 = f3 * (1.0f - f2);
        float f6 = f3 * (1.0f - f2 * f4);
        float f7 = f3 * (1.0f - f2 * (1.0f - f4));
        switch (n) {
            case 0: {
                return Color.convert(f3, f7, f5, 0.0f);
            }
            case 1: {
                return Color.convert(f6, f3, f5, 0.0f);
            }
            case 2: {
                return Color.convert(f5, f3, f7, 0.0f);
            }
            case 3: {
                return Color.convert(f5, f6, f3, 0.0f);
            }
            case 4: {
                return Color.convert(f7, f5, f3, 0.0f);
            }
            case 5: {
                return Color.convert(f3, f5, f6, 0.0f);
            }
        }
        throw new InternalError("impossible");
    }

    public static float[] RGBtoHSB(int n, int n2, int n3, float[] fArray) {
        int n4;
        int n5;
        if (fArray == null) {
            fArray = new float[3];
        }
        if (n < n2) {
            n5 = n;
            n4 = n2;
        } else {
            n5 = n2;
            n4 = n;
        }
        if (n3 > n4) {
            n4 = n3;
        } else if (n3 < n5) {
            n5 = n3;
        }
        fArray[2] = (float)n4 / 255.0f;
        fArray[1] = n4 == 0 ? 0.0f : (float)(n4 - n5) / (float)n4;
        if (fArray[1] == 0.0f) {
            fArray[0] = 0.0f;
        } else {
            float f = (n4 - n5) * 6;
            fArray[0] = n == n4 ? (float)(n2 - n3) / f : (n2 == n4 ? 0.33333334f + (float)(n3 - n) / f : 0.6666667f + (float)(n - n2) / f);
            if (fArray[0] < 0.0f) {
                fArray[0] = fArray[0] + 1.0f;
            }
        }
        return fArray;
    }

    public static Color getHSBColor(float f, float f2, float f3) {
        return new Color(Color.HSBtoRGB(f, f2, f3), false);
    }

    public float[] getRGBComponents(float[] fArray) {
        if (fArray == null) {
            fArray = new float[4];
        }
        this.getRGBColorComponents(fArray);
        fArray[3] = this.falpha == 0.0f && this.frgbvalue == null ? (float)((this.getRGB() & 0xFF000000) >> 24) / 255.0f : this.falpha;
        return fArray;
    }

    public float[] getRGBColorComponents(float[] fArray) {
        if (fArray == null) {
            fArray = new float[3];
        } else if (fArray == this.frgbvalue) {
            return fArray;
        }
        if (this.frgbvalue == null) {
            int n = this.getRGB();
            this.frgbvalue = new float[]{(float)((n & 0xFF0000) >> 16) / 255.0f, (float)((n & 0xFF00) >> 8) / 255.0f, (float)(n & 0xFF) / 255.0f};
        }
        fArray[0] = this.frgbvalue[0];
        fArray[1] = this.frgbvalue[1];
        fArray[2] = this.frgbvalue[2];
        return fArray;
    }

    public float[] getComponents(float[] fArray) {
        int n;
        int n2 = n = this.cs == null ? 3 : this.cs.getNumComponents();
        if (fArray == null) {
            fArray = new float[1 + n];
        }
        this.getColorComponents(fArray);
        fArray[n] = this.falpha == 0.0f && this.frgbvalue == null ? (float)((this.getRGB() & 0xFF000000) >> 24) / 255.0f : this.falpha;
        return fArray;
    }

    public float[] getColorComponents(float[] fArray) {
        int n;
        int n2 = n = this.cs == null ? 3 : this.cs.getNumComponents();
        if (fArray == null) {
            fArray = new float[n];
        }
        if (this.fvalue == null) {
            this.fvalue = this.getRGBColorComponents(this.frgbvalue);
        }
        System.arraycopy(this.fvalue, 0, fArray, 0, n);
        return fArray;
    }

    public float[] getComponents(ColorSpace colorSpace, float[] fArray) {
        int n = colorSpace.getNumComponents();
        if (fArray == null) {
            fArray = new float[1 + n];
        }
        this.getColorComponents(colorSpace, fArray);
        fArray[n] = this.falpha == 0.0f && this.frgbvalue == null ? (float)((this.getRGB() & 0xFF000000) >> 24) / 255.0f : this.falpha;
        return fArray;
    }

    public float[] getColorComponents(ColorSpace colorSpace, float[] fArray) {
        float[] fArray2 = colorSpace.fromRGB(this.getRGBColorComponents(this.frgbvalue));
        if (fArray == null) {
            return fArray2;
        }
        System.arraycopy(fArray2, 0, fArray, 0, fArray2.length);
        return fArray;
    }

    public ColorSpace getColorSpace() {
        if (this.cs == null) {
            return ColorSpace.getInstance(1000);
        }
        return this.cs;
    }

    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        if (this.context == null || !this.context.getColorModel().equals(colorModel)) {
            this.context = new ColorPaintContext(colorModel, this.value);
        }
        return this.context;
    }

    public int getTransparency() {
        int n = this.getRGB() & 0xFF000000;
        if (n == -16777216) {
            return 1;
        }
        if (n == 0) {
            return 2;
        }
        return 3;
    }

    private static int convert(float f, float f2, float f3, float f4) {
        if (f < 0.0f || f > 1.0f || f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f || f4 < 0.0f || f4 > 1.0f) {
            throw new IllegalArgumentException("Bad RGB values");
        }
        int n = Math.round(255.0f * f);
        int n2 = Math.round(255.0f * f2);
        int n3 = Math.round(255.0f * f3);
        int n4 = Math.round(255.0f * f4);
        return n4 << 24 | n << 16 | n2 << 8 | n3;
    }

    static {
        WHITE = white = new Color(0xFFFFFF, false);
        LIGHT_GRAY = lightGray = new Color(0xC0C0C0, false);
        GRAY = gray = new Color(0x808080, false);
        DARK_GRAY = darkGray = new Color(0x404040, false);
        BLACK = black = new Color(0, false);
        RED = red = new Color(0xFF0000, false);
        PINK = pink = new Color(0xFFAFAF, false);
        ORANGE = orange = new Color(16762880, false);
        YELLOW = yellow = new Color(0xFFFF00, false);
        GREEN = green = new Color(65280, false);
        MAGENTA = magenta = new Color(0xFF00FF, false);
        CYAN = cyan = new Color(65535, false);
        BLUE = blue = new Color(255, false);
    }
}

