/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.dom;

import gnu.xml.libxmlj.util.NamedInputStream;
import gnu.xml.libxmlj.util.StandaloneDocumentType;
import gnu.xml.libxmlj.util.StandaloneLocator;
import gnu.xml.libxmlj.util.XMLJ;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class GnomeDocumentBuilder
extends DocumentBuilder
implements DOMImplementation {
    private boolean validate;
    private boolean coalesce;
    private boolean expandEntities;
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;
    private boolean seenFatalError;

    public GnomeDocumentBuilder() {
        this(true, false, false);
    }

    public GnomeDocumentBuilder(boolean bl, boolean bl2, boolean bl3) {
        this.validate = bl;
        this.coalesce = bl2;
        this.expandEntities = bl3;
    }

    public DOMImplementation getDOMImplementation() {
        return this;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return this.validate;
    }

    public Document newDocument() {
        return this.createDocument(null, null, null);
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        NamedInputStream namedInputStream = XMLJ.getInputStream(inputSource);
        byte[] byArray = namedInputStream.getDetectBuffer();
        String string = inputSource.getPublicId();
        String string2 = inputSource.getSystemId();
        String string3 = XMLJ.getBaseURI(string2);
        if (byArray == null) {
            throw new SAXParseException("No document element", string, string2, 0, 0);
        }
        this.seenFatalError = false;
        return this.parseStream(namedInputStream, byArray, string, string2, string3, this.validate, this.coalesce, this.expandEntities, true, this.errorHandler != null);
    }

    private native Document parseStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10);

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public boolean hasFeature(String string, String string2) {
        if (string.length() == 0) {
            return false;
        }
        if ((string = string.toLowerCase()).charAt(0) == '+') {
            string = string.substring(1);
        }
        if ("xml".equals(string) || "core".equals(string)) {
            return string2 == null || "".equals(string2) || "1.0".equals(string2) || "2.0".equals(string2) || "3.0".equals(string2);
        }
        if ("ls".equals(string) || "ls-async".equals(string)) {
            return false;
        }
        if ("traversal".equals(string)) {
            return string2 == null || "".equals(string2) || "2.0".equals(string2);
        }
        if ("xpath".equals(string)) {
            return string2 == null || "".equals(string2) || "3.0".equals(string2);
        }
        return false;
    }

    public Object getFeature(String string, String string2) {
        if (this.hasFeature(string, string2)) {
            return this;
        }
        return null;
    }

    public native Document createDocument(String var1, String var2, DocumentType var3);

    public DocumentType createDocumentType(String string, String string2, String string3) {
        return new StandaloneDocumentType(string, string2, string3);
    }

    private void setDocumentLocator(Object object, Object object2) {
    }

    private InputStream resolveEntity(String string, String string2, String string3) throws SAXException, IOException {
        InputSource inputSource;
        String string4 = XMLJ.getAbsoluteURI(string3, string2);
        NamedInputStream namedInputStream = null;
        if (this.entityResolver != null && (inputSource = this.entityResolver.resolveEntity(string, string4)) != null) {
            namedInputStream = XMLJ.getInputStream(inputSource);
        }
        if (namedInputStream == null) {
            namedInputStream = XMLJ.getInputStream(new URL(string4));
        }
        return namedInputStream;
    }

    private void warning(String string, int n, int n2, String string2, String string3) throws SAXException {
        if (!this.seenFatalError && this.errorHandler != null) {
            StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
            this.errorHandler.warning(new SAXParseException(string, standaloneLocator));
        }
    }

    private void error(String string, int n, int n2, String string2, String string3) throws SAXException {
        if (!this.seenFatalError && this.errorHandler != null) {
            StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
            this.errorHandler.error(new SAXParseException(string, standaloneLocator));
        }
    }

    private void fatalError(String string, int n, int n2, String string2, String string3) throws SAXException {
        if (!this.seenFatalError && this.errorHandler != null) {
            this.seenFatalError = true;
            StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
            this.errorHandler.fatalError(new SAXParseException(string, standaloneLocator));
        }
    }

    static {
        XMLJ.init();
    }
}

