/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.crypto.key.srp6.SRPKeyPairGenerator;
import gnu.javax.crypto.sasl.srp.PasswordFile;
import gnu.javax.crypto.sasl.srp.SRP;
import gnu.javax.net.ssl.SRPManagerParameters;
import gnu.javax.net.ssl.SRPTrustManager;
import gnu.javax.net.ssl.provider.Util;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.HashMap;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class SRPTrustManagerFactory
extends TrustManagerFactorySpi {
    private Manager current;

    protected TrustManager[] engineGetTrustManagers() {
        if (this.current == null) {
            throw new IllegalStateException("not initialized");
        }
        return new TrustManager[]{this.current};
    }

    protected void engineInit(KeyStore keyStore) {
        throw new IllegalArgumentException("only accepts SRPManagerParameters");
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        if (managerFactoryParameters == null) {
            try {
                String string;
                String string2 = Util.getSecurityProperty("jessie.srp.password.file");
                if (string2 == null) {
                    this.current = new Manager(this, new PasswordFile());
                    return;
                }
                String string3 = Util.getSecurityProperty("jessie.srp.password.file2");
                if (string3 == null) {
                    string3 = string2 + "2";
                }
                if ((string = Util.getSecurityProperty("jessie.srp.config")) == null) {
                    string = string2 + ".conf";
                }
                this.current = new Manager(this, new PasswordFile(string2, string3, string));
                return;
            }
            catch (IOException iOException) {
                throw new InvalidAlgorithmParameterException("default initialization failed: " + iOException.toString());
            }
        }
        if (managerFactoryParameters instanceof SRPManagerParameters) {
            this.current = new Manager(this, ((SRPManagerParameters)managerFactoryParameters).getPasswordFile());
            return;
        }
        throw new InvalidAlgorithmParameterException();
    }

    private class Manager
    implements SRPTrustManager {
        private /* synthetic */ SRPTrustManagerFactory this$0;
        private final PasswordFile file;

        Manager(SRPTrustManagerFactory sRPTrustManagerFactory, PasswordFile passwordFile) {
            this.this$0 = sRPTrustManagerFactory;
            this.file = passwordFile;
        }

        public boolean contains(String string) {
            try {
                return this.file.contains(string);
            }
            catch (IOException iOException) {
                return false;
            }
        }

        public KeyPair getKeyPair(String string) {
            try {
                if (this.file.contains(string)) {
                    SRP sRP = SRP.instance("SHA");
                    String[] stringArray = this.file.lookup(string, "SHA");
                    String[] stringArray2 = this.file.lookupConfig(stringArray[2]);
                    BigInteger bigInteger = new BigInteger(1, gnu.java.security.util.Util.fromBase64(stringArray[0]));
                    BigInteger bigInteger2 = new BigInteger(1, gnu.java.security.util.Util.fromBase64(stringArray2[0]));
                    BigInteger bigInteger3 = new BigInteger(1, gnu.java.security.util.Util.fromBase64(stringArray2[1]));
                    SRPKeyPairGenerator sRPKeyPairGenerator = new SRPKeyPairGenerator();
                    HashMap hashMap = new HashMap();
                    hashMap.put("gnu.crypto.srp.N", bigInteger2);
                    hashMap.put("gnu.crypto.srp.g", bigInteger3);
                    hashMap.put("gnu.crypto.srp.v", bigInteger);
                    sRPKeyPairGenerator.setup(hashMap);
                    return sRPKeyPairGenerator.generate();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public byte[] getSalt(String string) {
            try {
                if (this.file.contains(string)) {
                    return gnu.java.security.util.Util.fromBase64(this.file.lookup(string, "SHA")[1]);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public BigInteger getVerifier(String string) {
            try {
                if (this.file.contains(string)) {
                    return new BigInteger(1, gnu.java.security.util.Util.fromBase64(this.file.lookup(string, "SHA")[0]));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        public PasswordFile getPasswordFile() {
            return this.file;
        }
    }
}

