/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.CipherSuite;
import gnu.javax.net.ssl.provider.CompressionMethod;
import gnu.javax.net.ssl.provider.Extension;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.ProtocolVersion;
import gnu.javax.net.ssl.provider.Random;
import gnu.javax.net.ssl.provider.Util;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

final class ClientHello
implements Handshake.Body {
    private ProtocolVersion version;
    private Random random;
    private byte[] sessionId;
    private List suites;
    private List comp;
    private List extensions;

    ClientHello(ProtocolVersion protocolVersion, Random random, byte[] byArray, List list2, List list3) {
        this(protocolVersion, random, byArray, list2, list3, null);
    }

    ClientHello(ProtocolVersion protocolVersion, Random random, byte[] byArray, List list2, List list3, List list4) {
        this.version = protocolVersion;
        this.random = random;
        this.sessionId = byArray;
        this.suites = list2;
        this.comp = list3;
        this.extensions = list4;
    }

    static ClientHello read(InputStream inputStream) throws IOException {
        ProtocolVersion protocolVersion = ProtocolVersion.read(inputStream);
        Random random = Random.read(inputStream);
        byte[] byArray = new byte[inputStream.read() & 0xFF];
        inputStream.read(byArray);
        int n = (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
        ArrayList arrayList = new ArrayList(n / 2);
        for (int i = 0; i < n; i += 2) {
            arrayList.add(CipherSuite.read(inputStream).resolve(protocolVersion));
        }
        n = inputStream.read() & 0xFF;
        ArrayList arrayList2 = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            arrayList2.add(CompressionMethod.read(inputStream));
        }
        LinkedList linkedList = null;
        if (inputStream.available() > 0) {
            Extension extension;
            linkedList = new LinkedList();
            n = (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
            for (int i = 0; i < n; i += extension.getValue().length + 4) {
                extension = Extension.read(inputStream);
                linkedList.add(extension);
            }
        }
        return new ClientHello(protocolVersion, random, byArray, arrayList, arrayList2, linkedList);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.version.write(outputStream);
        this.random.write(outputStream);
        outputStream.write(this.sessionId.length);
        outputStream.write(this.sessionId);
        outputStream.write(this.suites.size() << 1 >>> 8 & 0xFF);
        outputStream.write(this.suites.size() << 1 & 0xFF);
        Object object = this.suites.iterator();
        while (object.hasNext()) {
            ((CipherSuite)object.next()).write(outputStream);
        }
        outputStream.write(this.comp.size());
        object = this.comp.iterator();
        while (object.hasNext()) {
            outputStream.write(((CompressionMethod)object.next()).getValue());
        }
        if (this.extensions != null) {
            object = new ByteArrayOutputStream();
            Iterator iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                ((Extension)iterator.next()).write((OutputStream)object);
            }
            outputStream.write(((ByteArrayOutputStream)object).size() >>> 8 & 0xFF);
            outputStream.write(((ByteArrayOutputStream)object).size() & 0xFF);
            ((ByteArrayOutputStream)object).writeTo(outputStream);
        }
    }

    ProtocolVersion getVersion() {
        return this.version;
    }

    Random getRandom() {
        return this.random;
    }

    byte[] getSessionId() {
        return this.sessionId;
    }

    List getCipherSuites() {
        return this.suites;
    }

    List getCompressionMethods() {
        return this.comp;
    }

    List getExtensions() {
        return this.extensions;
    }

    public String toString() {
        String string;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.println("  version = " + this.version + ";");
        BufferedReader bufferedReader = new BufferedReader(new StringReader(this.random.toString()));
        try {
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.print("  ");
                printWriter.println(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.println("  sessionId = " + Util.toHexString(this.sessionId, ':') + ";");
        printWriter.println("  cipherSuites = {");
        Iterator iterator = this.suites.iterator();
        while (iterator.hasNext()) {
            printWriter.print("    ");
            printWriter.println(iterator.next());
        }
        printWriter.println("  };");
        printWriter.print("  compressionMethods = { ");
        iterator = this.comp.iterator();
        while (iterator.hasNext()) {
            printWriter.print(iterator.next());
            if (!iterator.hasNext()) continue;
            printWriter.print(", ");
        }
        printWriter.println(" };");
        if (this.extensions != null) {
            printWriter.println("  extensions = {");
            iterator = this.extensions.iterator();
            while (iterator.hasNext()) {
                bufferedReader = new BufferedReader(new StringReader(iterator.next().toString()));
                try {
                    while ((string = bufferedReader.readLine()) != null) {
                        printWriter.print("    ");
                        printWriter.println(string);
                    }
                }
                catch (IOException iOException) {
                }
            }
            printWriter.println("  };");
        }
        printWriter.println("} ClientHello;");
        return stringWriter.toString();
    }
}

