/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.ICMGenerator;
import java.math.BigInteger;
import java.security.SecureRandomSpi;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Logger;

public class ICMRandomSpi
extends SecureRandomSpi {
    private static final Logger log = Logger.getLogger(ICMRandomSpi.class$("gnu.javax.crypto.jce.prng.ICMRandomSpi").getName());
    private static final ICMGenerator prng = new ICMGenerator();
    private static final String MSG = "Exception while setting up an icm SPI: ";
    private static final String RETRY = "Retry...";
    private static final String LIMIT_REACHED_MSG = "Limit reached: ";
    private static final String RESEED = "Re-seed...";
    private ICMGenerator adaptee;

    private /* synthetic */ void finit$() {
        this.adaptee = new ICMGenerator();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static void resetLocalPRNG() {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.prng.icm.cipher.name", "aes");
        byte[] byArray = new byte[16];
        Random random = new Random(System.currentTimeMillis());
        random.nextBytes(byArray);
        hashMap.put("gnu.crypto.cipher.key.material", byArray);
        int n = 16;
        byte[] byArray2 = new byte[n];
        random.nextBytes(byArray2);
        hashMap.put("gnu.crypto.prng.icm.offset", byArray2);
        int n2 = 0;
        int n3 = n / 2;
        while (n2 < 1 || n2 > n3) {
            n2 = random.nextInt(n3 + 1);
        }
        hashMap.put("gnu.crypto.prng.icm.segment.index.length", n2);
        byte[] byArray3 = new byte[n2];
        random.nextBytes(byArray3);
        hashMap.put("gnu.crypto.prng.icm.segment.index", new BigInteger(1, byArray3));
        prng.setup(hashMap);
    }

    public byte[] engineGenerateSeed(int n) {
        if (n < 1) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        this.engineNextBytes(byArray);
        return byArray;
    }

    public void engineNextBytes(byte[] byArray) {
        if (!this.adaptee.isInitialised()) {
            this.engineSetSeed(new byte[0]);
        }
        while (true) {
            try {
                this.adaptee.nextBytes(byArray, 0, byArray.length);
            }
            catch (LimitReachedException limitReachedException) {
                ICMRandomSpi.resetLocalPRNG();
                continue;
            }
            break;
        }
    }

    public void engineSetSeed(byte[] byArray) {
        int n = 0;
        n += 16;
        n += 16;
        byte[] byArray2 = new byte[n += 8];
        int n2 = 0;
        int n3 = byArray2.length;
        if (byArray.length > 0) {
            int n4 = Math.min(n, byArray.length);
            System.arraycopy(byArray, 0, byArray2, 0, n4);
            n2 += n4;
            n3 -= n4;
        }
        if (n2 > 0) {
            while (true) {
                try {
                    prng.nextBytes(byArray2, n2, n3);
                }
                catch (IllegalStateException illegalStateException) {
                    throw new InternalError(MSG + String.valueOf(illegalStateException));
                }
                catch (LimitReachedException limitReachedException) {
                    continue;
                }
                break;
            }
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.prng.icm.cipher.name", "aes");
        hashMap.put("gnu.crypto.prng.icm.segment.index.length", 4);
        byte[] byArray3 = new byte[16];
        System.arraycopy(byArray2, 0, byArray3, 0, 16);
        hashMap.put("gnu.crypto.cipher.key.material", byArray3);
        byte[] byArray4 = new byte[16];
        System.arraycopy(byArray2, 16, byArray4, 0, 16);
        hashMap.put("gnu.crypto.prng.icm.offset", byArray4);
        byte[] byArray5 = new byte[8];
        System.arraycopy(byArray2, 32, byArray5, 0, 8);
        hashMap.put("gnu.crypto.prng.icm.segment.index", new BigInteger(1, byArray5));
        this.adaptee.init(hashMap);
    }

    public ICMRandomSpi() {
        this.finit$();
    }

    static {
        ICMRandomSpi.resetLocalPRNG();
        MSG = MSG;
        RETRY = RETRY;
        LIMIT_REACHED_MSG = LIMIT_REACHED_MSG;
        RESEED = RESEED;
    }
}

