/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.params;

import gnu.javax.crypto.jce.params.DERReader;
import gnu.javax.crypto.jce.params.DERWriter;
import gnu.javax.crypto.jce.spec.BlockCipherParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.logging.Logger;
import javax.crypto.spec.IvParameterSpec;

public class BlockCipherParameters
extends AlgorithmParametersSpi {
    private static final Logger log = Logger.getLogger(BlockCipherParameters.class$("gnu.javax.crypto.jce.params.BlockCipherParameters").getName());
    protected BlockCipherParameterSpec cipherSpec;
    private static final String DEFAULT_FORMAT = "ASN.1";

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected byte[] engineGetEncoded() throws IOException {
        return this.engineGetEncoded(DEFAULT_FORMAT);
    }

    protected byte[] engineGetEncoded(String string) throws IOException {
        if (!string.equalsIgnoreCase(DEFAULT_FORMAT) && !string.equalsIgnoreCase("asn1")) {
            throw new IOException("unknown format \"" + string + "\"");
        }
        DERWriter dERWriter = new DERWriter();
        int n = this.cipherSpec.getBlockSize();
        int n2 = this.cipherSpec.getKeySize();
        byte[] byArray = this.cipherSpec.getIV();
        return dERWriter.joinarrays(dERWriter.writeBigInteger(BigInteger.valueOf(n)), dERWriter.writeBigInteger(BigInteger.valueOf(n2)), byArray != null ? dERWriter.writeBigInteger(new BigInteger(byArray)) : new byte[]{});
    }

    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
        if (!(algorithmParameterSpec instanceof BlockCipherParameterSpec)) {
            throw new InvalidParameterSpecException();
        }
        this.cipherSpec = (BlockCipherParameterSpec)algorithmParameterSpec;
    }

    protected void engineInit(byte[] byArray, String string) throws IOException {
        if (!string.equalsIgnoreCase(DEFAULT_FORMAT) && !string.equalsIgnoreCase("ASN1")) {
            throw new IOException("invalid format: only accepts ASN.1");
        }
        this.engineInit(byArray);
    }

    protected void engineInit(byte[] byArray) throws IOException {
        DERReader dERReader = new DERReader(byArray);
        int n = dERReader.getBigInteger().intValue();
        int n2 = dERReader.getBigInteger().intValue();
        byte[] byArray2 = null;
        if (dERReader.hasMorePrimitives()) {
            byArray2 = dERReader.getBigInteger().toByteArray();
        }
        this.cipherSpec = new BlockCipherParameterSpec(byArray2, n, n2);
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
        if (clazz.isInstance(this.cipherSpec)) {
            return this.cipherSpec;
        }
        if (BlockCipherParameters.class$("javax.crypto.spec.IvParameterSpec").isAssignableFrom(clazz)) {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(this.cipherSpec.getIV());
            return ivParameterSpec;
        }
        throw new InvalidParameterSpecException();
    }

    protected String engineToString() {
        return this.cipherSpec.toString();
    }

    static {
        DEFAULT_FORMAT = DEFAULT_FORMAT;
    }
}

