/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.cipher;

import gnu.java.security.prng.IRandom;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.PRNGFactory;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class ARCFourSpi
extends CipherSpi {
    private IRandom keystream = PRNGFactory.getInstance("arcfour");

    protected int engineGetBlockSize() {
        return 0;
    }

    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
    }

    protected void engineSetPadding(String string) throws NoSuchPaddingException {
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected int engineGetOutputSize(int n) {
        return n;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("arcfour is for encryption or decryption only");
        }
        if (key == null || !key.getFormat().equalsIgnoreCase("RAW")) {
            throw new InvalidKeyException("key must be non-null raw bytes");
        }
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.prng.arcfour.key-material", key.getEncoded());
        this.keystream.init(hashMap);
    }

    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(n, key, secureRandom);
    }

    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n2 + n > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        byte[] byArray2 = new byte[n2];
        try {
            for (int i = 0; i < n2; ++i) {
                byArray2[i] = byArray[i + n] ^ this.keystream.nextByte();
            }
        }
        catch (LimitReachedException limitReachedException) {
            // empty catch block
        }
        return byArray2;
    }

    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        if (n2 < 0 || n < 0 || n2 + n > byArray.length || n3 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n3 + n2 > byArray2.length) {
            throw new ShortBufferException();
        }
        try {
            for (int i = 0; i < n2; ++i) {
                byArray2[i + n3] = byArray[i + n] ^ this.keystream.nextByte();
            }
        }
        catch (LimitReachedException limitReachedException) {
            // empty catch block
        }
        return n2;
    }

    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(byArray, n, n2);
    }

    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return this.engineUpdate(byArray, n, n2, byArray2, n3);
    }
}

