/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.cipher;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.BaseCipher;
import java.security.InvalidKeyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.logging.Logger;

public final class Rijndael
extends BaseCipher {
    private static final Logger log;
    private static final int DEFAULT_BLOCK_SIZE = 16;
    private static final int DEFAULT_KEY_SIZE = 16;
    private static final String SS = "\u637c\u777b\uf26b\u6fc5\u3001\u672b\ufed7\uab76\uca82\uc97d\ufa59\u47f0\uadd4\ua2af\u9ca4\u72c0\ub7fd\u9326\u363f\uf7cc\u34a5\ue5f1\u71d8\u3115\u04c7\u23c3\u1896\u059a\u0712\u80e2\ueb27\ub275\u0983\u2c1a\u1b6e\u5aa0\u523b\ud6b3\u29e3\u2f84\u53d1\u00ed\u20fc\ub15b\u6acb\ube39\u4a4c\u58cf\ud0ef\uaafb\u434d\u3385\u45f9\u027f\u503c\u9fa8\u51a3\u408f\u929d\u38f5\ubcb6\uda21\u10ff\uf3d2\ucd0c\u13ec\u5f97\u4417\uc4a7\u7e3d\u645d\u1973\u6081\u4fdc\u222a\u9088\u46ee\ub814\ude5e\u0bdb\ue032\u3a0a\u4906\u245c\uc2d3\uac62\u9195\ue479\ue7c8\u376d\u8dd5\u4ea9\u6c56\uf4ea\u657a\uae08\uba78\u252e\u1ca6\ub4c6\ue8dd\u741f\u4bbd\u8b8a\u703e\ub566\u4803\uf60e\u6135\u57b9\u86c1\u1d9e\ue1f8\u9811\u69d9\u8e94\u9b1e\u87e9\uce55\u28df\u8ca1\u890d\ubfe6\u4268\u4199\u2d0f\ub054\ubb16";
    private static final byte[] S;
    private static final byte[] Si;
    private static final int[] T1;
    private static final int[] T2;
    private static final int[] T3;
    private static final int[] T4;
    private static final int[] T5;
    private static final int[] T6;
    private static final int[] T7;
    private static final int[] T8;
    private static final int[] U1;
    private static final int[] U2;
    private static final int[] U3;
    private static final int[] U4;
    private static final byte[] rcon;
    private static final int[][][] shifts;
    private static final byte[] KAT_KEY;
    private static final byte[] KAT_CT;
    private static Boolean valid;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Rijndael() {
        super("rijndael", 16, 16);
    }

    public static int getRounds(int n, int n2) {
        switch (n) {
            case 16: {
                if (n2 == 16) {
                    return 10;
                }
                if (n2 == 24) {
                    return 12;
                }
                return 14;
            }
            case 24: {
                if (n2 != 32) {
                    return 12;
                }
                return 14;
            }
        }
        return 14;
    }

    private static void rijndaelEncrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        int n4;
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[0];
        int n5 = n3 / 4;
        int n6 = nArray.length - 1;
        int n7 = n5 == 4 ? 0 : (n5 == 6 ? 1 : 2);
        int n8 = shifts[n7][1][0];
        int n9 = shifts[n7][2][0];
        int n10 = shifts[n7][3][0];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray3[n4] = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n4];
        }
        for (int i = 1; i < n6; ++i) {
            for (n4 = 0; n4 < n5; ++n4) {
                nArray2[n4] = T1[nArray3[n4] >>> 24] ^ T2[nArray3[(n4 + n8) % n5] >>> 16 & 0xFF] ^ T3[nArray3[(n4 + n9) % n5] >>> 8 & 0xFF] ^ T4[nArray3[(n4 + n10) % n5] & 0xFF] ^ nArray[i][n4];
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n5);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            int n11 = nArray[n6][n4];
            byArray2[n2++] = S[nArray3[n4] >>> 24] ^ (byte)(n11 >>> 24);
            byArray2[n2++] = S[nArray3[(n4 + n8) % n5] >>> 16 & 0xFF] ^ (byte)(n11 >>> 16);
            byArray2[n2++] = S[nArray3[(n4 + n9) % n5] >>> 8 & 0xFF] ^ (byte)(n11 >>> 8);
            byArray2[n2++] = S[nArray3[(n4 + n10) % n5] & 0xFF] ^ (byte)n11;
        }
    }

    private static void rijndaelDecrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        int n4;
        Object[] objectArray = (Object[])object;
        int[][] nArray = (int[][])objectArray[1];
        int n5 = n3 / 4;
        int n6 = nArray.length - 1;
        int n7 = n5 == 4 ? 0 : (n5 == 6 ? 1 : 2);
        int n8 = shifts[n7][1][1];
        int n9 = shifts[n7][2][1];
        int n10 = shifts[n7][3][1];
        int[] nArray2 = new int[n5];
        int[] nArray3 = new int[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            nArray3[n4] = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray[0][n4];
        }
        for (int i = 1; i < n6; ++i) {
            for (n4 = 0; n4 < n5; ++n4) {
                nArray2[n4] = T5[nArray3[n4] >>> 24] ^ T6[nArray3[(n4 + n8) % n5] >>> 16 & 0xFF] ^ T7[nArray3[(n4 + n9) % n5] >>> 8 & 0xFF] ^ T8[nArray3[(n4 + n10) % n5] & 0xFF] ^ nArray[i][n4];
            }
            System.arraycopy(nArray2, 0, nArray3, 0, n5);
        }
        for (n4 = 0; n4 < n5; ++n4) {
            int n11 = nArray[n6][n4];
            byArray2[n2++] = Si[nArray3[n4] >>> 24] ^ (byte)(n11 >>> 24);
            byArray2[n2++] = Si[nArray3[(n4 + n8) % n5] >>> 16 & 0xFF] ^ (byte)(n11 >>> 16);
            byArray2[n2++] = Si[nArray3[(n4 + n9) % n5] >>> 8 & 0xFF] ^ (byte)(n11 >>> 8);
            byArray2[n2++] = Si[nArray3[(n4 + n10) % n5] & 0xFF] ^ (byte)n11;
        }
    }

    private static void aesEncrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        int n3;
        int[][] nArray = (int[][])((Object[])object)[0];
        int n4 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n5 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n6 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n7 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n8 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        for (n3 = 1; n3 < n4; ++n3) {
            nArray2 = nArray[n3];
            int n9 = T1[n5 >>> 24] ^ T2[n6 >>> 16 & 0xFF] ^ T3[n7 >>> 8 & 0xFF] ^ T4[n8 & 0xFF] ^ nArray2[0];
            int n10 = T1[n6 >>> 24] ^ T2[n7 >>> 16 & 0xFF] ^ T3[n8 >>> 8 & 0xFF] ^ T4[n5 & 0xFF] ^ nArray2[1];
            int n11 = T1[n7 >>> 24] ^ T2[n8 >>> 16 & 0xFF] ^ T3[n5 >>> 8 & 0xFF] ^ T4[n6 & 0xFF] ^ nArray2[2];
            int n12 = T1[n8 >>> 24] ^ T2[n5 >>> 16 & 0xFF] ^ T3[n6 >>> 8 & 0xFF] ^ T4[n7 & 0xFF] ^ nArray2[3];
            n5 = n9;
            n6 = n10;
            n7 = n11;
            n8 = n12;
        }
        nArray2 = nArray[n4];
        n3 = nArray2[0];
        byArray2[n2++] = S[n5 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = S[n6 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = S[n7 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = S[n8 & 0xFF] ^ (byte)n3;
        n3 = nArray2[1];
        byArray2[n2++] = S[n6 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = S[n7 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = S[n8 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = S[n5 & 0xFF] ^ (byte)n3;
        n3 = nArray2[2];
        byArray2[n2++] = S[n7 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = S[n8 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = S[n5 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = S[n6 & 0xFF] ^ (byte)n3;
        n3 = nArray2[3];
        byArray2[n2++] = S[n8 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = S[n5 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = S[n6 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = S[n7 & 0xFF] ^ (byte)n3;
    }

    private static void aesDecrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object) {
        int n3;
        int[][] nArray = (int[][])((Object[])object)[1];
        int n4 = nArray.length - 1;
        int[] nArray2 = nArray[0];
        int n5 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[0];
        int n6 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[1];
        int n7 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[2];
        int n8 = (byArray[n++] << 24 | (byArray[n++] & 0xFF) << 16 | (byArray[n++] & 0xFF) << 8 | byArray[n++] & 0xFF) ^ nArray2[3];
        for (n3 = 1; n3 < n4; ++n3) {
            nArray2 = nArray[n3];
            int n9 = T5[n5 >>> 24] ^ T6[n8 >>> 16 & 0xFF] ^ T7[n7 >>> 8 & 0xFF] ^ T8[n6 & 0xFF] ^ nArray2[0];
            int n10 = T5[n6 >>> 24] ^ T6[n5 >>> 16 & 0xFF] ^ T7[n8 >>> 8 & 0xFF] ^ T8[n7 & 0xFF] ^ nArray2[1];
            int n11 = T5[n7 >>> 24] ^ T6[n6 >>> 16 & 0xFF] ^ T7[n5 >>> 8 & 0xFF] ^ T8[n8 & 0xFF] ^ nArray2[2];
            int n12 = T5[n8 >>> 24] ^ T6[n7 >>> 16 & 0xFF] ^ T7[n6 >>> 8 & 0xFF] ^ T8[n5 & 0xFF] ^ nArray2[3];
            n5 = n9;
            n6 = n10;
            n7 = n11;
            n8 = n12;
        }
        nArray2 = nArray[n4];
        n3 = nArray2[0];
        byArray2[n2++] = Si[n5 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = Si[n8 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = Si[n7 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = Si[n6 & 0xFF] ^ (byte)n3;
        n3 = nArray2[1];
        byArray2[n2++] = Si[n6 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = Si[n5 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = Si[n8 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = Si[n7 & 0xFF] ^ (byte)n3;
        n3 = nArray2[2];
        byArray2[n2++] = Si[n7 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = Si[n6 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = Si[n5 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = Si[n8 & 0xFF] ^ (byte)n3;
        n3 = nArray2[3];
        byArray2[n2++] = Si[n8 >>> 24] ^ (byte)(n3 >>> 24);
        byArray2[n2++] = Si[n7 >>> 16 & 0xFF] ^ (byte)(n3 >>> 16);
        byArray2[n2++] = Si[n6 >>> 8 & 0xFF] ^ (byte)(n3 >>> 8);
        byArray2[n2++] = Si[n5 & 0xFF] ^ (byte)n3;
    }

    public Object clone() {
        Rijndael rijndael = new Rijndael();
        rijndael.currentBlockSize = this.currentBlockSize;
        return rijndael;
    }

    public Iterator blockSizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(16);
        arrayList.add(24);
        arrayList.add(32);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public Iterator keySizes() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(16);
        arrayList.add(24);
        arrayList.add(32);
        return Collections.unmodifiableList(arrayList).iterator();
    }

    public Object makeKey(byte[] byArray, int n) throws InvalidKeyException {
        int n2;
        if (byArray == null) {
            throw new InvalidKeyException("Empty key");
        }
        if (byArray.length != 16 && byArray.length != 24 && byArray.length != 32) {
            throw new InvalidKeyException("Incorrect key length");
        }
        if (n != 16 && n != 24 && n != 32) {
            throw new IllegalArgumentException();
        }
        int n3 = Rijndael.getRounds(byArray.length, n);
        int n4 = n / 4;
        int[][] nArray = new int[n3 + 1][n4];
        int[][] nArray2 = new int[n3 + 1][n4];
        int n5 = (n3 + 1) * n4;
        int n6 = byArray.length / 4;
        int[] nArray3 = new int[n6];
        int n7 = 0;
        int n8 = 0;
        while (n7 < n6) {
            nArray3[n7++] = byArray[n8++] << 24 | (byArray[n8++] & 0xFF) << 16 | (byArray[n8++] & 0xFF) << 8 | byArray[n8++] & 0xFF;
        }
        int n9 = 0;
        for (n8 = 0; n8 < n6 && n9 < n5; ++n8, ++n9) {
            nArray[n9 / n4][n9 % n4] = nArray3[n8];
            nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
        }
        int n10 = 0;
        while (n9 < n5) {
            n2 = nArray3[n6 - 1];
            nArray3[0] = nArray3[0] ^ ((S[n2 >>> 16 & 0xFF] & 0xFF) << 24 ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 16 ^ (S[n2 & 0xFF] & 0xFF) << 8 ^ S[n2 >>> 24] & 0xFF ^ rcon[n10++] << 24);
            if (n6 != 8) {
                n7 = 1;
                n8 = 0;
                while (n7 < n6) {
                    int n11 = n7++;
                    nArray3[n11] = nArray3[n11] ^ nArray3[n8++];
                }
            } else {
                n7 = 1;
                n8 = 0;
                while (n7 < n6 / 2) {
                    int n12 = n7++;
                    nArray3[n12] = nArray3[n12] ^ nArray3[n8++];
                }
                n2 = nArray3[n6 / 2 - 1];
                int n13 = n6 / 2;
                nArray3[n13] = nArray3[n13] ^ (S[n2 & 0xFF] & 0xFF ^ (S[n2 >>> 8 & 0xFF] & 0xFF) << 8 ^ (S[n2 >>> 16 & 0xFF] & 0xFF) << 16 ^ S[n2 >>> 24 & 0xFF] << 24);
                n8 = n6 / 2;
                n7 = n8 + 1;
                while (n7 < n6) {
                    int n14 = n7++;
                    nArray3[n14] = nArray3[n14] ^ nArray3[n8++];
                }
            }
            for (n8 = 0; n8 < n6 && n9 < n5; ++n8, ++n9) {
                nArray[n9 / n4][n9 % n4] = nArray3[n8];
                nArray2[n3 - n9 / n4][n9 % n4] = nArray3[n8];
            }
        }
        for (int i = 1; i < n3; ++i) {
            for (n8 = 0; n8 < n4; ++n8) {
                n2 = nArray2[i][n8];
                nArray2[i][n8] = U1[n2 >>> 24] ^ U2[n2 >>> 16 & 0xFF] ^ U3[n2 >>> 8 & 0xFF] ^ U4[n2 & 0xFF];
            }
        }
        return new Object[]{nArray, nArray2};
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16 && n3 != 24 && n3 != 32) {
            throw new IllegalArgumentException();
        }
        if (n3 == 16) {
            Rijndael.aesEncrypt(byArray, n, byArray2, n2, object);
        } else {
            Rijndael.rijndaelEncrypt(byArray, n, byArray2, n2, object, n3);
        }
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2, Object object, int n3) {
        if (n3 != 16 && n3 != 24 && n3 != 32) {
            throw new IllegalArgumentException();
        }
        if (n3 == 16) {
            Rijndael.aesDecrypt(byArray, n, byArray2, n2, object);
        } else {
            Rijndael.rijndaelDecrypt(byArray, n, byArray2, n2, object, n3);
        }
    }

    public boolean selfTest() {
        if (valid == null) {
            boolean bl = super.selfTest();
            if (bl) {
                bl = this.testKat(KAT_KEY, KAT_CT);
            }
            valid = bl;
        }
        return valid;
    }

    static {
        int n;
        log = Logger.getLogger(Rijndael.class$("gnu.javax.crypto.cipher.Rijndael").getName());
        SS = SS;
        S = new byte[256];
        Si = new byte[256];
        T1 = new int[256];
        T2 = new int[256];
        T3 = new int[256];
        T4 = new int[256];
        T5 = new int[256];
        T6 = new int[256];
        T7 = new int[256];
        T8 = new int[256];
        U1 = new int[256];
        U2 = new int[256];
        U3 = new int[256];
        U4 = new int[256];
        rcon = new byte[30];
        shifts = new int[][][]{new int[][]{{0, 0}, {1, 3}, {2, 2}, {3, 1}}, new int[][]{{0, 0}, {1, 5}, {2, 4}, {3, 3}}, new int[][]{{0, 0}, {1, 7}, {3, 5}, {4, 4}}};
        KAT_KEY = Util.toBytesFromString("0000000000000000000000010000000000000000000000000000000000000000");
        KAT_CT = Util.toBytesFromString("E44429474D6FC3084EB2A6B8B46AF754");
        long l = System.currentTimeMillis();
        int n2 = 283;
        boolean bl = false;
        for (n = 0; n < 256; ++n) {
            int n3;
            int n4;
            int n5;
            char c = SS.charAt(n >>> 1);
            Rijndael.S[n] = (n & 1) == 0 ? (byte)(c >>> 8) : (byte)c;
            int n6 = S[n] & 0xFF;
            Rijndael.Si[n6] = (byte)n;
            int n7 = n6 << 1;
            if (n7 >= 256) {
                n7 ^= n2;
            }
            int n8 = n7 ^ n6;
            int n9 = n << 1;
            if (n9 >= 256) {
                n9 ^= n2;
            }
            if ((n5 = n9 << 1) >= 256) {
                n5 ^= n2;
            }
            if ((n4 = n5 << 1) >= 256) {
                n4 ^= n2;
            }
            int n10 = n4 ^ n;
            int n11 = n10 ^ n9;
            int n12 = n10 ^ n5;
            int n13 = n4 ^ n5 ^ n9;
            Rijndael.T1[n] = n3 = n7 << 24 | n6 << 16 | n6 << 8 | n8;
            Rijndael.T2[n] = n3 >>> 8 | n3 << 24;
            Rijndael.T3[n] = n3 >>> 16 | n3 << 16;
            Rijndael.T4[n] = n3 >>> 24 | n3 << 8;
            Rijndael.U1[n] = n3 = n13 << 24 | n10 << 16 | n12 << 8 | n11;
            Rijndael.T5[n6] = n3;
            Rijndael.T6[n6] = Rijndael.U2[n] = n3 >>> 8 | n3 << 24;
            Rijndael.T7[n6] = Rijndael.U3[n] = n3 >>> 16 | n3 << 16;
            Rijndael.T8[n6] = Rijndael.U4[n] = n3 >>> 24 | n3 << 8;
        }
        int n14 = 1;
        Rijndael.rcon[0] = 1;
        for (n = 1; n < 30; ++n) {
            if ((n14 <<= 1) >= 256) {
                n14 ^= n2;
            }
            Rijndael.rcon[n] = (byte)n14;
        }
        l = System.currentTimeMillis() - l;
    }
}

