/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.text;

import gnu.java.text.BaseBreakIterator;
import java.text.CharacterIterator;

public class WordBreakIterator
extends BaseBreakIterator {
    public Object clone() {
        return new WordBreakIterator(this);
    }

    public WordBreakIterator() {
    }

    private WordBreakIterator(WordBreakIterator wordBreakIterator) {
        this.iter = (CharacterIterator)wordBreakIterator.iter.clone();
    }

    private final boolean isHira(char c) {
        return c >= '\u3040' && c <= '\u309f';
    }

    private final boolean isKata(char c) {
        return c >= '\u30a0' && c <= '\u30ff';
    }

    private final boolean isHan(char c) {
        return c >= '\u4e00' && c <= '\u9fff';
    }

    public int next() {
        char c;
        int n = this.iter.getEndIndex();
        if (this.iter.getIndex() == n) {
            return -1;
        }
        while (this.iter.getIndex() < n && (c = this.iter.current()) != '\uffff') {
            int n2 = Character.getType(c);
            char c2 = this.iter.next();
            if (c2 == '\uffff' || n2 == 14 || n2 == 13) break;
            boolean bl = Character.isLetter(c);
            if (c != '\'' && !bl && n2 != 6 && Character.isLetter(c2) || c != '\'' && (n2 == 20 || n2 == 21 || n2 == 22 || n2 == 23 || n2 == 24 || n2 == 25 || n2 == 26 || n2 == 27 || n2 == 28 || n2 == 16 || n2 == 15)) break;
            boolean bl2 = this.isHira(c);
            boolean bl3 = this.isKata(c);
            boolean bl4 = this.isHan(c);
            if (!bl2 && !bl3 && !bl4 && n2 != 6 && (this.isHira(c2) || this.isKata(c2) || this.isHan(c2))) break;
            if (!bl2 && !bl3 && !bl4 && !bl) continue;
            int n3 = this.iter.getIndex();
            while (c2 != '\uffff' && Character.getType(c2) == 6) {
                c2 = this.iter.next();
            }
            if (c2 == '\uffff' || bl2 && !this.isHira(c2) || bl3 && !this.isHira(c2) && !this.isKata(c2) || bl4 && !this.isHira(c2) && !this.isHan(c2) || bl && !Character.isLetter(c2) && c2 != '\'') break;
            this.iter.setIndex(n3);
        }
        return this.iter.getIndex();
    }

    public int previous() {
        char c;
        int n = this.iter.getBeginIndex();
        if (this.iter.getIndex() == n) {
            return -1;
        }
        while (this.iter.getIndex() >= n && (c = this.iter.previous()) != '\uffff') {
            boolean bl = this.isHira(c);
            boolean bl2 = this.isKata(c);
            boolean bl3 = this.isHan(c);
            boolean bl4 = Character.isLetter(c);
            char c2 = this.iter.previous();
            if (c2 == '\uffff') break;
            this.iter.next();
            int n2 = Character.getType(c2);
            if (n2 == 14 || n2 == 13 || c2 != '\'' && !Character.isLetter(c2) && n2 != 6 && bl4 || c2 != '\'' && (n2 == 20 || n2 == 21 || n2 == 22 || n2 == 23 || n2 == 24 || n2 == 25 || n2 == 26 || n2 == 27 || n2 == 28 || n2 == 16 || n2 == 15) || (bl || bl2 || bl3) && !this.isHira(c2) && !this.isKata(c2) && !this.isHan(c2) && n2 != 6) break;
            if (bl && (bl4 || c == '\'')) continue;
            int n3 = this.iter.getIndex();
            while (c2 != '\uffff' && Character.getType(c2) == 6) {
                c2 = this.iter.previous();
            }
            this.iter.setIndex(n3);
            if (!(c2 == '\uffff' || this.isHira(c2) && !bl || this.isKata(c2) && !bl && !bl2 || this.isHan(c2) && !bl && !bl3) && (bl4 || c == '\'' || !Character.isLetter(c2))) continue;
            break;
        }
        return this.iter.getIndex();
    }
}

