/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.rsa;

import gnu.java.security.OID;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.rsa.GnuRSAPrivateKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.logging.Logger;

public class RSAKeyPairPKCS8Codec
implements IKeyPairCodec {
    private static final Logger log = Logger.getLogger(RSAKeyPairPKCS8Codec.class$("gnu.java.security.key.rsa.RSAKeyPairPKCS8Codec").getName());
    private static final OID RSA_ALG_OID = new OID("1.2.840.113549.1.1.1");

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public int getFormatID() {
        return 3;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        byte[] byArray;
        if (!(privateKey instanceof GnuRSAPrivateKey)) {
            throw new InvalidParameterException("Wrong key type");
        }
        GnuRSAPrivateKey gnuRSAPrivateKey = (GnuRSAPrivateKey)privateKey;
        BigInteger bigInteger = gnuRSAPrivateKey.getN();
        BigInteger bigInteger2 = gnuRSAPrivateKey.getE();
        BigInteger bigInteger3 = gnuRSAPrivateKey.getPrivateExponent();
        BigInteger bigInteger4 = gnuRSAPrivateKey.getPrimeP();
        BigInteger bigInteger5 = gnuRSAPrivateKey.getPrimeQ();
        BigInteger bigInteger6 = gnuRSAPrivateKey.getPrimeExponentP();
        BigInteger bigInteger7 = gnuRSAPrivateKey.getPrimeExponentQ();
        BigInteger bigInteger8 = gnuRSAPrivateKey.getCrtCoefficient();
        DERValue dERValue = new DERValue(2, BigInteger.ZERO);
        DERValue dERValue2 = new DERValue(6, RSA_ALG_OID);
        ArrayList arrayList = new ArrayList(2);
        arrayList.add(dERValue2);
        arrayList.add(new DERValue(5, null));
        DERValue dERValue3 = new DERValue(48, arrayList);
        DERValue dERValue4 = new DERValue(2, BigInteger.ZERO);
        DERValue dERValue5 = new DERValue(2, bigInteger);
        DERValue dERValue6 = new DERValue(2, bigInteger2);
        DERValue dERValue7 = new DERValue(2, bigInteger3);
        DERValue dERValue8 = new DERValue(2, bigInteger4);
        DERValue dERValue9 = new DERValue(2, bigInteger5);
        DERValue dERValue10 = new DERValue(2, bigInteger6);
        DERValue dERValue11 = new DERValue(2, bigInteger7);
        DERValue dERValue12 = new DERValue(2, bigInteger8);
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(dERValue4);
        arrayList2.add(dERValue5);
        arrayList2.add(dERValue6);
        arrayList2.add(dERValue7);
        arrayList2.add(dERValue8);
        arrayList2.add(dERValue9);
        arrayList2.add(dERValue10);
        arrayList2.add(dERValue11);
        arrayList2.add(dERValue12);
        DERValue dERValue13 = new DERValue(48, arrayList2);
        byte[] byArray2 = dERValue13.getEncoded();
        DERValue dERValue14 = new DERValue(4, byArray2);
        ArrayList arrayList3 = new ArrayList(3);
        arrayList3.add(dERValue);
        arrayList3.add(dERValue3);
        arrayList3.add(dERValue14);
        DERValue dERValue15 = new DERValue(48, arrayList3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue15);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        throw new InvalidParameterException("Wrong format for public keys");
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        BigInteger bigInteger5;
        BigInteger bigInteger6;
        BigInteger bigInteger7;
        BigInteger bigInteger8;
        Object object;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader dERReader = new DERReader(byArray);
        try {
            object = dERReader.read();
            DerUtil.checkIsConstructed((DERValue)object, "Wrong PrivateKeyInfo field");
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue, "Wrong Version field");
            BigInteger bigInteger9 = (BigInteger)dERValue.getValue();
            if (bigInteger9.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected Version: " + bigInteger9);
            }
            DERValue dERValue2 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue2, "Wrong AlgorithmIdentifier field");
            DERValue dERValue3 = dERReader.read();
            OID oID = (OID)dERValue3.getValue();
            if (!oID.equals(RSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + oID);
            }
            DERValue dERValue4 = dERReader.read();
            if (dERValue4.getTag() == 5) {
                dERValue4 = dERReader.read();
            }
            byte[] byArray2 = (byte[])dERValue4.getValue();
            dERReader = new DERReader(byArray2);
            DERValue dERValue5 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue5, "Wrong RSAPrivateKey field");
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong RSAPrivateKey Version field");
            bigInteger9 = (BigInteger)dERValue4.getValue();
            if (bigInteger9.compareTo(BigInteger.ZERO) != 0) {
                throw new InvalidParameterException("Unexpected RSAPrivateKey Version: " + bigInteger9);
            }
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong modulus field");
            bigInteger8 = (BigInteger)dERValue4.getValue();
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong publicExponent field");
            bigInteger7 = (BigInteger)dERValue4.getValue();
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong privateExponent field");
            bigInteger6 = (BigInteger)dERValue4.getValue();
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong prime1 field");
            bigInteger5 = (BigInteger)dERValue4.getValue();
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong prime2 field");
            bigInteger4 = (BigInteger)dERValue4.getValue();
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong exponent1 field");
            bigInteger3 = (BigInteger)dERValue4.getValue();
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong exponent2 field");
            bigInteger2 = (BigInteger)dERValue4.getValue();
            dERValue4 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue4, "Wrong coefficient field");
            bigInteger = (BigInteger)dERValue4.getValue();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        object = new GnuRSAPrivateKey(3, bigInteger8, bigInteger7, bigInteger6, bigInteger5, bigInteger4, bigInteger3, bigInteger2, bigInteger);
        return object;
    }
}

