/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.http;

import gnu.classpath.SystemProperties;
import gnu.java.net.EmptyX509TrustManager;
import gnu.java.net.protocol.http.Cookie;
import gnu.java.net.protocol.http.CookieManager;
import gnu.java.net.protocol.http.Request;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HTTPConnection {
    public static final int HTTP_PORT = 80;
    public static final int HTTPS_PORT = 443;
    private static final String userAgent = SystemProperties.getProperty("http.agent");
    protected final String hostname;
    protected final int port;
    protected final boolean secure;
    protected final int connectionTimeout;
    protected final int timeout;
    protected String proxyHostname;
    protected int proxyPort;
    protected int majorVersion;
    protected int minorVersion;
    private final List handshakeCompletedListeners;
    protected Socket socket;
    private SSLSocketFactory sslSocketFactory;
    protected InputStream in;
    protected OutputStream out;
    private Map nonceCounts;
    protected CookieManager cookieManager;
    private Pool pool;
    int useCount;
    long timeLastUsed;

    public HTTPConnection(String string) {
        this(string, 80, false, 0, 0);
    }

    public HTTPConnection(String string, boolean bl) {
        this(string, bl ? 443 : 80, bl, 0, 0);
    }

    public HTTPConnection(String string, boolean bl, int n, int n2) {
        this(string, bl ? 443 : 80, bl, n, n2);
    }

    public HTTPConnection(String string, int n) {
        this(string, n, false, 0, 0);
    }

    public HTTPConnection(String string, int n, boolean bl) {
        this(string, n, bl, 0, 0);
    }

    public HTTPConnection(String string, int n, boolean bl, int n2, int n3) {
        this.hostname = string;
        this.port = n;
        this.secure = bl;
        this.connectionTimeout = n2;
        this.timeout = n3;
        this.minorVersion = 1;
        this.majorVersion = 1;
        this.handshakeCompletedListeners = new ArrayList(2);
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getVersion() {
        return "HTTP/" + this.majorVersion + '.' + this.minorVersion;
    }

    public void setVersion(int n, int n2) {
        if (n != 1) {
            throw new IllegalArgumentException("major version not supported: " + n);
        }
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("minor version not supported: " + n2);
        }
        this.majorVersion = n;
        this.minorVersion = n2;
    }

    public void setProxy(String string, int n) {
        this.proxyHostname = string;
        this.proxyPort = n;
    }

    public boolean isUsingProxy() {
        return this.proxyHostname != null && this.proxyPort > 0;
    }

    public void setCookieManager(CookieManager cookieManager) {
        this.cookieManager = cookieManager;
    }

    public CookieManager getCookieManager() {
        return this.cookieManager;
    }

    void setPool(Pool pool) {
        this.pool = pool;
    }

    void release() {
        if (this.pool != null) {
            ++this.useCount;
            this.pool.put(this);
        } else {
            try {
                this.closeConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Request newRequest(String string, String string2) {
        Cookie[] cookieArray;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("method must have non-zero length");
        }
        if (string2 == null || string2.length() == 0) {
            string2 = "/";
        }
        Request request = new Request(this, string, string2);
        if (this.secure && this.port != 443 || !this.secure && this.port != 80) {
            request.setHeader("Host", this.hostname + ":" + this.port);
        } else {
            request.setHeader("Host", this.hostname);
        }
        request.setHeader("User-Agent", userAgent);
        request.setHeader("Connection", "keep-alive");
        request.setHeader("Accept-Encoding", "chunked;q=1.0, gzip;q=0.9, deflate;q=0.8, identity;q=0.6, *;q=0");
        if (this.cookieManager != null && (cookieArray = this.cookieManager.getCookies(this.hostname, this.secure, string2)) != null && cookieArray.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("$Version=1");
            for (int i = 0; i < cookieArray.length; ++i) {
                stringBuilder.append(',');
                stringBuilder.append(' ');
                stringBuilder.append(cookieArray[i].toString());
            }
            request.setHeader("Cookie", stringBuilder.toString());
        }
        return request;
    }

    public void close() throws IOException {
        this.closeConnection();
    }

    protected synchronized Socket getSocket() throws IOException {
        Object object;
        block11: {
            block12: {
                if (this.socket != null) break block11;
                String string = this.hostname;
                int n = this.port;
                if (this.isUsingProxy()) {
                    string = this.proxyHostname;
                    n = this.proxyPort;
                }
                this.socket = new Socket();
                InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
                if (this.connectionTimeout > 0) {
                    this.socket.connect(inetSocketAddress, this.connectionTimeout);
                } else {
                    this.socket.connect(inetSocketAddress);
                }
                if (this.timeout > 0) {
                    this.socket.setSoTimeout(this.timeout);
                }
                if (!this.secure) break block12;
                try {
                    SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
                    SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, string, n, true);
                    String[] stringArray = new String[]{"TLSv1", "SSLv3"};
                    sSLSocket.setEnabledProtocols(stringArray);
                    sSLSocket.setUseClientMode(true);
                    List list2 = this.handshakeCompletedListeners;
                    synchronized (list2) {
                        try {
                            if (!this.handshakeCompletedListeners.isEmpty()) {
                                object = this.handshakeCompletedListeners.iterator();
                                while (object.hasNext()) {
                                    HandshakeCompletedListener handshakeCompletedListener = (HandshakeCompletedListener)object.next();
                                    sSLSocket.addHandshakeCompletedListener(handshakeCompletedListener);
                                }
                            }
                            object = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_9 = null;
                            throw throwable;
                        }
                    }
                    sSLSocket.startHandshake();
                    this.socket = sSLSocket;
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IOException(generalSecurityException.getMessage());
                }
            }
            this.in = this.socket.getInputStream();
            this.in = new BufferedInputStream(this.in);
            this.out = this.socket.getOutputStream();
            this.out = new BufferedOutputStream(this.out);
        }
        object = this.socket;
        return object;
    }

    SSLSocketFactory getSSLSocketFactory() throws GeneralSecurityException {
        if (this.sslSocketFactory == null) {
            EmptyX509TrustManager emptyX509TrustManager = new EmptyX509TrustManager();
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            TrustManager[] trustManagerArray = new TrustManager[]{emptyX509TrustManager};
            sSLContext.init(null, trustManagerArray, null);
            this.sslSocketFactory = sSLContext.getSocketFactory();
        }
        return this.sslSocketFactory;
    }

    void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.in;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.socket == null) {
            this.getSocket();
        }
        return this.out;
    }

    protected synchronized void closeConnection() throws IOException {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            finally {
                Object var1_1 = null;
                this.socket = null;
            }
        }
    }

    protected String getURI() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.secure ? "https://" : "http://");
        stringBuilder.append(this.hostname);
        if (this.secure) {
            if (this.port != 443) {
                stringBuilder.append(':');
                stringBuilder.append(this.port);
            }
        } else if (this.port != 80) {
            stringBuilder.append(':');
            stringBuilder.append(this.port);
        }
        return stringBuilder.toString();
    }

    int getNonceCount(String string) {
        if (this.nonceCounts == null) {
            return 0;
        }
        return (Integer)this.nonceCounts.get(string);
    }

    void incrementNonce(String string) {
        int n = this.getNonceCount(string);
        if (this.nonceCounts == null) {
            this.nonceCounts = new HashMap();
        }
        this.nonceCounts.put(string, new Integer(n + 1));
    }

    void addHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        List list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            try {
                this.handshakeCompletedListeners.add(handshakeCompletedListener);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    void removeHandshakeCompletedListener(HandshakeCompletedListener handshakeCompletedListener) {
        List list2 = this.handshakeCompletedListeners;
        synchronized (list2) {
            try {
                this.handshakeCompletedListeners.remove(handshakeCompletedListener);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    static class Pool {
        static Pool instance = new Pool();
        final LinkedList connectionPool;
        int maxConnections;
        int connectionTTL;
        Reaper reaper;

        private /* synthetic */ void finit$() {
            this.connectionPool = new LinkedList();
        }

        Pool() {
            this.finit$();
        }

        private static boolean matches(HTTPConnection hTTPConnection, String string, int n, boolean bl) {
            return string.equals(hTTPConnection.hostname) && n == hTTPConnection.port && bl == hTTPConnection.secure;
        }

        synchronized HTTPConnection get(String string, int n, boolean bl, int n2, int n3) {
            String string2 = SystemProperties.getProperty("classpath.net.http.keepAliveTTL");
            this.connectionTTL = string2 != null && string2.length() > 0 ? 1000 * Math.max(1, Integer.parseInt(string2)) : 10000;
            String string3 = SystemProperties.getProperty("http.maxConnections");
            int n4 = this.maxConnections = string3 != null && string3.length() > 0 ? Math.max(Integer.parseInt(string3), 1) : 5;
            if (this.maxConnections < 1) {
                this.maxConnections = 1;
            }
            HTTPConnection hTTPConnection = null;
            ListIterator listIterator = this.connectionPool.listIterator(0);
            while (listIterator.hasNext()) {
                HTTPConnection hTTPConnection2 = (HTTPConnection)listIterator.next();
                if (!Pool.matches(hTTPConnection2, string, n, bl)) continue;
                hTTPConnection = hTTPConnection2;
                listIterator.remove();
                break;
            }
            if (hTTPConnection == null) {
                hTTPConnection = new HTTPConnection(string, n, bl, n2, n3);
                hTTPConnection.setPool(this);
            }
            return hTTPConnection;
        }

        synchronized void put(HTTPConnection hTTPConnection) {
            hTTPConnection.timeLastUsed = System.currentTimeMillis();
            this.connectionPool.addLast(hTTPConnection);
            while (this.connectionPool.size() >= this.maxConnections) {
                this.removeOldest();
            }
            if (this.connectionTTL > 0 && this.reaper == null) {
                this.reaper = new Reaper(this);
                Thread thread = new Thread(this.reaper, "HTTPConnection.Reaper");
                thread.setDaemon(true);
                thread.start();
            }
        }

        void removeOldest() {
            HTTPConnection hTTPConnection = (HTTPConnection)this.connectionPool.removeFirst();
            try {
                hTTPConnection.closeConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        class Reaper
        implements Runnable {
            private /* synthetic */ Pool this$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Pool pool = this.this$1;
                synchronized (pool) {
                    block9: while (true) {
                        try {
                            try {}
                            catch (Throwable throwable) {
                                Object var2_5 = null;
                                this.this$1.reaper = null;
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var2_6 = null;
                            throw throwable;
                        }
                        while (true) {
                            if (this.this$1.connectionPool.size() > 0) {
                                long l = System.currentTimeMillis();
                                HTTPConnection hTTPConnection = (HTTPConnection)this.this$1.connectionPool.getFirst();
                                long l2 = hTTPConnection.timeLastUsed + (long)this.this$1.connectionTTL - l;
                                if (l2 <= 0L) {
                                    this.this$1.removeOldest();
                                    continue;
                                }
                                try {
                                    this.this$1.wait(l2);
                                    continue block9;
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                            }
                            try {
                                this.this$1.wait(this.this$1.connectionTTL);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (this.this$1.connectionPool.size() <= 0) break block9;
                        }
                        break;
                    }
                    Object var2_4 = null;
                    this.this$1.reaper = null;
                    return;
                }
            }

            Reaper(Pool pool) {
                this.this$1 = pool;
            }
        }
    }
}

