/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.print;

import gnu.java.awt.peer.gtk.CairoSurface;
import gnu.java.awt.print.SpooledDocument;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterGraphics;
import java.awt.print.PrinterJob;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.AttributedCharacterIterator;

public class JavaPrinterGraphics
extends Graphics
implements PrinterGraphics {
    private Graphics g;
    private PrinterJob printerJob;
    private static final double DPI = 72.0;
    private int xSize;
    private int ySize;
    private Image image;

    public JavaPrinterGraphics(PrinterJob printerJob) {
        this.printerJob = printerJob;
    }

    public SpooledDocument spoolPostScript(Printable printable, PageFormat pageFormat, Pageable pageable) throws PrinterException {
        try {
            File file = File.createTempFile("cpspool", ".ps");
            file.deleteOnExit();
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO8859_1"), 1000000));
            this.writePSHeader(printWriter);
            if (pageable != null) {
                for (int i = 0; i < pageable.getNumberOfPages(); ++i) {
                    this.spoolPage(printWriter, pageable.getPrintable(i), pageable.getPageFormat(i), i);
                }
            } else {
                int n = 0;
                while (this.spoolPage(printWriter, printable, pageFormat, n++) == 0) {
                }
            }
            printWriter.println("%%Trailer");
            printWriter.println("%%EOF");
            printWriter.close();
            return new SpooledDocument(file);
        }
        catch (IOException iOException) {
            PrinterException printerException = new PrinterException();
            printerException.initCause(iOException);
            throw printerException;
        }
    }

    public int spoolPage(PrintWriter printWriter, Printable printable, PageFormat pageFormat, int n) throws IOException, PrinterException {
        this.initImage(pageFormat);
        if (printable.print(this, pageFormat, n) == 1) {
            return 1;
        }
        this.g.dispose();
        this.g = null;
        this.writePage(printWriter, pageFormat);
        return 0;
    }

    private void initImage(PageFormat pageFormat) {
        this.xSize = (int)(72.0 * pageFormat.getWidth() / 72.0);
        this.ySize = (int)(72.0 * pageFormat.getHeight() / 72.0);
        if (pageFormat.getOrientation() != 1) {
            int n = this.xSize;
            this.xSize = this.ySize;
            this.ySize = n;
        }
        this.image = CairoSurface.getBufferedImage(this.xSize, this.ySize);
        this.g = this.image.getGraphics();
        this.setColor(Color.white);
        this.fillRect(0, 0, this.xSize, this.ySize);
        this.setColor(Color.black);
    }

    private void writePSHeader(PrintWriter printWriter) {
        printWriter.println("%!PS-Adobe-3.0");
        printWriter.println("%%Title: " + this.printerJob.getJobName());
        printWriter.println("%%Creator: GNU Classpath ");
        printWriter.println("%%DocumentData: Clean8Bit");
        printWriter.println("%%DocumentNeededResources: font Times-Roman Helvetica Courier");
        printWriter.println("%%EndComments");
        printWriter.println("%%BeginProlog");
        printWriter.println("%%EndProlog");
        printWriter.println("%%BeginSetup");
        printWriter.println("%%EndFeature");
        printWriter.println("%%EndSetup");
    }

    private void writePage(PrintWriter printWriter, PageFormat pageFormat) {
        printWriter.println("%%BeginPageSetup");
        Paper paper = pageFormat.getPaper();
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        if (pageFormat.getOrientation() == 1) {
            printWriter.println("%%Orientation: Portrait");
        } else {
            printWriter.println("%%Orientation: Landscape");
            double d3 = d;
            d = d2;
            d2 = d3;
        }
        printWriter.println("gsave % first save");
        printWriter.println("<< /PageSize [" + d + " " + d2 + "] >> setpagedevice");
        AffineTransform affineTransform = new AffineTransform();
        if (pageFormat.getOrientation() == 2) {
            affineTransform.translate(d, d2);
            affineTransform.scale(-1.0, -1.0);
        }
        this.concatCTM(printWriter, affineTransform);
        printWriter.println("%%EndPageSetup");
        printWriter.println("gsave");
        printWriter.println(this.xSize + " " + this.ySize + " 8 [1 0 0 -1 0 " + this.ySize + " ]");
        printWriter.println("{currentfile 3 string readhexstring pop} bind");
        printWriter.println("false 3 colorimage");
        int[] nArray = new int[this.xSize * this.ySize];
        PixelGrabber pixelGrabber = new PixelGrabber(this.image, 0, 0, this.xSize, this.ySize, nArray, 0, this.xSize);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            printWriter.println("% Bug getting pixels!");
        }
        int n = 0;
        for (int i = 0; i < this.ySize; ++i) {
            for (int j = 0; j < this.xSize; ++j) {
                printWriter.print(this.colorTripleHex(nArray[i * this.xSize + j]));
                if (++n % 11 != 0) continue;
                printWriter.println();
            }
        }
        printWriter.println();
        printWriter.println("%%EOF");
        printWriter.println("grestore");
        printWriter.println("showpage");
    }

    private String colorTripleHex(int n) {
        String string = "";
        try {
            string = Integer.toHexString(n & 0xFFFFFF);
            if (string.length() < 6) {
                string = "000000" + string;
                return string.substring(string.length() - 6);
            }
        }
        catch (Exception exception) {
            string = "FFFFFF";
        }
        return string;
    }

    private void concatCTM(PrintWriter printWriter, AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        printWriter.print("[ ");
        for (int i = 0; i < 6; ++i) {
            printWriter.print(dArray[i] + " ");
        }
        printWriter.println("] concat");
    }

    public PrinterJob getPrinterJob() {
        return this.printerJob;
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.g.clearRect(n, n2, n3, n4);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.g.clipRect(n, n2, n3, n4);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.copyArea(n, n2, n3, n4, n5, n6);
    }

    public Graphics create() {
        return this.g.create();
    }

    public void dispose() {
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawArc(n, n2, n3, n4, n5, n6);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.g.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.g.drawLine(n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.g.drawOval(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.g.drawPolyline(nArray, nArray2, n);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.g.drawString(attributedCharacterIterator, n, n2);
    }

    public void drawString(String string, int n, int n2) {
        this.g.drawString(string, n, n2);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.g.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.g.fillPolygon(nArray, nArray2, n);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.g.fillRect(n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.g.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public Shape getClip() {
        return this.g.getClip();
    }

    public Rectangle getClipBounds() {
        return this.g.getClipBounds();
    }

    public Color getColor() {
        return this.g.getColor();
    }

    public Font getFont() {
        return this.g.getFont();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.g.getFontMetrics(font);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.g.setClip(n, n2, n3, n4);
    }

    public void setClip(Shape shape) {
        this.g.setClip(shape);
    }

    public void setColor(Color color) {
        this.g.setColor(color);
    }

    public void setFont(Font font) {
        this.g.setFont(font);
    }

    public void setPaintMode() {
        this.g.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.g.setXORMode(color);
    }

    public void translate(int n, int n2) {
        this.g.translate(n, n2);
    }
}

