/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkComponentPeer;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.TextArea;
import java.awt.im.InputMethodRequests;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextComponentPeer;

public class GtkTextAreaPeer
extends GtkComponentPeer
implements TextComponentPeer,
TextAreaPeer {
    private static transient int DEFAULT_ROWS = 10;
    private static transient int DEFAULT_COLS = 80;

    native void create(int var1, int var2, int var3);

    protected native void gtkWidgetModifyFont(String var1, int var2, int var3);

    native void gtkWidgetRequestFocus();

    public native void connectSignals();

    public native int getCaretPosition();

    public native void setCaretPosition(int var1);

    public native int getSelectionStart();

    public native int getSelectionEnd();

    public native String getText();

    public native void select(int var1, int var2);

    public native void setEditable(boolean var1);

    public native void setText(String var1);

    public int getIndexAtPoint(int n, int n2) {
        return 0;
    }

    public Rectangle getCharacterBounds(int n) {
        return null;
    }

    public long filterEvents(long l) {
        return l;
    }

    void create() {
        Font font = this.awtComponent.getFont();
        if (font == null) {
            font = new Font("Dialog", 0, 12);
            this.awtComponent.setFont(font);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        TextArea textArea = (TextArea)this.awtComponent;
        int n = textArea.getRows();
        int n2 = textArea.getColumns();
        n = n == 0 ? DEFAULT_ROWS : n;
        n2 = n2 == 0 ? DEFAULT_COLS : n2;
        int n3 = n2 * fontMetrics.getMaxAdvance();
        int n4 = n * (fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent());
        this.create(n3, n4, textArea.getScrollbarVisibility());
        this.setEditable(textArea.isEditable());
    }

    public GtkTextAreaPeer(TextArea textArea) {
        super(textArea);
        this.setText(textArea.getText());
        this.setCaretPosition(0);
    }

    public native void insert(String var1, int var2);

    public native void replaceRange(String var1, int var2, int var3);

    public Dimension getMinimumSize(int n, int n2) {
        return this.minimumSize(n == 0 ? DEFAULT_ROWS : n, n2 == 0 ? DEFAULT_COLS : n2);
    }

    public Dimension getPreferredSize(int n, int n2) {
        return this.preferredSize(n == 0 ? DEFAULT_ROWS : n, n2 == 0 ? DEFAULT_COLS : n2);
    }

    native int getHScrollbarHeight();

    native int getVScrollbarWidth();

    public Dimension minimumSize(int n, int n2) {
        Font font;
        TextArea textArea = (TextArea)this.awtComponent;
        int n3 = 0;
        int n4 = 0;
        if (textArea.getScrollbarVisibility() == 0 || textArea.getScrollbarVisibility() == 2) {
            n3 = this.getHScrollbarHeight();
        }
        if (textArea.getScrollbarVisibility() == 0 || textArea.getScrollbarVisibility() == 1) {
            n4 = this.getVScrollbarWidth();
        }
        if ((font = this.awtComponent.getFont()) == null) {
            return new Dimension(n4, n3);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n5 = n == 0 ? DEFAULT_ROWS : n;
        int n6 = n2 == 0 ? DEFAULT_COLS : n2;
        return new Dimension(n4 += n6 * fontMetrics.getMaxAdvance(), n3 += n5 * (fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()));
    }

    public Dimension preferredSize(int n, int n2) {
        Font font;
        TextArea textArea = (TextArea)this.awtComponent;
        int n3 = 0;
        int n4 = 0;
        if (textArea.getScrollbarVisibility() == 0 || textArea.getScrollbarVisibility() == 2) {
            n3 = this.getHScrollbarHeight();
        }
        if (textArea.getScrollbarVisibility() == 0 || textArea.getScrollbarVisibility() == 1) {
            n4 = this.getVScrollbarWidth();
        }
        if ((font = this.awtComponent.getFont()) == null) {
            return new Dimension(n4, n3);
        }
        FontMetrics fontMetrics = this.getFontMetrics(font);
        int n5 = n == 0 ? DEFAULT_ROWS : n;
        int n6 = n2 == 0 ? DEFAULT_COLS : n2;
        return new Dimension(n4 += n6 * fontMetrics.getMaxAdvance(), n3 += n5 * (fontMetrics.getMaxDescent() + fontMetrics.getMaxAscent()));
    }

    public void replaceText(String string, int n, int n2) {
        this.replaceRange(string, n, n2);
    }

    public void insertText(String string, int n) {
        this.insert(string, n);
    }

    public InputMethodRequests getInputMethodRequests() {
        return null;
    }
}

