/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import gnu.java.awt.java2d.ImagePaint;
import gnu.java.awt.java2d.PolyEdge;
import gnu.java.awt.java2d.PolyEdgeComparator;
import java.awt.AWTError;
import java.awt.AWTPermission;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractGraphics2D
extends Graphics2D
implements Cloneable {
    private static final int AA_SAMPLING = 8;
    protected AffineTransform transform = new AffineTransform();
    private Paint paint;
    private Color background = Color.WHITE;
    private Font font;
    private Composite composite = AlphaComposite.SrcOver;
    private Stroke stroke = new BasicStroke();
    private Shape clip;
    private RenderingHints renderingHints;
    private Raster paintRaster;
    private WritableRaster destinationRaster;
    private transient int[] alpha;
    private transient ArrayList[] edgeTable;
    private boolean isOptimized;

    protected AbstractGraphics2D() {
        HashMap hashMap = new HashMap();
        hashMap.put(RenderingHints.KEY_TEXT_ANTIALIASING, "Default antialiasing text mode");
        hashMap.put(RenderingHints.KEY_ANTIALIASING, "Default antialiasing rendering mode");
        this.renderingHints = new RenderingHints(hashMap);
    }

    public void draw(Shape shape) {
        Shape shape2 = this.stroke.createStrokedShape(shape);
        this.fillShape(shape2, false);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        boolean bl = false;
        Rectangle rectangle = new Rectangle(0, 0, image.getWidth(imageObserver), image.getHeight(imageObserver));
        return this.drawImageImpl(image, affineTransform, imageObserver, rectangle);
    }

    private boolean drawImageImpl(Image image, AffineTransform affineTransform, ImageObserver imageObserver, Rectangle rectangle) {
        boolean bl;
        if (image == null) {
            bl = true;
        } else if (image instanceof RenderedImage) {
            this.drawRenderedImageImpl((RenderedImage)((Object)image), affineTransform, rectangle);
            bl = true;
        } else if (image instanceof RenderableImage) {
            this.drawRenderableImageImpl((RenderableImage)((Object)image), affineTransform, rectangle);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        BufferedImage bufferedImage2 = bufferedImageOp.createCompatibleDestImage(bufferedImage, bufferedImage.getColorModel());
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        this.drawRenderedImage(bufferedImage2, affineTransform);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        Rectangle rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getHeight(), renderedImage.getWidth(), renderedImage.getHeight());
        this.drawRenderedImageImpl(renderedImage, affineTransform, rectangle);
    }

    private void drawRenderedImageImpl(RenderedImage renderedImage, AffineTransform affineTransform, Rectangle rectangle) {
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.translate(-rectangle.x - renderedImage.getMinX(), -rectangle.y - renderedImage.getMinY());
        affineTransform2.concatenate(affineTransform);
        affineTransform2.concatenate(this.transform);
        AffineTransform affineTransform3 = null;
        try {
            affineTransform3 = affineTransform2.createInverse();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        if (affineTransform3 != null) {
            GeneralPath generalPath = new GeneralPath(rectangle);
            generalPath.transform(affineTransform);
            ImagePaint imagePaint = new ImagePaint(renderedImage, affineTransform3);
            Paint paint = this.paint;
            try {
                this.paint = imagePaint;
                this.fillShape(generalPath, false);
            }
            finally {
                Object var9_10 = null;
                this.paint = paint;
            }
        }
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        Rectangle rectangle = new Rectangle((int)renderableImage.getMinX(), (int)renderableImage.getHeight(), (int)renderableImage.getWidth(), (int)renderableImage.getHeight());
        this.drawRenderableImageImpl(renderableImage, affineTransform, rectangle);
    }

    private void drawRenderableImageImpl(RenderableImage renderableImage, AffineTransform affineTransform, Rectangle rectangle) {
        RenderedImage renderedImage = renderableImage.createDefaultRendering();
        this.drawRenderedImageImpl(renderedImage, affineTransform, rectangle);
    }

    public void drawString(String string, int n, int n2) {
        if (this.isOptimized) {
            this.rawDrawString(string, n, n2);
        } else {
            FontRenderContext fontRenderContext = this.getFontRenderContext();
            GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, string.toCharArray());
            this.drawGlyphVector(glyphVector, n, n2);
        }
    }

    public void drawString(String string, float f, float f2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, string.toCharArray());
        this.drawGlyphVector(glyphVector, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, attributedCharacterIterator);
        this.drawGlyphVector(glyphVector, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, attributedCharacterIterator);
        this.drawGlyphVector(glyphVector, f, f2);
    }

    public void fill(Shape shape) {
        this.fillShape(shape, false);
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setComposite(Composite composite) {
        SecurityManager securityManager;
        if (!(composite instanceof AlphaComposite) && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new AWTPermission("readDisplayPixels"));
        }
        this.composite = composite;
        if (!composite.equals(AlphaComposite.SrcOver)) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void setPaint(Paint paint) {
        if (paint != null) {
            this.paint = paint;
            if (!(this.paint instanceof Color)) {
                this.isOptimized = false;
            } else {
                this.updateOptimization();
            }
        }
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (!this.stroke.equals(new BasicStroke())) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.renderingHints.put(key, object);
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    public void setRenderingHints(Map map) {
        this.renderingHints.clear();
        this.renderingHints.putAll(map);
    }

    public void addRenderingHints(Map map) {
        this.renderingHints.putAll(map);
    }

    public RenderingHints getRenderingHints() {
        return (RenderingHints)this.renderingHints.clone();
    }

    public void translate(int n, int n2) {
        this.transform.translate(n, n2);
        if (this.clip != null) {
            if (this.clip instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)this.clip;
                rectangle.x -= n;
                rectangle.y -= n2;
                this.setClip(rectangle);
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-n, -n2);
                this.updateClip(affineTransform);
            }
        }
    }

    public void translate(double d, double d2) {
        this.transform.translate(d, d2);
        if (this.clip != null) {
            if (this.clip instanceof Rectangle) {
                Rectangle rectangle = (Rectangle)this.clip;
                rectangle.x = (int)((double)rectangle.x - d);
                rectangle.y = (int)((double)rectangle.y - d2);
            } else {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(-d, -d2);
                this.updateClip(affineTransform);
            }
        }
    }

    public void rotate(double d) {
        this.transform.rotate(d);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-d);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void rotate(double d, double d2, double d3) {
        this.transform.rotate(d, d2, d3);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(-d, d2, d3);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void scale(double d, double d2) {
        this.transform.scale(d, d2);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.scale(1.0 / d, 1.0 / d2);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void shear(double d, double d2) {
        this.transform.shear(d, d2);
        if (this.clip != null) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.shear(-d, -d2);
            this.updateClip(affineTransform);
        }
        this.updateOptimization();
    }

    public void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        try {
            AffineTransform affineTransform2 = affineTransform.createInverse();
            this.updateClip(affineTransform2);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        this.updateOptimization();
    }

    public void setTransform(AffineTransform affineTransform) {
        this.updateClip(this.transform);
        this.transform.setTransform(affineTransform);
        try {
            this.updateClip(this.transform.createInverse());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            noninvertibleTransformException.printStackTrace();
        }
        this.updateOptimization();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public Paint getPaint() {
        return this.paint;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        return this.background;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void clip(Shape shape) {
        if (this.clip == null) {
            this.clip = shape;
        } else if (this.clip instanceof Rectangle && shape instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)this.clip;
            Rectangle rectangle2 = (Rectangle)shape;
            AbstractGraphics2D.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle);
            this.setClip(rectangle);
        } else {
            Area area = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            Area area2 = shape instanceof Area ? (Area)shape : new Area(shape);
            area.intersect(area2);
            this.clip = area;
            this.isOptimized = false;
            this.setClip(this.clip);
        }
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, false, true);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        int n = glyphVector.getNumGlyphs();
        this.translate(f, f2);
        for (int i = 0; i < n; ++i) {
            Shape shape = glyphVector.getGlyphOutline(i);
            this.fillShape(shape, true);
        }
        this.translate(-f, -f2);
    }

    public Graphics create() {
        AbstractGraphics2D abstractGraphics2D = (AbstractGraphics2D)this.clone();
        return abstractGraphics2D;
    }

    protected Object clone() {
        try {
            AbstractGraphics2D abstractGraphics2D = (AbstractGraphics2D)super.clone();
            abstractGraphics2D.clip = this.clip instanceof Rectangle ? new Rectangle((Rectangle)this.clip) : new GeneralPath(this.clip);
            abstractGraphics2D.renderingHints = new RenderingHints(this.renderingHints);
            abstractGraphics2D.transform = new AffineTransform(this.transform);
            return abstractGraphics2D;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            AWTError aWTError = new AWTError("Unexpected exception while cloning");
            aWTError.initCause(cloneNotSupportedException);
            throw aWTError;
        }
    }

    public Color getColor() {
        Color color = null;
        if (this.paint instanceof Color) {
            color = (Color)this.paint;
        }
        return color;
    }

    public void setColor(Color color) {
        this.setPaint(color);
    }

    public void setPaintMode() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void setXORMode(Color color) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font != null) {
            this.font = font;
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        Rectangle rectangle = null;
        if (this.clip != null) {
            rectangle = this.clip.getBounds();
        }
        return rectangle;
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.setClip(new Rectangle(n, n2, n3, n4));
    }

    public Shape getClip() {
        return this.clip;
    }

    public void setClip(Shape shape) {
        this.clip = shape;
        if (!(this.clip instanceof Rectangle)) {
            this.isOptimized = false;
        } else {
            this.updateOptimization();
        }
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isOptimized) {
            this.rawCopyArea(n, n2, n3, n4, n5, n6);
        } else {
            this.copyAreaImpl(n, n2, n3, n4, n5, n6);
        }
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        if (this.isOptimized) {
            int n5 = (int)this.transform.getTranslateX();
            int n6 = (int)this.transform.getTranslateY();
            this.rawDrawLine(n + n5, n2 + n6, n3 + n5, n4 + n6);
        } else {
            Line2D.Double double_ = new Line2D.Double(n, n2, n3, n4);
            this.draw(double_);
        }
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        if (this.isOptimized) {
            int n5 = (int)this.transform.getTranslateX();
            int n6 = (int)this.transform.getTranslateY();
            this.rawFillRect(n + n5, n2 + n6, n3, n4);
        } else {
            this.fill(new Rectangle(n, n2, n3, n4));
        }
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        if (this.isOptimized) {
            this.rawClearRect(n, n2, n3, n4);
        } else {
            Paint paint = this.getPaint();
            this.setPaint(this.getBackground());
            this.fillRect(n, n2, n3, n4);
            this.setPaint(paint);
        }
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new RoundRectangle2D.Double(n, n2, n3, n4, n5, n6));
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.draw(new Ellipse2D.Double(n, n2, n3, n4));
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.fill(new Ellipse2D.Double(n, n2, n3, n4));
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.draw(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fill(new Arc2D.Double(n, n2, n3, n4, n5, n6, 0));
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.draw(new Polygon(nArray, nArray2, n));
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.fill(new Polygon(nArray, nArray2, n));
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        boolean bl;
        if (this.isOptimized) {
            bl = this.rawDrawImage(image, n, n2, imageObserver);
        } else {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(n, n2);
            bl = this.drawImage(image, affineTransform, imageObserver);
        }
        return bl;
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        double d = (double)n3 / (double)image.getWidth(imageObserver);
        double d2 = (double)n4 / (double)image.getHeight(imageObserver);
        affineTransform.scale(d, d2);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        double d = (double)image.getWidth(imageObserver) / (double)n3;
        double d2 = (double)image.getHeight(imageObserver) / (double)n4;
        affineTransform.scale(d, d2);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        int n9 = Math.min(n5, n5);
        int n10 = Math.min(n6, n8);
        int n11 = Math.abs(n5 - n7);
        int n12 = Math.abs(n6 - n8);
        int n13 = Math.min(n, n);
        int n14 = Math.min(n2, n4);
        int n15 = Math.abs(n - n3);
        int n16 = Math.abs(n2 - n4);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n9 - n13, n10 - n14);
        double d = (double)n11 / (double)n15;
        double d2 = (double)n12 / (double)n16;
        affineTransform.scale(d, d2);
        Rectangle rectangle = new Rectangle(n9, n10, n11, n12);
        return this.drawImageImpl(image, affineTransform, imageObserver, rectangle);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public void dispose() {
    }

    protected void fillShape(Shape shape, boolean bl) {
        Object object;
        boolean bl2 = false;
        bl2 = bl ? (object = this.renderingHints.get(RenderingHints.KEY_TEXT_ANTIALIASING)) == "Antialiased text mode" : (object = this.renderingHints.get(RenderingHints.KEY_ANTIALIASING)) == "Antialiased rendering mode";
        object = shape.getBounds2D();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        ArrayList arrayList = this.getSegments(shape, this.transform, double_, false);
        Rectangle2D.Double double_2 = new Rectangle2D.Double();
        ArrayList arrayList2 = this.getSegments(this.clip, this.transform, double_2, true);
        arrayList.addAll(arrayList2);
        Rectangle2D.Double double_3 = new Rectangle2D.Double();
        Rectangle2D.union(double_2, double_, double_3);
        if (arrayList.size() > 0) {
            if (bl2) {
                this.fillShapeAntialias(arrayList, double_, (Rectangle2D)object, double_3);
            } else {
                this.fillShapeImpl(arrayList, double_, (Rectangle2D)object, double_3);
            }
        }
    }

    protected abstract ColorModel getColorModel();

    protected Rectangle getDeviceBounds() {
        return this.destinationRaster.getBounds();
    }

    protected void rawDrawLine(int n, int n2, int n3, int n4) {
        this.draw(new Line2D.Float(n, n2, n3, n4));
    }

    protected void rawDrawString(String string, int n, int n2) {
        FontRenderContext fontRenderContext = this.getFontRenderContext();
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, string.toCharArray());
        this.drawGlyphVector(glyphVector, n, n2);
    }

    protected void rawClearRect(int n, int n2, int n3, int n4) {
        Paint paint = this.getPaint();
        this.setPaint(this.getBackground());
        this.rawFillRect(n, n2, n3, n4);
        this.setPaint(paint);
    }

    protected void rawFillRect(int n, int n2, int n3, int n4) {
        this.fill(new Rectangle(n, n2, n3, n4));
    }

    protected boolean rawDrawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(n, n2);
        return this.drawImage(image, affineTransform, imageObserver);
    }

    protected void rawCopyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.copyAreaImpl(n, n2, n3, n4, n5, n6);
    }

    private void copyAreaImpl(int n, int n2, int n3, int n4, int n5, int n6) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private void fillShapeImpl(ArrayList arrayList, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        int n;
        Object object;
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D3.getMinY();
        double d6 = rectangle2D3.getMaxY();
        Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)Math.ceil(d3) - (int)d, (int)Math.ceil(d4) - (int)d2);
        PaintContext paintContext = this.paint.createContext(this.getColorModel(), rectangle, rectangle2D2, this.transform, this.renderingHints);
        ArrayList[] arrayListArray = new ArrayList[(int)Math.ceil(d6) - (int)Math.ceil(d5) + 1];
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (PolyEdge)object2.next();
            n = (int)Math.ceil(((PolyEdge)object).y0) - (int)Math.ceil(d5);
            if (arrayListArray[n] == null) {
                arrayListArray[n] = new ArrayList();
            }
            arrayListArray[n].add(object);
        }
        object2 = new ArrayList();
        object = new PolyEdgeComparator();
        n = (int)Math.ceil(d5);
        Rectangle rectangle2 = this.getDeviceBounds();
        int n2 = (int)Math.min(d4, rectangle2.getMaxY());
        for (int i = n; i < n2; ++i) {
            int n3;
            PolyEdge polyEdge;
            ArrayList arrayList2 = arrayListArray[i - n];
            Iterator iterator = ((AbstractList)object2).iterator();
            while (iterator.hasNext()) {
                polyEdge = (PolyEdge)iterator.next();
                if ((double)i > polyEdge.y1) {
                    iterator.remove();
                    continue;
                }
                polyEdge.xIntersection += polyEdge.slope;
            }
            if (arrayList2 != null) {
                ((ArrayList)object2).addAll(arrayList2);
            }
            if ((n3 = ((ArrayList)object2).size()) > 1) {
                for (int j = 1; j < n3; ++j) {
                    PolyEdge polyEdge2;
                    PolyEdge polyEdge3 = (PolyEdge)((ArrayList)object2).get(j - 1);
                    if (((PolyEdgeComparator)object).compare(polyEdge3, polyEdge2 = (PolyEdge)((ArrayList)object2).get(j)) <= 0) continue;
                    int n4 = j;
                    do {
                        ((ArrayList)object2).set(n4, polyEdge3);
                        ((ArrayList)object2).set(n4 - 1, polyEdge2);
                        if (--n4 < 1) continue;
                        polyEdge3 = (PolyEdge)((ArrayList)object2).get(n4 - 1);
                    } while (n4 >= 1 && ((PolyEdgeComparator)object).compare(polyEdge3, polyEdge2) > 0);
                }
            }
            polyEdge = null;
            boolean bl = false;
            boolean bl2 = false;
            Iterator iterator2 = ((AbstractList)object2).iterator();
            while (iterator2.hasNext()) {
                int n5;
                int n6;
                PolyEdge polyEdge4 = (PolyEdge)iterator2.next();
                if (polyEdge4.y1 <= (double)i) continue;
                if (bl2 && bl && (n6 = (int)polyEdge.xIntersection) < (n5 = (int)polyEdge4.xIntersection)) {
                    this.fillScanline(paintContext, n6, n5, i);
                }
                polyEdge = polyEdge4;
                if (polyEdge4.isClip) {
                    bl2 ^= true;
                    continue;
                }
                bl ^= true;
            }
        }
        paintContext.dispose();
    }

    protected void fillScanline(PaintContext paintContext, int n, int n2, int n3) {
        Raster raster = paintContext.getRaster(n, n3, n2 - n, 1);
        ColorModel colorModel = paintContext.getColorModel();
        CompositeContext compositeContext = this.composite.createContext(colorModel, this.getColorModel(), this.renderingHints);
        WritableRaster writableRaster = this.destinationRaster.createWritableTranslatedChild(-n, -n3);
        compositeContext.compose(raster, writableRaster, writableRaster);
        this.updateRaster(this.destinationRaster, n, n3, n2 - n, 1);
        compositeContext.dispose();
    }

    private void fillShapeAntialias(ArrayList arrayList, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        int n;
        Object object;
        double d = rectangle2D.getMinX();
        double d2 = rectangle2D.getMinY();
        double d3 = rectangle2D.getMaxX();
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D3.getMinY();
        double d6 = rectangle2D3.getMaxY();
        double d7 = rectangle2D3.getMinX();
        double d8 = rectangle2D3.getMaxX();
        Rectangle rectangle = new Rectangle((int)d, (int)d2, (int)Math.ceil(d3) - (int)d, (int)Math.ceil(d4) - (int)d2);
        PaintContext paintContext = this.paint.createContext(ColorModel.getRGBdefault(), rectangle, rectangle2D2, this.transform, this.renderingHints);
        int n2 = (int)Math.ceil(d6) - (int)d5;
        int n3 = (int)Math.ceil(d8) - (int)d7 + 1;
        if (this.alpha == null || this.alpha.length < n3 + 1) {
            this.alpha = new int[n3 + 1];
        }
        int n4 = (int)d5;
        int n5 = (int)Math.ceil((d5 - Math.floor(d5)) * 8.0);
        double d9 = (double)n4 + (double)n5 / 8.0;
        if (this.edgeTable == null || this.edgeTable.length < n2 * 8 + 8) {
            this.edgeTable = new ArrayList[n2 * 8 + 8];
        }
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            object = (PolyEdge)object2.next();
            n = (int)Math.ceil((((PolyEdge)object).y0 - d9) * 8.0);
            ((PolyEdge)object).slope = (((PolyEdge)object).x1 - ((PolyEdge)object).x0) / (((PolyEdge)object).y1 - ((PolyEdge)object).y0) / 8.0;
            if (((PolyEdge)object).y0 == ((PolyEdge)object).y1) {
                ((PolyEdge)object).xIntersection = Math.min(((PolyEdge)object).x0, ((PolyEdge)object).x1);
            } else {
                double d10 = Math.ceil(((PolyEdge)object).y0 * 8.0) / 8.0;
                ((PolyEdge)object).xIntersection = ((PolyEdge)object).x0 + ((PolyEdge)object).slope * 8.0 * (d10 - ((PolyEdge)object).y0);
            }
            if (n < 0 || n >= this.edgeTable.length) continue;
            if (this.edgeTable[n] == null) {
                this.edgeTable[n] = new ArrayList();
            }
            this.edgeTable[n].add(object);
        }
        object2 = new ArrayList();
        object = new PolyEdgeComparator();
        n = 0;
        int n6 = n4;
        while ((double)n6 <= d6) {
            int n7 = (int)d8;
            int n8 = (int)d7;
            boolean bl = true;
            for (int i = n5; i < 8; ++i) {
                int n9;
                PolyEdge polyEdge;
                ArrayList arrayList2 = this.edgeTable[n];
                Iterator iterator = ((AbstractList)object2).iterator();
                while (iterator.hasNext()) {
                    polyEdge = (PolyEdge)iterator.next();
                    if ((double)n6 + (double)i / 8.0 > polyEdge.y1) {
                        iterator.remove();
                        continue;
                    }
                    polyEdge.xIntersection += polyEdge.slope;
                }
                if (arrayList2 != null) {
                    ((ArrayList)object2).addAll(arrayList2);
                    this.edgeTable[n].clear();
                }
                if ((n9 = ((ArrayList)object2).size()) > 1) {
                    for (int j = 1; j < n9; ++j) {
                        PolyEdge polyEdge2;
                        PolyEdge polyEdge3 = (PolyEdge)((ArrayList)object2).get(j - 1);
                        if (((PolyEdgeComparator)object).compare(polyEdge3, polyEdge2 = (PolyEdge)((ArrayList)object2).get(j)) <= 0) continue;
                        int n10 = j;
                        do {
                            ((ArrayList)object2).set(n10, polyEdge3);
                            ((ArrayList)object2).set(n10 - 1, polyEdge2);
                            if (--n10 < 1) continue;
                            polyEdge3 = (PolyEdge)((ArrayList)object2).get(n10 - 1);
                        } while (n10 >= 1 && ((PolyEdgeComparator)object).compare(polyEdge3, polyEdge2) > 0);
                    }
                }
                polyEdge = null;
                boolean bl2 = false;
                boolean bl3 = false;
                Iterator iterator2 = ((AbstractList)object2).iterator();
                while (iterator2.hasNext()) {
                    PolyEdge polyEdge4 = (PolyEdge)iterator2.next();
                    if (polyEdge4.y1 <= (double)n6 + (double)i / 8.0) continue;
                    if (bl2 && bl3 && polyEdge4.y1 > (double)n6 + (double)i / 8.0) {
                        int n11 = (int)Math.min(Math.max(polyEdge.xIntersection, d), d3);
                        int n12 = (int)Math.min(Math.max(polyEdge4.xIntersection, d), d3);
                        int n13 = n11 - (int)d;
                        int n14 = n12 - (int)d + 1;
                        int n15 = n13;
                        this.alpha[n15] = this.alpha[n15] + 1;
                        int n16 = n14;
                        this.alpha[n16] = this.alpha[n16] - 1;
                        n7 = Math.min(n11, n7);
                        n8 = Math.max(n12 + 2, n8);
                        bl = false;
                    }
                    polyEdge = polyEdge4;
                    if (polyEdge4.isClip) {
                        bl2 ^= true;
                        continue;
                    }
                    bl3 ^= true;
                }
                ++n;
            }
            n5 = 0;
            if (!bl) {
                this.fillScanlineAA(this.alpha, n7, n6, n8 - n7, paintContext, (int)d);
            }
            ++n6;
        }
        paintContext.dispose();
    }

    private void fillScanlineAA(int[] nArray, int n, int n2, int n3, PaintContext paintContext, int n4) {
        CompositeContext compositeContext = this.composite.createContext(paintContext.getColorModel(), this.getColorModel(), this.renderingHints);
        Raster raster = paintContext.getRaster(n, n2, n3, 1);
        WritableRaster writableRaster = raster.createCompatibleWritableRaster();
        int n5 = raster.getNumBands();
        ColorModel colorModel = paintContext.getColorModel();
        double d = 0.0;
        int n6 = 0;
        Object object = null;
        int[] nArray2 = null;
        int n7 = n + n3;
        for (int i = n; i < n7; ++i) {
            int n8 = i - n4;
            if (nArray[n8] != 0) {
                d = (double)(n6 += nArray[n8]) / 8.0;
                nArray[n8] = 0;
            }
            object = raster.getDataElements(i - n, 0, object);
            nArray2 = colorModel.getComponents(object, nArray2, 0);
            if (colorModel.hasAlpha() && !colorModel.isAlphaPremultiplied()) {
                nArray2[nArray2.length - 1] = (int)((double)nArray2[nArray2.length - 1] * d);
            } else {
                int n9 = colorModel.hasAlpha() ? nArray2.length - 2 : nArray2.length - 1;
                for (int j = 0; j < n9; ++j) {
                    nArray2[j] = (int)((double)nArray2[j] * d);
                }
            }
            object = colorModel.getDataElements(nArray2, 0, object);
            writableRaster.setDataElements(i - n, 0, object);
        }
        WritableRaster writableRaster2 = this.destinationRaster.createWritableTranslatedChild(-n, -n2);
        compositeContext.compose(writableRaster, writableRaster2, writableRaster2);
        this.updateRaster(this.destinationRaster, n, n2, n3, 1);
        compositeContext.dispose();
    }

    protected void init() {
        this.setPaint(Color.BLACK);
        this.setFont(new Font("SansSerif", 0, 12));
        this.isOptimized = true;
        this.destinationRaster = this.getDestinationRaster();
        this.clip = this.getDeviceBounds();
    }

    protected WritableRaster getDestinationRaster() {
        Rectangle rectangle = this.getDeviceBounds();
        if (this.destinationRaster == null) {
            int[] nArray = new int[]{0xFF0000, 65280, 255};
            this.destinationRaster = Raster.createPackedRaster(3, rectangle.width, rectangle.height, nArray, null);
            int n = this.destinationRaster.getMinX();
            int n2 = this.destinationRaster.getWidth() + n;
            int n3 = this.destinationRaster.getMinY();
            int n4 = this.destinationRaster.getHeight() + n3;
            int n5 = this.destinationRaster.getNumBands();
            for (int i = n3; i < n4; ++i) {
                for (int j = n; j < n2; ++j) {
                    for (int k = 0; k < n5; ++k) {
                        this.destinationRaster.setSample(j, i, k, 255);
                    }
                }
            }
        }
        return this.destinationRaster;
    }

    protected void updateRaster(Raster raster, int n, int n2, int n3, int n4) {
    }

    private void updateOptimization() {
        int n = this.transform.getType();
        boolean bl = false;
        if (n == 0 || n == 1) {
            bl = true;
        }
        boolean bl2 = this.clip == null || this.clip instanceof Rectangle;
        this.isOptimized = bl2 && bl && this.paint instanceof Color && this.composite == AlphaComposite.SrcOver && this.stroke.equals(new BasicStroke());
    }

    private static Rectangle computeIntersection(int n, int n2, int n3, int n4, Rectangle rectangle) {
        int n5;
        int n6 = rectangle.x;
        int n7 = rectangle.y;
        int n8 = rectangle.width;
        int n9 = rectangle.height;
        int n10 = n > n6 ? n : n6;
        int n11 = n2 > n7 ? n2 : n7;
        int n12 = n + n3 < n6 + n8 ? n + n3 - n10 : n6 + n8 - n10;
        int n13 = n5 = n2 + n4 < n7 + n9 ? n2 + n4 - n11 : n7 + n9 - n11;
        if (n12 >= 0 && n5 >= 0) {
            rectangle.setBounds(n10, n11, n12, n5);
        } else {
            rectangle.setBounds(0, 0, 0, 0);
        }
        return rectangle;
    }

    private void updateClip(AffineTransform affineTransform) {
        if (!(this.clip instanceof GeneralPath)) {
            this.clip = new GeneralPath(this.clip);
        }
        GeneralPath generalPath = (GeneralPath)this.clip;
        generalPath.transform(affineTransform);
    }

    private ArrayList getSegments(Shape shape, AffineTransform affineTransform, Rectangle2D rectangle2D, boolean bl) {
        PathIterator pathIterator = shape.getPathIterator(this.getTransform(), 1.0);
        double[] dArray = new double[6];
        ArrayList arrayList = new ArrayList();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 2.147483647E9;
        double d6 = -2.147483648E9;
        double d7 = 2.147483647E9;
        double d8 = -2.147483648E9;
        while (!pathIterator.isDone()) {
            PolyEdge polyEdge;
            int n = pathIterator.currentSegment(dArray);
            d5 = Math.min(d5, dArray[0]);
            d6 = Math.max(d6, dArray[0]);
            d7 = Math.min(d7, dArray[1]);
            d8 = Math.max(d8, dArray[1]);
            if (n == 0) {
                d = dArray[0];
                d2 = dArray[1];
                d3 = dArray[0];
                d4 = dArray[1];
            } else if (n == 4) {
                polyEdge = new PolyEdge(d, d2, d3, d4, bl);
                arrayList.add(polyEdge);
            } else if (n == 1) {
                polyEdge = new PolyEdge(d, d2, dArray[0], dArray[1], bl);
                arrayList.add(polyEdge);
                d = dArray[0];
                d2 = dArray[1];
            }
            pathIterator.next();
        }
        rectangle2D.setRect(d5, d7, d6 - d5, d8 - d7);
        return arrayList;
    }
}

