/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.Scaler;
import gnu.java.awt.font.opentype.truetype.GlyphLoader;
import gnu.java.awt.font.opentype.truetype.GlyphLocator;
import gnu.java.awt.font.opentype.truetype.GlyphMeasurer;
import gnu.java.awt.font.opentype.truetype.VirtualMachine;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.FontFormatException;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.nio.ByteBuffer;

public final class TrueTypeScaler
extends Scaler {
    private ByteBuffer glyfTable;
    private GlyphLoader glyphLoader;
    private final GlyphMeasurer glyphMeasurer;
    private final Zone glyphZone;
    private int unitsPerEm;

    public TrueTypeScaler(int n, ByteBuffer byteBuffer, ByteBuffer byteBuffer2, ByteBuffer byteBuffer3, ByteBuffer byteBuffer4, ByteBuffer byteBuffer5, ByteBuffer byteBuffer6, ByteBuffer byteBuffer7, int n2, ByteBuffer byteBuffer8, ByteBuffer byteBuffer9, ByteBuffer byteBuffer10) throws FontFormatException {
        int n3 = Math.max(byteBuffer5.getChar(8), byteBuffer5.getChar(12)) + 8;
        int n4 = Math.max(byteBuffer5.getChar(6), byteBuffer5.getChar(10)) + 12;
        this.glyphZone = new Zone(n4 + 4);
        this.glyfTable = byteBuffer9;
        VirtualMachine virtualMachine = new VirtualMachine(n, byteBuffer5, byteBuffer6, byteBuffer7, byteBuffer10);
        GlyphLocator glyphLocator = GlyphLocator.forTable(n2, byteBuffer8, byteBuffer9);
        this.glyphMeasurer = new GlyphMeasurer(byteBuffer, byteBuffer2, byteBuffer3, byteBuffer4);
        this.glyphLoader = new GlyphLoader(glyphLocator, virtualMachine, n, n3, n4, this.glyphMeasurer);
        this.unitsPerEm = n;
    }

    public GeneralPath getOutline(int n, float f, AffineTransform affineTransform, boolean bl, boolean bl2) {
        this.glyphLoader.loadGlyph(n, f, affineTransform, bl, this.glyphZone);
        return this.glyphZone.getPath();
    }

    public void getAdvance(int n, float f, AffineTransform affineTransform, boolean bl, boolean bl2, boolean bl3, Point2D point2D) {
        double d = (double)f / (double)this.unitsPerEm;
        point2D.setLocation(d * (double)this.glyphMeasurer.getAdvanceWidth(n, bl3), d * (double)this.glyphMeasurer.getAdvanceHeight(n, bl3));
        affineTransform.transform(point2D, point2D);
    }

    private float scaleFromFUnits(int n, float f, AffineTransform affineTransform, boolean bl, boolean bl2) {
        double d = (double)f / (double)this.unitsPerEm;
        if (affineTransform != null) {
            d *= bl2 ? affineTransform.getScaleY() : affineTransform.getScaleX();
        }
        d *= (double)n;
        if (!bl) {
            d = Math.round(d);
        }
        return (float)d;
    }

    public float getAscent(float f, AffineTransform affineTransform, boolean bl, boolean bl2, boolean bl3) {
        return this.scaleFromFUnits(this.glyphMeasurer.getAscent(bl3), f, affineTransform, bl2, bl3 ^ true);
    }

    public float getDescent(float f, AffineTransform affineTransform, boolean bl, boolean bl2, boolean bl3) {
        return this.scaleFromFUnits(this.glyphMeasurer.getDescent(bl3), f, affineTransform, bl2, bl3 ^ true);
    }
}

