/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.giop.grmic;

import gnu.classpath.tools.AbstractMethodGenerator;
import gnu.classpath.tools.giop.grmic.CompilationError;
import gnu.classpath.tools.giop.grmic.Generator;
import gnu.classpath.tools.giop.grmic.HashFinder;
import gnu.classpath.tools.giop.grmic.MethodGenerator;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class GiopRmicCompiler
extends Generator
implements Comparator {
    protected String packag;
    protected String name;
    protected String implName;
    protected String stubName;
    protected Collection implementedRemotes;
    protected Collection extraImports;
    protected Collection methods;
    public Properties vars;
    protected boolean poaMode;
    protected boolean warnings;
    protected boolean verbose;
    protected boolean force;
    ClassLoader classLoader;

    private /* synthetic */ void finit$() {
        this.implementedRemotes = new HashSet();
        this.extraImports = new HashSet();
        this.methods = new HashSet();
        this.vars = new Properties();
        this.poaMode = true;
        this.warnings = true;
        this.verbose = false;
        this.force = false;
    }

    public void reset() {
        this.stubName = null;
        this.implName = null;
        this.name = null;
        this.packag = null;
        this.implementedRemotes.clear();
        this.extraImports.clear();
        this.methods.clear();
        this.vars.clear();
    }

    public void setClassPath(String string) {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator, true);
        ArrayList<URL> arrayList = new ArrayList<URL>(stringTokenizer.countTokens());
        String string2 = null;
        try {
            while (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals(File.pathSeparator)) {
                    arrayList.add(new File(".").toURL());
                    continue;
                }
                arrayList.add(new File(string2).toURL());
                if (!stringTokenizer.hasMoreTokens()) continue;
                stringTokenizer.nextToken();
                if (stringTokenizer.hasMoreTokens()) continue;
                arrayList.add(new File(".").toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed path '" + string2 + "' in classpath '" + string + "'");
            System.exit(1);
        }
        URL[] uRLArray = new URL[arrayList.size()];
        for (int i = 0; i < uRLArray.length; ++i) {
            uRLArray[i] = (URL)arrayList.get(i);
        }
        this.classLoader = new URLClassLoader(uRLArray, this.classLoader);
    }

    public Class loadClass(String string) {
        ClassLoader classLoader = this.classLoader;
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(string + " not found on " + classLoader);
            System.exit(1);
            return null;
        }
    }

    public synchronized void compile(Class clazz) {
        this.reset();
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n < 0) {
            this.packag = "";
            this.implName = this.name = string;
        } else {
            this.packag = string.substring(0, n);
            this.implName = this.name = string.substring(n + 1);
        }
        this.stubName = this.name = this.convertStubName(this.name);
        this.vars.put("#name", this.name);
        this.vars.put("#package", this.packag);
        this.vars.put("#implName", this.implName);
        if (this.verbose) {
            System.out.println("Package " + this.packag + ", name " + this.name + " impl " + this.implName);
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!GiopRmicCompiler.class$("java.rmi.Remote").isAssignableFrom(classArray[i]) || classArray[i].equals(GiopRmicCompiler.class$("java.rmi.Remote"))) continue;
            this.implementedRemotes.add(classArray[i]);
        }
        this.vars.put("#idList", this.getIdList(this.implementedRemotes));
        Iterator iterator = this.implementedRemotes.iterator();
        while (iterator.hasNext()) {
            Class clazz2 = (Class)iterator.next();
            Method[] methodArray = clazz2.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                Class<?>[] classArray2 = methodArray[i].getExceptionTypes();
                boolean bl = false;
                for (int j = 0; j < classArray2.length; ++j) {
                    if (!GiopRmicCompiler.class$("java.rmi.RemoteException").isAssignableFrom(classArray2[j])) continue;
                    bl = true;
                    break;
                }
                if (!bl && !this.force) {
                    throw new CompilationError(methodArray[i].getName() + ", defined in " + clazz2.getName() + ", does not throw " + GiopRmicCompiler.class$("java.rmi.RemoteException").getName());
                }
                AbstractMethodGenerator abstractMethodGenerator = this.createMethodGenerator(methodArray[i]);
                this.methods.add(abstractMethodGenerator);
            }
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected AbstractMethodGenerator createMethodGenerator(Method method) {
        return new MethodGenerator(method, this);
    }

    public String name(Class clazz) {
        int n;
        if (clazz.isArray()) {
            int n2 = 0;
            Class<?> clazz2 = clazz;
            while (clazz2.isArray()) {
                clazz2 = clazz2.getComponentType();
                ++n2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < n2; ++i) {
                stringBuffer.append("[]");
            }
            return this.name(clazz2) + " " + stringBuffer;
        }
        String string = clazz.getName();
        if (!(clazz.isArray() || clazz.isPrimitive() || string.startsWith("java.lang") || this.packag != null && string.startsWith(this.packag))) {
            this.extraImports.add(string);
        }
        if ((n = string.lastIndexOf(46)) < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public String getId(Class clazz) {
        return "RMI:" + clazz.getName() + ":0000000000000000";
    }

    public String getIdList(Collection collection) {
        StringBuffer stringBuffer = new StringBuffer();
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            treeSet.add(this.getId((Class)iterator.next()));
        }
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("      \"" + iterator.next() + "\"");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", \n");
        }
        return stringBuffer.toString();
    }

    public String generateStub() {
        Object object;
        String string = this.getResource("Stub.jav");
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            object = (AbstractMethodGenerator)iterator.next();
            stringBuffer.append(object.generateStubMethod());
        }
        this.vars.put("#stub_methods", stringBuffer.toString());
        this.vars.put("#imports", this.getImportStatements());
        this.vars.put("#interfaces", this.getAllInterfaces());
        object = this.replaceAll(string, this.vars);
        return object;
    }

    public String getAllInterfaces() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.implementedRemotes.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(this.name((Class)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public String generateTie() {
        Object object;
        int n;
        String string = this.poaMode ? this.getResource("Tie.jav") : this.getResource("ImplTie.jav");
        HashFinder hashFinder = new HashFinder();
        Iterator iterator = this.methods.iterator();
        String[] stringArray = new String[this.methods.size()];
        boolean bl = false;
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = ((MethodGenerator)iterator.next()).getGiopMethodName();
        }
        n = hashFinder.findHashCharPosition(stringArray);
        iterator = this.methods.iterator();
        while (iterator.hasNext()) {
            ((MethodGenerator)iterator.next()).hashCharPosition = n;
        }
        this.vars.put("#hashCharPos", Integer.toString(n));
        ArrayList arrayList = new ArrayList(this.methods);
        Collections.sort(arrayList, this);
        iterator = arrayList.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        MethodGenerator methodGenerator = null;
        while (iterator.hasNext()) {
            object = (MethodGenerator)iterator.next();
            ((MethodGenerator)object).previous = methodGenerator;
            ((MethodGenerator)object).hashCharPosition = n;
            methodGenerator = object;
            stringBuffer.append(((MethodGenerator)object).generateTieMethod());
        }
        this.vars.put("#tie_methods", stringBuffer.toString());
        this.vars.put("#imports", this.getImportStatements());
        object = this.replaceAll(string, this.vars);
        return object;
    }

    public int compare(Object object, Object object2) {
        MethodGenerator methodGenerator = (MethodGenerator)object;
        MethodGenerator methodGenerator2 = (MethodGenerator)object2;
        return methodGenerator.getHashChar() - methodGenerator2.getHashChar();
    }

    protected String getImportStatements() {
        CharSequence charSequence;
        TreeSet<String> treeSet = new TreeSet<String>();
        Iterator iterator = this.extraImports.iterator();
        while (iterator.hasNext()) {
            charSequence = iterator.next().toString();
            treeSet.add("import " + (String)charSequence + ";\n");
        }
        charSequence = new StringBuffer();
        iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ((StringBuffer)charSequence).append(iterator.next());
        }
        return ((StringBuffer)charSequence).toString();
    }

    public void setPoaMode(boolean bl) {
        this.poaMode = bl;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void setWarnings(boolean bl) {
        this.warnings = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    public String getPackageName() {
        return this.packag;
    }

    public String getStubName() {
        return this.stubName;
    }

    public String convertStubName(String string) {
        if (string.endsWith("Impl")) {
            return string.substring(0, string.length() - "Impl".length());
        }
        return string;
    }

    public GiopRmicCompiler() {
        this.finit$();
    }
}

