/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Arcs_Curves;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java2d.AnimatingSurface;

public class Ellipses
extends AnimatingSurface {
    private static Color[] colors = new Color[]{Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE, Color.PINK, Color.RED, Color.YELLOW, Color.LIGHT_GRAY, Color.WHITE};
    private Ellipse2D.Float[] ellipses;
    private double[] esize;
    private float[] estroke;
    private double maxSize;

    public Ellipses() {
        this.setBackground(Color.BLACK);
        this.ellipses = new Ellipse2D.Float[25];
        this.esize = new double[this.ellipses.length];
        this.estroke = new float[this.ellipses.length];
        for (int i = 0; i < this.ellipses.length; ++i) {
            this.ellipses[i] = new Ellipse2D.Float();
            this.getRandomXY(i, 20.0 * Math.random(), 200, 200);
        }
    }

    public void getRandomXY(int n, double d, int n2, int n3) {
        this.esize[n] = d;
        this.estroke[n] = 1.0f;
        double d2 = Math.random() * ((double)n2 - this.maxSize / 2.0);
        double d3 = Math.random() * ((double)n3 - this.maxSize / 2.0);
        this.ellipses[n].setFrame(d2, d3, d, d);
    }

    public void reset(int n, int n2) {
        this.maxSize = n / 10;
        for (int i = 0; i < this.ellipses.length; ++i) {
            this.getRandomXY(i, this.maxSize * Math.random(), n, n2);
        }
    }

    public void step(int n, int n2) {
        for (int i = 0; i < this.ellipses.length; ++i) {
            int n3 = i;
            this.estroke[n3] = this.estroke[n3] + 0.025f;
            int n4 = i;
            this.esize[n4] = this.esize[n4] + 1.0;
            if (this.esize[i] > this.maxSize) {
                this.getRandomXY(i, 1.0, n, n2);
                continue;
            }
            this.ellipses[i].setFrame(this.ellipses[i].getX(), this.ellipses[i].getY(), this.esize[i], this.esize[i]);
        }
    }

    public void render(int n, int n2, Graphics2D graphics2D) {
        for (int i = 0; i < this.ellipses.length; ++i) {
            graphics2D.setColor(colors[i % colors.length]);
            graphics2D.setStroke(new BasicStroke(this.estroke[i]));
            graphics2D.draw(this.ellipses[i]);
        }
    }

    public static void main(String[] stringArray) {
        Ellipses.createDemoFrame(new Ellipses());
    }
}

