/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import gnu.xml.aelfred2.JAXPFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.validation.Schema;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public abstract class SAXParserFactory {
    private boolean validating;
    private boolean namespaceAware;
    private Schema schema;
    private boolean xIncludeAware;

    protected SAXParserFactory() {
    }

    public static SAXParserFactory newInstance() throws FactoryConfigurationError {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = SAXParserFactory.class$("javax.xml.parsers.SAXParserFactory").getClassLoader();
        }
        String string = null;
        int n = 0;
        do {
            if ((string = SAXParserFactory.getFactoryClassName(classLoader, n++)) == null) continue;
            try {
                Class clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                return (SAXParserFactory)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                string = null;
            }
            catch (Exception exception) {
                throw new FactoryConfigurationError(exception, "error instantiating class " + string);
            }
        } while (string == null && n < 3);
        return new JAXPFactory();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String getFactoryClassName(ClassLoader classLoader, int n) {
        String string = "javax.xml.parsers.SAXParserFactory";
        switch (n) {
            case 0: {
                return System.getProperty(string);
            }
            case 1: {
                try {
                    File file = new File(System.getProperty("java.home"));
                    file = new File(file, "lib");
                    file = new File(file, "jaxp.properties");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    ((InputStream)fileInputStream).close();
                    return properties.getProperty(string);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            case 2: {
                try {
                    InputStream inputStream;
                    String string2 = "/META-INF/services/" + string;
                    InputStream inputStream2 = inputStream = classLoader != null ? classLoader.getResourceAsStream(string2) : SAXParserFactory.class$("javax.xml.parsers.SAXParserFactory").getResourceAsStream(string2);
                    if (inputStream != null) {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                        String string3 = bufferedReader.readLine();
                        bufferedReader.close();
                        return string3;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
        }
        return null;
    }

    public abstract SAXParser newSAXParser() throws ParserConfigurationException, SAXException;

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public abstract void setFeature(String var1, boolean var2) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    public abstract boolean getFeature(String var1) throws ParserConfigurationException, SAXNotRecognizedException, SAXNotSupportedException;

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public boolean isXIncludeAware() {
        return this.xIncludeAware;
    }

    public void setXIncludeAware(boolean bl) {
        this.xIncludeAware = bl;
    }
}

