/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.RowMapper;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class DefaultTreeSelectionModel
implements Cloneable,
Serializable,
TreeSelectionModel {
    static final long serialVersionUID = 3288129636638950196L;
    public static final String SELECTION_MODE_PROPERTY = "selectionMode";
    protected SwingPropertyChangeSupport changeSupport;
    protected TreePath[] selection;
    protected EventListenerList listenerList;
    protected transient RowMapper rowMapper;
    protected DefaultListSelectionModel listSelectionModel;
    protected int selectionMode;
    protected TreePath leadPath;
    protected int leadIndex;
    protected int leadRow;

    public DefaultTreeSelectionModel() {
        this.setSelectionMode(1);
        this.listenerList = new EventListenerList();
    }

    public Object clone() throws CloneNotSupportedException {
        return null;
    }

    public String toString() {
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public void setRowMapper(RowMapper rowMapper) {
    }

    public RowMapper getRowMapper() {
        return this.rowMapper;
    }

    public void setSelectionMode(int n) {
        this.selectionMode = n;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionPath(TreePath treePath) {
        this.selection = new TreePath[]{treePath};
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
    }

    public void addSelectionPath(TreePath treePath) {
        if (!this.isPathSelected(treePath)) {
            if (this.isSelectionEmpty()) {
                this.setSelectionPath(treePath);
            } else {
                TreePath[] treePathArray = new TreePath[this.selection.length + 1];
                System.arraycopy(this.selection, 0, treePathArray, 0, this.selection.length);
                treePathArray[treePathArray.length - 1] = treePath;
                this.selection = new TreePath[treePathArray.length];
                System.arraycopy(treePathArray, 0, this.selection, 0, treePathArray.length);
            }
            this.leadPath = treePath;
            this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, true, this.leadPath, treePath));
        }
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            TreePath treePath = null;
            for (int i = 0; i < treePathArray.length; ++i) {
                treePath = treePathArray[i];
                if (this.isPathSelected(treePath)) continue;
                if (this.isSelectionEmpty()) {
                    this.setSelectionPath(treePath);
                } else {
                    TreePath[] treePathArray2 = new TreePath[this.selection.length + 1];
                    System.arraycopy(this.selection, 0, treePathArray2, 0, this.selection.length);
                    treePathArray2[treePathArray2.length - 1] = treePath;
                    this.selection = new TreePath[treePathArray2.length];
                    System.arraycopy(treePathArray2, 0, this.selection, 0, treePathArray2.length);
                }
                this.leadPath = treePathArray[treePathArray.length - 1];
                this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, true, this.leadPath, treePathArray[0]));
            }
        }
    }

    public void removeSelectionPath(TreePath treePath) {
        int n = -1;
        if (this.isPathSelected(treePath)) {
            for (int i = 0; i < this.selection.length; ++i) {
                if (!this.selection[i].equals(treePath)) continue;
                n = i;
                break;
            }
            TreePath[] treePathArray = new TreePath[this.selection.length - 1];
            System.arraycopy(this.selection, 0, treePathArray, 0, n);
            System.arraycopy(this.selection, n + 1, treePathArray, n, this.selection.length - n - 1);
            this.selection = new TreePath[treePathArray.length];
            System.arraycopy(treePathArray, 0, this.selection, 0, treePathArray.length);
            this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, false, this.leadPath, treePath));
        }
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            int n = -1;
            TreePath treePath = null;
            for (int i = 0; i < treePathArray.length; ++i) {
                treePath = treePathArray[i];
                if (!this.isPathSelected(treePath)) continue;
                for (int j = 0; j < this.selection.length; ++j) {
                    if (!this.selection[i].equals(treePath)) continue;
                    n = j;
                    break;
                }
                TreePath[] treePathArray2 = new TreePath[this.selection.length - 1];
                System.arraycopy(this.selection, 0, treePathArray2, 0, n);
                System.arraycopy(this.selection, n + 1, treePathArray2, n, this.selection.length - n - 1);
                this.selection = new TreePath[treePathArray2.length];
                System.arraycopy(treePathArray2, 0, this.selection, 0, treePathArray2.length);
                this.fireValueChanged(new TreeSelectionEvent((Object)this, treePath, false, this.leadPath, treePathArray[0]));
            }
        }
    }

    public TreePath getSelectionPath() {
        if (this.selection == null || this.selection.length == 0) {
            return null;
        }
        return this.selection[0];
    }

    public TreePath[] getSelectionPaths() {
        return this.selection;
    }

    public int getSelectionCount() {
        if (this.selection == null) {
            return 0;
        }
        return this.selection.length;
    }

    public boolean isPathSelected(TreePath treePath) {
        if (this.selection == null) {
            return false;
        }
        for (int i = 0; i < this.selection.length; ++i) {
            if (!this.selection[i].equals(treePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isSelectionEmpty() {
        return this.selection == null || this.selection.length == 0;
    }

    public void clearSelection() {
        this.leadPath = null;
        this.selection = null;
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener"), treeSelectionListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener"), treeSelectionListener);
    }

    public TreeSelectionListener[] getTreeSelectionListeners() {
        return (TreeSelectionListener[])this.getListeners(DefaultTreeSelectionModel.class$("javax.swing.event.TreeSelectionListener"));
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreeSelectionListener[] treeSelectionListenerArray = this.getTreeSelectionListeners();
        for (int i = 0; i < treeSelectionListenerArray.length; ++i) {
            treeSelectionListenerArray[i].valueChanged(treeSelectionEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public int[] getSelectionRows() {
        if (this.rowMapper == null) {
            return null;
        }
        return this.rowMapper.getRowsForPaths(this.selection);
    }

    public int getMinSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.min(n, nArray[i]);
        }
        return n;
    }

    public int getMaxSelectionRow() {
        if (this.rowMapper == null || this.selection == null || this.selection.length == 0) {
            return -1;
        }
        int[] nArray = this.rowMapper.getRowsForPaths(this.selection);
        int n = -1;
        for (int i = 0; i < nArray.length; ++i) {
            n = Math.max(n, nArray[i]);
        }
        return n;
    }

    public boolean isRowSelected(int n) {
        return false;
    }

    public void resetRowSelection() {
    }

    public int getLeadSelectionRow() {
        if (this.rowMapper == null || this.leadPath == null) {
            return -1;
        }
        return this.rowMapper.getRowsForPaths(new TreePath[]{this.leadPath})[0];
    }

    public TreePath getLeadSelectionPath() {
        return this.leadPath;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected void insureRowContinuity() {
    }

    protected boolean arePathsContiguous(TreePath[] treePathArray) {
        return false;
    }

    protected boolean canPathsBeAdded(TreePath[] treePathArray) {
        return false;
    }

    protected boolean canPathsBeRemoved(TreePath[] treePathArray) {
        return false;
    }

    protected void notifyPathChange(Vector vector, TreePath treePath) {
    }

    protected void updateLeadIndex() {
    }

    protected void insureUniqueness() {
    }
}

