/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DefaultTreeModel
implements Serializable,
TreeModel {
    static final long serialVersionUID = -2621068368932566998L;
    protected TreeNode root;
    protected EventListenerList listenerList;
    protected boolean asksAllowsChildren;

    private /* synthetic */ void finit$() {
        this.root = null;
        this.listenerList = new EventListenerList();
    }

    public DefaultTreeModel(TreeNode treeNode) {
        this.finit$();
        if (treeNode == null) {
            treeNode = new DefaultMutableTreeNode();
        }
        this.setRoot(treeNode);
    }

    public DefaultTreeModel(TreeNode treeNode, boolean bl) {
        this.finit$();
        this.setRoot(treeNode);
        this.asksAllowsChildren = bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }

    public boolean asksAllowsChildren() {
        return this.asksAllowsChildren;
    }

    public void setAsksAllowsChildren(boolean bl) {
        this.asksAllowsChildren = bl;
    }

    public void setRoot(TreeNode treeNode) {
        if (treeNode == null) {
            throw new IllegalArgumentException("null root");
        }
        this.root = treeNode;
    }

    public Object getRoot() {
        return this.root;
    }

    public int getIndexOfChild(Object object, Object object2) {
        for (int i = 0; i < this.getChildCount(object); ++i) {
            if (!this.getChild(object, i).equals(object2)) continue;
            return i;
        }
        return -1;
    }

    public Object getChild(Object object, int n) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildAt(n);
        }
        return null;
    }

    public int getChildCount(Object object) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).getChildCount();
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        if (object instanceof TreeNode) {
            return ((TreeNode)object).isLeaf();
        }
        return true;
    }

    public void reload() {
    }

    public void reload(TreeNode treeNode) {
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
        Object object2 = treePath.getLastPathComponent();
        if (object2 instanceof MutableTreeNode) {
            ((MutableTreeNode)object2).setUserObject(object);
            int[] nArray = null;
            Object[] objectArray = null;
            Object[] objectArray2 = treePath.getPath();
            if (treePath.getPathCount() > 1) {
                TreeNode treeNode = ((TreeNode)object2).getParent();
                nArray = new int[]{this.getIndexOfChild(treeNode, object2)};
                object2 = object;
                treePath = treePath.getParentPath().pathByAddingChild(object2);
                objectArray = new Object[]{object2};
                objectArray2 = treePath.getParentPath().getPath();
            }
            this.fireTreeNodesChanged(this, objectArray2, nArray, objectArray);
        }
    }

    public void insertNodeInto(MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2, int n) {
        mutableTreeNode.setParent(mutableTreeNode2);
        mutableTreeNode2.insert(mutableTreeNode, n);
        int[] nArray = new int[]{n};
        this.nodesWereInserted(mutableTreeNode2, nArray);
    }

    public void removeNodeFromParent(MutableTreeNode mutableTreeNode) {
        TreeNode treeNode = mutableTreeNode.getParent();
        Object[] objectArray = new Object[]{mutableTreeNode};
        int[] nArray = new int[]{this.getIndexOfChild(treeNode, mutableTreeNode)};
        mutableTreeNode.removeFromParent();
        this.nodesWereRemoved(treeNode, nArray, objectArray);
    }

    public void nodeChanged(TreeNode treeNode) {
        TreeNode treeNode2 = treeNode.getParent();
        int[] nArray = new int[]{this.getIndexOfChild(treeNode2, treeNode)};
        Object[] objectArray = new Object[]{treeNode};
        this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), nArray, objectArray);
    }

    public void nodesWereInserted(TreeNode treeNode, int[] nArray) {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getChild(treeNode, nArray[i]);
        }
        this.fireTreeNodesInserted(this, this.getPathToRoot(treeNode), nArray, objectArray);
    }

    public void nodesWereRemoved(TreeNode treeNode, int[] nArray, Object[] objectArray) {
        this.fireTreeNodesRemoved(this, this.getPathToRoot(treeNode), nArray, objectArray);
    }

    public void nodesChanged(TreeNode treeNode, int[] nArray) {
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getChild(treeNode, nArray[i]);
        }
        this.fireTreeNodesChanged(this, this.getPathToRoot(treeNode), nArray, objectArray);
    }

    public void nodeStructureChanged(TreeNode treeNode) {
    }

    public TreeNode[] getPathToRoot(TreeNode treeNode) {
        return this.getPathToRoot(treeNode, 0);
    }

    protected TreeNode[] getPathToRoot(TreeNode treeNode, int n) {
        if (treeNode == null) {
            if (n == 0) {
                return null;
            }
            return new TreeNode[n];
        }
        TreeNode[] treeNodeArray = this.getPathToRoot(treeNode.getParent(), n + 1);
        treeNodeArray[treeNodeArray.length - n - 1] = treeNode;
        return treeNodeArray;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.add(DefaultTreeModel.class$("javax.swing.event.TreeModelListener"), treeModelListener);
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.listenerList.remove(DefaultTreeModel.class$("javax.swing.event.TreeModelListener"), treeModelListener);
    }

    public TreeModelListener[] getTreeModelListeners() {
        return (TreeModelListener[])this.listenerList.getListeners(DefaultTreeModel.class$("javax.swing.event.TreeModelListener"));
    }

    protected void fireTreeNodesChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        TreeModelListener[] treeModelListenerArray = this.getTreeModelListeners();
        for (int i = treeModelListenerArray.length - 1; i >= 0; --i) {
            treeModelListenerArray[i].treeNodesChanged(treeModelEvent);
        }
    }

    protected void fireTreeNodesInserted(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        TreeModelListener[] treeModelListenerArray = this.getTreeModelListeners();
        for (int i = treeModelListenerArray.length - 1; i >= 0; --i) {
            treeModelListenerArray[i].treeNodesInserted(treeModelEvent);
        }
    }

    protected void fireTreeNodesRemoved(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        TreeModelListener[] treeModelListenerArray = this.getTreeModelListeners();
        for (int i = treeModelListenerArray.length - 1; i >= 0; --i) {
            treeModelListenerArray[i].treeNodesRemoved(treeModelEvent);
        }
    }

    protected void fireTreeStructureChanged(Object object, Object[] objectArray, int[] nArray, Object[] objectArray2) {
        TreeModelEvent treeModelEvent = new TreeModelEvent(object, objectArray, nArray, objectArray2);
        TreeModelListener[] treeModelListenerArray = this.getTreeModelListeners();
        for (int i = treeModelListenerArray.length - 1; i >= 0; --i) {
            treeModelListenerArray[i].treeStructureChanged(treeModelEvent);
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }
}

