/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.text.AttributeSet;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.TabSet;

public class StyleConstants {
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_CENTER = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_JUSTIFIED = 3;
    public static final Object Background = CharacterConstants.Background;
    public static final Object BidiLevel = CharacterConstants.BidiLevel;
    public static final Object Bold = CharacterConstants.Bold;
    public static final Object ComponentAttribute = CharacterConstants.ComponentAttribute;
    public static final Object Family = CharacterConstants.Family;
    public static final Object FontFamily = CharacterConstants.Family;
    public static final Object FontSize = CharacterConstants.Size;
    public static final Object Foreground = CharacterConstants.Foreground;
    public static final Object IconAttribute = CharacterConstants.IconAttribute;
    public static final Object Italic = CharacterConstants.Italic;
    public static final Object Size = CharacterConstants.Size;
    public static final Object StrikeThrough = CharacterConstants.StrikeThrough;
    public static final Object Subscript = CharacterConstants.Subscript;
    public static final Object Superscript = CharacterConstants.Superscript;
    public static final Object Underline = CharacterConstants.Underline;
    public static final Object Alignment = ParagraphConstants.Alignment;
    public static final Object FirstLineIndent = ParagraphConstants.FirstLineIndent;
    public static final Object LeftIndent = ParagraphConstants.LeftIndent;
    public static final Object LineSpacing = ParagraphConstants.LineSpacing;
    public static final Object Orientation = ParagraphConstants.Orientation;
    public static final Object RightIndent = ParagraphConstants.RightIndent;
    public static final Object SpaceAbove = ParagraphConstants.SpaceAbove;
    public static final Object SpaceBelow = ParagraphConstants.SpaceBelow;
    public static final Object TabSet = ParagraphConstants.TabSet;
    public static final String ComponentElementName = "component";
    public static final String IconElementName = "icon";
    public static final Object ComposedTextAttribute;
    public static final Object ModelAttribute;
    public static final Object NameAttribute;
    public static final Object ResolveAttribute;
    String keyname;

    StyleConstants(String string) {
        this.keyname = string;
    }

    public String toString() {
        return this.keyname;
    }

    public static int getAlignment(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Alignment)) {
            return (Integer)attributeSet.getAttribute(Alignment);
        }
        return 0;
    }

    public static Color getBackground(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Background)) {
            return (Color)attributeSet.getAttribute(Background);
        }
        return Color.WHITE;
    }

    public static int getBidiLevel(AttributeSet attributeSet) {
        if (attributeSet.isDefined(BidiLevel)) {
            return (Integer)attributeSet.getAttribute(BidiLevel);
        }
        return 0;
    }

    public static Component getComponent(AttributeSet attributeSet) {
        if (attributeSet.isDefined(ComponentAttribute)) {
            return (Component)attributeSet.getAttribute(ComponentAttribute);
        }
        return null;
    }

    public static float getFirstLineIndent(AttributeSet attributeSet) {
        if (attributeSet.isDefined(FirstLineIndent)) {
            return ((Float)attributeSet.getAttribute(FirstLineIndent)).floatValue();
        }
        return 0.0f;
    }

    public static String getFontFamily(AttributeSet attributeSet) {
        if (attributeSet.isDefined(FontFamily)) {
            return (String)attributeSet.getAttribute(FontFamily);
        }
        return "Monospaced";
    }

    public static int getFontSize(AttributeSet attributeSet) {
        if (attributeSet.isDefined(FontSize)) {
            return (Integer)attributeSet.getAttribute(FontSize);
        }
        return 12;
    }

    public static Color getForeground(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Foreground)) {
            return (Color)attributeSet.getAttribute(Foreground);
        }
        return Color.BLACK;
    }

    public static Icon getIcon(AttributeSet attributeSet) {
        if (attributeSet.isDefined(IconAttribute)) {
            return (Icon)attributeSet.getAttribute(IconAttribute);
        }
        return null;
    }

    public static float getLeftIndent(AttributeSet attributeSet) {
        if (attributeSet.isDefined(LeftIndent)) {
            return ((Float)attributeSet.getAttribute(LeftIndent)).floatValue();
        }
        return 0.0f;
    }

    public static float getLineSpacing(AttributeSet attributeSet) {
        if (attributeSet.isDefined(LineSpacing)) {
            return ((Float)attributeSet.getAttribute(LineSpacing)).floatValue();
        }
        return 0.0f;
    }

    public static float getRightIndent(AttributeSet attributeSet) {
        if (attributeSet.isDefined(RightIndent)) {
            return ((Float)attributeSet.getAttribute(RightIndent)).floatValue();
        }
        return 0.0f;
    }

    public static float getSpaceAbove(AttributeSet attributeSet) {
        if (attributeSet.isDefined(SpaceAbove)) {
            return ((Float)attributeSet.getAttribute(SpaceAbove)).floatValue();
        }
        return 0.0f;
    }

    public static float getSpaceBelow(AttributeSet attributeSet) {
        if (attributeSet.isDefined(SpaceBelow)) {
            return ((Float)attributeSet.getAttribute(SpaceBelow)).floatValue();
        }
        return 0.0f;
    }

    public static TabSet getTabSet(AttributeSet attributeSet) {
        if (attributeSet.isDefined(TabSet)) {
            return (TabSet)attributeSet.getAttribute(TabSet);
        }
        return null;
    }

    public static boolean isBold(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Bold)) {
            return (Boolean)attributeSet.getAttribute(Bold);
        }
        return false;
    }

    public static boolean isItalic(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Italic)) {
            return (Boolean)attributeSet.getAttribute(Italic);
        }
        return false;
    }

    public static boolean isStrikeThrough(AttributeSet attributeSet) {
        if (attributeSet.isDefined(StrikeThrough)) {
            return (Boolean)attributeSet.getAttribute(StrikeThrough);
        }
        return false;
    }

    public static boolean isSubscript(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Subscript)) {
            return (Boolean)attributeSet.getAttribute(Subscript);
        }
        return false;
    }

    public static boolean isSuperscript(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Superscript)) {
            return (Boolean)attributeSet.getAttribute(Superscript);
        }
        return false;
    }

    public static boolean isUnderline(AttributeSet attributeSet) {
        if (attributeSet.isDefined(Underline)) {
            return (Boolean)attributeSet.getAttribute(Underline);
        }
        return false;
    }

    public static void setAlignment(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(Alignment, new Integer(n));
    }

    public static void setBackground(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute(Background, color);
    }

    public static void setBidiLevel(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(BidiLevel, new Integer(n));
    }

    public static void setBold(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Bold, bl);
    }

    public static void setComponent(MutableAttributeSet mutableAttributeSet, Component component) {
        mutableAttributeSet.addAttribute(ComponentAttribute, component);
    }

    public static void setFirstLineIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(FirstLineIndent, new Float(f));
    }

    public static void setFontFamily(MutableAttributeSet mutableAttributeSet, String string) {
        mutableAttributeSet.addAttribute(FontFamily, string);
    }

    public static void setFontSize(MutableAttributeSet mutableAttributeSet, int n) {
        mutableAttributeSet.addAttribute(FontSize, new Integer(n));
    }

    public static void setForeground(MutableAttributeSet mutableAttributeSet, Color color) {
        mutableAttributeSet.addAttribute(Foreground, color);
    }

    public static void setIcon(MutableAttributeSet mutableAttributeSet, Icon icon) {
        mutableAttributeSet.addAttribute(IconAttribute, icon);
    }

    public static void setItalic(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Italic, bl);
    }

    public static void setLeftIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(LeftIndent, new Float(f));
    }

    public static void setLineSpacing(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(LineSpacing, new Float(f));
    }

    public static void setRightIndent(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(RightIndent, new Float(f));
    }

    public static void setSpaceAbove(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(SpaceAbove, new Float(f));
    }

    public static void setSpaceBelow(MutableAttributeSet mutableAttributeSet, float f) {
        mutableAttributeSet.addAttribute(SpaceBelow, new Float(f));
    }

    public static void setStrikeThrough(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(StrikeThrough, bl);
    }

    public static void setSubscript(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Subscript, bl);
    }

    public static void setSuperscript(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Superscript, bl);
    }

    public static void setTabSet(MutableAttributeSet mutableAttributeSet, TabSet tabSet) {
        mutableAttributeSet.addAttribute(TabSet, tabSet);
    }

    public static void setUnderline(MutableAttributeSet mutableAttributeSet, boolean bl) {
        mutableAttributeSet.addAttribute(Underline, bl);
    }

    static {
        ComponentElementName = ComponentElementName;
        IconElementName = IconElementName;
        ComposedTextAttribute = new StyleConstants("composed text");
        ModelAttribute = new StyleConstants("model");
        NameAttribute = new StyleConstants("name");
        ResolveAttribute = new StyleConstants("resolver");
    }

    public static class ParagraphConstants
    extends StyleConstants
    implements AttributeSet.ParagraphAttribute {
        public static Object Alignment = new ParagraphConstants("Alignment");
        public static Object FirstLineIndent = new ParagraphConstants("FirstLineIndent");
        public static Object LeftIndent = new ParagraphConstants("LeftIndent");
        public static Object LineSpacing = new ParagraphConstants("LineSpacing");
        public static Object Orientation = new ParagraphConstants("Orientation");
        public static Object RightIndent = new ParagraphConstants("RightIndent");
        public static Object SpaceAbove = new ParagraphConstants("SpaceAbove");
        public static Object SpaceBelow = new ParagraphConstants("SpaceBelow");
        public static Object TabSet = new ParagraphConstants("TabSet");

        ParagraphConstants(String string) {
            super(string);
        }
    }

    public static class FontConstants
    extends StyleConstants
    implements AttributeSet.FontAttribute,
    AttributeSet.CharacterAttribute {
        public static Object Bold = new FontConstants("bold");
        public static Object Family = new FontConstants("family");
        public static Object Italic = new FontConstants("italic");
        public static Object Size = new FontConstants("size");

        FontConstants(String string) {
            super(string);
        }
    }

    public static class ColorConstants
    extends StyleConstants
    implements AttributeSet.ColorAttribute,
    AttributeSet.CharacterAttribute {
        public static Object Foreground = new ColorConstants("foreground");
        public static Object Background = new ColorConstants("background");

        ColorConstants(String string) {
            super(string);
        }
    }

    public static class CharacterConstants
    extends StyleConstants
    implements AttributeSet.CharacterAttribute {
        public static Object Background = ColorConstants.Background;
        public static Object BidiLevel = new CharacterConstants("bidiLevel");
        public static Object Bold = FontConstants.Bold;
        public static Object ComponentAttribute = new CharacterConstants("component");
        public static Object Family = FontConstants.Family;
        public static Object Size = FontConstants.Size;
        public static Object Foreground = ColorConstants.Foreground;
        public static Object IconAttribute = new CharacterConstants("icon");
        public static Object Italic = FontConstants.Italic;
        public static Object StrikeThrough = new CharacterConstants("strikethrough");
        public static Object Subscript = new CharacterConstants("subscript");
        public static Object Superscript = new CharacterConstants("superscript");
        public static Object Underline = new CharacterConstants("underline");

        CharacterConstants(String string) {
            super(string);
        }
    }
}

