/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.ArrayList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.SimpleAttributeSet;

public class PlainDocument
extends AbstractDocument {
    private static final long serialVersionUID = 4758290289196893664L;
    public static final String lineLimitAttribute = "lineLimit";
    public static final String tabSizeAttribute = "tabSize";
    private AbstractDocument.BranchElement rootElement = (AbstractDocument.BranchElement)this.createDefaultRoot();
    private int tabSize = 8;

    public PlainDocument() {
        this(new GapContent());
    }

    public PlainDocument(AbstractDocument.Content content) {
        super(content);
    }

    private void reindex() {
        Element[] elementArray;
        try {
            String string = this.content.getString(0, this.content.length());
            ArrayList arrayList = new ArrayList();
            int n = 0;
            int n2 = string.indexOf(10, 0);
            while (n2 != -1) {
                arrayList.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, n, n2 + 1));
                n = n2 + 1;
                n2 = string.indexOf(10, n2 + 1);
            }
            if (n < this.content.length()) {
                arrayList.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, n, this.content.length()));
            }
            elementArray = new Element[arrayList.size()];
            for (n2 = 0; n2 < arrayList.size(); ++n2) {
                elementArray[n2] = (Element)arrayList.get(n2);
            }
        }
        catch (BadLocationException badLocationException) {
            elementArray = new Element[]{this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, 0, 1)};
        }
        this.rootElement.replace(0, this.rootElement.getElementCount(), elementArray);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(null, SimpleAttributeSet.EMPTY);
        Element[] elementArray = new Element[]{this.createLeafElement(branchElement, SimpleAttributeSet.EMPTY, 0, 1)};
        branchElement.replace(0, 0, elementArray);
        return branchElement;
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        int n = defaultDocumentEvent.getOffset();
        int n2 = n + defaultDocumentEvent.getLength();
        int n3 = this.rootElement.getElementIndex(n);
        Element element = this.rootElement.getElement(n3);
        Element[] elementArray = new Element[1];
        try {
            String string = this.content.getString(0, this.content.length());
            ArrayList arrayList = new ArrayList();
            int n4 = element.getStartOffset();
            int n5 = string.indexOf(10, n);
            while (n5 != -1 && n5 <= n2) {
                arrayList.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, n4, n5 + 1));
                n4 = n5 + 1;
                if (n4 >= string.length()) break;
                n5 = string.indexOf(10, n4);
            }
            if (arrayList.size() != 0) {
                Element[] elementArray2 = new Element[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    elementArray2[i] = (Element)arrayList.get(i);
                }
                elementArray[0] = element;
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(this.rootElement, n3, elementArray, elementArray2);
                defaultDocumentEvent.addEdit(elementEdit);
                this.rootElement.replace(n3, 1, elementArray2);
            }
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError();
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        super.insertUpdate(defaultDocumentEvent, attributeSet);
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
        super.removeUpdate(defaultDocumentEvent);
        Element[] elementArray = new Element[1];
        int n = defaultDocumentEvent.getOffset();
        int n2 = this.rootElement.getElementIndex(n);
        int n3 = this.rootElement.getElementIndex(n + defaultDocumentEvent.getLength());
        if (n2 != n3) {
            int n4;
            Element[] elementArray2 = new Element[n3 - n2 + 1];
            for (n4 = n2; n4 <= n3; ++n4) {
                elementArray2[n4 - n2] = this.rootElement.getElement(n4);
            }
            n4 = this.rootElement.getElement(n2).getStartOffset();
            int n5 = this.rootElement.getElement(n3).getEndOffset();
            elementArray[0] = this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, n4, n5);
            AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(this.rootElement, n2, elementArray2, elementArray);
            defaultDocumentEvent.addEdit(elementEdit);
            this.rootElement.replace(n2, n3 - n2 + 1, elementArray);
        }
    }

    public Element getDefaultRootElement() {
        return this.rootElement;
    }

    public Element getParagraphElement(int n) {
        Element element = this.getDefaultRootElement();
        return element.getElement(element.getElementIndex(n));
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        String string2 = string;
        if (string != null && Boolean.TRUE.equals(this.getProperty("filterNewlines"))) {
            string2 = string.replaceAll("\n", " ");
        }
        super.insertString(n, string2, attributeSet);
    }
}

