/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public abstract class FlowView
extends BoxView {
    static final FlowStrategy sharedStrategy = new FlowStrategy();
    protected int layoutSpan;
    protected View layoutPool;
    protected FlowStrategy strategy = sharedStrategy;

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public FlowView(Element element, int n) {
        super(element, n);
    }

    public int getFlowAxis() {
        int n = this.getAxis();
        int n2 = n == 0 ? 1 : 0;
        return n2;
    }

    public int getFlowSpan(int n) {
        return this.layoutSpan;
    }

    public int getFlowStart(int n) {
        return this.getLeftInset();
    }

    protected abstract View createRow();

    protected void loadChildren(ViewFactory viewFactory) {
        if (this.layoutPool == null) {
            this.layoutPool = new LogicalView(this, this.getElement());
            Element element = this.getElement();
            int n = element.getElementCount();
            for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                View view = viewFactory.create(element2);
                this.layoutPool.append(view);
            }
        }
    }

    protected void layout(int n, int n2) {
        boolean bl = false;
        int n3 = this.getFlowAxis();
        if (n3 == 0) {
            bl = this.layoutSpan != n;
            this.layoutSpan = n;
        } else {
            bl = this.layoutSpan != n2;
            this.layoutSpan = n2;
        }
        if (bl) {
            this.strategy.layout(this);
        }
        super.layout(n, n2);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.layoutPool.insertUpdate(documentEvent, shape, viewFactory);
        this.strategy.insertUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.strategy.removeUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.strategy.changedUpdate(this, documentEvent, this.getInsideAllocation(shape));
    }

    protected int getViewIndexAtPosition(int n) {
        if (!this.isAllocationValid()) {
            this.layout(this.getWidth(), this.getHeight());
        }
        int n2 = this.getViewCount();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            int n4 = view.getStartOffset();
            int n5 = view.getEndOffset();
            if (n4 > n || n5 <= n) continue;
            n3 = i;
            break;
        }
        return n3;
    }

    class LogicalView
    extends View {
        private /* synthetic */ FlowView this$0;
        Vector children;
        private static final /* synthetic */ boolean $assertionsDisabled;

        LogicalView(FlowView flowView, Element element) {
            this.this$0 = flowView;
            super(element);
            this.children = new Vector();
        }

        public Container getContainer() {
            return this.this$0.getContainer();
        }

        public int getViewCount() {
            return this.children.size();
        }

        public View getView(int n) {
            return (View)this.children.get(n);
        }

        public void replace(int n, int n2, View[] viewArray) {
            int n3;
            if (n2 > 0) {
                for (n3 = 0; n3 < n2; ++n3) {
                    this.children.remove(n);
                }
            }
            n3 = n + viewArray.length;
            for (int i = n; i < n3; ++i) {
                this.children.add(i, viewArray[i - n]);
                viewArray[i - n].setParent(this.this$0);
            }
        }

        public int getViewIndex(int n, Position.Bias bias) {
            int n2 = -1;
            int n3 = 0;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                View view = (View)iterator.next();
                if (view.getStartOffset() >= n && view.getEndOffset() < n) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            return n2;
        }

        public float getPreferredSpan(int n) {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        public void paint(Graphics graphics, Shape shape) {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            throw new AssertionError((Object)"This method must not be called in LogicalView.");
        }

        public int getNextVisualPositionFrom(JTextComponent jTextComponent, int n, Position.Bias bias, int n2, Position.Bias[] biasArray) throws BadLocationException {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)"getNextVisualPositionFrom() must not be called in LogicalView");
            }
            return 0;
        }

        static {
            $assertionsDisabled = FlowView.class$("javax.swing.text.FlowView$LogicalView").desiredAssertionStatus() ^ true;
        }
    }

    public static class FlowStrategy {
        public void insertUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            this.layout(flowView);
        }

        public void removeUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            this.layout(flowView);
        }

        public void changedUpdate(FlowView flowView, DocumentEvent documentEvent, Rectangle rectangle) {
            this.layout(flowView);
        }

        public View getLogicalView(FlowView flowView) {
            return flowView.layoutPool;
        }

        public void layout(FlowView flowView) {
            flowView.removeAll();
            Element element = flowView.getElement();
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            int n3 = 0;
            while (n >= 0 && n < n2) {
                View view = flowView.createRow();
                flowView.append(view);
                n = this.layoutRow(flowView, n3, n);
                ++n3;
            }
        }

        protected int layoutRow(FlowView flowView, int n, int n2) {
            int n3 = flowView.getFlowSpan(n);
            if (n3 <= 0) {
                return -1;
            }
            int n4 = n2;
            View view = flowView.getView(n);
            int n5 = flowView.getFlowAxis();
            while (n3 > 0) {
                View view2 = this.createView(flowView, n4, n3, n);
                if (view2 == null) {
                    n4 = -1;
                    break;
                }
                int n6 = (int)view2.getPreferredSpan(n5);
                if (n6 > n3) {
                    n4 = -1;
                    break;
                }
                view.append(view2);
                n3 -= n6;
                n4 = view2.getEndOffset();
            }
            return n4;
        }

        protected View createView(FlowView flowView, int n, int n2, int n3) {
            int n4;
            View view = this.getLogicalView(flowView);
            int n5 = view.getViewIndex(n, Position.Bias.Forward);
            if (n5 == -1) {
                return null;
            }
            View view2 = view.getView(n5);
            int n6 = (int)view2.getPreferredSpan(n4 = flowView.getFlowAxis());
            if (n6 <= n2) {
                return view2;
            }
            if (view2.getBreakWeight(n4, n, n2) > 0) {
                return view2.breakView(n4, n, 0.0f, n2);
            }
            return null;
        }
    }
}

