/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.PlainView;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;

public class FieldView
extends PlainView {
    public FieldView(Element element) {
        super(element);
    }

    protected FontMetrics getFontMetrics() {
        Container container = this.getContainer();
        return container.getFontMetrics(container.getFont());
    }

    protected Shape adjustAllocation(Shape shape) {
        int n;
        Rectangle rectangle = shape.getBounds();
        int n2 = (int)this.getPreferredSpan(1);
        int n3 = rectangle.y + (rectangle.height - n2) / 2;
        JTextField jTextField = (JTextField)this.getContainer();
        int n4 = jTextField.getHorizontalAlignment();
        int n5 = (int)this.getPreferredSpan(0);
        ComponentOrientation componentOrientation = jTextField.getComponentOrientation();
        switch (n4) {
            case 0: {
                n = rectangle.x + (rectangle.width - n5) / 2;
                break;
            }
            case 4: {
                n = rectangle.x + (rectangle.width - n5);
                break;
            }
            case 11: {
                if (componentOrientation.isLeftToRight()) {
                    n = rectangle.x + (rectangle.width - n5);
                    break;
                }
                n = rectangle.x;
                break;
            }
            case 10: {
                if (componentOrientation.isLeftToRight()) {
                    n = rectangle.x;
                    break;
                }
                n = rectangle.x + (rectangle.width - n5);
                break;
            }
            default: {
                n = rectangle.x;
            }
        }
        return new Rectangle(n, n3, n5, n2);
    }

    public float getPreferredSpan(int n) {
        String string;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        FontMetrics fontMetrics = this.getFontMetrics();
        if (n == 1) {
            return super.getPreferredSpan(n);
        }
        Element element = this.getElement();
        try {
            string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset());
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError();
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        return fontMetrics.stringWidth(string);
    }

    public int getResizeWeight(int n) {
        n = n == 0 ? 1 : 0;
        return n;
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        Shape shape2 = this.adjustAllocation(shape);
        return super.modelToView(n, shape2, bias);
    }

    public void paint(Graphics graphics, Shape shape) {
        Shape shape2 = this.adjustAllocation(shape);
        super.paint(graphics, shape2);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.insertUpdate(documentEvent, shape2, viewFactory);
        this.getContainer().repaint();
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.removeUpdate(documentEvent, shape2, viewFactory);
        this.getContainer().repaint();
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Shape shape2 = this.adjustAllocation(shape);
        super.removeUpdate(documentEvent, shape2, viewFactory);
        this.getContainer().repaint();
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return super.viewToModel(f, f2, shape, biasArray);
    }
}

