/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Font;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public class DefaultStyledDocument
extends AbstractDocument
implements StyledDocument {
    private static final long serialVersionUID = 940485415728614849L;
    public static final int BUFFER_SIZE_DEFAULT = 4096;
    protected ElementBuffer buffer = new ElementBuffer(this, this.createDefaultRoot());
    private StyleChangeListener styleChangeListener;
    private static final /* synthetic */ boolean $assertionsDisabled;

    public DefaultStyledDocument() {
        this((AbstractDocument.Content)new GapContent(4096), new StyleContext());
    }

    public DefaultStyledDocument(StyleContext styleContext) {
        this((AbstractDocument.Content)new GapContent(4096), styleContext);
    }

    public DefaultStyledDocument(AbstractDocument.Content content, StyleContext styleContext) {
        super(content, styleContext);
        this.setLogicalStyle(0, styleContext.getStyle("default"));
    }

    public Style addStyle(String string, Style style) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        Style style2 = styleContext.addStyle(string, style);
        if (this.styleChangeListener == null) {
            this.styleChangeListener = new StyleChangeListener(this);
        }
        style2.addChangeListener(this.styleChangeListener);
        return style2;
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        SectionElement sectionElement = new SectionElement(this);
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.createBranchElement(sectionElement, null);
        branchElement.setResolveParent(this.getStyle("default"));
        Element[] elementArray = new Element[]{branchElement};
        sectionElement.replace(0, 0, elementArray);
        AbstractDocument.LeafElement leafElement = new AbstractDocument.LeafElement(this, branchElement, null, 0, 1);
        elementArray = new Element[]{leafElement};
        branchElement.replace(0, 0, elementArray);
        return sectionElement;
    }

    public Element getCharacterElement(int n) {
        Element element = this.getDefaultRootElement();
        while (!element.isLeaf()) {
            int n2 = element.getElementIndex(n);
            element = element.getElement(n2);
        }
        return element;
    }

    public Color getBackground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getBackground(attributeSet);
    }

    public Element getDefaultRootElement() {
        return this.buffer.getRootElement();
    }

    public Font getFont(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getFont(attributeSet);
    }

    public Color getForeground(AttributeSet attributeSet) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getForeground(attributeSet);
    }

    public Style getLogicalStyle(int n) {
        Element element = this.getParagraphElement(n);
        AttributeSet attributeSet = element.getAttributes();
        return (Style)attributeSet.getResolveParent();
    }

    public Element getParagraphElement(int n) {
        AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.getDefaultRootElement();
        int n2 = branchElement.getStartOffset();
        int n3 = branchElement.getEndOffset();
        if (n >= n3) {
            n = n3 - 1;
        } else if (n < n2) {
            n = n2;
        }
        Element element = branchElement.positionToElement(n);
        if (!$assertionsDisabled && element == null) {
            throw new AssertionError((Object)"The paragraph element must not be null");
        }
        return element;
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Style getStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyle(string);
    }

    public void removeStyle(String string) {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        styleContext.removeStyle(string);
    }

    public void setCharacterAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2, DocumentEvent.EventType.CHANGE);
        this.buffer.change(n, n2, defaultDocumentEvent);
        Element element = this.getDefaultRootElement();
        int n3 = element.getElementCount();
        for (int i = 0; i < n3; ++i) {
            Element element2 = element.getElement(i);
            if (element2.getStartOffset() > n + n2 || element2.getEndOffset() < n) continue;
            int n4 = element2.getElementCount();
            for (int j = 0; j < n4; ++j) {
                Element element3 = element2.getElement(j);
                if (element3.getStartOffset() > n + n2 || element3.getEndOffset() < n) continue;
                if (element3 instanceof AbstractDocument.AbstractElement) {
                    AbstractDocument.AbstractElement abstractElement = (AbstractDocument.AbstractElement)element3;
                    if (bl) {
                        abstractElement.removeAttributes(abstractElement);
                    }
                    abstractElement.addAttributes(attributeSet);
                    continue;
                }
                throw new AssertionError((Object)"content elements are expected to beinstances of javax.swing.text.AbstractDocument.AbstractElement");
            }
        }
        this.fireChangedUpdate(defaultDocumentEvent);
    }

    public void setLogicalStyle(int n, Style style) {
        Element element = this.getParagraphElement(n);
        if (!(element instanceof AbstractDocument.AbstractElement)) {
            throw new AssertionError((Object)"paragraph elements are expected to beinstances of javax.swing.text.AbstractDocument.AbstractElement");
        }
        AbstractDocument.AbstractElement abstractElement = (AbstractDocument.AbstractElement)element;
        abstractElement.setResolveParent(style);
    }

    public void setParagraphAttributes(int n, int n2, AttributeSet attributeSet, boolean bl) {
        int n3 = n;
        while (n3 < n + n2) {
            AbstractDocument.AbstractElement abstractElement = (AbstractDocument.AbstractElement)this.getParagraphElement(n3);
            AbstractDocument.AttributeContext attributeContext = this.getAttributeContext();
            if (bl) {
                abstractElement.removeAttributes(abstractElement);
            }
            abstractElement.addAttributes(attributeSet);
            n3 = abstractElement.getElementCount();
        }
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
        super.insertUpdate(defaultDocumentEvent, attributeSet);
        int n = defaultDocumentEvent.getOffset();
        int n2 = defaultDocumentEvent.getLength();
        int n3 = n + n2;
        Segment segment = new Segment();
        try {
            this.getText(n, n2, segment);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
        int n4 = 0;
        Vector vector = new Vector();
        Element element = this.getCharacterElement(n);
        Element element2 = this.getCharacterElement(n3);
        for (int i = n; i < n3; ++i) {
            ++n4;
            if (segment.array[i] != '\n') continue;
            ElementSpec elementSpec = new ElementSpec(attributeSet, 3, n4);
            if (i == n3 - 1) {
                if (element2.getAttributes().isEqual(attributeSet)) {
                    elementSpec.setDirection((short)5);
                }
            } else if (vector.size() == 0 && element.getAttributes().isEqual(attributeSet)) {
                elementSpec.setDirection((short)4);
            }
            vector.add(elementSpec);
            ElementSpec elementSpec2 = new ElementSpec(null, 2);
            vector.add(elementSpec2);
            ElementSpec elementSpec3 = new ElementSpec(null, 1);
            elementSpec3.setDirection((short)7);
            vector.add(elementSpec3);
            n4 = 0;
            n += n4;
        }
        if (n4 > 0) {
            ElementSpec elementSpec = new ElementSpec(attributeSet, 3, n4);
            if (vector.size() == 0) {
                if (element.getAttributes().isEqual(attributeSet)) {
                    elementSpec.setDirection((short)4);
                }
            } else if (element2.getAttributes().isEqual(attributeSet)) {
                elementSpec.setDirection((short)5);
            }
            vector.add(elementSpec);
        }
        ElementSpec[] elementSpecArray = (ElementSpec[])vector.toArray(new ElementSpec[vector.size()]);
        this.buffer.insert(n, n2, elementSpecArray, defaultDocumentEvent);
    }

    public Enumeration getStyleNames() {
        StyleContext styleContext = (StyleContext)this.getAttributeContext();
        return styleContext.getStyleNames();
    }

    protected void styleChanged(Style style) {
    }

    protected void insert(int n, ElementSpec[] elementSpecArray) throws BadLocationException {
        Object object;
        this.writeLock();
        int n2 = n;
        for (int i = 0; i < elementSpecArray.length; ++i) {
            ElementSpec elementSpec = elementSpecArray[i];
            if (elementSpec.getArray() != null && elementSpec.getLength() > 0) {
                object = new String(elementSpec.getArray(), elementSpec.getOffset(), elementSpec.getLength());
                this.content.insertString(n2, (String)object);
            }
            n2 += elementSpec.getLength();
        }
        AbstractDocument.DefaultDocumentEvent defaultDocumentEvent = new AbstractDocument.DefaultDocumentEvent(this, n, n2 - n, DocumentEvent.EventType.INSERT);
        for (int i = 0; i < elementSpecArray.length; ++i) {
            object = elementSpecArray[i];
            AttributeSet attributeSet = ((ElementSpec)object).getAttributes();
            if (attributeSet == null) continue;
            this.insertUpdate(defaultDocumentEvent, attributeSet);
        }
        this.buffer.insert(n, n2 - n, elementSpecArray, defaultDocumentEvent);
        this.fireInsertUpdate(defaultDocumentEvent);
        this.writeUnlock();
    }

    protected void create(ElementSpec[] elementSpecArray) {
        try {
            this.content.remove(0, this.content.length());
            this.buffer = new ElementBuffer(this, this.createDefaultRoot());
            this.insert(0, elementSpecArray);
        }
        catch (BadLocationException badLocationException) {
            AssertionError assertionError = new AssertionError((Object)"Unexpected bad location");
            ((Throwable)((Object)assertionError)).initCause(badLocationException);
            throw assertionError;
        }
    }

    static {
        $assertionsDisabled = DefaultStyledDocument.class$("javax.swing.text.DefaultStyledDocument").desiredAssertionStatus() ^ true;
    }

    private class StyleChangeListener
    implements ChangeListener {
        private /* synthetic */ DefaultStyledDocument this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            Style style = (Style)changeEvent.getSource();
            this.this$0.styleChanged(style);
        }

        StyleChangeListener(DefaultStyledDocument defaultStyledDocument) {
            this.this$0 = defaultStyledDocument;
        }
    }

    protected class SectionElement
    extends AbstractDocument.BranchElement {
        private /* synthetic */ DefaultStyledDocument this$0;

        public SectionElement(DefaultStyledDocument defaultStyledDocument) {
            this.this$0 = defaultStyledDocument;
            super(defaultStyledDocument, null, null);
        }

        public String getName() {
            return "section";
        }
    }

    public class ElementBuffer
    implements Serializable {
        private /* synthetic */ DefaultStyledDocument this$0;
        private static final long serialVersionUID = 1688745877691146623L;
        private Element root;
        private int offset;
        private int length;
        Element[] fracture;
        AbstractDocument.DefaultDocumentEvent documentEvent;

        public ElementBuffer(DefaultStyledDocument defaultStyledDocument, Element element) {
            this.this$0 = defaultStyledDocument;
            this.root = element;
        }

        public Element getRootElement() {
            return this.root;
        }

        public void change(int n, int n2, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.offset = n;
            this.length = n2;
            this.documentEvent = defaultDocumentEvent;
            this.changeUpdate();
        }

        protected void changeUpdate() {
            Element element = this.this$0.getCharacterElement(this.offset);
            this.split(element, this.offset);
            int n = this.offset + this.length;
            element = this.this$0.getCharacterElement(n);
            this.split(element, n);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void split(Element element, int n) {
            if (!(element instanceof AbstractDocument.AbstractElement)) throw new AssertionError((Object)"content elements are expected to be instances of javax.swing.text.AbstractDocument.AbstractElement");
            AbstractDocument.AbstractElement abstractElement = (AbstractDocument.AbstractElement)element;
            int n2 = abstractElement.getStartOffset();
            int n3 = abstractElement.getEndOffset();
            int n4 = n3 - n2;
            if (n2 == n || n3 == n) return;
            Element element2 = abstractElement.getParentElement();
            if (!(element2 instanceof AbstractDocument.BranchElement)) throw new AssertionError((Object)"paragraph elements are expected to be instances of javax.swing.text.AbstractDocument.BranchElement");
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element2;
            Element element3 = this.this$0.createLeafElement(branchElement, abstractElement, n2, n);
            Element element4 = this.this$0.createLeafElement(branchElement, abstractElement, n, n3);
            int n5 = branchElement.getElementIndex(n2);
            Element[] elementArray = new Element[]{element3, element4};
            branchElement.replace(n5, 1, elementArray);
            this.documentEvent.addEdit(new AbstractDocument.ElementEdit(branchElement, n5, new Element[]{element}, elementArray));
        }

        public void insert(int n, int n2, ElementSpec[] elementSpecArray, AbstractDocument.DefaultDocumentEvent defaultDocumentEvent) {
            this.offset = n;
            this.length = n2;
            this.documentEvent = defaultDocumentEvent;
            this.insertUpdate(elementSpecArray);
        }

        protected void insertUpdate(ElementSpec[] elementSpecArray) {
            block4: for (int i = 0; i < elementSpecArray.length; ++i) {
                switch (elementSpecArray[i].getType()) {
                    case 1: {
                        this.insertStartTag(elementSpecArray[i]);
                        continue block4;
                    }
                    case 2: {
                        this.insertEndTag(elementSpecArray[i]);
                        continue block4;
                    }
                    default: {
                        this.insertContentTag(elementSpecArray[i]);
                    }
                }
            }
        }

        void insertStartTag(ElementSpec elementSpec) {
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.this$0.getDefaultRootElement();
            int n = branchElement.getElementIndex(this.offset);
            if (n == -1) {
                n = 0;
            }
            AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)this.this$0.createBranchElement(branchElement, elementSpec.getAttributes());
            branchElement2.setResolveParent(this.this$0.getStyle("default"));
            Element[] elementArray = new Element[]{branchElement2};
            branchElement.replace(n + 1, 0, elementArray);
            AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n + 1, new Element[0], elementArray);
            this.documentEvent.addEdit(elementEdit);
            if (elementSpec.getDirection() == 7) {
                Element[] elementArray2 = new Element[this.fracture.length];
                for (int i = 0; i < this.fracture.length; ++i) {
                    Element element;
                    Element element2 = this.fracture[i];
                    elementArray2[i] = element = this.this$0.createLeafElement(branchElement2, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
                }
                branchElement2.replace(0, 0, elementArray2);
                elementEdit = new AbstractDocument.ElementEdit(branchElement2, 0, new Element[0], this.fracture);
                this.documentEvent.addEdit(elementEdit);
                this.fracture = new Element[0];
            }
        }

        void insertEndTag(ElementSpec elementSpec) {
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.this$0.getDefaultRootElement();
            int n = branchElement.getElementIndex(this.offset);
            AbstractDocument.BranchElement branchElement2 = (AbstractDocument.BranchElement)branchElement.getElement(n);
            int n2 = branchElement2.getElementIndex(this.offset);
            AbstractDocument.LeafElement leafElement = (AbstractDocument.LeafElement)branchElement2.getElement(n2);
            this.split(leafElement, this.offset);
            n2 = branchElement2.getElementIndex(this.offset);
            int n3 = branchElement2.getElementCount();
            this.fracture = new Element[n3 - n2];
            for (int i = n2; i < n3; ++i) {
                this.fracture[i - n2] = branchElement2.getElement(i);
            }
            branchElement2.replace(n2, n3 - n2, new Element[0]);
            AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement2, n2, this.fracture, new Element[0]);
            this.documentEvent.addEdit(elementEdit);
        }

        void insertContentTag(ElementSpec elementSpec) {
            int n = elementSpec.getLength();
            short s = elementSpec.getDirection();
            if (s == 4) {
                Element element = this.this$0.getCharacterElement(this.offset);
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
                Element element2 = this.this$0.createLeafElement(branchElement, elementSpec.getAttributes(), element.getStartOffset(), Math.max(element.getEndOffset(), this.offset + n));
                int n2 = branchElement.getElementIndex(this.offset);
                if (n2 == -1) {
                    n2 = 0;
                }
                Element[] elementArray = new Element[]{element2};
                branchElement.replace(n2, 1, elementArray);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n2, new Element[]{element}, elementArray);
                this.documentEvent.addEdit(elementEdit);
            } else if (s == 5) {
                Element element = this.this$0.getCharacterElement(this.offset + n);
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)element.getParentElement();
                Element element3 = this.this$0.createLeafElement(branchElement, elementSpec.getAttributes(), this.offset, element.getEndOffset());
                int n3 = branchElement.getElementIndex(this.offset + n);
                if (n3 == -1) {
                    n3 = 0;
                }
                Element[] elementArray = new Element[]{element3};
                branchElement.replace(n3, 1, elementArray);
                AbstractDocument.ElementEdit elementEdit = new AbstractDocument.ElementEdit(branchElement, n3, new Element[]{element}, elementArray);
                this.documentEvent.addEdit(elementEdit);
            } else {
                Element[] elementArray;
                Element[] elementArray2;
                Element[] elementArray3;
                Element element;
                int n4;
                AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.this$0.getParagraphElement(this.offset);
                Element element4 = branchElement.getElement(n4 = branchElement.getElementIndex(this.offset));
                if (element4 != null && element4.getStartOffset() < this.offset) {
                    element = this.this$0.createLeafElement(branchElement, element4.getAttributes(), element4.getStartOffset(), this.offset);
                    elementArray3 = new Element[]{element4};
                    elementArray2 = new Element[]{element};
                    if (element4.getEndOffset() > this.offset + n) {
                        elementArray = this.this$0.createLeafElement(branchElement, element4.getAttributes(), this.offset + n, element4.getEndOffset());
                        elementArray2 = new Element[]{element, elementArray};
                    }
                    branchElement.replace(n4, 1, elementArray2);
                    this.documentEvent.addEdit(new AbstractDocument.ElementEdit(branchElement, n4, elementArray3, elementArray2));
                    ++n4;
                }
                if ((element = branchElement.getElement(n4)) != null && element.getStartOffset() < this.offset + n) {
                    elementArray3 = this.this$0.createLeafElement(branchElement, element.getAttributes(), this.offset + n, element.getEndOffset());
                    elementArray2 = new Element[]{element};
                    elementArray = new Element[]{elementArray3};
                    branchElement.replace(n4, 1, elementArray);
                    this.documentEvent.addEdit(new AbstractDocument.ElementEdit(branchElement, n4, elementArray2, elementArray));
                }
                elementArray3 = this.this$0.createLeafElement(branchElement, elementSpec.getAttributes(), this.offset, this.offset + n);
                elementArray2 = new Element[]{elementArray3};
                branchElement.replace(n4, 0, elementArray2);
                elementArray = new AbstractDocument.ElementEdit(branchElement, n4, new Element[0], elementArray2);
                this.documentEvent.addEdit((UndoableEdit)elementArray);
            }
            this.offset += n;
        }

        public Element clone(Element element, Element element2) {
            if (element2.isLeaf()) {
                return this.this$0.createLeafElement(element, element2.getAttributes(), element2.getStartOffset(), element2.getEndOffset());
            }
            AbstractDocument.BranchElement branchElement = (AbstractDocument.BranchElement)this.this$0.createBranchElement(element, element2.getAttributes());
            Element[] elementArray = new Element[element2.getElementCount()];
            for (int i = 0; i < elementArray.length; ++i) {
                elementArray[i] = this.clone(branchElement, element2.getElement(i));
            }
            branchElement.replace(0, 0, elementArray);
            return branchElement;
        }
    }

    public static class ElementSpec {
        public static final short StartTagType = 1;
        public static final short EndTagType = 2;
        public static final short ContentType = 3;
        public static final short JoinPreviousDirection = 4;
        public static final short JoinNextDirection = 5;
        public static final short OriginateDirection = 6;
        public static final short JoinFractureDirection = 7;
        short type;
        short direction;
        int offset;
        int length;
        char[] content;
        AttributeSet attributes;

        public ElementSpec(AttributeSet attributeSet, short s) {
            this(attributeSet, s, 0);
        }

        public ElementSpec(AttributeSet attributeSet, short s, int n) {
            this(attributeSet, s, null, 0, n);
        }

        public ElementSpec(AttributeSet attributeSet, short s, char[] cArray, int n, int n2) {
            this.attributes = attributeSet;
            this.type = s;
            this.offset = n;
            this.length = n2;
            this.content = cArray;
            this.direction = (short)6;
        }

        public void setType(short s) {
            this.type = s;
        }

        public short getType() {
            return this.type;
        }

        public void setDirection(short s) {
            this.direction = s;
        }

        public short getDirection() {
            return this.direction;
        }

        public AttributeSet getAttributes() {
            return this.attributes;
        }

        public char[] getArray() {
            return this.content;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('<');
            switch (this.type) {
                case 1: {
                    stringBuilder.append("StartTag");
                    break;
                }
                case 2: {
                    stringBuilder.append("EndTag");
                    break;
                }
                case 3: {
                    stringBuilder.append("Content");
                    break;
                }
                default: {
                    stringBuilder.append("??");
                }
            }
            stringBuilder.append(':');
            switch (this.direction) {
                case 4: {
                    stringBuilder.append("JoinPrevious");
                    break;
                }
                case 5: {
                    stringBuilder.append("JoinNext");
                    break;
                }
                case 6: {
                    stringBuilder.append("Originate");
                    break;
                }
                case 7: {
                    stringBuilder.append("Fracture");
                    break;
                }
                default: {
                    stringBuilder.append("??");
                }
            }
            stringBuilder.append(':');
            stringBuilder.append(this.length);
            return stringBuilder.toString();
        }
    }

    public static class AttributeUndoableEdit
    extends AbstractUndoableEdit {
        protected AttributeSet copy;
        protected AttributeSet newAttributes;
        protected boolean isReplacing;
        protected Element element;

        public AttributeUndoableEdit(Element element, AttributeSet attributeSet, boolean bl) {
            this.element = element;
            this.newAttributes = attributeSet;
            this.isReplacing = bl;
            this.copy = element.getAttributes().copyAttributes();
        }

        public void undo() {
            super.undo();
            AttributeSet attributeSet = this.element.getAttributes();
            if (attributeSet instanceof MutableAttributeSet) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
                mutableAttributeSet.removeAttributes(attributeSet);
                mutableAttributeSet.addAttributes(this.copy);
            }
        }

        public void redo() {
            super.undo();
            AttributeSet attributeSet = this.element.getAttributes();
            if (attributeSet instanceof MutableAttributeSet) {
                MutableAttributeSet mutableAttributeSet = (MutableAttributeSet)attributeSet;
                if (this.isReplacing) {
                    mutableAttributeSet.removeAttributes(attributeSet);
                }
                mutableAttributeSet.addAttributes(this.newAttributes);
            }
        }
    }
}

