/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);
    private JTextComponent textComponent;
    private Vector highlights;
    private boolean drawsLayeredHighlights;

    private /* synthetic */ void finit$() {
        this.highlights = new Vector();
        this.drawsLayeredHighlights = true;
    }

    public DefaultHighlighter() {
        this.finit$();
    }

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    public void setDrawsLayeredHighlights(boolean bl) {
        this.drawsLayeredHighlights = bl;
    }

    private void checkPositions(int n, int n2) throws BadLocationException {
        if (n < 0) {
            throw new BadLocationException("DefaultHighlighter", n);
        }
        if (n2 < n) {
            throw new BadLocationException("DefaultHighlighter", n2);
        }
    }

    public void install(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textComponent = null;
    }

    public Object addHighlight(int n, int n2, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
        this.checkPositions(n, n2);
        HighlightEntry highlightEntry = new HighlightEntry(this, n, n2, highlightPainter);
        this.highlights.add(highlightEntry);
        return highlightEntry;
    }

    public void removeHighlight(Object object) {
        this.highlights.remove(object);
    }

    public void removeAllHighlights() {
        this.highlights.clear();
    }

    public Highlighter.Highlight[] getHighlights() {
        return null;
    }

    public void changeHighlight(Object object, int n, int n2) throws BadLocationException {
        this.checkPositions(n, n2);
        HighlightEntry highlightEntry = (HighlightEntry)object;
        highlightEntry.p0 = n;
        highlightEntry.p1 = n2;
    }

    public void paintLayeredHighlights(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
    }

    public void paint(Graphics graphics) {
        if (this.highlights.size() == 0) {
            return;
        }
        Rectangle rectangle = this.textComponent.getBounds();
        for (int i = 0; i < this.highlights.size(); ++i) {
            HighlightEntry highlightEntry = (HighlightEntry)this.highlights.get(i);
            highlightEntry.painter.paint(graphics, highlightEntry.p0, highlightEntry.p1, rectangle, this.textComponent);
        }
    }

    private class HighlightEntry {
        private /* synthetic */ DefaultHighlighter this$0;
        int p0;
        int p1;
        Highlighter.HighlightPainter painter;

        public HighlightEntry(DefaultHighlighter defaultHighlighter, int n, int n2, Highlighter.HighlightPainter highlightPainter) {
            this.this$0 = defaultHighlighter;
            this.p0 = n;
            this.p1 = n2;
            this.painter = highlightPainter;
        }

        public int getStartPosition() {
            return this.p0;
        }

        public int getEndPosition() {
            return this.p1;
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }

        private void paintHighlight(Graphics graphics, Rectangle rectangle) {
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            Rectangle rectangle3 = shape.getBounds();
            try {
                rectangle = jTextComponent.modelToView(n);
                rectangle2 = jTextComponent.modelToView(n2);
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            if (rectangle == null || rectangle2 == null) {
                return;
            }
            if (this.color == null) {
                graphics.setColor(jTextComponent.getSelectionColor());
            } else {
                graphics.setColor(this.color);
            }
            if (rectangle.y == rectangle2.y) {
                rectangle.width = rectangle2.x - rectangle.x;
                this.paintHighlight(graphics, rectangle);
                return;
            }
            rectangle.width = rectangle3.x + rectangle3.width - rectangle.x;
            this.paintHighlight(graphics, rectangle);
            rectangle.y += rectangle.height;
            rectangle.x = rectangle3.x;
            while (rectangle.y < rectangle2.y) {
                this.paintHighlight(graphics, rectangle);
                rectangle.y += rectangle.height;
            }
            this.paintHighlight(graphics, rectangle2);
        }

        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            throw new InternalError();
        }
    }
}

