/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.TextAction;
import javax.swing.text.ViewFactory;

public class DefaultEditorKit
extends EditorKit {
    private static final long serialVersionUID = 9017245433028523428L;
    public static final String backwardAction = "caret-backward";
    public static final String beepAction = "beep";
    public static final String beginAction = "caret-begin";
    public static final String beginLineAction = "caret-begin-line";
    public static final String beginParagraphAction = "caret-begin-paragraph";
    public static final String beginWordAction = "caret-begin-word";
    public static final String copyAction = "copy-to-clipboard";
    public static final String cutAction = "cut-to-clipboard";
    public static final String defaultKeyTypedAction = "default-typed";
    public static final String deleteNextCharAction = "delete-next";
    public static final String deletePrevCharAction = "delete-previous";
    public static final String downAction = "caret-down";
    public static final String endAction = "caret-end";
    public static final String endLineAction = "caret-end-line";
    public static final String EndOfLineStringProperty = "__EndOfLine__";
    public static final String endParagraphAction = "caret-end-paragraph";
    public static final String endWordAction = "caret-end-word";
    public static final String forwardAction = "caret-forward";
    public static final String insertBreakAction = "insert-break";
    public static final String insertContentAction = "insert-content";
    public static final String insertTabAction = "insert-tab";
    public static final String nextWordAction = "caret-next-word";
    public static final String pageDownAction = "page-down";
    public static final String pageUpAction = "page-up";
    public static final String pasteAction = "paste-from-clipboard";
    public static final String previousWordAction = "caret-previous-word";
    public static final String readOnlyAction = "set-read-only";
    public static final String selectAllAction = "select-all";
    public static final String selectionBackwardAction = "selection-backward";
    public static final String selectionBeginAction = "selection-begin";
    public static final String selectionBeginLineAction = "selection-begin-line";
    public static final String selectionBeginParagraphAction = "selection-begin-paragraph";
    public static final String selectionBeginWordAction = "selection-begin-word";
    public static final String selectionDownAction = "selection-down";
    public static final String selectionEndAction = "selection-end";
    public static final String selectionEndLineAction = "selection-end-line";
    public static final String selectionEndParagraphAction = "selection-end-paragraph";
    public static final String selectionEndWordAction = "selection-end-word";
    public static final String selectionForwardAction = "selection-forward";
    public static final String selectionNextWordAction = "selection-next-word";
    public static final String selectionPreviousWordAction = "selection-previous-word";
    public static final String selectionUpAction = "selection-up";
    public static final String selectLineAction = "select-line";
    public static final String selectParagraphAction = "select-paragraph";
    public static final String selectWordAction = "select-word";
    public static final String upAction = "caret-up";
    public static final String writableAction = "set-writable";
    private static Action[] defaultActions;

    public Caret createCaret() {
        return new DefaultCaret();
    }

    public Document createDefaultDocument() {
        return new PlainDocument();
    }

    public Action[] getActions() {
        return defaultActions;
    }

    public String getContentType() {
        return "text/plain";
    }

    public ViewFactory getViewFactory() {
        return null;
    }

    public void read(InputStream inputStream, Document document, int n) throws BadLocationException, IOException {
        this.read(new InputStreamReader(inputStream), document, n);
    }

    public void read(Reader reader, Document document, int n) throws BadLocationException, IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        document.insertString(n, stringBuffer.toString(), SimpleAttributeSet.EMPTY);
    }

    public void write(OutputStream outputStream, Document document, int n, int n2) throws BadLocationException, IOException {
        this.write(new OutputStreamWriter(outputStream), document, n, n2);
    }

    public void write(Writer writer, Document document, int n, int n2) throws BadLocationException, IOException {
        if (n < 0 || n > document.getLength()) {
            throw new BadLocationException("Tried to write to invalid location", n);
        }
        if (n + n2 > document.getLength()) {
            n2 = document.getLength() - n;
        }
        writer.write(document.getText(n, n2));
    }

    static {
        backwardAction = backwardAction;
        beepAction = beepAction;
        beginAction = beginAction;
        beginLineAction = beginLineAction;
        beginParagraphAction = beginParagraphAction;
        beginWordAction = beginWordAction;
        copyAction = copyAction;
        cutAction = cutAction;
        defaultKeyTypedAction = defaultKeyTypedAction;
        deleteNextCharAction = deleteNextCharAction;
        deletePrevCharAction = deletePrevCharAction;
        downAction = downAction;
        endAction = endAction;
        endLineAction = endLineAction;
        EndOfLineStringProperty = EndOfLineStringProperty;
        endParagraphAction = endParagraphAction;
        endWordAction = endWordAction;
        forwardAction = forwardAction;
        insertBreakAction = insertBreakAction;
        insertContentAction = insertContentAction;
        insertTabAction = insertTabAction;
        nextWordAction = nextWordAction;
        pageDownAction = pageDownAction;
        pageUpAction = pageUpAction;
        pasteAction = pasteAction;
        previousWordAction = previousWordAction;
        readOnlyAction = readOnlyAction;
        selectAllAction = selectAllAction;
        selectionBackwardAction = selectionBackwardAction;
        selectionBeginAction = selectionBeginAction;
        selectionBeginLineAction = selectionBeginLineAction;
        selectionBeginParagraphAction = selectionBeginParagraphAction;
        selectionBeginWordAction = selectionBeginWordAction;
        selectionDownAction = selectionDownAction;
        selectionEndAction = selectionEndAction;
        selectionEndLineAction = selectionEndLineAction;
        selectionEndParagraphAction = selectionEndParagraphAction;
        selectionEndWordAction = selectionEndWordAction;
        selectionForwardAction = selectionForwardAction;
        selectionNextWordAction = selectionNextWordAction;
        selectionPreviousWordAction = selectionPreviousWordAction;
        selectionUpAction = selectionUpAction;
        selectLineAction = selectLineAction;
        selectParagraphAction = selectParagraphAction;
        selectWordAction = selectWordAction;
        upAction = upAction;
        writableAction = writableAction;
        defaultActions = new Action[]{new BeepAction(), new CopyAction(), new CutAction(), new DefaultKeyTypedAction(), new InsertBreakAction(), new InsertContentAction(), new InsertTabAction(), new PasteAction(), new TextAction(null, deleteNextCharAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = defaultEditorKit;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    try {
                        int n = jTextComponent.getCaret().getDot();
                        if (n < jTextComponent.getDocument().getEndPosition().getOffset()) {
                            jTextComponent.getDocument().remove(jTextComponent.getCaret().getDot(), 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }, new TextAction(null, deletePrevCharAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = defaultEditorKit;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    try {
                        int n = jTextComponent.getCaret().getDot();
                        if (n > jTextComponent.getDocument().getStartPosition().getOffset()) {
                            jTextComponent.getDocument().remove(n - 1, 1);
                            jTextComponent.getCaret().setDot(n - 1);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }, new TextAction(null, backwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = defaultEditorKit;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    jTextComponent.getCaret().setDot(Math.max(jTextComponent.getCaret().getDot() - 1, jTextComponent.getDocument().getStartPosition().getOffset()));
                }
            }
        }, new TextAction(null, forwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = defaultEditorKit;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    jTextComponent.getCaret().setDot(Math.min(jTextComponent.getCaret().getDot() + 1, jTextComponent.getDocument().getEndPosition().getOffset()));
                }
            }
        }, new TextAction(null, selectionBackwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = defaultEditorKit;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    jTextComponent.getCaret().moveDot(Math.max(jTextComponent.getCaret().getDot() - 1, jTextComponent.getDocument().getStartPosition().getOffset()));
                }
            }
        }, new TextAction(null, selectionForwardAction){
            private /* synthetic */ DefaultEditorKit this$0;
            {
                this.this$0 = defaultEditorKit;
                super(string);
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JTextComponent jTextComponent = this.getTextComponent(actionEvent);
                if (jTextComponent != null) {
                    jTextComponent.getCaret().moveDot(Math.min(jTextComponent.getCaret().getDot() + 1, jTextComponent.getDocument().getEndPosition().getOffset()));
                }
            }
        }};
    }

    public static class InsertTabAction
    extends TextAction {
        public InsertTabAction() {
            super(DefaultEditorKit.insertTabAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class InsertContentAction
    extends TextAction {
        public InsertContentAction() {
            super(DefaultEditorKit.insertContentAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class InsertBreakAction
    extends TextAction {
        public InsertBreakAction() {
            super(DefaultEditorKit.insertBreakAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            jTextComponent.replaceSelection("\n");
        }
    }

    public static class DefaultKeyTypedAction
    extends TextAction {
        public DefaultKeyTypedAction() {
            super(DefaultEditorKit.defaultKeyTypedAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            char c = actionEvent.getActionCommand().charAt(0);
            if (Character.isISOControl(c)) {
                return;
            }
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent != null) {
                try {
                    jTextComponent.getDocument().insertString(jTextComponent.getCaret().getDot(), actionEvent.getActionCommand(), null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }
    }

    public static class PasteAction
    extends TextAction {
        public PasteAction() {
            super(DefaultEditorKit.pasteAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class CutAction
    extends TextAction {
        public CutAction() {
            super(DefaultEditorKit.cutAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class CopyAction
    extends TextAction {
        public CopyAction() {
            super(DefaultEditorKit.copyAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public static class BeepAction
    extends TextAction {
        public BeepAction() {
            super(DefaultEditorKit.beepAction);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

