/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 4325555698756477346L;
    public static final int ALWAYS_UPDATE = 2;
    public static final int NEVER_UPDATE = 1;
    public static final int UPDATE_WHEN_ON_EDT = 0;
    int policy;
    protected ChangeEvent changeEvent;
    protected EventListenerList listenerList;
    DocumentListener documentListener;
    PropertyChangeListener propertyChangeListener;
    private JTextComponent textComponent;
    private boolean selectionVisible;
    private int blinkRate;
    private int dot;
    private int mark;
    private Point magicCaretPosition;
    boolean visible;
    private Object highlightEntry;
    private Timer blinkTimer;
    private BlinkTimerListener blinkListener;
    private static final /* synthetic */ boolean $assertionsDisabled;

    private /* synthetic */ void finit$() {
        this.policy = 0;
        this.changeEvent = new ChangeEvent(this);
        this.listenerList = new EventListenerList();
        this.selectionVisible = true;
        this.blinkRate = 500;
        this.dot = 0;
        this.mark = 0;
        this.magicCaretPosition = null;
        this.visible = false;
    }

    public DefaultCaret() {
        this.finit$();
    }

    public void setUpdatePolicy(int n) {
        if (n != 2 && n != 1 && n != 0) {
            throw new IllegalArgumentException("policy must be ALWAYS_UPDATE, NEVER__UPDATE, or UPDATE_WHEN_ON_EDT");
        }
        this.policy = n;
    }

    public int getUpdatePolicy() {
        return this.policy;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveCaret(mouseEvent);
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.positionCaret(mouseEvent);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setVisible(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!focusEvent.isTemporary()) {
            this.setVisible(false);
        }
    }

    protected void moveCaret(MouseEvent mouseEvent) {
        int n = this.getComponent().viewToModel(mouseEvent.getPoint());
        this.moveDot(n);
    }

    protected void positionCaret(MouseEvent mouseEvent) {
        int n = this.getComponent().viewToModel(mouseEvent.getPoint());
        this.setDot(n);
    }

    public void deinstall(JTextComponent jTextComponent) {
        this.textComponent.removeFocusListener(this);
        this.textComponent.removeMouseListener(this);
        this.textComponent.removeMouseMotionListener(this);
        this.textComponent.getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        this.textComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.textComponent = null;
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
        this.blinkTimer = null;
    }

    public void install(JTextComponent jTextComponent) {
        this.textComponent = jTextComponent;
        this.textComponent.addFocusListener(this);
        this.textComponent.addMouseListener(this);
        this.textComponent.addMouseMotionListener(this);
        this.propertyChangeListener = new PropertyChangeHandler(this);
        this.textComponent.addPropertyChangeListener(this.propertyChangeListener);
        this.documentListener = new DocumentHandler(this);
        this.textComponent.getDocument().addDocumentListener(this.documentListener);
        this.repaint();
    }

    public void setMagicCaretPosition(Point point) {
        this.magicCaretPosition = point;
    }

    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    public int getMark() {
        return this.mark;
    }

    private void handleHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        int n = Math.min(this.dot, this.mark);
        int n2 = Math.max(this.dot, this.mark);
        if (this.selectionVisible && n != n2) {
            try {
                if (this.highlightEntry == null) {
                    this.highlightEntry = highlighter.addHighlight(n, n2, this.getSelectionPainter());
                }
                highlighter.changeHighlight(this.highlightEntry, n, n2);
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError();
            }
        } else if (this.highlightEntry != null) {
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    public void setSelectionVisible(boolean bl) {
        if (this.selectionVisible == bl) {
            return;
        }
        this.selectionVisible = bl;
        this.handleHighlight();
        this.repaint();
    }

    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    protected final void repaint() {
        this.getComponent().repaint(this.x, this.y, this.width, this.height);
    }

    public void paint(Graphics graphics) {
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent == null) {
            return;
        }
        int n = this.getDot();
        Rectangle rectangle = null;
        try {
            rectangle = this.textComponent.modelToView(n);
        }
        catch (BadLocationException badLocationException) {
            if (!$assertionsDisabled) {
                throw new AssertionError((Object)("Unexpected bad caret location: " + n));
            }
            return;
        }
        if (rectangle == null) {
            return;
        }
        if (this.x != rectangle.x || this.y != rectangle.y) {
            this.repaint();
            this.x = rectangle.x;
            this.y = rectangle.y;
            this.width = 1;
            this.height = rectangle.height;
        }
        if (this.visible) {
            graphics.setColor(this.textComponent.getCaretColor());
            graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(DefaultCaret.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(DefaultCaret.class$("javax.swing.event.ChangeListener"), changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(DefaultCaret.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireStateChanged() {
        ChangeListener[] changeListenerArray = this.getChangeListeners();
        for (int i = 0; i < changeListenerArray.length; ++i) {
            changeListenerArray[i].stateChanged(this.changeEvent);
        }
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    public int getBlinkRate() {
        return this.blinkRate;
    }

    public void setBlinkRate(int n) {
        if (this.blinkTimer != null) {
            this.blinkTimer.setDelay(n);
        }
        this.blinkRate = n;
    }

    public int getDot() {
        return this.dot;
    }

    public void moveDot(int n) {
        if (n >= 0) {
            this.dot = n;
            this.handleHighlight();
            this.adjustVisibility(this);
            this.appear();
        }
    }

    public void setDot(int n) {
        if (n >= 0) {
            this.mark = n;
            this.dot = n;
            this.handleHighlight();
            this.adjustVisibility(this);
            this.appear();
        }
    }

    void appear() {
        if (this.blinkListener != null) {
            Rectangle rectangle;
            block5: {
                this.blinkListener.ignoreNextEvent = true;
                if (this.visible) {
                    this.repaint();
                }
                this.visible = true;
                rectangle = null;
                try {
                    rectangle = this.getComponent().modelToView(this.getDot());
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block5;
                    throw new AssertionError((Object)("Unexpected bad caret location: " + this.getDot()));
                }
            }
            if (rectangle != null) {
                this.damage(rectangle);
            }
        }
        this.repaint();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            Rectangle rectangle;
            block9: {
                this.visible = bl;
                if (this.visible) {
                    if (this.textComponent.isEnabled() && this.textComponent.isEditable()) {
                        if (this.blinkTimer == null) {
                            this.initBlinkTimer();
                        }
                        this.blinkTimer.start();
                    } else if (this.blinkTimer != null) {
                        this.blinkTimer.stop();
                    }
                }
                rectangle = null;
                try {
                    rectangle = this.getComponent().modelToView(this.getDot());
                }
                catch (BadLocationException badLocationException) {
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError((Object)("Unexpected bad caret location: " + this.getDot()));
                }
            }
            if (rectangle != null) {
                this.damage(rectangle);
            }
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void damage(Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        this.x = rectangle.x;
        this.y = rectangle.y;
        this.width = 1;
        if (this.height <= 0) {
            this.height = this.getComponent().getHeight();
        }
        this.repaint();
    }

    protected void adjustVisibility(Rectangle rectangle) {
        this.getComponent().scrollRectToVisible(rectangle);
    }

    private void initBlinkTimer() {
        this.blinkListener = new BlinkTimerListener(this);
        this.blinkTimer = new Timer(this.getBlinkRate(), this.blinkListener);
        this.blinkTimer.setRepeats(true);
    }

    static {
        $assertionsDisabled = DefaultCaret.class$("javax.swing.text.DefaultCaret").desiredAssertionStatus() ^ true;
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ DefaultCaret this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                Document document = (Document)propertyChangeEvent.getOldValue();
                document.removeDocumentListener(this.this$0.documentListener);
                Document document2 = (Document)propertyChangeEvent.getNewValue();
                document2.addDocumentListener(this.this$0.documentListener);
            }
        }

        PropertyChangeHandler(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private /* synthetic */ DefaultCaret this$0;

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.this$0.policy == 2 || SwingUtilities.isEventDispatchThread() && this.this$0.policy == 0) {
                int n = this.this$0.getDot();
                this.this$0.setDot(n + documentEvent.getLength());
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.this$0.policy == 2 || SwingUtilities.isEventDispatchThread() && this.this$0.policy == 0) {
                int n = this.this$0.getDot();
                this.this$0.setDot(n - documentEvent.getLength());
            } else if (this.this$0.policy == 1) {
                int n = documentEvent.getDocument().getLength();
                if (this.this$0.getDot() > n) {
                    this.this$0.setDot(n);
                }
            }
        }

        DocumentHandler(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }

    private class BlinkTimerListener
    implements ActionListener {
        private /* synthetic */ DefaultCaret this$0;
        boolean ignoreNextEvent;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.ignoreNextEvent) {
                this.ignoreNextEvent = false;
            } else {
                this.this$0.visible ^= true;
                this.this$0.repaint();
            }
        }

        BlinkTimerListener(DefaultCaret defaultCaret) {
            this.this$0 = defaultCaret;
        }
    }
}

