/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.BadLocationException;
import javax.swing.text.CompositeView;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;

public class BoxView
extends CompositeView {
    int myAxis;
    boolean xLayoutValid;
    boolean yLayoutValid;
    int[] spansX;
    int[] spansY;
    int[] offsetsX;
    int[] offsetsY;
    int width;
    int height;

    public BoxView(Element element, int n) {
        super(element);
        this.myAxis = n;
        this.xLayoutValid = false;
        this.yLayoutValid = false;
        this.spansX = new int[0];
        this.spansY = new int[0];
        this.offsetsX = new int[0];
        this.offsetsY = new int[0];
        this.width = 0;
        this.height = 0;
    }

    public int getAxis() {
        return this.myAxis;
    }

    public void setAxis(int n) {
        this.myAxis = n;
    }

    public void layoutChanged(int n) {
        switch (n) {
            case 0: {
                this.xLayoutValid = false;
                break;
            }
            case 1: {
                this.yLayoutValid = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid axis parameter.");
            }
        }
    }

    protected boolean isLayoutValid(int n) {
        boolean bl = false;
        switch (n) {
            case 0: {
                bl = this.xLayoutValid;
                break;
            }
            case 1: {
                bl = this.yLayoutValid;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid axis parameter.");
            }
        }
        return bl;
    }

    protected void paintChild(Graphics graphics, Rectangle rectangle, int n) {
        View view = this.getView(n);
        view.paint(graphics, rectangle);
    }

    public void replace(int n, int n2, View[] viewArray) {
        int n3 = this.getViewCount();
        int[] nArray = new int[n3 - n2 + viewArray.length];
        System.arraycopy(this.spansX, 0, nArray, 0, n);
        System.arraycopy(this.spansX, n + n2, nArray, n + viewArray.length, n3 - (n + n2));
        this.spansX = nArray;
        int[] nArray2 = new int[n3 - n2 + viewArray.length];
        System.arraycopy(this.spansY, 0, nArray2, 0, n);
        System.arraycopy(this.spansY, n + n2, nArray2, n + viewArray.length, n3 - (n + n2));
        this.spansY = nArray2;
        int[] nArray3 = new int[n3 - n2 + viewArray.length];
        System.arraycopy(this.offsetsX, 0, nArray3, 0, n);
        System.arraycopy(this.offsetsX, n + n2, nArray3, n + viewArray.length, n3 - (n + n2));
        this.offsetsX = nArray3;
        int[] nArray4 = new int[n3 - n2 + viewArray.length];
        System.arraycopy(this.offsetsY, 0, nArray4, 0, n);
        System.arraycopy(this.offsetsY, n + n2, nArray4, n + viewArray.length, n3 - (n + n2));
        this.offsetsY = nArray4;
        super.replace(n, n2, viewArray);
        this.layoutChanged(0);
        this.layoutChanged(1);
    }

    public void paint(Graphics graphics, Shape shape) {
        Rectangle rectangle = shape.getBounds();
        if (rectangle.width != this.getWidth() || rectangle.height != this.getHeight()) {
            this.setSize(rectangle.width, rectangle.height);
        }
        Rectangle rectangle2 = this.getInsideAllocation(shape);
        Rectangle rectangle3 = new Rectangle(rectangle2);
        int n = this.getViewCount();
        for (int i = 0; i < n; ++i) {
            rectangle3.setBounds(rectangle2);
            this.childAllocation(i, rectangle3);
            if (rectangle3.isEmpty() || !graphics.hitClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height)) continue;
            this.paintChild(graphics, rectangle3, i);
        }
    }

    public float getPreferredSpan(int n) {
        SizeRequirements sizeRequirements = new SizeRequirements();
        int n2 = this.baselineRequirements((int)n, (SizeRequirements)sizeRequirements).preferred;
        return n2;
    }

    public float getMaximumSpan(int n) {
        if (n == this.getAxis()) {
            return this.getPreferredSpan(n);
        }
        return 2.1474836E9f;
    }

    protected SizeRequirements baselineRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements sizeRequirements2 = n == this.myAxis ? this.calculateMajorAxisRequirements(n, sizeRequirements) : this.calculateMinorAxisRequirements(n, sizeRequirements);
        return sizeRequirements2;
    }

    protected void baselineLayout(int n, int n2, int[] nArray, int[] nArray2) {
        if (n2 == this.myAxis) {
            this.layoutMajorAxis(n, n2, nArray, nArray2);
        } else {
            this.layoutMinorAxis(n, n2, nArray, nArray2);
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements[] sizeRequirementsArray = this.getChildRequirements(n);
        return SizeRequirements.getTiledSizeRequirements(sizeRequirementsArray);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
        SizeRequirements[] sizeRequirementsArray = this.getChildRequirements(n);
        return SizeRequirements.getAlignedSizeRequirements(sizeRequirementsArray);
    }

    protected boolean isBefore(int n, int n2, Rectangle rectangle) {
        boolean bl = false;
        bl = this.myAxis == 0 ? n < rectangle.x : n2 < rectangle.y;
        return bl;
    }

    protected boolean isAfter(int n, int n2, Rectangle rectangle) {
        boolean bl = false;
        bl = this.myAxis == 0 ? n > rectangle.x : n2 > rectangle.y;
        return bl;
    }

    protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
        View view = null;
        int n3 = this.getViewCount();
        Rectangle rectangle2 = new Rectangle(rectangle);
        for (int i = 0; i < n3; ++i) {
            rectangle2.setBounds(rectangle);
            this.childAllocation(i, rectangle);
            if (!rectangle2.contains(n, n2)) continue;
            view = this.getView(i);
            break;
        }
        if (view == null && n3 > 0) {
            return this.getView(n3 - 1);
        }
        return view;
    }

    protected void childAllocation(int n, Rectangle rectangle) {
        if (!this.isAllocationValid()) {
            this.layout(rectangle.width, rectangle.height);
        }
        rectangle.x += this.offsetsX[n];
        rectangle.y += this.offsetsY[n];
        rectangle.width = this.spansX[n];
        rectangle.height = this.spansY[n];
    }

    protected void layout(int n, int n2) {
        this.baselineLayout(n, 0, this.offsetsX, this.spansX);
        this.baselineLayout(n2, 1, this.offsetsY, this.spansY);
    }

    protected void layoutMajorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        SizeRequirements[] sizeRequirementsArray = this.getChildRequirements(n2);
        SizeRequirements.calculateTiledPositions(n, null, sizeRequirementsArray, nArray, nArray2);
        this.validateLayout(n2);
    }

    protected void layoutMinorAxis(int n, int n2, int[] nArray, int[] nArray2) {
        SizeRequirements[] sizeRequirementsArray = this.getChildRequirements(n2);
        SizeRequirements sizeRequirements = this.baselineRequirements(n2, null);
        SizeRequirements.calculateAlignedPositions(n, sizeRequirements, sizeRequirementsArray, nArray, nArray2);
        this.validateLayout(n2);
    }

    protected boolean isAllocationValid() {
        return this.isLayoutValid(0) && this.isLayoutValid(1);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setSize(float f, float f2) {
        if (this.width != (int)f) {
            this.layoutChanged(0);
        }
        if (this.height != (int)f2) {
            this.layoutChanged(1);
        }
        this.width = (int)f;
        this.height = (int)f2;
        Rectangle rectangle = new Rectangle(0, 0, this.width, this.height);
        Rectangle rectangle2 = this.getInsideAllocation(rectangle);
        if (!this.isAllocationValid()) {
            this.layout(rectangle2.width, rectangle2.height);
        }
    }

    void validateLayout(int n) {
        if (n == 0) {
            this.xLayoutValid = true;
        }
        if (n == 1) {
            this.yLayoutValid = true;
        }
    }

    SizeRequirements[] getChildRequirements(int n) {
        int n2 = this.getViewCount();
        SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n2];
        for (int i = 0; i < n2; ++i) {
            View view = this.getView(i);
            sizeRequirementsArray[i] = new SizeRequirements((int)view.getMinimumSpan(n), (int)view.getPreferredSpan(n), (int)view.getMaximumSpan(n), view.getAlignment(n));
        }
        return sizeRequirementsArray;
    }

    protected int getSpan(int n, int n2) {
        if (n == 0) {
            return this.spansX[n2];
        }
        return this.spansY[n2];
    }

    protected int getOffset(int n, int n2) {
        if (n == 0) {
            return this.offsetsX[n2];
        }
        return this.offsetsY[n2];
    }

    public float getAlignment(int n) {
        if (n == this.myAxis) {
            return 0.5f;
        }
        return this.baselineRequirements((int)n, null).alignment;
    }

    public void preferenceChanged(View view, boolean bl, boolean bl2) {
        if (bl) {
            this.xLayoutValid = false;
        }
        if (bl2) {
            this.yLayoutValid = false;
        }
        super.preferenceChanged(view, bl, bl2);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle rectangle = shape.getBounds();
            this.setSize(rectangle.width, rectangle.height);
        }
        return super.modelToView(n, shape, bias);
    }
}

