/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.UIManager;

class MetalUtils {
    static BufferedImage pattern2D;
    static Color lightColor;
    static Color darkColor;

    static void fillMetalPattern(Component component, Graphics graphics, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (graphics instanceof Graphics2D) {
            MetalUtils.fillMetalPattern2D((Graphics2D)graphics, n, n2, n3, n4, color, color2);
        } else {
            int n5 = 0;
            for (int i = n2; i < n2 + n4; ++i) {
                if ((i - n2) % 2 == 0) {
                    graphics.setColor(color);
                } else {
                    graphics.setColor(color2);
                }
                for (int j = n + n5; j < n + n3; j += 4) {
                    graphics.drawLine(j, i, j, i);
                }
                if (++n5 <= 3) continue;
                n5 = 0;
            }
        }
    }

    static void fillMetalPattern2D(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2) {
        if (pattern2D == null || !darkColor.equals(color2) || !lightColor.equals(color)) {
            MetalUtils.initializePattern(color, color2);
        }
        TexturePaint texturePaint = new TexturePaint(pattern2D, new Rectangle2D.Double(0.0, 0.0, 4.0, 4.0));
        graphics2D.setPaint(texturePaint);
        graphics2D.fillRect(n, n2, n3, n4);
    }

    static void initializePattern(Color color, Color color2) {
        pattern2D = new BufferedImage(4, 4, 2);
        lightColor = color;
        darkColor = color2;
        Graphics graphics = pattern2D.getGraphics();
        graphics.setColor(color);
        graphics.fillRect(0, 0, 1, 1);
        graphics.fillRect(2, 2, 1, 1);
        graphics.setColor(color2);
        graphics.fillRect(1, 1, 1, 1);
        graphics.fillRect(3, 3, 1, 1);
        graphics.dispose();
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, int n5, String string) {
        List list2 = (List)UIManager.get(string);
        double d = (Double)list2.get(0);
        double d2 = (Double)list2.get(1);
        Color color = (Color)list2.get(2);
        Color color2 = (Color)list2.get(3);
        Color color3 = (Color)list2.get(4);
        MetalUtils.paintGradient(graphics, n, n2, n3, n4, d, d2, color, color2, color3, n5);
    }

    static void paintGradient(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2, Color color, Color color2, Color color3, int n5) {
        if (n5 == 0) {
            MetalUtils.paintHorizontalGradient(graphics, n, n2, n3, n4, d, d2, color, color2, color3);
        } else {
            MetalUtils.paintVerticalGradient(graphics, n, n2, n3, n4, d, d2, color, color2, color3);
        }
    }

    static void paintHorizontalGradient(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2, Color color, Color color2, Color color3) {
        Color color4;
        int n5;
        int n6;
        int n7;
        double d3;
        int n8;
        int n9 = (int)((double)n3 * d);
        int n10 = (int)((double)n3 * d2);
        int n11 = n;
        int n12 = n11 + n9;
        int n13 = n12 + n10;
        int n14 = n13 + n9;
        int n15 = n + n3;
        for (n8 = n11; n8 < n12 && n8 <= n + n3; ++n8) {
            d3 = (double)(n8 - n11) / (double)n9;
            n7 = (int)((double)(color2.getRed() - color.getRed()) * d3 + (double)color.getRed());
            n6 = (int)((double)(color2.getGreen() - color.getGreen()) * d3 + (double)color.getGreen());
            n5 = (int)((double)(color2.getBlue() - color.getBlue()) * d3 + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            graphics.drawLine(n8, n2, n8, n2 + n4);
        }
        graphics.setColor(color2);
        graphics.fillRect(n12, n2, n13 - n12, n4);
        for (n8 = n13; n8 < n14 && n8 <= n + n3; ++n8) {
            d3 = (double)(n8 - n13) / (double)n9;
            n7 = (int)((double)(color.getRed() - color2.getRed()) * d3 + (double)color2.getRed());
            n6 = (int)((double)(color.getGreen() - color2.getGreen()) * d3 + (double)color2.getGreen());
            n5 = (int)((double)(color.getBlue() - color2.getBlue()) * d3 + (double)color2.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            graphics.drawLine(n8, n2, n8, n2 + n4);
        }
        for (n8 = n14; n8 < n15 && n8 <= n + n3; ++n8) {
            d3 = (double)(n8 - n14) / (double)(n15 - n14);
            n7 = (int)((double)(color3.getRed() - color.getRed()) * d3 + (double)color.getRed());
            n6 = (int)((double)(color3.getGreen() - color.getGreen()) * d3 + (double)color.getGreen());
            n5 = (int)((double)(color3.getBlue() - color.getBlue()) * d3 + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            graphics.drawLine(n8, n2, n8, n2 + n4);
        }
    }

    static void paintVerticalGradient(Graphics graphics, int n, int n2, int n3, int n4, double d, double d2, Color color, Color color2, Color color3) {
        Color color4;
        int n5;
        int n6;
        int n7;
        double d3;
        int n8;
        int n9 = (int)((double)n4 * d);
        int n10 = (int)((double)n4 * d2);
        int n11 = n2;
        int n12 = n11 + n9;
        int n13 = n12 + n10;
        int n14 = n13 + n9;
        int n15 = n2 + n4;
        for (n8 = n11; n8 < n12 && n8 <= n2 + n4; ++n8) {
            d3 = (double)(n8 - n11) / (double)n9;
            n7 = (int)((double)(color2.getRed() - color.getRed()) * d3 + (double)color.getRed());
            n6 = (int)((double)(color2.getGreen() - color.getGreen()) * d3 + (double)color.getGreen());
            n5 = (int)((double)(color2.getBlue() - color.getBlue()) * d3 + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            graphics.drawLine(n, n8, n + n3, n8);
        }
        graphics.setColor(color2);
        graphics.fillRect(n, n12, n3, n13 - n12);
        for (n8 = n13; n8 < n14 && n8 <= n2 + n4; ++n8) {
            d3 = (double)(n8 - n13) / (double)n9;
            n7 = (int)((double)(color.getRed() - color2.getRed()) * d3 + (double)color2.getRed());
            n6 = (int)((double)(color.getGreen() - color2.getGreen()) * d3 + (double)color2.getGreen());
            n5 = (int)((double)(color.getBlue() - color2.getBlue()) * d3 + (double)color2.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            graphics.drawLine(n, n8, n + n3, n8);
        }
        for (n8 = n14; n8 < n15 && n8 <= n2 + n4; ++n8) {
            d3 = (double)(n8 - n14) / (double)(n15 - n14);
            n7 = (int)((double)(color3.getRed() - color.getRed()) * d3 + (double)color.getRed());
            n6 = (int)((double)(color3.getGreen() - color.getGreen()) * d3 + (double)color.getGreen());
            n5 = (int)((double)(color3.getBlue() - color.getBlue()) * d3 + (double)color.getBlue());
            color4 = new Color(n7, n6, n5);
            graphics.setColor(color4);
            graphics.drawLine(n, n8, n + n3, n8);
        }
    }

    MetalUtils() {
    }
}

