/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;
import javax.swing.plaf.metal.MetalUtils;

public class MetalScrollBarUI
extends BasicScrollBarUI {
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    private static final Dimension MIN_THUMB_SIZE;
    private static final Dimension MIN_THUMB_SIZE_FREE_STANDING;
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected int scrollBarWidth;
    protected boolean isFreeStanding;
    Color scrollBarShadowColor;

    private /* synthetic */ void finit$() {
        this.isFreeStanding = true;
    }

    public MetalScrollBarUI() {
        this.finit$();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalScrollBarUI();
    }

    protected void installDefaults() {
        Boolean bl = (Boolean)this.scrollbar.getClientProperty(FREE_STANDING_PROP);
        this.isFreeStanding = bl == null ? true : bl;
        this.scrollBarShadowColor = UIManager.getColor("ScrollBar.shadow");
        super.installDefaults();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new MetalScrollBarPropertyChangeHandler(this);
    }

    protected JButton createDecreaseButton(int n) {
        this.scrollBarWidth = UIManager.getInt("ScrollBar.width");
        this.decreaseButton = new MetalScrollButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    protected JButton createIncreaseButton(int n) {
        this.scrollBarWidth = UIManager.getInt("ScrollBar.width");
        this.increaseButton = new MetalScrollButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.setColor(MetalLookAndFeel.getControl());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this.scrollbar.getOrientation() == 0) {
            this.paintTrackHorizontal(graphics, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.paintTrackVertical(graphics, jComponent, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private void paintTrackHorizontal(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4) {
        if (jComponent.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(this.scrollBarShadowColor);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 2, n2 + 1);
            if (this.isFreeStanding) {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawLine(n, n2 + n4 - 2, n + n3 - 1, n2 + n4 - 2);
                graphics.setColor(this.scrollBarShadowColor);
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            if (this.isFreeStanding) {
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            } else {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
        }
    }

    private void paintTrackVertical(Graphics graphics, JComponent jComponent, int n, int n2, int n3, int n4) {
        if (jComponent.isEnabled()) {
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            graphics.setColor(this.scrollBarShadowColor);
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 1, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 2);
            if (this.isFreeStanding) {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                graphics.drawLine(n + n3 - 2, n2, n + n3 - 2, n2 + n4 - 1);
                graphics.setColor(MetalLookAndFeel.getControlHighlight());
                graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
            }
        } else {
            graphics.setColor(MetalLookAndFeel.getControlDisabled());
            if (this.isFreeStanding) {
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            } else {
                graphics.drawLine(n, n2, n + n3 - 1, n2);
                graphics.drawLine(n, n2, n, n2 + n4 - 1);
                graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            }
        }
    }

    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        if (this.scrollbar.getOrientation() == 0) {
            this.paintThumbHorizontal(graphics, jComponent, rectangle);
        } else {
            this.paintThumbVertical(graphics, jComponent, rectangle);
        }
        MetalUtils.fillMetalPattern(jComponent, graphics, rectangle.x + 3, rectangle.y + 3, rectangle.width - 6, rectangle.height - 6, this.thumbHighlightColor, this.thumbLightShadowColor);
    }

    private void paintThumbHorizontal(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        graphics.setColor(this.thumbColor);
        if (this.isFreeStanding) {
            graphics.fillRect(n, n2, n3, n4 - 1);
        } else {
            graphics.fillRect(n, n2, n3, n4);
        }
        graphics.setColor(this.thumbLightShadowColor);
        if (this.isFreeStanding) {
            graphics.drawRect(n, n2, n3 - 1, n4 - 2);
        } else {
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - 1);
        }
        graphics.setColor(this.thumbHighlightColor);
        if (this.isFreeStanding) {
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
        } else {
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 1);
        }
        graphics.setColor(UIManager.getColor("ScrollBar.shadow"));
        graphics.drawLine(n + n3, n2 + 1, n + n3, n2 + n4 - 1);
    }

    private void paintThumbVertical(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        graphics.setColor(this.thumbColor);
        if (this.isFreeStanding) {
            graphics.fillRect(n, n2, n3 - 1, n4);
        } else {
            graphics.fillRect(n, n2, n3, n4);
        }
        graphics.setColor(this.thumbLightShadowColor);
        if (this.isFreeStanding) {
            graphics.drawRect(n, n2, n3 - 2, n4 - 1);
        } else {
            graphics.drawLine(n, n2, n + n3 - 1, n2);
            graphics.drawLine(n, n2, n, n2 + n4 - 1);
            graphics.drawLine(n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
        }
        graphics.setColor(this.thumbHighlightColor);
        if (this.isFreeStanding) {
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 3, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
        } else {
            graphics.drawLine(n + 1, n2 + 1, n + n3 - 1, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + n4 - 3);
        }
        graphics.setColor(UIManager.getColor("ScrollBar.shadow"));
        graphics.drawLine(n + 1, n2 + n4, n + n3 - 2, n2 + n4);
    }

    protected Dimension getMinimumThumbSize() {
        if (this.isFreeStanding) {
            return MIN_THUMB_SIZE_FREE_STANDING;
        }
        return MIN_THUMB_SIZE;
    }

    static {
        FREE_STANDING_PROP = FREE_STANDING_PROP;
        MIN_THUMB_SIZE = new Dimension(15, 15);
        MIN_THUMB_SIZE_FREE_STANDING = new Dimension(17, 17);
    }

    class MetalScrollBarPropertyChangeHandler
    extends BasicScrollBarUI.PropertyChangeHandler {
        private /* synthetic */ MetalScrollBarUI this$0;

        public MetalScrollBarPropertyChangeHandler(MetalScrollBarUI metalScrollBarUI) {
            this.this$0 = metalScrollBarUI;
            super(metalScrollBarUI);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals(MetalScrollBarUI.FREE_STANDING_PROP)) {
                Boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                boolean bl2 = this.this$0.isFreeStanding = bl == null ? true : bl;
                if (this.this$0.increaseButton != null) {
                    this.this$0.increaseButton.setFreeStanding(this.this$0.isFreeStanding);
                }
                if (this.this$0.decreaseButton != null) {
                    this.this$0.decreaseButton.setFreeStanding(this.this$0.isFreeStanding);
                }
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }
    }
}

