/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class MetalRadioButtonUI
extends BasicRadioButtonUI {
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalRadioButtonUI();
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        this.disabledTextColor = UIManager.getColor("RadioButton.disabledText");
        this.focusColor = UIManager.getColor("RadioButton.focus");
        this.selectColor = UIManager.getColor("RadioButton.select");
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.disabledTextColor = null;
        this.focusColor = null;
        this.selectColor = null;
    }

    protected Color getSelectColor() {
        return this.selectColor;
    }

    protected Color getDisabledTextColor() {
        return this.disabledTextColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(this.focusColor);
        graphics.drawRect(rectangle.x - 1, rectangle.y + 2, rectangle.width + 2, rectangle.height - 4);
    }
}

