/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.metal.MetalCheckBoxIcon;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalUtils;

public class MetalIconFactory
implements Serializable {
    public static final boolean DARK = false;
    public static final boolean LIGHT = true;
    private static Icon checkBoxIcon;
    private static Icon checkBoxMenuItemIcon;
    private static Icon fileChooserDetailViewIcon;
    private static Icon fileChooserHomeFolderIcon;
    private static Icon fileChooserListViewIcon;
    private static Icon fileChooserNewFolderIcon;
    private static Icon fileChooserUpFolderIcon;
    private static RadioButtonIcon radioButtonIcon;
    private static Icon radioButtonMenuItemIcon;
    private static Icon internalFrameDefaultMenuIcon;
    private static Icon treeComputerIcon;
    private static Icon treeFloppyDriveIcon;
    private static Icon treeHardDriveIcon;

    public static Icon getCheckBoxIcon() {
        if (checkBoxIcon == null) {
            checkBoxIcon = new MetalCheckBoxIcon();
        }
        return checkBoxIcon;
    }

    public static Icon getCheckBoxMenuItemIcon() {
        if (checkBoxMenuItemIcon == null) {
            checkBoxMenuItemIcon = new CheckBoxMenuItemIcon();
        }
        return checkBoxMenuItemIcon;
    }

    public static Icon getFileChooserDetailViewIcon() {
        if (fileChooserDetailViewIcon == null) {
            fileChooserDetailViewIcon = new FileChooserDetailViewIcon();
        }
        return fileChooserDetailViewIcon;
    }

    public static Icon getFileChooserHomeFolderIcon() {
        if (fileChooserHomeFolderIcon == null) {
            fileChooserHomeFolderIcon = new FileChooserHomeFolderIcon();
        }
        return fileChooserHomeFolderIcon;
    }

    public static Icon getFileChooserListViewIcon() {
        if (fileChooserListViewIcon == null) {
            fileChooserListViewIcon = new FileChooserListViewIcon();
        }
        return fileChooserListViewIcon;
    }

    public static Icon getFileChooserNewFolderIcon() {
        if (fileChooserNewFolderIcon == null) {
            fileChooserNewFolderIcon = new FileChooserNewFolderIcon();
        }
        return fileChooserNewFolderIcon;
    }

    public static Icon getFileChooserUpFolderIcon() {
        if (fileChooserUpFolderIcon == null) {
            fileChooserUpFolderIcon = new FileChooserUpFolderIcon();
        }
        return fileChooserUpFolderIcon;
    }

    public static Icon getRadioButtonIcon() {
        if (radioButtonIcon == null) {
            radioButtonIcon = new RadioButtonIcon();
        }
        return radioButtonIcon;
    }

    public static Icon getRadioButtonMenuItemIcon() {
        if (radioButtonMenuItemIcon == null) {
            radioButtonMenuItemIcon = new RadioButtonMenuItemIcon();
        }
        return radioButtonMenuItemIcon;
    }

    public static Icon getHorizontalSliderThumbIcon() {
        return new HorizontalSliderThumbIcon();
    }

    public static Icon getInternalFrameCloseIcon(int n) {
        return new InternalFrameCloseIcon(n);
    }

    public static Icon getInternalFrameDefaultMenuIcon() {
        if (internalFrameDefaultMenuIcon == null) {
            internalFrameDefaultMenuIcon = new InternalFrameDefaultMenuIcon();
        }
        return internalFrameDefaultMenuIcon;
    }

    public static Icon getInternalFrameMaximizeIcon(int n) {
        return new InternalFrameMaximizeIcon();
    }

    public static Icon getInternalFrameMinimizeIcon(int n) {
        return new InternalFrameMinimizeIcon();
    }

    public static Icon getInternalFrameAltMaximizeIcon(int n) {
        return new InternalFrameAltMaximizeIcon(n);
    }

    public static Icon getVerticalSliderThumbIcon() {
        return new VerticalSliderThumbIcon();
    }

    public static Icon getTreeFolderIcon() {
        return new TreeFolderIcon();
    }

    public static Icon getTreeLeafIcon() {
        return new TreeLeafIcon();
    }

    public static Icon getTreeControlIcon(boolean bl) {
        return new TreeControlIcon(bl);
    }

    public static Icon getTreeComputerIcon() {
        if (treeComputerIcon == null) {
            treeComputerIcon = new TreeComputerIcon();
        }
        return treeComputerIcon;
    }

    public static Icon getTreeFloppyDriveIcon() {
        if (treeFloppyDriveIcon == null) {
            treeFloppyDriveIcon = new TreeFloppyDriveIcon();
        }
        return treeFloppyDriveIcon;
    }

    public static Icon getTreeHardDriveIcon() {
        if (treeHardDriveIcon == null) {
            treeHardDriveIcon = new TreeHardDriveIcon();
        }
        return treeHardDriveIcon;
    }

    private static class TreeComputerIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 3, n2 + 1, n + 12, n2 + 1);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 8);
            graphics.drawLine(n + 13, n2 + 2, n + 13, n2 + 8);
            graphics.drawLine(n + 3, n2 + 9, n + 3, n2 + 9);
            graphics.drawLine(n + 12, n2 + 9, n + 12, n2 + 9);
            graphics.drawRect(n + 1, n2 + 10, 13, 4);
            graphics.drawLine(n + 5, n2 + 3, n + 10, n2 + 3);
            graphics.drawLine(n + 5, n2 + 8, n + 10, n2 + 8);
            graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 7);
            graphics.drawLine(n + 11, n2 + 4, n + 11, n2 + 7);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(n + 5, n2 + 4, 6, 4);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(n + 6, n2 + 12, n + 8, n2 + 12);
            graphics.drawLine(n + 10, n2 + 12, n + 12, n2 + 12);
            graphics.setColor(color);
        }
    }

    private static class TreeFloppyDriveIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 1, n2 + 1, n + 13, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 14);
            graphics.drawLine(n + 1, n2 + 14, n + 14, n2 + 14);
            graphics.drawLine(n + 14, n2 + 2, n + 14, n2 + 14);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(n + 2, n2 + 2, 12, 12);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.fillRect(n + 5, n2 + 2, 6, 5);
            graphics.drawLine(n + 4, n2 + 8, n + 11, n2 + 8);
            graphics.drawLine(n + 3, n2 + 9, n + 3, n2 + 13);
            graphics.drawLine(n + 12, n2 + 9, n + 12, n2 + 13);
            graphics.setColor(MetalLookAndFeel.getWhite());
            graphics.fillRect(n + 8, n2 + 3, 2, 3);
            graphics.fillRect(n + 4, n2 + 9, 8, 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            graphics.drawLine(n + 5, n2 + 10, n + 9, n2 + 10);
            graphics.drawLine(n + 5, n2 + 12, n + 8, n2 + 12);
            graphics.setColor(color);
        }
    }

    private static class TreeHardDriveIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 5);
            graphics.drawLine(n + 14, n2 + 4, n + 14, n2 + 5);
            graphics.drawLine(n + 1, n2 + 7, n + 1, n2 + 8);
            graphics.drawLine(n + 14, n2 + 7, n + 14, n2 + 8);
            graphics.drawLine(n + 1, n2 + 10, n + 1, n2 + 11);
            graphics.drawLine(n + 14, n2 + 10, n + 14, n2 + 11);
            graphics.drawLine(n + 2, n2 + 3, n + 3, n2 + 3);
            graphics.drawLine(n + 12, n2 + 3, n + 13, n2 + 3);
            graphics.drawLine(n + 2, n2 + 6, n + 3, n2 + 6);
            graphics.drawLine(n + 12, n2 + 6, n + 13, n2 + 6);
            graphics.drawLine(n + 2, n2 + 9, n + 3, n2 + 9);
            graphics.drawLine(n + 12, n2 + 9, n + 13, n2 + 9);
            graphics.drawLine(n + 2, n2 + 12, n + 3, n2 + 12);
            graphics.drawLine(n + 12, n2 + 12, n + 13, n2 + 12);
            graphics.drawLine(n + 4, n2 + 2, n + 11, n2 + 2);
            graphics.drawLine(n + 4, n2 + 7, n + 11, n2 + 7);
            graphics.drawLine(n + 4, n2 + 10, n + 11, n2 + 10);
            graphics.drawLine(n + 4, n2 + 13, n + 11, n2 + 13);
            graphics.setColor(MetalLookAndFeel.getWhite());
            graphics.fillRect(n + 4, n2 + 3, 2, 2);
            graphics.drawLine(n + 6, n2 + 4, n + 6, n2 + 4);
            graphics.drawLine(n + 7, n2 + 3, n + 9, n2 + 3);
            graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 4);
            graphics.drawLine(n + 11, n2 + 3, n + 11, n2 + 3);
            graphics.fillRect(n + 2, n2 + 4, 2, 2);
            graphics.fillRect(n + 2, n2 + 7, 2, 2);
            graphics.fillRect(n + 2, n2 + 10, 2, 2);
            graphics.drawLine(n + 4, n2 + 6, n + 4, n2 + 6);
            graphics.drawLine(n + 4, n2 + 9, n + 4, n2 + 9);
            graphics.drawLine(n + 4, n2 + 12, n + 4, n2 + 12);
            graphics.setColor(MetalLookAndFeel.getControlShadow());
            graphics.drawLine(n + 13, n2 + 4, n + 13, n2 + 4);
            graphics.drawLine(n + 12, n2 + 5, n + 13, n2 + 5);
            graphics.drawLine(n + 13, n2 + 7, n + 13, n2 + 7);
            graphics.drawLine(n + 12, n2 + 8, n + 13, n2 + 8);
            graphics.drawLine(n + 13, n2 + 10, n + 13, n2 + 10);
            graphics.drawLine(n + 12, n2 + 11, n + 13, n2 + 11);
            graphics.drawLine(n + 10, n2 + 5, n + 10, n2 + 5);
            graphics.drawLine(n + 7, n2 + 6, n + 7, n2 + 6);
            graphics.drawLine(n + 9, n2 + 6, n + 9, n2 + 6);
            graphics.drawLine(n + 11, n2 + 6, n + 11, n2 + 6);
            graphics.drawLine(n + 10, n2 + 8, n + 10, n2 + 8);
            graphics.drawLine(n + 7, n2 + 9, n + 7, n2 + 9);
            graphics.drawLine(n + 9, n2 + 9, n + 9, n2 + 9);
            graphics.drawLine(n + 11, n2 + 9, n + 11, n2 + 9);
            graphics.drawLine(n + 10, n2 + 11, n + 10, n2 + 11);
            graphics.drawLine(n + 7, n2 + 12, n + 7, n2 + 12);
            graphics.drawLine(n + 9, n2 + 12, n + 9, n2 + 12);
            graphics.drawLine(n + 11, n2 + 12, n + 11, n2 + 12);
            graphics.setColor(color);
        }
    }

    public static class TreeLeafIcon
    extends FileIcon16 {
        public int getAdditionalHeight() {
            return 4;
        }

        public int getShift() {
            return 2;
        }
    }

    public static class TreeFolderIcon
    extends FolderIcon16 {
        public int getAdditionalHeight() {
            return 2;
        }

        public int getShift() {
            return -1;
        }
    }

    public static class TreeControlIcon
    implements Icon,
    Serializable {
        protected boolean isLight;
        private boolean collapsed;

        public TreeControlIcon(boolean bl) {
            this.collapsed = bl;
        }

        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            n += 5;
            n2 += 5;
            if (this.collapsed) {
                graphics.setColor(Color.black);
                graphics.drawLine(n + 2, n2, n + 5, n2);
                graphics.drawLine(n + 6, n2 + 1, n + 7, n2 + 2);
                graphics.fillRect(n + 7, n2 + 3, 5, 2);
                graphics.drawLine(n + 7, n2 + 5, n + 6, n2 + 6);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n, n2 + 2, n, n2 + 5);
                graphics.drawLine(n + 1, n2 + 6, n + 1, n2 + 6);
                graphics.drawLine(n + 2, n2 + 7, n + 5, n2 + 7);
                graphics.fillRect(n + 3, n2 + 3, 2, 2);
                graphics.setColor(new Color(204, 204, 255));
                graphics.drawLine(n + 3, n2 + 2, n + 4, n2 + 2);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 4);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                graphics.drawLine(n + 5, n2 + 3, n + 5, n2 + 3);
                graphics.setColor(new Color(153, 153, 204));
                graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
                graphics.drawLine(n + 2, n2 + 5, n + 2, n2 + 5);
                graphics.drawLine(n + 2, n2 + 6, n + 5, n2 + 6);
                graphics.drawLine(n + 5, n2 + 2, n + 5, n2 + 2);
                graphics.drawLine(n + 6, n2 + 2, n + 6, n2 + 5);
                graphics.setColor(new Color(102, 102, 153));
                graphics.drawLine(n + 2, n2 + 1, n + 5, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 5);
            } else {
                graphics.setColor(Color.black);
                graphics.drawLine(n + 2, n2, n + 5, n2);
                graphics.drawLine(n + 6, n2 + 1, n + 7, n2 + 2);
                graphics.drawLine(n + 7, n2 + 2, n + 7, n2 + 5);
                graphics.fillRect(n + 3, n2 + 7, 2, 5);
                graphics.drawLine(n + 7, n2 + 5, n + 6, n2 + 6);
                graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
                graphics.drawLine(n, n2 + 2, n, n2 + 5);
                graphics.drawLine(n + 1, n2 + 6, n + 1, n2 + 6);
                graphics.drawLine(n + 2, n2 + 7, n + 5, n2 + 7);
                graphics.fillRect(n + 3, n2 + 3, 2, 2);
                graphics.setColor(new Color(204, 204, 255));
                graphics.drawLine(n + 3, n2 + 2, n + 4, n2 + 2);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 4);
                graphics.drawLine(n + 3, n2 + 5, n + 3, n2 + 5);
                graphics.drawLine(n + 5, n2 + 3, n + 5, n2 + 3);
                graphics.setColor(new Color(153, 153, 204));
                graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
                graphics.drawLine(n + 2, n2 + 5, n + 2, n2 + 5);
                graphics.drawLine(n + 2, n2 + 6, n + 5, n2 + 6);
                graphics.drawLine(n + 5, n2 + 2, n + 5, n2 + 2);
                graphics.drawLine(n + 6, n2 + 2, n + 6, n2 + 5);
                graphics.setColor(new Color(102, 102, 153));
                graphics.drawLine(n + 2, n2 + 1, n + 5, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 5);
            }
        }

        public void paintMe(Component component, Graphics graphics, int n, int n2) {
            this.paintIcon(component, graphics, n, n2);
        }
    }

    private static class VerticalSliderThumbIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 15;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl = false;
            boolean bl2 = false;
            if (component != null) {
                bl = component.isEnabled();
                bl2 = component.hasFocus();
            }
            if (bl) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(n + 1, n2, n + 7, n2);
            graphics.drawLine(n + 8, n2, n + 15, n2 + 7);
            graphics.drawLine(n + 14, n2 + 8, n + 8, n2 + 14);
            graphics.drawLine(n + 8, n2 + 14, n + 1, n2 + 14);
            graphics.drawLine(n, n2 + 13, n, n2 + 1);
            if (bl2) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControl());
            }
            graphics.fillRect(n + 2, n2 + 1, 7, 13);
            graphics.drawLine(n + 9, n2 + 2, n + 9, n2 + 12);
            graphics.drawLine(n + 10, n2 + 3, n + 10, n2 + 11);
            graphics.drawLine(n + 11, n2 + 4, n + 11, n2 + 10);
            graphics.drawLine(n + 12, n2 + 5, n + 12, n2 + 9);
            graphics.drawLine(n + 13, n2 + 6, n + 13, n2 + 8);
            graphics.drawLine(n + 14, n2 + 7, n + 14, n2 + 7);
            if (bl) {
                if (bl2) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    graphics.setColor(MetalLookAndFeel.getBlack());
                }
                graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3);
                graphics.drawLine(n + 3, n2 + 7, n + 3, n2 + 7);
                graphics.drawLine(n + 3, n2 + 11, n + 3, n2 + 11);
                graphics.drawLine(n + 5, n2 + 5, n + 5, n2 + 5);
                graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
                graphics.drawLine(n + 7, n2 + 3, n + 7, n2 + 3);
                graphics.drawLine(n + 7, n2 + 7, n + 7, n2 + 7);
                graphics.drawLine(n + 7, n2 + 11, n + 7, n2 + 11);
                if (bl2) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    graphics.setColor(MetalLookAndFeel.getWhite());
                }
                graphics.drawLine(n + 1, n2 + 1, n + 8, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 13);
                graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
                graphics.drawLine(n + 2, n2 + 6, n + 2, n2 + 6);
                graphics.drawLine(n + 2, n2 + 10, n + 2, n2 + 10);
                graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 4);
                graphics.drawLine(n + 4, n2 + 8, n + 4, n2 + 8);
                graphics.drawLine(n + 6, n2 + 2, n + 6, n2 + 2);
                graphics.drawLine(n + 6, n2 + 6, n + 6, n2 + 6);
                graphics.drawLine(n + 6, n2 + 10, n + 6, n2 + 10);
            }
        }
    }

    private static class InternalFrameMinimizeIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            graphics.drawLine(n + 12, n2 + 1, n + 13, n2 + 1);
            graphics.drawLine(n + 11, n2 + 2, n + 12, n2 + 2);
            graphics.drawLine(n + 10, n2 + 3, n + 11, n2 + 3);
            graphics.drawLine(n + 8, n2 + 2, n + 8, n2 + 3);
            graphics.fillRect(n + 8, n2 + 4, 3, 3);
            graphics.drawLine(n + 11, n2 + 6, n + 12, n2 + 6);
            graphics.drawLine(n + 1, n2 + 8, n + 6, n2 + 8);
            graphics.drawLine(n + 1, n2 + 9, n + 1, n2 + 12);
            graphics.drawLine(n + 6, n2 + 9, n + 6, n2 + 12);
            graphics.drawLine(n + 1, n2 + 13, n + 6, n2 + 13);
            graphics.drawLine(n + 5, n2 + 9, n + 5, n2 + 9);
            graphics.drawLine(n + 2, n2 + 12, n + 2, n2 + 12);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 12, n2, n + 9, n2 + 3);
            graphics.drawLine(n + 7, n2 + 1, n + 8, n2 + 1);
            graphics.drawLine(n + 7, n2 + 2, n + 7, n2 + 6);
            graphics.drawLine(n, n2 + 7, n + 6, n2 + 7);
            graphics.drawLine(n, n2 + 8, n, n2 + 13);
            graphics.drawLine(n + 3, n2 + 12, n + 5, n2 + 12);
            graphics.drawLine(n + 5, n2 + 10, n + 5, n2 + 11);
            graphics.drawLine(n + 11, n2 + 5, n + 12, n2 + 5);
            graphics.setColor(MetalLookAndFeel.getWhite());
            graphics.drawLine(n + 9, n2 + 2, n + 9, n2 + 2);
            graphics.drawLine(n + 11, n2 + 4, n + 13, n2 + 2);
            graphics.drawLine(n + 13, n2 + 6, n + 13, n2 + 6);
            graphics.drawLine(n + 8, n2 + 7, n + 13, n2 + 7);
            graphics.drawLine(n + 7, n2 + 9, n + 7, n2 + 13);
            graphics.drawLine(n + 1, n2 + 14, n + 7, n2 + 14);
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
                graphics.fillRect(n + 2, n2 + 9, 3, 3);
            } else {
                graphics.drawLine(n + 2, n2 + 9, n + 4, n2 + 9);
                graphics.drawLine(n + 2, n2 + 10, n + 2, n2 + 11);
            }
            graphics.setColor(color);
        }
    }

    private static class InternalFrameMaximizeIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            graphics.fillRect(n + 2, n2 + 6, 7, 7);
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            graphics.drawLine(n + 9, n2 + 1, n + 10, n2 + 1);
            graphics.fillRect(n + 11, n2 + 1, 3, 3);
            graphics.fillRect(n + 12, n2 + 4, 2, 2);
            graphics.drawLine(n + 10, n2 + 3, n + 10, n2 + 3);
            graphics.drawLine(n + 9, n2 + 4, n + 10, n2 + 4);
            graphics.drawLine(n + 1, n2 + 5, n + 9, n2 + 5);
            graphics.drawLine(n + 1, n2 + 6, n + 1, n2 + 12);
            graphics.drawLine(n + 9, n2 + 6, n + 9, n2 + 12);
            graphics.drawLine(n + 1, n2 + 13, n + 9, n2 + 13);
            graphics.drawLine(n + 7, n2 + 6, n + 8, n2 + 6);
            graphics.drawLine(n + 6, n2 + 7, n + 8, n2 + 7);
            graphics.drawLine(n + 5, n2 + 8, n + 6, n2 + 8);
            graphics.drawLine(n + 4, n2 + 9, n + 5, n2 + 9);
            graphics.drawLine(n + 3, n2 + 10, n + 4, n2 + 10);
            graphics.drawLine(n + 2, n2 + 11, n + 3, n2 + 11);
            graphics.drawLine(n + 2, n2 + 12, n + 4, n2 + 12);
            graphics.drawLine(n + 8, n2 + 8, n + 8, n2 + 8);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 8, n2, n + 13, n2);
            graphics.drawLine(n + 8, n2 + 1, n + 8, n2 + 1);
            graphics.drawLine(n + 10, n2 + 2, n + 9, n2 + 3);
            graphics.drawLine(n, n2 + 4, n + 8, n2 + 4);
            graphics.drawLine(n, n2 + 5, n, n2 + 13);
            graphics.drawLine(n + 2, n2 + 10, n + 6, n2 + 6);
            graphics.drawLine(n + 8, n2 + 9, n + 8, n2 + 11);
            graphics.drawLine(n + 5, n2 + 12, n + 8, n2 + 12);
            graphics.setColor(MetalLookAndFeel.getWhite());
            if (!abstractButton.getModel().isPressed()) {
                graphics.drawLine(n + 2, n2 + 6, n + 5, n2 + 6);
                graphics.drawLine(n + 2, n2 + 7, n + 2, n2 + 9);
                graphics.drawLine(n + 4, n2 + 11, n + 7, n2 + 8);
            }
            graphics.drawLine(n + 1, n2 + 14, n + 10, n2 + 14);
            graphics.drawLine(n + 10, n2 + 5, n + 10, n2 + 13);
            graphics.drawLine(n + 9, n2 + 2, n + 9, n2 + 2);
            graphics.drawLine(n + 11, n2 + 4, n + 11, n2 + 5);
            graphics.drawLine(n + 13, n2 + 6, n + 14, n2 + 6);
            graphics.drawLine(n + 14, n2 + 1, n + 14, n2 + 5);
            graphics.setColor(color);
        }
    }

    private static class InternalFrameAltMaximizeIcon
    implements Icon,
    Serializable {
        private int size;

        public InternalFrameAltMaximizeIcon(int n) {
            this.size = n;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            graphics.fillRect(n + 2, n2 + 6, 7, 7);
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            }
            graphics.drawLine(n + 12, n2 + 1, n + 13, n2 + 1);
            graphics.drawLine(n + 11, n2 + 2, n + 12, n2 + 2);
            graphics.drawLine(n + 10, n2 + 3, n + 11, n2 + 3);
            graphics.drawLine(n + 8, n2 + 2, n + 8, n2 + 3);
            graphics.fillRect(n + 8, n2 + 4, 3, 3);
            graphics.drawLine(n + 11, n2 + 6, n + 12, n2 + 6);
            graphics.drawLine(n + 1, n2 + 5, n + 5, n2 + 5);
            graphics.drawLine(n + 1, n2 + 6, n + 1, n2 + 12);
            graphics.drawLine(n + 9, n2 + 9, n + 9, n2 + 12);
            graphics.drawLine(n + 1, n2 + 13, n + 9, n2 + 13);
            graphics.drawLine(n + 2, n2 + 12, n + 2, n2 + 12);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 12, n2, n + 9, n2 + 3);
            graphics.drawLine(n + 7, n2 + 1, n + 8, n2 + 1);
            graphics.drawLine(n + 7, n2 + 2, n + 7, n2 + 6);
            graphics.drawLine(n + 11, n2 + 5, n + 12, n2 + 5);
            graphics.drawLine(n, n2 + 4, n + 5, n2 + 4);
            graphics.drawLine(n, n2 + 5, n, n2 + 13);
            graphics.drawLine(n + 3, n2 + 12, n + 8, n2 + 12);
            graphics.drawLine(n + 8, n2 + 8, n + 8, n2 + 11);
            graphics.drawLine(n + 9, n2 + 8, n + 9, n2 + 8);
            graphics.setColor(MetalLookAndFeel.getWhite());
            graphics.drawLine(n + 9, n2 + 2, n + 9, n2 + 2);
            graphics.drawLine(n + 11, n2 + 4, n + 13, n2 + 2);
            graphics.drawLine(n + 13, n2 + 6, n + 13, n2 + 6);
            graphics.drawLine(n + 8, n2 + 7, n + 13, n2 + 7);
            graphics.drawLine(n + 6, n2 + 5, n + 6, n2 + 5);
            graphics.drawLine(n + 10, n2 + 8, n + 10, n2 + 13);
            graphics.drawLine(n + 1, n2 + 14, n + 10, n2 + 14);
            if (!abstractButton.getModel().isPressed()) {
                graphics.drawLine(n + 2, n2 + 6, n + 6, n2 + 6);
                graphics.drawLine(n + 2, n2 + 6, n + 2, n2 + 11);
            }
            graphics.setColor(color);
        }
    }

    private static class InternalFrameDefaultMenuIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(new Color(102, 102, 153));
            graphics.fillRect(n + 1, n2, 14, 2);
            graphics.fillRect(n, n2 + 1, 2, 14);
            graphics.fillRect(n + 1, n2 + 14, 14, 2);
            graphics.fillRect(n + 14, n2 + 1, 2, 14);
            graphics.drawLine(n + 2, n2 + 5, n + 14, n2 + 5);
            graphics.setColor(new Color(204, 204, 255));
            graphics.fillRect(n + 2, n2 + 2, 12, 3);
            graphics.setColor(new Color(102, 102, 153));
            graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3);
            graphics.drawLine(n + 6, n2 + 3, n + 6, n2 + 3);
            graphics.drawLine(n + 9, n2 + 3, n + 9, n2 + 3);
            graphics.drawLine(n + 12, n2 + 3, n + 12, n2 + 3);
            graphics.setColor(Color.white);
            graphics.fillRect(n + 2, n2 + 6, 12, 8);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
            graphics.drawLine(n + 5, n2 + 2, n + 5, n2 + 2);
            graphics.drawLine(n + 8, n2 + 2, n + 8, n2 + 2);
            graphics.drawLine(n + 11, n2 + 2, n + 11, n2 + 2);
        }
    }

    private static class InternalFrameCloseIcon
    implements Icon,
    Serializable {
        private int size;

        public InternalFrameCloseIcon(int n) {
            this.size = n;
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            }
            graphics.fillRect(n + 2, n2 + 2, 10, 10);
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                boolean bl = true;
                if (bl) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
                }
            }
            graphics.drawLine(n + 1, n2 + 1, n + 13, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 12);
            graphics.drawLine(n + 1, n2 + 13, n + 13, n2 + 13);
            graphics.drawLine(n + 13, n2 + 2, n + 13, n2 + 12);
            graphics.drawLine(n + 2, n2 + 12, n + 2, n2 + 12);
            graphics.drawLine(n + 12, n2 + 2, n + 12, n2 + 2);
            graphics.fillRect(n + 4, n2 + 4, 2, 2);
            graphics.fillRect(n + 5, n2 + 5, 4, 4);
            graphics.drawLine(n + 9, n2 + 4, n + 10, n2 + 4);
            graphics.drawLine(n + 9, n2 + 4, n + 9, n2 + 5);
            graphics.drawLine(n + 4, n2 + 9, n + 4, n2 + 10);
            graphics.drawLine(n + 4, n2 + 9, n + 5, n2 + 9);
            graphics.drawLine(n + 9, n2 + 8, n + 9, n2 + 10);
            graphics.drawLine(n + 8, n2 + 9, n + 10, n2 + 9);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n, n2, n + 13, n2);
            graphics.drawLine(n, n2 + 1, n, n2 + 13);
            graphics.drawLine(n + 3, n2 + 4, n + 4, n2 + 3);
            graphics.drawLine(n + 3, n2 + 9, n + 5, n2 + 7);
            graphics.drawLine(n + 7, n2 + 5, n + 9, n2 + 3);
            graphics.drawLine(n + 12, n2 + 3, n + 12, n2 + 11);
            graphics.drawLine(n + 3, n2 + 12, n + 12, n2 + 12);
            graphics.setColor(MetalLookAndFeel.getWhite());
            graphics.drawLine(n + 1, n2 + 14, n + 14, n2 + 14);
            graphics.drawLine(n + 14, n2 + 1, n + 14, n2 + 14);
            if (!abstractButton.getModel().isPressed()) {
                graphics.drawLine(n + 5, n2 + 10, n + 5, n2 + 10);
                graphics.drawLine(n + 6, n2 + 9, n + 7, n2 + 9);
                graphics.drawLine(n + 10, n2 + 5, n + 10, n2 + 5);
                graphics.drawLine(n + 9, n2 + 6, n + 9, n2 + 7);
                graphics.drawLine(n + 10, n2 + 10, n + 11, n2 + 10);
                graphics.drawLine(n + 10, n2 + 11, n + 10, n2 + 11);
            }
            graphics.setColor(color);
        }
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            boolean bl = false;
            boolean bl2 = false;
            if (component != null) {
                bl = component.isEnabled();
                bl2 = component.hasFocus();
            }
            if (bl) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(n + 1, n2, n + 13, n2);
            graphics.drawLine(n + 14, n2 + 1, n + 14, n2 + 7);
            graphics.drawLine(n + 14, n2 + 8, n + 7, n2 + 15);
            graphics.drawLine(n + 6, n2 + 14, n, n2 + 8);
            graphics.drawLine(n, n2 + 7, n, n2 + 1);
            if (bl2) {
                graphics.setColor(MetalLookAndFeel.getPrimaryControlShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControl());
            }
            graphics.fillRect(n + 1, n2 + 2, 13, 7);
            graphics.drawLine(n + 2, n2 + 9, n + 12, n2 + 9);
            graphics.drawLine(n + 3, n2 + 10, n + 11, n2 + 10);
            graphics.drawLine(n + 4, n2 + 11, n + 10, n2 + 11);
            graphics.drawLine(n + 5, n2 + 12, n + 9, n2 + 12);
            graphics.drawLine(n + 6, n2 + 13, n + 8, n2 + 13);
            graphics.drawLine(n + 7, n2 + 14, n + 7, n2 + 14);
            if (component.isEnabled()) {
                if (bl2) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                } else {
                    graphics.setColor(MetalLookAndFeel.getBlack());
                }
                graphics.drawLine(n + 3, n2 + 3, n + 3, n2 + 3);
                graphics.drawLine(n + 7, n2 + 3, n + 7, n2 + 3);
                graphics.drawLine(n + 11, n2 + 3, n + 11, n2 + 3);
                graphics.drawLine(n + 5, n2 + 5, n + 5, n2 + 5);
                graphics.drawLine(n + 9, n2 + 5, n + 9, n2 + 5);
                graphics.drawLine(n + 3, n2 + 7, n + 3, n2 + 7);
                graphics.drawLine(n + 7, n2 + 7, n + 7, n2 + 7);
                graphics.drawLine(n + 11, n2 + 7, n + 11, n2 + 7);
                if (bl2) {
                    graphics.setColor(MetalLookAndFeel.getPrimaryControl());
                } else {
                    graphics.setColor(MetalLookAndFeel.getWhite());
                }
                graphics.drawLine(n + 1, n2 + 1, n + 13, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 8);
                graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
                graphics.drawLine(n + 6, n2 + 2, n + 6, n2 + 2);
                graphics.drawLine(n + 10, n2 + 2, n + 10, n2 + 2);
                graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 4);
                graphics.drawLine(n + 8, n2 + 4, n + 8, n2 + 4);
                graphics.drawLine(n + 2, n2 + 6, n + 2, n2 + 6);
                graphics.drawLine(n + 6, n2 + 6, n + 6, n2 + 6);
                graphics.drawLine(n + 10, n2 + 6, n + 10, n2 + 6);
            }
        }
    }

    private static class RadioButtonMenuItemIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            JRadioButtonMenuItem jRadioButtonMenuItem = (JRadioButtonMenuItem)component;
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 2, n2, n + 6, n2);
            graphics.drawLine(n + 7, n2 + 1, n + 7, n2 + 1);
            graphics.drawLine(n + 8, n2 + 2, n + 8, n2 + 6);
            graphics.drawLine(n + 7, n2 + 7, n + 7, n2 + 7);
            graphics.drawLine(n + 2, n2 + 8, n + 6, n2 + 8);
            graphics.drawLine(n + 1, n2 + 7, n + 1, n2 + 7);
            graphics.drawLine(n, n2 + 2, n, n2 + 6);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 1);
            if (jRadioButtonMenuItem.isSelected()) {
                graphics.drawLine(n + 3, n2 + 2, n + 5, n2 + 2);
                graphics.fillRect(n + 2, n2 + 3, 5, 3);
                graphics.drawLine(n + 3, n2 + 6, n + 5, n2 + 6);
            }
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n + 3, n2 + 1, n + 6, n2 + 1);
            graphics.drawLine(n + 8, n2 + 1, n + 8, n2 + 1);
            graphics.drawLine(n + 9, n2 + 2, n + 9, n2 + 7);
            graphics.drawLine(n + 8, n2 + 8, n + 8, n2 + 8);
            graphics.drawLine(n + 2, n2 + 9, n + 7, n2 + 9);
            graphics.drawLine(n + 1, n2 + 8, n + 1, n2 + 8);
            graphics.drawLine(n + 1, n2 + 3, n + 1, n2 + 6);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 2);
            graphics.setColor(color);
        }
    }

    static class RadioButtonIcon
    implements Icon,
    UIResource,
    Serializable {
        public int getIconWidth() {
            return 13;
        }

        public int getIconHeight() {
            return 13;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (UIManager.get("RadioButton.gradient") != null) {
                MetalUtils.paintGradient(graphics, n, n2, this.getIconWidth(), this.getIconHeight(), 1, "RadioButton.gradient");
            }
            Color color = graphics.getColor();
            JRadioButton jRadioButton = (JRadioButton)component;
            if (jRadioButton.isEnabled()) {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDisabled());
            }
            graphics.drawLine(n + 2, n2 + 1, n + 3, n2 + 1);
            graphics.drawLine(n + 4, n2, n + 7, n2);
            graphics.drawLine(n + 8, n2 + 1, n + 9, n2 + 1);
            graphics.drawLine(n + 10, n2 + 2, n + 10, n2 + 3);
            graphics.drawLine(n + 11, n2 + 4, n + 11, n2 + 7);
            graphics.drawLine(n + 10, n2 + 8, n + 10, n2 + 9);
            graphics.drawLine(n + 8, n2 + 10, n + 9, n2 + 10);
            graphics.drawLine(n + 4, n2 + 11, n + 7, n2 + 11);
            graphics.drawLine(n + 2, n2 + 10, n + 3, n2 + 10);
            graphics.drawLine(n + 1, n2 + 9, n + 1, n2 + 8);
            graphics.drawLine(n, n2 + 7, n, n2 + 4);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 3);
            if (jRadioButton.getModel().isArmed()) {
                graphics.setColor(MetalLookAndFeel.getControlShadow());
                graphics.drawLine(n + 4, n2 + 1, n + 7, n2 + 1);
                graphics.drawLine(n + 4, n2 + 10, n + 7, n2 + 10);
                graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 7);
                graphics.drawLine(n + 10, n2 + 4, n + 10, n2 + 7);
                graphics.fillRect(n + 2, n2 + 2, 8, 8);
            } else if (jRadioButton.isEnabled()) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                graphics.drawLine(n + 2, n2 + 8, n + 2, n2 + 9);
                graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 7);
                graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 3);
                graphics.drawLine(n + 3, n2 + 2, n + 3, n2 + 2);
                graphics.drawLine(n + 4, n2 + 1, n + 7, n2 + 1);
                graphics.drawLine(n + 8, n2 + 2, n + 9, n2 + 2);
            }
            if (jRadioButton.isEnabled()) {
                graphics.setColor(MetalLookAndFeel.getWhite());
                graphics.drawLine(n + 10, n2 + 1, n + 10, n2 + 1);
                graphics.drawLine(n + 11, n2 + 2, n + 11, n2 + 3);
                graphics.drawLine(n + 12, n2 + 4, n + 12, n2 + 7);
                graphics.drawLine(n + 11, n2 + 8, n + 11, n2 + 9);
                graphics.drawLine(n + 10, n2 + 10, n + 10, n2 + 10);
                graphics.drawLine(n + 8, n2 + 11, n + 9, n2 + 11);
                graphics.drawLine(n + 4, n2 + 12, n + 7, n2 + 12);
                graphics.drawLine(n + 2, n2 + 11, n + 3, n2 + 11);
            }
            if (jRadioButton.isSelected()) {
                if (jRadioButton.isEnabled()) {
                    graphics.setColor(MetalLookAndFeel.getBlack());
                } else {
                    graphics.setColor(MetalLookAndFeel.getControlDisabled());
                }
                graphics.drawLine(n + 4, n2 + 3, n + 7, n2 + 3);
                graphics.fillRect(n + 3, n2 + 4, 6, 4);
                graphics.drawLine(n + 4, n2 + 8, n + 7, n2 + 8);
            }
            graphics.setColor(color);
        }

        RadioButtonIcon() {
        }
    }

    public static class PaletteCloseIcon
    implements Icon,
    Serializable,
    UIResource {
        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            AbstractButton abstractButton = (AbstractButton)component;
            if (abstractButton.getModel().isPressed()) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.fillRect(n + 2, n2 + 2, 3, 3);
            graphics.drawLine(n + 1, n2, n + 1, n2 + 2);
            graphics.drawLine(n, n2 + 1, n + 2, n2 + 1);
            graphics.drawLine(n + 5, n2, n + 5, n2 + 2);
            graphics.drawLine(n + 4, n2 + 1, n + 6, n2 + 1);
            graphics.drawLine(n + 1, n2 + 4, n + 1, n2 + 6);
            graphics.drawLine(n, n2 + 5, n + 2, n2 + 5);
            graphics.drawLine(n + 5, n2 + 4, n + 5, n2 + 6);
            graphics.drawLine(n + 4, n2 + 5, n + 6, n2 + 5);
            graphics.setColor(MetalLookAndFeel.getControlHighlight());
            graphics.drawLine(n + 2, n2 + 6, n + 3, n2 + 5);
            graphics.drawLine(n + 5, n2 + 3, n + 6, n2 + 2);
            graphics.drawLine(n + 6, n2 + 6, n + 6, n2 + 6);
            graphics.setColor(color);
        }
    }

    public static class FolderIcon16
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16 + this.getAdditionalHeight();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2 + 3, n, n2 + 12);
            graphics.drawLine(n, n2 + 12, n + 15, n2 + 12);
            graphics.drawLine(n + 15, n2 + 12, n + 15, n2 + 2);
            graphics.drawLine(n + 14, n2 + 3, n + 9, n2 + 3);
            graphics.drawLine(n + 8, n2 + 2, n + 1, n2 + 2);
            graphics.setColor(new Color(204, 204, 255));
            graphics.fillRect(n + 2, n2 + 4, 7, 8);
            graphics.fillRect(n + 9, n2 + 5, 6, 7);
            graphics.setColor(new Color(102, 102, 153));
            graphics.drawLine(n + 9, n2 + 2, n + 14, n2 + 2);
            graphics.setColor(new Color(50, 50, 120));
            graphics.drawLine(n + 9, n2 + 1, n + 15, n2 + 1);
            graphics.drawLine(n + 10, n2, n + 15, n2);
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getShift() {
            return 0;
        }
    }

    public static class FileIcon16
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16 + this.getAdditionalHeight();
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            graphics.setColor(Color.black);
            graphics.drawLine(n, n2, n + 9, n2);
            graphics.drawLine(n, n2 + 1, n, n2 + 15);
            graphics.drawLine(n, n2 + 15, n + 12, n2 + 15);
            graphics.drawLine(n + 12, n2 + 15, n + 12, n2 + 6);
            graphics.drawLine(n + 12, n2 + 6, n + 9, n2);
            graphics.drawLine(n + 7, n2 + 2, n + 11, n2 + 6);
            graphics.drawLine(n + 8, n2 + 1, n + 9, n2 + 1);
            graphics.setColor(new Color(204, 204, 255));
            graphics.drawLine(n + 1, n2 + 1, n + 7, n2 + 1);
            graphics.drawLine(n + 1, n2 + 1, n + 1, n2 + 14);
            graphics.drawLine(n + 1, n2 + 14, n + 11, n2 + 14);
            graphics.drawLine(n + 11, n2 + 14, n + 11, n2 + 7);
            graphics.drawLine(n + 8, n2 + 2, n + 10, n2 + 4);
        }

        public int getAdditionalHeight() {
            return 0;
        }

        public int getShift() {
            return 0;
        }
    }

    private static class FileChooserUpFolderIcon
    extends FileChooserNewFolderIcon
    implements Icon,
    Serializable {
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            super.paintIcon(component, graphics, n, n2);
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 8, n2 + 9, n + 8, n2 + 16);
            int n3 = n + 8;
            for (int i = 0; i < 4; ++i) {
                graphics.drawLine(n3 - i, n2 + 9 + i, n3 + i, n2 + 9 + i);
            }
            graphics.setColor(color);
        }
    }

    private static class FileChooserNewFolderIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 2, n2 + 5, n + 9, n2 + 5);
            graphics.drawLine(n + 10, n2 + 6, n + 15, n2 + 6);
            graphics.drawLine(n + 15, n2 + 5, n + 15, n2 + 14);
            graphics.drawLine(n + 2, n2 + 14, n + 15, n2 + 14);
            graphics.drawLine(n + 1, n2 + 6, n + 1, n2 + 14);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.drawLine(n + 11, n2 + 3, n + 15, n2 + 3);
            graphics.drawLine(n + 10, n2 + 4, n + 15, n2 + 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(n + 3, n2 + 7, 7, 7);
            graphics.fillRect(n + 10, n2 + 8, 5, 6);
            graphics.drawLine(n + 10, n2 + 5, n + 14, n2 + 5);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(n + 10, n2 + 7, n + 14, n2 + 7);
            graphics.drawLine(n + 2, n2 + 6, n + 9, n2 + 6);
            graphics.drawLine(n + 2, n2 + 6, n + 2, n2 + 13);
            graphics.setColor(color);
        }
    }

    private static class FileChooserListViewIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 2, n2 + 2, n + 5, n2 + 2);
            graphics.drawLine(n + 6, n2 + 3, n + 6, n2 + 7);
            graphics.drawLine(n + 2, n2 + 7, n + 6, n2 + 7);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 7);
            graphics.drawLine(n + 2, n2 + 10, n + 5, n2 + 10);
            graphics.drawLine(n + 6, n2 + 11, n + 6, n2 + 15);
            graphics.drawLine(n + 2, n2 + 15, n + 6, n2 + 15);
            graphics.drawLine(n + 2, n2 + 10, n + 2, n2 + 15);
            graphics.drawLine(n + 10, n2 + 2, n + 13, n2 + 2);
            graphics.drawLine(n + 14, n2 + 3, n + 14, n2 + 7);
            graphics.drawLine(n + 10, n2 + 7, n + 14, n2 + 7);
            graphics.drawLine(n + 10, n2 + 2, n + 10, n2 + 7);
            graphics.drawLine(n + 10, n2 + 10, n + 13, n2 + 10);
            graphics.drawLine(n + 14, n2 + 11, n + 14, n2 + 15);
            graphics.drawLine(n + 10, n2 + 15, n + 14, n2 + 15);
            graphics.drawLine(n + 10, n2 + 10, n + 10, n2 + 15);
            graphics.drawLine(n + 8, n2 + 5, n + 8, n2 + 5);
            graphics.drawLine(n + 8, n2 + 13, n + 8, n2 + 13);
            graphics.drawLine(n + 16, n2 + 5, n + 16, n2 + 5);
            graphics.drawLine(n + 16, n2 + 13, n + 16, n2 + 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(n + 3, n2 + 3, 3, 4);
            graphics.fillRect(n + 3, n2 + 11, 3, 4);
            graphics.fillRect(n + 11, n2 + 3, 3, 4);
            graphics.fillRect(n + 11, n2 + 11, 3, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 5);
            graphics.drawLine(n + 4, n2 + 12, n + 4, n2 + 13);
            graphics.drawLine(n + 12, n2 + 4, n + 12, n2 + 5);
            graphics.drawLine(n + 12, n2 + 12, n + 12, n2 + 13);
            graphics.setColor(color);
        }
    }

    private static class FileChooserHomeFolderIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 1, n2 + 8, n + 8, n2 + 1);
            graphics.drawLine(n + 8, n2 + 1, n + 15, n2 + 8);
            graphics.drawLine(n + 3, n2 + 6, n + 3, n2 + 15);
            graphics.drawLine(n + 3, n2 + 15, n + 13, n2 + 15);
            graphics.drawLine(n + 13, n2 + 6, n + 13, n2 + 15);
            graphics.drawLine(n + 6, n2 + 9, n + 6, n2 + 15);
            graphics.drawLine(n + 6, n2 + 9, n + 10, n2 + 9);
            graphics.drawLine(n + 10, n2 + 9, n + 10, n2 + 15);
            graphics.drawLine(n + 11, n2 + 2, n + 11, n2 + 4);
            graphics.drawLine(n + 12, n2 + 2, n + 12, n2 + 5);
            graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            int n3 = n + 8;
            for (int i = 0; i < 4; ++i) {
                graphics.drawLine(n3 - i, n2 + 2 + i, n3 + i, n2 + 2 + i);
            }
            graphics.fillRect(n + 4, n2 + 6, 9, 2);
            graphics.drawLine(n + 9, n2 + 12, n + 9, n2 + 12);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.drawLine(n + 4, n2 + 8, n + 12, n2 + 8);
            graphics.fillRect(n + 4, n2 + 9, 2, 6);
            graphics.fillRect(n + 11, n2 + 9, 2, 6);
            graphics.setColor(color);
        }
    }

    private static class FileChooserDetailViewIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 18;
        }

        public int getIconHeight() {
            return 18;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            graphics.setColor(MetalLookAndFeel.getBlack());
            graphics.drawLine(n + 2, n2 + 2, n + 5, n2 + 2);
            graphics.drawLine(n + 6, n2 + 3, n + 6, n2 + 7);
            graphics.drawLine(n + 2, n2 + 7, n + 6, n2 + 7);
            graphics.drawLine(n + 2, n2 + 2, n + 2, n2 + 7);
            graphics.drawLine(n + 2, n2 + 10, n + 5, n2 + 10);
            graphics.drawLine(n + 6, n2 + 11, n + 6, n2 + 15);
            graphics.drawLine(n + 2, n2 + 15, n + 6, n2 + 15);
            graphics.drawLine(n + 2, n2 + 10, n + 2, n2 + 15);
            graphics.drawLine(n + 8, n2 + 5, n + 15, n2 + 5);
            graphics.drawLine(n + 8, n2 + 13, n + 15, n2 + 13);
            graphics.setColor(MetalLookAndFeel.getPrimaryControl());
            graphics.fillRect(n + 3, n2 + 3, 3, 4);
            graphics.fillRect(n + 3, n2 + 11, 3, 4);
            graphics.setColor(MetalLookAndFeel.getPrimaryControlHighlight());
            graphics.drawLine(n + 4, n2 + 4, n + 4, n2 + 5);
            graphics.drawLine(n + 4, n2 + 12, n + 4, n2 + 13);
            graphics.setColor(color);
        }
    }

    private static class CheckBoxMenuItemIcon
    implements Icon,
    Serializable {
        public int getIconWidth() {
            return 10;
        }

        public int getIconHeight() {
            return 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)component;
            if (jCheckBoxMenuItem.isArmed()) {
                graphics.setColor(MetalLookAndFeel.getBlack());
            } else {
                graphics.setColor(MetalLookAndFeel.getControlDarkShadow());
            }
            graphics.drawLine(n, n2, n + 8, n2);
            graphics.drawLine(n, n2 + 1, n, n2 + 8);
            graphics.drawLine(n + 2, n2 + 8, n + 8, n2 + 8);
            graphics.drawLine(n + 8, n2 + 2, n + 8, n2 + 7);
            graphics.setColor(MetalLookAndFeel.getWhite());
            graphics.drawLine(n + 1, n2 + 1, n + 7, n2 + 1);
            graphics.drawLine(n + 1, n2 + 2, n + 1, n2 + 7);
            graphics.drawLine(n + 1, n2 + 9, n + 9, n2 + 9);
            graphics.drawLine(n + 9, n2 + 1, n + 9, n2 + 8);
            if (jCheckBoxMenuItem.isSelected()) {
                graphics.setColor(MetalLookAndFeel.getBlack());
                graphics.fillRect(n + 2, n2 + 2, 2, 5);
                for (int i = 0; i < 6; ++i) {
                    graphics.drawLine(n + 8 - i, n2 + i, n + 9 - i, n2 + i);
                }
            }
        }
    }
}

