/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.text.Caret;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class BasicTreeUI
extends TreeUI {
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected Dimension preferredMinSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    Timer editorTimer;
    Object newVal;
    TreeAction action;
    boolean isEditing;
    TreePath currentVisiblePath;
    int gap;
    int rowHeight;
    private PropertyChangeListener propertyChangeListener;
    private FocusListener focusListener;
    private TreeSelectionListener treeSelectionListener;
    private MouseListener mouseListener;
    private KeyListener keyListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private ComponentListener componentListener;
    CellEditorListener cellEditorListener;
    private TreeExpansionListener treeExpansionListener;
    private TreeModelListener treeModelListener;

    private /* synthetic */ void finit$() {
        this.editorTimer = new EditorUpdateTimer(this);
        this.gap = 4;
        this.rowHeight = 20;
    }

    public BasicTreeUI() {
        this.finit$();
        this.validCachedPreferredSize = false;
        this.drawingCache = new Hashtable();
        this.nodeDimensions = this.createNodeDimensions();
        this.configureLayoutCache();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.treeSelectionListener = this.createTreeSelectionListener();
        this.mouseListener = this.createMouseListener();
        this.keyListener = this.createKeyListener();
        this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener();
        this.componentListener = this.createComponentListener();
        this.cellEditorListener = this.createCellEditorListener();
        this.treeExpansionListener = this.createTreeExpansionListener();
        this.treeModelListener = this.createTreeModelListener();
        this.editingRow = -1;
        this.lastSelectedRow = -1;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return UIManager.getColor("Tree.hash");
    }

    protected void setHashColor(Color color) {
        UIManager.put("Tree.hash", color);
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean bl) {
        if (bl != this.largeModel) {
            this.tree.removeComponentListener(this.componentListener);
            this.largeModel = bl;
            this.tree.addComponentListener(this.componentListener);
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int n) {
        if (n == 0) {
            n = this.rowHeight;
        }
        this.treeState.setRowHeight(n);
    }

    protected int getRowHeight() {
        return this.treeState.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.currentCellRenderer = treeCellRenderer;
        this.updateRenderer();
    }

    protected TreeCellRenderer getCellRenderer() {
        if (this.currentCellRenderer != null) {
            return this.currentCellRenderer;
        }
        return this.createDefaultCellRenderer();
    }

    protected void setModel(TreeModel treeModel) {
        this.tree.setModel(treeModel);
        this.treeModel = this.tree.getModel();
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    protected boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    protected void setShowsRootHandles(boolean bl) {
        this.tree.setShowsRootHandles(bl);
    }

    protected boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.cellEditor = treeCellEditor;
        this.createdCellEditor = true;
    }

    protected TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    protected void setEditable(boolean bl) {
        this.tree.setEditable(bl);
    }

    protected boolean isEditable() {
        return this.tree.isEditable();
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel != null) {
            this.treeSelectionModel = treeSelectionModel;
            this.tree.setSelectionModel(this.treeSelectionModel);
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        Rectangle rectangle = null;
        int n = -1;
        Object object = null;
        if (treePath != null) {
            n = this.getRowForPath(jTree, treePath);
            object = treePath.getLastPathComponent();
            rectangle = new Rectangle(0, n * this.getRowHeight(), 0, 0);
        }
        return this.nodeDimensions.getNodeDimensions(object, n, this.getLevel(object), jTree.isExpanded(treePath), rectangle);
    }

    public TreePath getPathForRow(JTree jTree, int n) {
        Object[] objectArray;
        if (this.treeModel != null && this.currentVisiblePath != null && n < (objectArray = this.currentVisiblePath.getPath()).length) {
            return new TreePath(this.getPathToRoot(objectArray[n], 0));
        }
        return null;
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        Object object = treePath.getLastPathComponent();
        int n = this.getRowCount(jTree);
        if (this.currentVisiblePath != null) {
            Object[] objectArray = this.currentVisiblePath.getPath();
            for (int i = 0; i < n; ++i) {
                if (!object.equals(objectArray[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public int getRowCount(JTree jTree) {
        if (this.currentVisiblePath != null) {
            return this.currentVisiblePath.getPathCount();
        }
        return 0;
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        int n3 = Math.round(n2 / this.getRowHeight());
        TreePath treePath = this.getPathForRow(jTree, n3);
        while (n3 > 0 && treePath == null) {
            treePath = this.getPathForRow(jTree, --n3);
        }
        return treePath;
    }

    public boolean isEditing(JTree jTree) {
        return this.isEditing;
    }

    public boolean stopEditing(JTree jTree) {
        if (this.isEditing(jTree)) {
            this.completeEditing(true, false, false);
        }
        return this.isEditing(jTree) ^ true;
    }

    public void cancelEditing(JTree jTree) {
        if (this.isEditing(jTree)) {
            this.completeEditing(false, true, false);
        }
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        this.startEditing(treePath, null);
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    protected void prepareForUIInstall() {
    }

    protected void completeUIInstall() {
    }

    protected void completeUIUninstall() {
    }

    protected void installComponents() {
        this.currentCellRenderer = this.createDefaultCellRenderer();
        this.rendererPane = this.createCellRendererPane();
        this.createdRenderer = true;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler(this);
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler(this);
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler(this);
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler(this);
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler(this);
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler(this);
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new FixedHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null) {
            return new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer, this.cellEditor);
        }
        return new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.createDefaultCellRenderer(), this.cellEditor);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler(this);
    }

    protected void uninstallListeners() {
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        this.tree.removeFocusListener(this.focusListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeKeyListener(this.keyListener);
        this.tree.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.removeComponentListener(this.componentListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor != null) {
            treeCellEditor.removeCellEditorListener(this.cellEditorListener);
        }
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
    }

    protected void uninstallKeyboardActions() {
        this.action = null;
        this.tree.getInputMap(1).setParent(null);
        this.tree.getActionMap().setParent(null);
    }

    protected void uninstallComponents() {
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.createdRenderer = false;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected int getVerticalLegBuffer() {
        return this.getRowHeight() / 2;
    }

    protected int getHorizontalLegBuffer() {
        return this.rightChildIndent / 2;
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        Enumeration enumeration = this.tree.getExpandedDescendants(treePath);
        while (enumeration.hasMoreElements()) {
            this.treeState.setExpandedState((TreePath)enumeration.nextElement(), true);
        }
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        return (TreePath)treePath.getLastPathComponent();
    }

    protected void updateDepthOffset() {
        this.depthOffset += this.getVerticalLegBuffer();
    }

    protected void updateCellEditor() {
        if (this.tree.isEditable() && this.cellEditor == null) {
            this.setCellEditor(this.createDefaultCellEditor());
        }
        this.createdCellEditor = true;
    }

    protected void updateRenderer() {
        if (this.tree != null && this.tree.getCellRenderer() == null) {
            if (this.currentCellRenderer == null) {
                this.currentCellRenderer = this.createDefaultCellRenderer();
            }
            this.tree.setCellRenderer(this.currentCellRenderer);
        }
    }

    protected void configureLayoutCache() {
        this.treeState = this.createLayoutCache();
    }

    protected void updateSize() {
        this.preferredSize = null;
        this.updateCachedPreferredSize();
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        int n = 0;
        boolean bl = false;
        if (this.currentVisiblePath != null) {
            Object[] objectArray = this.currentVisiblePath.getPath();
            for (int i = 0; i < objectArray.length; ++i) {
                TreePath treePath = new TreePath(this.getPathToRoot(objectArray[i], 0));
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                if (this.treeModel != null) {
                    bl = this.treeModel.isLeaf(objectArray[i]);
                }
                if (!bl && this.hasControlIcons()) {
                    rectangle.width += this.getCurrentControlIcon(treePath).getIconWidth();
                }
                n = Math.max(n, rectangle.x + rectangle.width);
            }
            this.preferredSize = new Dimension(n, this.getRowHeight() * objectArray.length);
        } else {
            this.preferredSize = new Dimension(0, 0);
        }
        this.validCachedPreferredSize = true;
    }

    protected void pathWasExpanded(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.tree.revalidate();
        this.tree.repaint();
    }

    protected void pathWasCollapsed(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.tree.revalidate();
        this.tree.repaint();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tree, "Tree.background", "Tree.foreground", "Tree.font");
        this.tree.setOpaque(true);
        this.rightChildIndent = UIManager.getInt("Tree.rightChildIndent");
        this.leftChildIndent = UIManager.getInt("Tree.leftChildIndent");
        this.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(this.getRowHeight());
        this.tree.requestFocusInWindow(false);
        this.tree.setScrollsOnExpand(UIManager.getBoolean("Tree.scrollsOnExpand"));
        this.setExpandedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(UIManager.getIcon("Tree.collapsedIcon"));
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("Tree.focusInputMap");
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        this.action = new TreeAction(this);
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            inputMapUIResource.put(KeyStroke.getKeyStroke(keyStrokeArray[i].getKeyCode(), this.convertModifiers(keyStrokeArray[i].getModifiers())), (String)inputMap.get(keyStrokeArray[i]));
            inputMapUIResource.put(KeyStroke.getKeyStroke(keyStrokeArray[i].getKeyCode(), keyStrokeArray[i].getModifiers()), (String)inputMap.get(keyStrokeArray[i]));
            actionMapUIResource.put((String)inputMap.get(keyStrokeArray[i]), new ActionListenerProxy(this.action, (String)inputMap.get(keyStrokeArray[i])));
        }
        inputMapUIResource.setParent(this.tree.getInputMap(1).getParent());
        actionMapUIResource.setParent(this.tree.getActionMap().getParent());
        this.tree.getInputMap(1).setParent(inputMapUIResource);
        this.tree.getActionMap().setParent(actionMapUIResource);
    }

    private int convertModifiers(int n) {
        if ((n & 0x40) != 0) {
            n |= 1;
            n &= 0xFFFFFFBF;
        }
        if ((n & 0x80) != 0) {
            n |= 2;
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x100) != 0) {
            n |= 4;
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x200) != 0) {
            n |= 8;
            n &= 0xFFFFFDFF;
        }
        if ((n & 0x2000) != 0) {
            n |= 0x20;
            n &= 0xFFFFDFFF;
        }
        return n;
    }

    protected void installListeners() {
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        this.tree.addFocusListener(this.focusListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.addKeyListener(this.keyListener);
        this.tree.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.addComponentListener(this.componentListener);
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
    }

    public void installUI(JComponent jComponent) {
        TreePath treePath;
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        super.installUI(jComponent);
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
        this.setCellEditor(this.createDefaultCellEditor());
        this.createdCellEditor = true;
        this.isEditing = false;
        TreeModel treeModel = this.tree.getModel();
        this.setModel(treeModel);
        if (treeModel != null && !this.tree.isExpanded(treePath = new TreePath(treeModel.getRoot()))) {
            this.toggleExpandState(treePath);
        }
        this.treeSelectionModel = this.tree.getSelectionModel();
        this.completeUIInstall();
    }

    protected void uninstallDefaults() {
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.tree = null;
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        if (this.currentVisiblePath == null) {
            this.updateCurrentVisiblePath();
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = jTree.getInsets();
        if (rectangle != null && this.treeModel != null && this.currentVisiblePath != null) {
            int n = jTree.getClosestRowForLocation(rectangle.x, rectangle.y);
            int n2 = jTree.getClosestRowForLocation(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            this.paintVerticalPartOfLeg(graphics, rectangle, insets, this.currentVisiblePath);
            for (int i = n; i <= n2; ++i) {
                Object object = this.currentVisiblePath.getPathComponent(i);
                boolean bl = this.treeModel.isLeaf(object);
                TreePath treePath = new TreePath(this.getPathToRoot(object, 0));
                boolean bl2 = jTree.isExpanded(treePath);
                Rectangle rectangle2 = this.getPathBounds(jTree, treePath);
                this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, i, bl2, false, bl);
                this.paintRow(graphics, rectangle, insets, rectangle2, treePath, i, bl2, false, bl);
            }
        }
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        int n3;
        if (n < n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        for (n3 = n; n3 < n2; ++n3) {
            TreePath treePath = this.getPathForRow(this.tree, n3);
            if (this.tree.isVisible(treePath)) continue;
            this.tree.makeVisible(treePath);
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        return this.preferredMinSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, false);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        return this.preferredSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredMinSize();
        if (dimension == null) {
            return new Dimension();
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (jComponent instanceof JTree) {
            return ((JTree)jComponent).getPreferredSize();
        }
        return new Dimension();
    }

    protected void completeEditing() {
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            this.getCellEditor().stopCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (bl2) {
            this.getCellEditor().cancelCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (bl3) {
            this.treeModel.valueForPathChanged(this.tree.getLeadSelectionPath(), this.newVal);
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent == null) {
            object = this.getPathBounds(this.tree, treePath);
            int n = ((Rectangle)object).x;
            int n2 = ((Rectangle)object).y;
        } else {
            int n = mouseEvent.getX();
            int n3 = mouseEvent.getY();
        }
        this.updateCellEditor();
        object = this.getCellEditor();
        if (object != null && object.shouldSelectCell(mouseEvent) && object.isCellEditable(mouseEvent)) {
            this.editingPath = treePath;
            this.editingRow = this.tree.getRowForPath(this.editingPath);
            Object object2 = this.editingPath.getLastPathComponent();
            this.cellEditor.addCellEditorListener(this.cellEditorListener);
            this.stopEditingInCompleteEditing = false;
            boolean bl = this.tree.isExpanded(this.editingPath);
            this.isEditing = true;
            this.editingComponent = object.getTreeCellEditorComponent(this.tree, object2, true, bl, this.isLeaf(this.editingRow), this.editingRow);
            this.editingComponent.getParent().setVisible(true);
            this.editingComponent.getParent().validate();
            this.tree.add(this.editingComponent.getParent());
            this.editingComponent.getParent().validate();
            this.validCachedPreferredSize = false;
            this.tree.revalidate();
            ((JTextField)this.editingComponent).requestFocusInWindow(false);
            this.editorTimer.start();
            return true;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        if (this.isLocationInExpandControl(treePath, n, n2)) {
            this.toggleExpandState(treePath);
        }
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        boolean bl = false;
        int n3 = this.getRowForPath(this.tree, treePath);
        if (!this.isLeaf(n3)) {
            Rectangle rectangle = this.getPathBounds(this.tree, treePath);
            if (this.hasControlIcons() && n < rectangle.x && n > rectangle.x - this.getCurrentControlIcon(treePath).getIconWidth() - this.gap) {
                bl = true;
            }
        }
        return bl;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.toggleExpandState(treePath);
    }

    protected void toggleExpandState(TreePath treePath) {
        if (this.tree.isExpanded(treePath)) {
            this.tree.collapsePath(treePath);
        } else {
            this.tree.expandPath(treePath);
        }
        this.updateCurrentVisiblePath();
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return this.tree.getSelectionModel().getSelectionMode() == 1;
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return this.tree.getSelectionModel().getSelectionMode() == 2;
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        return true;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
                this.tree.setAnchorSelectionPath(treePath);
            }
        } else if (this.isMultiSelectEvent(mouseEvent)) {
            TreePath treePath2 = this.tree.getAnchorSelectionPath();
            if (treePath2 != null) {
                int n = this.getRowForPath(this.tree, treePath2);
                this.tree.addSelectionInterval(n, this.getRowForPath(this.tree, treePath));
            } else {
                this.tree.addSelectionPath(treePath);
            }
        } else {
            this.tree.addSelectionPath(treePath);
        }
    }

    protected boolean isLeaf(int n) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        return this.treeModel.isLeaf(object);
    }

    boolean hasControlIcons() {
        return this.expandedIcon != null || this.collapsedIcon != null;
    }

    Icon getCurrentControlIcon(TreePath treePath) {
        if (this.tree.isExpanded(treePath)) {
            return this.expandedIcon;
        }
        return this.collapsedIcon;
    }

    Object getParent(Object object, Object object2) {
        if (object == null || object2 == null || object.equals(object2)) {
            return null;
        }
        if (object2 instanceof TreeNode) {
            return ((TreeNode)object2).getParent();
        }
        return this.findNode(object, object2);
    }

    private Object findNode(Object object, Object object2) {
        if (!this.treeModel.isLeaf(object) && !object.equals(object2)) {
            int n = this.treeModel.getChildCount(object);
            for (int i = 0; i < n; ++i) {
                Object object3 = this.treeModel.getChild(object, i);
                if (object2.equals(object3)) {
                    return object;
                }
                Object object4 = this.findNode(object3, object2);
                if (object4 == null) continue;
                return object4;
            }
        }
        return null;
    }

    Object getPreviousVisibleNode(Object object) {
        if (this.currentVisiblePath != null) {
            int n;
            Object[] objectArray = this.currentVisiblePath.getPath();
            for (n = 0; n < objectArray.length && !object.equals(objectArray[n]); ++n) {
            }
            if (n - 1 >= 0) {
                return objectArray[n - 1];
            }
        }
        return null;
    }

    Object getNextNode(Object object) {
        if (!this.treeModel.isLeaf(object) && this.treeModel.getChildCount(object) > 0) {
            return this.treeModel.getChild(object, 0);
        }
        Object object2 = object;
        Object object3 = null;
        do {
            object3 = this.getNextSibling(object2);
            object2 = this.getParent(this.treeModel.getRoot(), object2);
        } while (object3 == null && object2 != null);
        return object3;
    }

    Object getPreviousNode(Object object) {
        Object object2 = this.getParent(this.treeModel.getRoot(), object);
        if (object2 == null) {
            return null;
        }
        Object object3 = this.getPreviousSibling(object);
        if (object3 == null) {
            return object2;
        }
        int n = 0;
        if (!this.treeModel.isLeaf(object3)) {
            n = this.treeModel.getChildCount(object3);
        }
        while (n > 0) {
            if (!this.treeModel.isLeaf(object3 = this.treeModel.getChild(object3, n - 1))) {
                n = this.treeModel.getChildCount(object3);
                continue;
            }
            n = 0;
        }
        return object3;
    }

    Object getNextSibling(Object object) {
        Object object2 = this.getParent(this.treeModel.getRoot(), object);
        if (object2 == null) {
            return null;
        }
        int n = this.treeModel.getIndexOfChild(object2, object) + 1;
        int n2 = 0;
        if (!this.treeModel.isLeaf(object2)) {
            n2 = this.treeModel.getChildCount(object2);
        }
        if (n == 0 || n >= n2) {
            return null;
        }
        return this.treeModel.getChild(object2, n);
    }

    Object getPreviousSibling(Object object) {
        Object object2 = this.getParent(this.treeModel.getRoot(), object);
        if (object2 == null) {
            return null;
        }
        int n = this.treeModel.getIndexOfChild(object2, object) - 1;
        int n2 = 0;
        if (!this.treeModel.isLeaf(object2)) {
            n2 = this.treeModel.getChildCount(object2);
        }
        if (n < 0 || n >= n2) {
            return null;
        }
        return this.treeModel.getChild(object2, n);
    }

    void selectPath(JTree jTree, TreePath treePath) {
        if (treePath != null) {
            if (jTree.getSelectionModel().getSelectionMode() == 1) {
                jTree.getSelectionModel().clearSelection();
                jTree.addSelectionPath(treePath);
                jTree.setLeadSelectionPath(treePath);
            } else if (jTree.getSelectionModel().getSelectionMode() != 2) {
                jTree.addSelectionPath(treePath);
                jTree.setLeadSelectionPath(treePath);
                jTree.getSelectionModel().setSelectionMode(4);
            }
        }
    }

    Object[] getPathToRoot(Object object, int n) {
        if (object == null) {
            if (n == 0) {
                return null;
            }
            return new Object[n];
        }
        Object[] objectArray = this.getPathToRoot(this.getParent(this.treeModel.getRoot(), object), n + 1);
        objectArray[objectArray.length - n - 1] = object;
        return objectArray;
    }

    int getLevel(Object object) {
        int n = -1;
        Object object2 = object;
        if (this.treeModel != null) {
            Object object3 = this.treeModel.getRoot();
            if (!this.tree.isRootVisible() && this.tree.isExpanded(new TreePath(object3))) {
                --n;
            }
            do {
                object2 = this.getParent(object3, object2);
                ++n;
            } while (object2 != null);
        }
        return n;
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n, n2, n, n3);
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n2, n, n3, n);
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        n2 -= icon.getIconHeight() / 2;
        if ((n -= icon.getIconWidth() / 2) < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        icon.paintIcon(component, graphics, n, n2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        for (int i = n2; i < n3; i += 2) {
            graphics.drawLine(i, n, i + 1, n);
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        for (int i = n2; i < n3; i += 2) {
            graphics.drawLine(n, i, n, i + 1);
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.shouldPaintExpandControl(treePath, n, bl, bl2, bl3)) {
            Icon icon = this.getCurrentControlIcon(treePath);
            int n2 = icon.getIconWidth();
            int n3 = rectangle2.x - this.rightChildIndent + n2 / 2;
            if (n3 + n2 > rectangle2.x) {
                n3 = rectangle2.x - this.rightChildIndent - this.gap;
            }
            icon.paintIcon(this.tree, graphics, n3, rectangle2.y + rectangle2.height / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (n != 0) {
            this.paintHorizontalLine(graphics, this.tree, rectangle2.y + rectangle2.height / 2, rectangle2.x - this.gap - 2, rectangle2.x);
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        int n = this.tree.getVisibleRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = treePath.getPathComponent(i);
            TreePath treePath2 = new TreePath(this.getPathToRoot(object, 0));
            int n2 = this.treeModel.getChildCount(object);
            if (n2 <= 0 || !this.tree.isExpanded(treePath2)) continue;
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath2);
            Rectangle rectangle3 = this.getPathBounds(this.tree, new TreePath(this.getPathToRoot(this.treeModel.getChild(object, n2 - 1), 0)));
            this.paintVerticalLine(graphics, this.tree, rectangle2.x + this.gap + 2, rectangle2.y + rectangle2.height - 2, rectangle3.y + rectangle3.height / 2);
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.tree.isPathSelected(treePath);
        boolean bl5 = false;
        Object object = treePath.getLastPathComponent();
        if (this.tree.isVisible(treePath)) {
            if (!this.validCachedPreferredSize) {
                this.updateCachedPreferredSize();
            }
            this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            if (n != 0) {
                rectangle2.x += this.gap;
            }
            rectangle2.width = this.preferredSize.width + rectangle2.x;
            if (this.editingComponent != null && this.editingPath != null && this.isEditing(this.tree) && object.equals(this.editingPath.getLastPathComponent())) {
                this.rendererPane.paintComponent(graphics, this.editingComponent.getParent(), null, rectangle2);
            } else {
                TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                if (treeCellRenderer == null) {
                    treeCellRenderer = this.createDefaultCellRenderer();
                }
                Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, object, bl4, bl, bl3, n, this.tree.hasFocus());
                this.rendererPane.paintComponent(graphics, component, component.getParent(), rectangle2);
            }
        }
    }

    protected void prepareForUIUninstall() {
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        return !bl3 && this.getLevel(object) != 0 && this.hasControlIcons();
    }

    void updateCurrentVisiblePath() {
        if (this.treeModel == null) {
            return;
        }
        Object object = this.treeModel.getRoot();
        TreePath treePath = new TreePath(object);
        Rectangle rectangle = this.getPathBounds(this.tree, treePath);
        if (rectangle.width == 0 && rectangle.height == 0 || !this.isRootVisible() && this.tree.isExpanded(new TreePath(object))) {
            object = this.getNextNode(object);
            treePath = new TreePath(object);
        }
        Object object2 = object;
        TreePath treePath2 = null;
        while (object != null) {
            treePath2 = treePath2 == null ? treePath : treePath2.pathByAddingChild(object);
            do {
                TreePath treePath3;
                if (this.tree.isVisible(treePath3 = new TreePath(this.getPathToRoot(object, 0))) && this.tree.isExpanded(treePath3) || this.treeModel.isLeaf(object)) {
                    object = this.getNextNode(object);
                    continue;
                }
                Object object3 = object;
                if ((object = this.getNextSibling(object3)) != null) continue;
                Object object4 = this.getParent(object2, object3);
                while (object == null && object4 != null) {
                    object = this.getNextSibling(object4);
                    if (object != null) continue;
                    object4 = this.getParent(object2, object4);
                }
            } while (object != null && !this.tree.isVisible(new TreePath(this.getPathToRoot(object, 0))));
        }
        this.currentVisiblePath = treePath2;
        this.tree.setVisibleRowCount(this.getRowCount(this.tree));
        if (this.tree.getSelectionModel() != null && this.tree.getSelectionCount() == 0 && this.currentVisiblePath != null) {
            this.selectPath(this.tree, new TreePath(this.getPathToRoot(this.currentVisiblePath.getPathComponent(0), 0)));
        }
    }

    Object getNextVisibleNode(Object object) {
        if (this.currentVisiblePath != null) {
            int n;
            Object[] objectArray = this.currentVisiblePath.getPath();
            for (n = 0; n < objectArray.length && !object.equals(objectArray[n]); ++n) {
            }
            if (n + 1 < objectArray.length) {
                return objectArray[n + 1];
            }
        }
        return null;
    }

    public class TreeTraverseAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreeTraverseAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = this.this$0.tree.getLeadSelectionPath().getLastPathComponent();
            if (actionEvent.getActionCommand().equals("selectParent")) {
                TreePath treePath = new TreePath(this.this$0.getPathToRoot(object, 0));
                Object object2 = this.this$0.getParent(this.this$0.treeModel.getRoot(), object);
                if (!this.this$0.treeModel.isLeaf(object)) {
                    this.this$0.toggleExpandState(treePath);
                } else if (object2 != null) {
                    this.this$0.selectPath(this.this$0.tree, new TreePath(this.this$0.getPathToRoot(object2, 0)));
                }
            } else if (actionEvent.getActionCommand().equals("selectChild")) {
                TreePath treePath = new TreePath(this.this$0.getPathToRoot(object, 0));
                if (!this.this$0.treeModel.isLeaf(object)) {
                    this.this$0.toggleExpandState(treePath);
                } else {
                    Object object3 = this.this$0.getNextVisibleNode(object);
                    if (object3 != null) {
                        this.this$0.selectPath(this.this$0.tree, new TreePath(this.this$0.getPathToRoot(object3, 0)));
                    }
                }
            }
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeToggleAction(BasicTreeUI basicTreeUI, String string) {
            this.this$0 = basicTreeUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeSelectionHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (this.this$0.tree.isEditing()) {
                this.this$0.tree.cancelEditing();
            }
        }
    }

    public class TreePageAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreePageAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
            this.direction = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeModelHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.updateCurrentVisiblePath();
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.updateCurrentVisiblePath();
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.updateCurrentVisiblePath();
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getPath().length == 1 && !treeModelEvent.getPath()[0].equals(this.this$0.treeModel.getRoot())) {
                this.this$0.tree.expandPath(new TreePath(this.this$0.treeModel.getRoot()));
            }
            this.this$0.updateCurrentVisiblePath();
            this.this$0.validCachedPreferredSize = false;
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreeIncrementAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2 = this.this$0.tree.getLeadSelectionPath().getLastPathComponent();
            if (actionEvent.getActionCommand().equals("selectPreviousChangeLead")) {
                Object object3 = this.this$0.getPreviousVisibleNode(object2);
                if (object3 != null) {
                    TreePath treePath = new TreePath(this.this$0.getPathToRoot(object3, 0));
                    this.this$0.selectPath(this.this$0.tree, treePath);
                    this.this$0.tree.setLeadSelectionPath(treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectPreviousExtendSelection")) {
                Object object4 = this.this$0.getPreviousVisibleNode(object2);
                if (object4 != null) {
                    TreePath treePath = new TreePath(this.this$0.getPathToRoot(object4, 0));
                    this.this$0.tree.addSelectionPath(treePath);
                    this.this$0.tree.setLeadSelectionPath(treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectPrevious")) {
                Object object5 = this.this$0.getPreviousVisibleNode(object2);
                if (object5 != null) {
                    TreePath treePath = new TreePath(this.this$0.getPathToRoot(object5, 0));
                    this.this$0.selectPath(this.this$0.tree, treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectNext")) {
                Object object6 = this.this$0.getNextVisibleNode(object2);
                if (object6 != null) {
                    TreePath treePath = new TreePath(this.this$0.getPathToRoot(object6, 0));
                    this.this$0.selectPath(this.this$0.tree, treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectNextExtendSelection")) {
                Object object7 = this.this$0.getNextVisibleNode(object2);
                if (object7 != null) {
                    TreePath treePath = new TreePath(this.this$0.getPathToRoot(object7, 0));
                    this.this$0.tree.addSelectionPath(treePath);
                    this.this$0.tree.setLeadSelectionPath(treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectNextChangeLead") && (object = this.this$0.getNextVisibleNode(object2)) != null) {
                TreePath treePath = new TreePath(this.this$0.getPathToRoot(object, 0));
                this.this$0.selectPath(this.this$0.tree, treePath);
                this.this$0.tree.setLeadSelectionPath(treePath);
            }
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;
        protected int direction;

        public TreeHomeAction(BasicTreeUI basicTreeUI, int n, String string) {
            this.this$0 = basicTreeUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeExpansionHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.updateCurrentVisiblePath();
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.this$0.validCachedPreferredSize = false;
            this.this$0.updateCurrentVisiblePath();
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;

        public TreeCancelEditingAction(BasicTreeUI basicTreeUI, String string) {
            this.this$0 = basicTreeUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTreeUI this$0;

        public SelectionModelPropertyChangeHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicTreeUI this$0;

        public PropertyChangeHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("rootVisible")) {
                this.this$0.validCachedPreferredSize = false;
                this.this$0.updateCurrentVisiblePath();
                this.this$0.tree.revalidate();
                this.this$0.tree.repaint();
            }
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        private /* synthetic */ BasicTreeUI this$0;

        public NodeDimensionsHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (rectangle == null || object == null) {
                return null;
            }
            String string = object.toString();
            Font font = this.this$0.tree.getFont();
            FontMetrics fontMetrics = this.this$0.tree.getToolkit().getFontMetrics(font);
            if (string != null) {
                rectangle.x = this.getRowX(n, n2);
                rectangle.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle.height = fontMetrics.getHeight();
            }
            return rectangle;
        }

        protected int getRowX(int n, int n2) {
            if (n == 0) {
                return 0;
            }
            return n2 * this.this$0.rightChildIndent;
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        private /* synthetic */ BasicTreeUI this$0;
        protected Component source;
        protected Component destination;

        public MouseInputHandler(BasicTreeUI basicTreeUI, Component component, Component component2, MouseEvent mouseEvent) {
            this.this$0 = basicTreeUI;
            this.source = component;
            this.destination = component2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected void removeFromSource() {
        }
    }

    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ BasicTreeUI this$0;

        public MouseHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            TreePath treePath = this.this$0.getClosestPathForLocation(this.this$0.tree, point.x, point.y);
            if (treePath != null) {
                boolean bl;
                Icon icon;
                Rectangle rectangle = this.this$0.getPathBounds(this.this$0.tree, treePath);
                int n = this.this$0.getRowForPath(this.this$0.tree, treePath);
                boolean bl2 = this.this$0.isLocationInExpandControl(treePath, point.x, point.y);
                boolean bl3 = this.this$0.isLeaf(n);
                TreeCellRenderer treeCellRenderer = this.this$0.getCellRenderer();
                Icon icon2 = bl3 ? UIManager.getIcon("Tree.leafIcon") : (this.this$0.tree.isExpanded(treePath) ? UIManager.getIcon("Tree.openIcon") : UIManager.getIcon("Tree.closedIcon"));
                if (treeCellRenderer instanceof DefaultTreeCellRenderer && (icon = ((DefaultTreeCellRenderer)treeCellRenderer).getIcon()) != null) {
                    icon2 = icon;
                }
                if (icon2 != null) {
                    rectangle.width += icon2.getIconWidth() + this.this$0.gap * 2;
                }
                if (((bl = rectangle.contains(point.x, point.y)) || bl2) && this.this$0.tree.isVisible(treePath)) {
                    if (bl) {
                        this.this$0.selectPath(this.this$0.tree, treePath);
                        if (mouseEvent.getClickCount() == 2 && !this.this$0.isLeaf(n)) {
                            this.this$0.toggleExpandState(treePath);
                        }
                    }
                    if (bl2) {
                        this.this$0.handleExpandControlClick(treePath, point.x, point.y);
                        if (this.this$0.cellEditor != null) {
                            this.this$0.cellEditor.cancelCellEditing();
                        }
                        this.this$0.tree.scrollPathToVisible(treePath);
                    } else if (this.this$0.tree.isEditable()) {
                        this.this$0.startEditing(treePath, mouseEvent);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        private /* synthetic */ BasicTreeUI this$0;
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public KeyHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicTreeUI this$0;

        public FocusHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        private /* synthetic */ BasicTreeUI this$0;

        public CellEditorHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void editingStopped(ChangeEvent changeEvent) {
            this.this$0.editingPath = null;
            this.this$0.editingRow = -1;
            this.this$0.stopEditingInCompleteEditing = false;
            if (this.this$0.editingComponent != null) {
                this.this$0.tree.remove(this.this$0.editingComponent.getParent());
                this.this$0.editingComponent = null;
            }
            if (this.this$0.cellEditor != null) {
                this.this$0.newVal = ((JTextField)this.this$0.getCellEditor().getCellEditorValue()).getText();
                this.this$0.completeEditing(false, false, true);
                if (this.this$0.cellEditor instanceof DefaultTreeCellEditor) {
                    this.this$0.tree.removeTreeSelectionListener((DefaultTreeCellEditor)this.this$0.cellEditor);
                }
                this.this$0.cellEditor.removeCellEditorListener(this.this$0.cellEditorListener);
                this.this$0.setCellEditor(null);
                this.this$0.createdCellEditor = false;
            }
            this.this$0.isEditing = false;
            this.this$0.tree.requestFocusInWindow(false);
            this.this$0.editorTimer.stop();
            this.this$0.validCachedPreferredSize = false;
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            this.this$0.editingPath = null;
            this.this$0.editingRow = -1;
            this.this$0.stopEditingInCompleteEditing = false;
            if (this.this$0.editingComponent != null) {
                this.this$0.tree.remove(this.this$0.editingComponent.getParent());
            }
            this.this$0.editingComponent = null;
            if (this.this$0.cellEditor != null) {
                if (this.this$0.cellEditor instanceof DefaultTreeCellEditor) {
                    this.this$0.tree.removeTreeSelectionListener((DefaultTreeCellEditor)this.this$0.cellEditor);
                }
                this.this$0.cellEditor.removeCellEditorListener(this.this$0.cellEditorListener);
                this.this$0.setCellEditor(null);
                this.this$0.createdCellEditor = false;
            }
            this.this$0.tree.requestFocusInWindow(false);
            this.this$0.editorTimer.stop();
            this.this$0.isEditing = false;
            this.this$0.validCachedPreferredSize = false;
            this.this$0.tree.revalidate();
            this.this$0.tree.repaint();
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        private /* synthetic */ BasicTreeUI this$0;
        protected Timer timer;
        protected JScrollBar scrollBar;

        public ComponentHandler(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }

        public void componentMoved(ComponentEvent componentEvent) {
        }

        protected void startTimer() {
        }

        protected JScrollPane getScrollPane() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private class EditorUpdateTimer
    extends Timer
    implements ActionListener {
        private /* synthetic */ BasicTreeUI this$0;

        public EditorUpdateTimer(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
            super(300, null);
            this.addActionListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Caret caret = ((JTextField)this.this$0.editingComponent).getCaret();
            if (caret != null) {
                caret.setVisible(caret.isVisible() ^ true);
            }
            this.this$0.tree.repaint();
        }

        public void update() {
            this.stop();
            Caret caret = ((JTextField)this.this$0.editingComponent).getCaret();
            if (caret != null) {
                this.setDelay(caret.getBlinkRate());
                if (((JTextField)this.this$0.editingComponent).isEditable()) {
                    this.start();
                } else {
                    caret.setVisible(false);
                }
            }
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }
    }

    class TreeAction
    extends AbstractAction {
        private /* synthetic */ BasicTreeUI this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = this.this$0.tree.getLeadSelectionPath();
            if (actionEvent.getActionCommand().equals("selectPreviousChangeLead") || actionEvent.getActionCommand().equals("selectPreviousExtendSelection") || actionEvent.getActionCommand().equals("selectPrevious") || actionEvent.getActionCommand().equals("selectNext") || actionEvent.getActionCommand().equals("selectNextExtendSelection") || actionEvent.getActionCommand().equals("selectNextChangeLead")) {
                new TreeIncrementAction(this.this$0, 0, "").actionPerformed(actionEvent);
            } else if (actionEvent.getActionCommand().equals("selectParent") || actionEvent.getActionCommand().equals("selectChild")) {
                new TreeTraverseAction(this.this$0, 0, "").actionPerformed(actionEvent);
            } else if (actionEvent.getActionCommand().equals("selectAll")) {
                TreePath[] treePathArray = new TreePath[this.this$0.tree.getVisibleRowCount()];
                Object object = this.this$0.getNextVisibleNode(this.this$0.treeModel.getRoot());
                for (int i = 0; object != null && i < treePathArray.length; ++i) {
                    treePathArray[i] = new TreePath(this.this$0.getPathToRoot(object, 0));
                }
                this.this$0.tree.addSelectionPaths(treePathArray);
            } else if (actionEvent.getActionCommand().equals("startEditing")) {
                this.this$0.tree.startEditingAtPath(treePath);
            } else if (actionEvent.getActionCommand().equals("toggle")) {
                if (this.this$0.tree.isEditing()) {
                    this.this$0.tree.stopEditing();
                } else {
                    Object object = treePath.getLastPathComponent();
                    TreePath treePath2 = new TreePath(this.this$0.getPathToRoot(object, 0));
                    if (!this.this$0.treeModel.isLeaf(object)) {
                        this.this$0.toggleExpandState(treePath2);
                    }
                }
            } else if (actionEvent.getActionCommand().equals("clearSelection")) {
                this.this$0.tree.clearSelection();
            }
            if (this.this$0.tree.isEditing() && !actionEvent.getActionCommand().equals("startEditing")) {
                this.this$0.tree.cancelEditing();
            }
            this.this$0.tree.scrollPathToVisible(treePath);
        }

        TreeAction(BasicTreeUI basicTreeUI) {
            this.this$0 = basicTreeUI;
        }
    }
}

