/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;

public class BasicSliderUI
extends SliderUI {
    protected ChangeListener changeListener;
    protected PropertyChangeListener propertyChangeListener;
    protected ScrollListener scrollListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected TrackListener trackListener;
    protected Insets focusInsets;
    protected Insets insetCache;
    protected Rectangle contentRect;
    protected Rectangle focusRect;
    protected Rectangle thumbRect;
    protected Rectangle tickRect;
    protected Rectangle labelRect;
    protected Rectangle trackRect;
    public static final int MAX_SCROLL = 2;
    public static final int MIN_SCROLL = -2;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int POSITIVE_SCROLL = 1;
    protected int trackBuffer;
    protected boolean leftToRightCache;
    protected Timer scrollTimer;
    protected JSlider slider;
    private transient Color shadowColor;
    private transient Color highlightColor;
    private transient Color focusColor;

    public BasicSliderUI(JSlider jSlider) {
    }

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicSliderUI((JSlider)jComponent);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        if (jComponent instanceof JSlider) {
            this.slider = (JSlider)jComponent;
            this.focusRect = new Rectangle();
            this.contentRect = new Rectangle();
            this.thumbRect = new Rectangle();
            this.trackRect = new Rectangle();
            this.tickRect = new Rectangle();
            this.labelRect = new Rectangle();
            this.insetCache = this.slider.getInsets();
            this.leftToRightCache = this.slider.getInverted() ^ true;
            this.scrollTimer = new Timer(200, null);
            this.scrollTimer.setRepeats(true);
            this.installDefaults(this.slider);
            this.installListeners(this.slider);
            this.installKeyboardActions(this.slider);
            this.calculateFocusRect();
            this.calculateContentRect();
            this.calculateThumbSize();
            this.calculateTrackBuffer();
            this.calculateTrackRect();
            this.calculateThumbLocation();
            this.calculateTickRect();
            this.calculateLabelRect();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallKeyboardActions(this.slider);
        this.uninstallListeners(this.slider);
        this.scrollTimer = null;
        this.focusRect = null;
        this.contentRect = null;
        this.thumbRect = null;
        this.trackRect = null;
        this.tickRect = null;
        this.labelRect = null;
        this.focusInsets = null;
    }

    protected void installDefaults(JSlider jSlider) {
        LookAndFeel.installColors(jSlider, "Slider.background", "Slider.foreground");
        LookAndFeel.installBorder(jSlider, "Slider.border");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.focusColor = UIManager.getColor("Slider.focus");
        this.focusInsets = UIManager.getInsets("Slider.focusInsets");
        jSlider.setOpaque(true);
    }

    protected TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener(this);
    }

    protected ChangeListener createChangeListener(JSlider jSlider) {
        return new ChangeHandler(this);
    }

    protected ComponentListener createComponentListener(JSlider jSlider) {
        return new ComponentHandler(this);
    }

    protected FocusListener createFocusListener(JSlider jSlider) {
        return new FocusHandler(this);
    }

    protected ScrollListener createScrollListener(JSlider jSlider) {
        return new ScrollListener(this);
    }

    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return new PropertyChangeHandler(this);
    }

    protected void installListeners(JSlider jSlider) {
        this.propertyChangeListener = this.createPropertyChangeListener(jSlider);
        this.componentListener = this.createComponentListener(jSlider);
        this.trackListener = this.createTrackListener(jSlider);
        this.focusListener = this.createFocusListener(jSlider);
        this.changeListener = this.createChangeListener(jSlider);
        this.scrollListener = this.createScrollListener(jSlider);
        jSlider.addPropertyChangeListener(this.propertyChangeListener);
        jSlider.addComponentListener(this.componentListener);
        jSlider.addMouseListener(this.trackListener);
        jSlider.addMouseMotionListener(this.trackListener);
        jSlider.addFocusListener(this.focusListener);
        jSlider.getModel().addChangeListener(this.changeListener);
        this.scrollTimer.addActionListener(this.scrollListener);
    }

    protected void uninstallListeners(JSlider jSlider) {
        jSlider.removePropertyChangeListener(this.propertyChangeListener);
        jSlider.removeComponentListener(this.componentListener);
        jSlider.removeMouseListener(this.trackListener);
        jSlider.removeMouseMotionListener(this.trackListener);
        jSlider.removeFocusListener(this.focusListener);
        jSlider.getModel().removeChangeListener(this.changeListener);
        this.scrollTimer.removeActionListener(this.scrollListener);
        this.propertyChangeListener = null;
        this.componentListener = null;
        this.trackListener = null;
        this.focusListener = null;
        this.changeListener = null;
        this.scrollListener = null;
    }

    protected void installKeyboardActions(JSlider jSlider) {
    }

    protected void uninstallKeyboardActions(JSlider jSlider) {
    }

    public Dimension getPreferredHorizontalSize() {
        Insets insets = this.slider.getInsets();
        int n = this.getWidthOfWidestLabel() * (this.slider.getLabelTable() == null ? 0 : this.slider.getLabelTable().size());
        if (n < 200) {
            n = 200;
        }
        n += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right;
        int n2 = this.getThumbSize().height;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            n2 += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            n2 += this.getHeightOfTallestLabel();
        }
        return new Dimension(n, n2 += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom);
    }

    public Dimension getPreferredVerticalSize() {
        Insets insets = this.slider.getInsets();
        int n = this.getHeightOfTallestLabel() * (this.slider.getLabelTable() == null ? 0 : this.slider.getLabelTable().size());
        if (n < 200) {
            n = 200;
        }
        n += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom;
        int n2 = this.getThumbSize().width;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            n2 += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            n2 += this.getWidthOfWidestLabel();
        }
        return new Dimension(n2 += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right, n);
    }

    public Dimension getMinimumHorizontalSize() {
        Insets insets = this.slider.getInsets();
        int n = this.getThumbSize().height;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            n += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            n += this.getHeightOfTallestLabel();
        }
        return new Dimension(36, n += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom);
    }

    public Dimension getMinimumVerticalSize() {
        Insets insets = this.slider.getInsets();
        int n = this.getThumbSize().width;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            n += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            n += this.getWidthOfWidestLabel();
        }
        return new Dimension(n += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right, 36);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.slider.getOrientation() == 0) {
            return this.getPreferredHorizontalSize();
        }
        return this.getPreferredVerticalSize();
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.slider.getOrientation() == 0) {
            return this.getMinimumHorizontalSize();
        }
        return this.getMinimumVerticalSize();
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Insets insets = this.slider.getInsets();
        if (this.slider.getOrientation() == 0) {
            int n = this.getThumbSize().height;
            if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
                n += this.getTickLength();
            }
            if (this.slider.getPaintLabels()) {
                n += this.getHeightOfTallestLabel();
            }
            return new Dimension(Short.MAX_VALUE, n += insets.top + insets.bottom + this.focusInsets.top + this.focusInsets.bottom);
        }
        int n = this.getThumbSize().width;
        if (this.slider.getPaintTicks() && this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0) {
            n += this.getTickLength();
        }
        if (this.slider.getPaintLabels()) {
            n += this.getWidthOfWidestLabel();
        }
        return new Dimension(n += insets.left + insets.right + this.focusInsets.left + this.focusInsets.right, Short.MAX_VALUE);
    }

    protected void calculateGeometry() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateTickRect();
        this.calculateLabelRect();
        this.calculateThumbLocation();
    }

    protected void calculateFocusRect() {
        this.insetCache = this.slider.getInsets();
        this.focusRect = SwingUtilities.calculateInnerArea(this.slider, this.focusRect);
        if (this.focusRect.width < 0) {
            this.focusRect.width = 0;
        }
        if (this.focusRect.height < 0) {
            this.focusRect.height = 0;
        }
    }

    protected void calculateThumbSize() {
        Dimension dimension = this.getThumbSize();
        this.thumbRect.width = dimension.width;
        this.thumbRect.height = dimension.height;
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.y = this.trackRect.y;
        } else {
            this.thumbRect.x = this.trackRect.x;
        }
    }

    protected void calculateContentRect() {
        this.contentRect.x = this.focusRect.x + this.focusInsets.left;
        this.contentRect.y = this.focusRect.y + this.focusInsets.top;
        this.contentRect.width = this.focusRect.width - this.focusInsets.left - this.focusInsets.right;
        this.contentRect.height = this.focusRect.height - this.focusInsets.top - this.focusInsets.bottom;
        if (this.contentRect.width < 0) {
            this.contentRect.width = 0;
        }
        if (this.contentRect.height < 0) {
            this.contentRect.height = 0;
        }
    }

    protected void calculateThumbLocation() {
        int n = this.slider.getValue();
        if (this.slider.getOrientation() == 0) {
            this.thumbRect.x = this.xPositionForValue(n) - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y;
        } else {
            this.thumbRect.x = this.trackRect.x;
            this.thumbRect.y = this.yPositionForValue(n) - this.thumbRect.height / 2;
        }
    }

    protected void calculateTrackBuffer() {
        this.trackBuffer = this.slider.getOrientation() == 0 ? this.thumbRect.width / 2 : this.thumbRect.height / 2;
    }

    protected Dimension getThumbSize() {
        if (this.slider.getOrientation() == 0) {
            return new Dimension(11, 20);
        }
        return new Dimension(20, 11);
    }

    protected void calculateTrackRect() {
        if (this.slider.getOrientation() == 0) {
            this.trackRect.x = this.contentRect.x + this.trackBuffer;
            int n = this.getThumbSize().height;
            if (this.slider.getPaintTicks() && (this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0)) {
                n += this.getTickLength();
            }
            this.trackRect.y = this.contentRect.y + (this.contentRect.height - n) / 2 - 1;
            this.trackRect.width = this.contentRect.width - 2 * this.trackBuffer;
            this.trackRect.height = this.thumbRect.height;
        } else {
            int n = this.getThumbSize().width;
            if (this.slider.getPaintTicks() && (this.slider.getMajorTickSpacing() > 0 || this.slider.getMinorTickSpacing() > 0)) {
                n += this.getTickLength();
            }
            this.trackRect.x = this.contentRect.x + (this.contentRect.width - n) / 2 - 1;
            this.trackRect.y = this.contentRect.y + this.trackBuffer;
            this.trackRect.width = this.thumbRect.width;
            this.trackRect.height = this.contentRect.height - 2 * this.trackBuffer;
        }
    }

    protected int getTickLength() {
        return 8;
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height;
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (this.tickRect.y + this.tickRect.height > this.contentRect.y + this.contentRect.height) {
                this.tickRect.height = this.contentRect.y + this.contentRect.height - this.tickRect.y;
            }
        } else {
            this.tickRect.x = this.trackRect.x + this.trackRect.width;
            this.tickRect.y = this.trackRect.y;
            this.tickRect.width = this.getTickLength();
            this.tickRect.height = this.trackRect.height;
            if (this.tickRect.x + this.tickRect.width > this.contentRect.x + this.contentRect.width) {
                this.tickRect.width = this.contentRect.x + this.contentRect.width - this.tickRect.x;
            }
        }
    }

    protected void calculateLabelRect() {
        if (this.slider.getOrientation() == 0) {
            this.labelRect.x = this.contentRect.x;
            this.labelRect.y = this.tickRect.y + this.tickRect.height;
            this.labelRect.width = this.contentRect.width;
            this.labelRect.height = this.contentRect.height - this.labelRect.y;
        } else {
            this.labelRect.x = this.tickRect.x + this.tickRect.width;
            this.labelRect.y = this.contentRect.y;
            this.labelRect.width = this.contentRect.width - this.labelRect.x;
            this.labelRect.height = this.contentRect.height;
        }
    }

    protected int getWidthOfWidestLabel() {
        int n = 0;
        if (this.slider.getLabelTable() == null) {
            return 0;
        }
        Enumeration enumeration = this.slider.getLabelTable().elements();
        while (enumeration.hasMoreElements()) {
            Component component;
            Dimension dimension;
            Object object = enumeration.nextElement();
            if (!(object instanceof Component) || (dimension = (component = (Component)object).getPreferredSize()) == null || dimension.width <= n) continue;
            n = dimension.width;
        }
        return n;
    }

    protected int getHeightOfTallestLabel() {
        int n = 0;
        if (this.slider.getLabelTable() == null) {
            return 0;
        }
        Enumeration enumeration = this.slider.getLabelTable().elements();
        while (enumeration.hasMoreElements()) {
            Component component;
            Dimension dimension;
            Object object = enumeration.nextElement();
            if (!(object instanceof Component) || (dimension = (component = (Component)object).getPreferredSize()) == null || dimension.height <= n) continue;
            n = dimension.height;
        }
        return n;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        if (component != null) {
            return component.getWidth();
        }
        return 0;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        if (component != null) {
            return component.getWidth();
        }
        return 0;
    }

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        if (component != null) {
            return component.getHeight();
        }
        return 0;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        if (component != null) {
            return component.getHeight();
        }
        return 0;
    }

    protected boolean drawInverted() {
        return this.slider.getInverted() ^ this.leftToRightCache ^ true;
    }

    protected Component getLowestValueLabel() {
        Integer n = new Integer(Integer.MAX_VALUE);
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary == null) {
            return null;
        }
        Object object = dictionary.keys();
        while (object.hasMoreElements()) {
            Integer n2;
            Object object2 = object.nextElement();
            if (!(object2 instanceof Integer) || (n2 = (Integer)object2) >= n) continue;
            n = n2;
        }
        object = dictionary.get(n);
        if (!(object instanceof Component)) {
            return null;
        }
        return (Component)object;
    }

    protected Component getHighestValueLabel() {
        Integer n = new Integer(Integer.MIN_VALUE);
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary == null) {
            return null;
        }
        Object object = dictionary.keys();
        while (object.hasMoreElements()) {
            Integer n2;
            Object object2 = object.nextElement();
            if (!(object2 instanceof Integer) || (n2 = (Integer)object2) <= n) continue;
            n = n2;
        }
        object = dictionary.get(n);
        if (!(object instanceof Component)) {
            return null;
        }
        return (Component)object;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        this.leftToRightCache = this.slider.getComponentOrientation() != ComponentOrientation.RIGHT_TO_LEFT;
        this.calculateGeometry();
        if (this.slider.getPaintTrack()) {
            this.paintTrack(graphics);
        }
        if (this.slider.getPaintTicks()) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels()) {
            this.paintLabels(graphics);
        }
        this.paintThumb(graphics);
    }

    protected void recalculateIfInsetsChanged() {
        this.calculateFocusRect();
        this.calculateContentRect();
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateThumbLocation();
        this.calculateTickRect();
        this.calculateLabelRect();
    }

    protected void recalculateIfOrientationChanged() {
        this.calculateThumbSize();
        this.calculateTrackBuffer();
        this.calculateTrackRect();
        this.calculateThumbLocation();
        this.calculateTickRect();
        this.calculateLabelRect();
    }

    public void paintFocus(Graphics graphics) {
        Color color = graphics.getColor();
        graphics.setColor(this.getFocusColor());
        graphics.drawRect(this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
        graphics.setColor(color);
    }

    public void paintTrack(Graphics graphics) {
        int n;
        int n2;
        Color color = graphics.getColor();
        Point point = new Point(this.trackRect.x, this.trackRect.y);
        Point point2 = new Point(point);
        Point point3 = new Point(point);
        Point point4 = new Point(point);
        if (this.slider.getOrientation() == 0) {
            n2 = this.trackRect.width;
            n = this.thumbRect.height / 4 == 0 ? 1 : this.thumbRect.height / 4;
            point.translate(0, this.trackRect.height / 2 - n / 2);
            point2.translate(0, this.trackRect.height / 2 + n / 2);
            point3.translate(this.trackRect.width, this.trackRect.height / 2 + n / 2);
            point4.translate(this.trackRect.width, this.trackRect.height / 2 - n / 2);
        } else {
            n2 = this.thumbRect.width / 4 == 0 ? 1 : this.thumbRect.width / 4;
            n = this.trackRect.height;
            point.translate(this.trackRect.width / 2 - n2 / 2, 0);
            point2.translate(this.trackRect.width / 2 - n2 / 2, this.trackRect.height);
            point3.translate(this.trackRect.width / 2 + n2 / 2, this.trackRect.height);
            point4.translate(this.trackRect.width / 2 + n2 / 2, 0);
        }
        graphics.setColor(Color.GRAY);
        graphics.fillRect(point.x, point.y, n2, n);
        graphics.setColor(this.getHighlightColor());
        graphics.drawLine(point2.x, point2.y, point3.x, point3.y);
        graphics.drawLine(point3.x, point3.y, point4.x, point4.y);
        graphics.setColor(this.getShadowColor());
        graphics.drawLine(point2.x, point2.y, point.x, point.y);
        graphics.drawLine(point.x, point.y, point4.x, point4.y);
        graphics.setColor(color);
    }

    public void paintTicks(Graphics graphics) {
        int n;
        double d;
        double d2;
        int n2 = this.slider.getMaximum();
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMajorTickSpacing();
        int n5 = this.slider.getMinorTickSpacing();
        if (n4 > 0) {
            if (this.slider.getOrientation() == 0) {
                d2 = (double)this.tickRect.x + 0.5;
                double d3 = d = n2 == n3 ? 0.0 : (double)n4 * (double)(this.tickRect.width - 1) / (double)(n2 - n3);
                if (this.drawInverted()) {
                    d2 += (double)this.tickRect.width;
                    d *= -1.0;
                }
                graphics.translate(0, this.tickRect.y);
                for (n = n3; n <= n2; n += n4) {
                    this.paintMajorTickForHorizSlider(graphics, this.tickRect, (int)d2);
                    d2 += d;
                }
                graphics.translate(0, -this.tickRect.y);
            } else {
                d2 = (double)(this.tickRect.height + this.tickRect.y) + 0.5;
                double d4 = d = n2 == n3 ? 0.0 : (double)(-n4) * (double)(this.tickRect.height - 1) / (double)(n2 - n3);
                if (this.drawInverted()) {
                    d2 = (double)this.tickRect.y + 0.5;
                    d *= -1.0;
                }
                graphics.translate(this.tickRect.x, 0);
                for (n = n3; n <= n2; n += n4) {
                    this.paintMajorTickForVertSlider(graphics, this.tickRect, (int)d2);
                    d2 += d;
                }
                graphics.translate(-this.tickRect.x, 0);
            }
        }
        if (n5 > 0) {
            if (this.slider.getOrientation() == 0) {
                d2 = (double)this.tickRect.x + 0.5;
                double d5 = d = n2 == n3 ? 0.0 : (double)n5 * (double)(this.tickRect.width - 1) / (double)(n2 - n3);
                if (this.drawInverted()) {
                    d2 += (double)this.tickRect.width;
                    d *= -1.0;
                }
                graphics.translate(0, this.tickRect.y);
                for (n = n3; n <= n2; n += n5) {
                    this.paintMinorTickForHorizSlider(graphics, this.tickRect, (int)d2);
                    d2 += d;
                }
                graphics.translate(0, -this.tickRect.y);
            } else {
                d2 = (double)(this.tickRect.height + this.tickRect.y) + 0.5;
                double d6 = d = n2 == n3 ? 0.0 : (double)(-n5) * (double)(this.tickRect.height - 1) / (double)(n2 - n3);
                if (this.drawInverted()) {
                    d2 = (double)this.tickRect.y + 0.5;
                    d *= -1.0;
                }
                graphics.translate(this.tickRect.x, 0);
                for (n = n3; n <= n2; n += n5) {
                    this.paintMinorTickForVertSlider(graphics, this.tickRect, (int)d2);
                    d2 += d;
                }
                graphics.translate(-this.tickRect.x, 0);
            }
        }
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.height / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n, n2, n, n2 + this.tickRect.height / 4);
        graphics.setColor(color);
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.height / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n, n2, n, n2 + this.tickRect.height / 2);
        graphics.setColor(color);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.width / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n2, n, n2 + this.tickRect.width / 4, n);
        graphics.setColor(color);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        int n2 = this.tickRect.width / 4;
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(n2, n, n2 + this.tickRect.width / 2, n);
        graphics.setColor(color);
    }

    public void paintLabels(Graphics graphics) {
        block4: {
            if (this.slider.getLabelTable() == null) break block4;
            Dictionary dictionary = this.slider.getLabelTable();
            if (this.slider.getOrientation() == 0) {
                Enumeration enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n;
                    Object object;
                    Object object2 = enumeration.nextElement();
                    if (!(object2 instanceof Integer) || !((object = dictionary.get(n = (Integer)object2)) instanceof JLabel)) continue;
                    Component component = (Component)object;
                    this.paintHorizontalLabel(graphics, n, component);
                }
            } else {
                Enumeration enumeration = dictionary.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n;
                    Object object;
                    Object object3 = enumeration.nextElement();
                    if (!(object3 instanceof Integer) || !((object = dictionary.get(n = (Integer)object3)) instanceof JLabel)) continue;
                    Component component = (Component)object;
                    this.paintVerticalLabel(graphics, n, component);
                }
            }
        }
    }

    protected void paintHorizontalLabel(Graphics graphics, int n, Component component) {
        Dimension dimension = component.getPreferredSize();
        int n2 = (int)dimension.getWidth();
        int n3 = (int)dimension.getHeight();
        int n4 = this.slider.getMaximum();
        int n5 = this.slider.getMinimum();
        if (n > n4 || n < n5) {
            return;
        }
        int n6 = this.xPositionForValue(n) - n2 / 2;
        int n7 = this.labelRect.y;
        if (n6 < 0) {
            n6 = 0;
        }
        if (n6 + n2 > this.labelRect.x + this.labelRect.width) {
            n2 = this.labelRect.x + this.labelRect.width - n6;
        }
        if (n3 > this.labelRect.height) {
            n3 = this.labelRect.height;
        }
        component.setBounds(n6, n7, n2, n3);
        SwingUtilities.paintComponent(graphics, component, null, component.getBounds());
    }

    protected void paintVerticalLabel(Graphics graphics, int n, Component component) {
        Dimension dimension = component.getPreferredSize();
        int n2 = (int)dimension.getWidth();
        int n3 = (int)dimension.getHeight();
        int n4 = this.slider.getMaximum();
        int n5 = this.slider.getMinimum();
        if (n > n4 || n < n5) {
            return;
        }
        int n6 = this.labelRect.x;
        int n7 = this.yPositionForValue(n) - n3 / 2;
        if (n7 < 0) {
            n7 = 0;
        }
        if (n7 + n3 > this.labelRect.y + this.labelRect.height) {
            n3 = this.labelRect.y + this.labelRect.height - n7;
        }
        if (n2 > this.labelRect.width) {
            n2 = this.labelRect.width;
        }
        component.setBounds(n6, n7, n2, n3);
        SwingUtilities.paintComponent(graphics, component, null, component.getBounds());
    }

    public void paintThumb(Graphics graphics) {
        Polygon polygon;
        Polygon polygon2;
        Polygon polygon3;
        Polygon polygon4;
        Color color = graphics.getColor();
        Point point = new Point(this.thumbRect.x, this.thumbRect.y);
        Point point2 = new Point(point);
        Point point3 = new Point(point);
        Point point4 = new Point(point);
        Point point5 = new Point(point);
        if (this.slider.getOrientation() == 0) {
            int n = this.thumbRect.height * 3 / 4;
            point2.translate(this.thumbRect.width - 1, 0);
            point3.translate(this.thumbRect.width - 1, n);
            point4.translate(this.thumbRect.width / 2 - 1, this.thumbRect.height - 1);
            point5.translate(0, n);
            polygon4 = new Polygon(new int[]{point2.x - 1, point.x, point5.x, point4.x}, new int[]{point2.y, point.y, point5.y, point4.y}, 4);
            polygon3 = new Polygon(new int[]{point2.x, point3.x, point4.x + 1}, new int[]{point2.y, point3.y - 1, point4.y}, 3);
            polygon2 = new Polygon(new int[]{point2.x - 1, point3.x - 1, point4.x + 1}, new int[]{point2.y + 1, point3.y - 1, point4.y - 1}, 3);
            polygon = new Polygon(new int[]{point.x + 1, point2.x - 2, point3.x - 2, point4.x, point5.x + 1}, new int[]{point.y + 1, point2.y + 1, point3.y - 1, point4.y - 1, point5.y}, 5);
        } else {
            int n = this.thumbRect.width * 3 / 4 - 1;
            point2.translate(n, 0);
            point3.translate(this.thumbRect.width - 1, this.thumbRect.height / 2);
            point4.translate(n, this.thumbRect.height - 1);
            point5.translate(0, this.thumbRect.height - 1);
            polygon4 = new Polygon(new int[]{point3.x - 1, point2.x, point.x, point5.x}, new int[]{point3.y - 1, point2.y, point.y, point5.y - 1}, 4);
            polygon3 = new Polygon(new int[]{point3.x, point4.x, point5.x}, new int[]{point3.y, point4.y, point5.y}, 3);
            polygon2 = new Polygon(new int[]{point3.x - 1, point4.x, point5.x + 1}, new int[]{point3.y, point4.y - 1, point5.y - 1}, 3);
            polygon = new Polygon(new int[]{point.x + 1, point2.x, point3.x - 2, point3.x - 2, point4.x, point5.x + 1}, new int[]{point.y + 1, point2.y + 1, point3.y - 1, point3.y, point4.y - 2, point5.y - 2}, 6);
        }
        graphics.setColor(Color.WHITE);
        graphics.drawPolyline(polygon4.xpoints, polygon4.ypoints, polygon4.npoints);
        graphics.setColor(Color.BLACK);
        graphics.drawPolyline(polygon3.xpoints, polygon3.ypoints, polygon3.npoints);
        graphics.setColor(Color.GRAY);
        graphics.drawPolyline(polygon2.xpoints, polygon2.ypoints, polygon2.npoints);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.drawPolyline(polygon.xpoints, polygon.ypoints, polygon.npoints);
        graphics.fillPolygon(polygon);
        graphics.setColor(color);
    }

    public void setThumbLocation(int n, int n2) {
        this.thumbRect.x = n;
        this.thumbRect.y = n2;
    }

    public void scrollByBlock(int n) {
        int n2 = n * (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
        int n3 = this.slider.getValue() + n2;
        if (this.slider.getSnapToTicks()) {
            n3 = this.findClosestTick(n3);
        }
        this.slider.setValue(n3);
    }

    public void scrollByUnit(int n) {
        int n2 = this.slider.getValue() + n;
        if (this.slider.getSnapToTicks()) {
            n2 = this.findClosestTick(n2);
        }
        this.slider.setValue(n2);
    }

    protected void scrollDueToClickInTrack(int n) {
        this.scrollTimer.stop();
        this.scrollListener.setDirection(n);
        this.scrollListener.setScrollByBlock(true);
        this.scrollTimer.start();
    }

    protected int xPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.width - 1;
        int n6 = n2 = n4 == n3 ? 0 : (n - n3) * n5 / (n4 - n3);
        if (!this.drawInverted()) {
            n2 += this.trackRect.x;
        } else {
            n2 = n5 - n2;
            n2 += this.trackRect.x;
        }
        return n2;
    }

    protected int yPositionForValue(int n) {
        int n2;
        int n3 = this.slider.getMinimum();
        int n4 = this.slider.getMaximum();
        int n5 = this.trackRect.height - 1;
        int n6 = n2 = n4 == n3 ? 0 : (n - n3) * n5 / (n4 - n3);
        if (!this.drawInverted()) {
            n2 = n5 - n2;
            n2 += this.trackRect.y;
        } else {
            n2 += this.trackRect.y;
        }
        return n2;
    }

    public int valueForYPosition(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        int n4 = this.trackRect.height;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = !this.drawInverted() ? (n4 - (n - this.trackRect.y)) * (n3 - n2) / n4 + n2 : (n - this.trackRect.y) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    public int valueForXPosition(int n) {
        int n2 = this.slider.getMinimum();
        int n3 = this.slider.getMaximum();
        int n4 = this.trackRect.width;
        if (n4 == 0) {
            return (n3 - n2) / 2;
        }
        int n5 = !this.drawInverted() ? (n - this.trackRect.x) * (n3 - n2) / n4 + n2 : (n4 - (n - this.trackRect.x)) * (n3 - n2) / n4 + n2;
        if (n5 > n3) {
            n5 = n3;
        } else if (n5 < n2) {
            n5 = n2;
        }
        return n5;
    }

    int findClosestTick(int n) {
        int n2;
        int n3;
        int n4;
        int n5 = this.slider.getMinimum();
        int n6 = this.slider.getMaximum();
        int n7 = this.slider.getMajorTickSpacing();
        int n8 = this.slider.getMinorTickSpacing();
        int n9 = n5 - n;
        int n10 = n5 - n;
        if (n7 <= 0 && n8 <= 0) {
            return n;
        }
        if (n7 > 0) {
            n4 = (n - n5) / n7;
            n3 = n7 * n4 + n5;
            n2 = n7 * (n4 + 1) + n5;
            n10 = n2 <= n6 && n2 - n <= n - n3 ? n2 - n : n3 - n;
        }
        if (n8 > 0) {
            n4 = n / n8;
            n3 = n8 * n4;
            n2 = n8 * (n4 + 1);
            n9 = n2 <= n6 && n2 - n <= n - n3 ? n2 - n : n3 - n;
        }
        if (Math.abs(n9) > Math.abs(n10)) {
            return n + n10;
        }
        return n + n9;
    }

    public class ActionScroller
    extends AbstractAction {
        private /* synthetic */ BasicSliderUI this$0;

        public ActionScroller(BasicSliderUI basicSliderUI, JSlider jSlider, int n, boolean bl) {
            this.this$0 = basicSliderUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    public class TrackListener
    extends MouseInputAdapter {
        private /* synthetic */ BasicSliderUI this$0;
        protected int currentMouseX;
        protected int currentMouseY;
        protected int offset;

        public void mouseDragged(MouseEvent mouseEvent) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (this.this$0.slider.getValueIsAdjusting()) {
                int n = this.this$0.slider.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) - this.offset : this.this$0.valueForYPosition(this.currentMouseY) - this.offset;
                this.this$0.slider.setValue(n);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            int n = this.this$0.slider.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) : this.this$0.valueForYPosition(this.currentMouseY);
            if (this.this$0.slider.getSnapToTicks()) {
                n = this.this$0.findClosestTick(n);
            }
            if (!this.this$0.thumbRect.contains(mouseEvent.getPoint())) {
                if (n > this.this$0.slider.getValue()) {
                    this.this$0.scrollDueToClickInTrack(1);
                } else {
                    this.this$0.scrollDueToClickInTrack(-1);
                }
            } else {
                this.this$0.slider.setValueIsAdjusting(true);
                this.offset = n - this.this$0.slider.getValue();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (this.this$0.slider.getValueIsAdjusting()) {
                this.this$0.slider.setValueIsAdjusting(false);
                if (this.this$0.slider.getSnapToTicks()) {
                    this.this$0.slider.setValue(this.this$0.findClosestTick(this.this$0.slider.getValue()));
                }
            }
            if (this.this$0.scrollTimer != null) {
                this.this$0.scrollTimer.stop();
            }
        }

        public boolean shouldScroll(int n) {
            int n2 = this.this$0.slider.getOrientation() == 0 ? this.this$0.valueForXPosition(this.currentMouseX) : this.this$0.valueForYPosition(this.currentMouseY);
            if (n == 1) {
                return n2 > this.this$0.slider.getValue();
            }
            return n2 < this.this$0.slider.getValue();
        }

        public TrackListener(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class ScrollListener
    implements ActionListener {
        private /* synthetic */ BasicSliderUI this$0;
        private transient int direction;
        private transient boolean block;

        public ScrollListener(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
            this.direction = 1;
            this.block = false;
        }

        public ScrollListener(BasicSliderUI basicSliderUI, int n, boolean bl) {
            this.this$0 = basicSliderUI;
            this.direction = n;
            this.block = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!this.this$0.trackListener.shouldScroll(this.direction)) {
                this.this$0.scrollTimer.stop();
                return;
            }
            if (this.block) {
                this.this$0.scrollByBlock(this.direction);
            } else {
                this.this$0.scrollByUnit(this.direction);
            }
        }

        public void setDirection(int n) {
            this.direction = n;
        }

        public void setScrollByBlock(boolean bl) {
            this.block = bl;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicSliderUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                this.this$0.recalculateIfOrientationChanged();
            } else if (propertyChangeEvent.getPropertyName().equals("model")) {
                BoundedRangeModel boundedRangeModel = (BoundedRangeModel)propertyChangeEvent.getOldValue();
                boundedRangeModel.removeChangeListener(this.this$0.changeListener);
                this.this$0.slider.getModel().addChangeListener(this.this$0.changeListener);
                this.this$0.calculateThumbLocation();
            }
            this.this$0.slider.repaint();
        }

        public PropertyChangeHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class FocusHandler
    implements FocusListener {
        private /* synthetic */ BasicSliderUI this$0;

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }

        public FocusHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class ComponentHandler
    extends ComponentAdapter {
        private /* synthetic */ BasicSliderUI this$0;

        public void componentResized(ComponentEvent componentEvent) {
            this.this$0.calculateGeometry();
            this.this$0.slider.revalidate();
            this.this$0.slider.repaint();
        }

        public ComponentHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicSliderUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            this.this$0.calculateThumbLocation();
            this.this$0.slider.repaint();
        }

        public ChangeHandler(BasicSliderUI basicSliderUI) {
            this.this$0 = basicSliderUI;
        }
    }
}

