/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneConstants;
import javax.swing.ScrollPaneLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ScrollPaneUI;

public class BasicScrollPaneUI
extends ScrollPaneUI
implements ScrollPaneConstants {
    protected JScrollPane scrollpane;
    protected ChangeListener hsbChangeListener;
    protected ChangeListener vsbChangeListener;
    protected ChangeListener viewportChangeListener;
    protected PropertyChangeListener spPropertyChangeListener;
    MouseWheelListener mouseWheelListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicScrollPaneUI();
    }

    protected void installDefaults(JScrollPane jScrollPane) {
        this.scrollpane = jScrollPane;
        LookAndFeel.installColorsAndFont(jScrollPane, "ScrollPane.background", "ScrollPane.foreground", "ScrollPane.font");
        LookAndFeel.installBorder(jScrollPane, "ScrollPane.border");
        jScrollPane.setOpaque(true);
    }

    protected void uninstallDefaults(JScrollPane jScrollPane) {
        jScrollPane.setForeground(null);
        jScrollPane.setBackground(null);
        jScrollPane.setFont(null);
        jScrollPane.setBorder(null);
        this.scrollpane = null;
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installDefaults((JScrollPane)jComponent);
        this.installListeners((JScrollPane)jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void installListeners(JScrollPane jScrollPane) {
        if (this.spPropertyChangeListener == null) {
            this.spPropertyChangeListener = this.createPropertyChangeListener();
        }
        jScrollPane.addPropertyChangeListener(this.spPropertyChangeListener);
        if (this.hsbChangeListener == null) {
            this.hsbChangeListener = this.createHSBChangeListener();
        }
        jScrollPane.getHorizontalScrollBar().getModel().addChangeListener(this.hsbChangeListener);
        if (this.vsbChangeListener == null) {
            this.vsbChangeListener = this.createVSBChangeListener();
        }
        jScrollPane.getVerticalScrollBar().getModel().addChangeListener(this.vsbChangeListener);
        if (this.viewportChangeListener == null) {
            this.viewportChangeListener = this.createViewportChangeListener();
        }
        jScrollPane.getViewport().addChangeListener(this.viewportChangeListener);
        if (this.mouseWheelListener == null) {
            this.mouseWheelListener = this.createMouseWheelListener();
        }
        jScrollPane.addMouseWheelListener(this.mouseWheelListener);
    }

    protected void installKeyboardActions(JScrollPane jScrollPane) {
    }

    protected ChangeListener createHSBChangeListener() {
        return new HSBChangeListener(this);
    }

    protected ChangeListener createVSBChangeListener() {
        return new VSBChangeListener(this);
    }

    protected ChangeListener createViewportChangeListener() {
        return new ViewportChangeHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected MouseWheelListener createMouseWheelListener() {
        return new MouseWheelHandler(this);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this.uninstallDefaults((JScrollPane)jComponent);
        this.uninstallListeners((JScrollPane)jComponent);
        this.installKeyboardActions((JScrollPane)jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        jScrollPane.removePropertyChangeListener(this.spPropertyChangeListener);
        jScrollPane.getHorizontalScrollBar().getModel().removeChangeListener(this.hsbChangeListener);
        jScrollPane.getVerticalScrollBar().getModel().removeChangeListener(this.vsbChangeListener);
        jScrollPane.getViewport().removeChangeListener(this.viewportChangeListener);
        jScrollPane.removeMouseWheelListener(this.mouseWheelListener);
    }

    protected void uninstallKeyboardActions(JScrollPane jScrollPane) {
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        JScrollPane jScrollPane = (JScrollPane)jComponent;
        ScrollPaneLayout scrollPaneLayout = (ScrollPaneLayout)jScrollPane.getLayout();
        return scrollPaneLayout.minimumLayoutSize(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    protected void syncScrollPaneWithViewport() {
        JViewport jViewport = this.scrollpane.getViewport();
        JScrollBar jScrollBar = this.scrollpane.getHorizontalScrollBar();
        jScrollBar.setMaximum(jViewport.getViewSize().width);
        jScrollBar.setValue(jViewport.getViewPosition().x);
        jScrollBar.setVisibleAmount(jViewport.getExtentSize().width);
        JScrollBar jScrollBar2 = this.scrollpane.getVerticalScrollBar();
        jScrollBar2.setMaximum(jViewport.getViewSize().height);
        jScrollBar2.setValue(jViewport.getViewPosition().y);
        jScrollBar2.setVisibleAmount(jViewport.getExtentSize().height);
    }

    protected void updateColumnHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateRowHeader(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateScrollBarDisplayPolicy(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        jViewport.removeChangeListener(this.viewportChangeListener);
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        jViewport.addChangeListener(this.viewportChangeListener);
    }

    protected class MouseWheelHandler
    implements MouseWheelListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        }

        protected MouseWheelHandler(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("viewport")) {
                this.this$0.updateViewport(propertyChangeEvent);
            } else if (string.equals("rowHeader")) {
                this.this$0.updateRowHeader(propertyChangeEvent);
            } else if (string.equals("columnHeader")) {
                this.this$0.updateColumnHeader(propertyChangeEvent);
            } else if (string.equals("horizontalScrollBarPolicy") || propertyChangeEvent.getPropertyName().equals("verticalScrollBarPolicy")) {
                this.this$0.updateScrollBarDisplayPolicy(propertyChangeEvent);
            } else if (string.equals("verticalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(this.this$0.vsbChangeListener);
                JScrollBar jScrollBar2 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar2.getModel().addChangeListener(this.this$0.vsbChangeListener);
            } else if (string.equals("horizontalScrollBar")) {
                JScrollBar jScrollBar = (JScrollBar)propertyChangeEvent.getOldValue();
                jScrollBar.getModel().removeChangeListener(this.this$0.hsbChangeListener);
                JScrollBar jScrollBar3 = (JScrollBar)propertyChangeEvent.getNewValue();
                jScrollBar3.getModel().addChangeListener(this.this$0.hsbChangeListener);
            }
        }

        public PropertyChangeHandler(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    public class ViewportChangeHandler
    implements ChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JViewport jViewport = this.this$0.scrollpane.getViewport();
            JScrollBar jScrollBar = this.this$0.scrollpane.getHorizontalScrollBar();
            JScrollBar jScrollBar2 = this.this$0.scrollpane.getVerticalScrollBar();
            this.this$0.syncScrollPaneWithViewport();
        }

        public ViewportChangeHandler(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    public class VSBChangeListener
    implements ChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = this.this$0.scrollpane.getVerticalScrollBar();
            JViewport jViewport = this.this$0.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            int n = jScrollBar.getValue();
            if (n != point.y) {
                point.y = n;
                jViewport.setViewPosition(point);
            }
            point.x = 0;
            JViewport jViewport2 = this.this$0.scrollpane.getRowHeader();
            if (jViewport2 != null && !jViewport2.getViewPosition().equals(point)) {
                jViewport2.setViewPosition(point);
            }
        }

        public VSBChangeListener(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }

    public class HSBChangeListener
    implements ChangeListener {
        private /* synthetic */ BasicScrollPaneUI this$0;

        public void stateChanged(ChangeEvent changeEvent) {
            JScrollBar jScrollBar = this.this$0.scrollpane.getHorizontalScrollBar();
            JViewport jViewport = this.this$0.scrollpane.getViewport();
            Point point = jViewport.getViewPosition();
            int n = jScrollBar.getValue();
            if (n != point.x) {
                point.x = n;
                jViewport.setViewPosition(point);
            }
            point.y = 0;
            JViewport jViewport2 = this.this$0.scrollpane.getColumnHeader();
            if (jViewport2 != null && !jViewport2.getViewPosition().equals(point)) {
                jViewport2.setViewPosition(point);
            }
        }

        public HSBChangeListener(BasicScrollPaneUI basicScrollPaneUI) {
            this.this$0 = basicScrollPaneUI;
        }
    }
}

